/*
 * Decompiled with CFR 0.152.
 */
package io.github.aakira.napier;

import io.github.aakira.napier.Antilog;
import io.github.aakira.napier.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ)\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001fJ.\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0003`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0003*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lio/github/aakira/napier/DebugAntilog;", "Lio/github/aakira/napier/Antilog;", "defaultTag", "", "(Ljava/lang/String;)V", "handler", "", "Ljava/util/logging/Handler;", "(Ljava/lang/String;Ljava/util/List;)V", "anonymousClass", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "consoleHandler", "Ljava/util/logging/ConsoleHandler;", "logger", "Ljava/util/logging/Logger;", "tagMap", "Ljava/util/HashMap;", "Lio/github/aakira/napier/LogLevel;", "Lkotlin/collections/HashMap;", "stackTraceString", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "buildLog", "priority", "tag", "message", "buildLog$napier", "createStackElementTag", "className", "createStackElementTag$napier", "performLog", "", "throwable", "performTag", "Companion", "napier"})
public final class DebugAntilog
extends Antilog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultTag;
    @NotNull
    private final List<Handler> handler;
    @NotNull
    private final ConsoleHandler consoleHandler;
    @NotNull
    private final Logger logger;
    private final Pattern anonymousClass;
    @NotNull
    private final HashMap<LogLevel, String> tagMap;
    private static final int CALL_STACK_INDEX = 8;

    /*
     * WARNING - void declaration
     */
    public DebugAntilog(@NotNull String defaultTag, @NotNull List<? extends Handler> handler2) {
        void it;
        Object $this$logger_u24lambda_u2d2;
        void $this$consoleHandler_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(defaultTag, "defaultTag");
        Intrinsics.checkNotNullParameter(handler2, "handler");
        this.defaultTag = defaultTag;
        this.handler = handler2;
        Pair[] pairArray = new ConsoleHandler();
        Object object = pairArray;
        DebugAntilog debugAntilog = this;
        boolean $i$a$-apply-DebugAntilog$consoleHandler$22 = false;
        $this$consoleHandler_u24lambda_u2d0.setLevel(Level.ALL);
        $this$consoleHandler_u24lambda_u2d0.setFormatter(new SimpleFormatter());
        debugAntilog.consoleHandler = pairArray;
        Object $i$a$-apply-DebugAntilog$consoleHandler$22 = object = Logger.getLogger(DebugAntilog.class.getName());
        debugAntilog = this;
        boolean bl = false;
        ((Logger)$this$logger_u24lambda_u2d2).setLevel(Level.ALL);
        if (this.handler.isEmpty()) {
            ((Logger)$this$logger_u24lambda_u2d2).addHandler(this.consoleHandler);
        } else {
            Iterable $this$forEach$iv = this.handler;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it2 = (Handler)element$iv;
                boolean bl2 = false;
                ((Logger)$this$logger_u24lambda_u2d2).addHandler(it2);
            }
        }
        $this$logger_u24lambda_u2d2 = object;
        boolean bl3 = false;
        it.setUseParentHandlers(false);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue(object2, "getLogger(DebugAntilog::\u2026eParentHandlers = false }");
        debugAntilog.logger = object2;
        this.anonymousClass = Pattern.compile("(\\$\\d+)+$");
        pairArray = new Pair[]{TuplesKt.to(LogLevel.VERBOSE, "[VERBOSE]"), TuplesKt.to(LogLevel.DEBUG, "[DEBUG]"), TuplesKt.to(LogLevel.INFO, "[INFO]"), TuplesKt.to(LogLevel.WARNING, "[WARN]"), TuplesKt.to(LogLevel.ERROR, "[ERROR]"), TuplesKt.to(LogLevel.ASSERT, "[ASSERT]")};
        this.tagMap = MapsKt.hashMapOf(pairArray);
    }

    public /* synthetic */ DebugAntilog(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "app";
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    public DebugAntilog(@NotNull String defaultTag) {
        Intrinsics.checkNotNullParameter(defaultTag, "defaultTag");
        this(defaultTag, CollectionsKt.emptyList());
    }

    public /* synthetic */ DebugAntilog(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "app";
        }
        this(string);
    }

    @Override
    protected void performLog(@NotNull LogLevel priority, @Nullable String tag2, @Nullable Throwable throwable, @Nullable String message) {
        Object object;
        String debugTag;
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        String string = tag2;
        if (string == null) {
            string = debugTag = this.performTag(this.defaultTag);
        }
        if (message != null) {
            object = throwable != null ? message + '\n' + this.getStackTraceString(throwable) : message;
        } else {
            object = throwable;
            if (object == null || (object = this.getStackTraceString((Throwable)object)) == null) {
                return;
            }
        }
        Object fullMessage = object;
        switch (WhenMappings.$EnumSwitchMapping$0[priority.ordinal()]) {
            case 1: {
                this.logger.finest(this.buildLog$napier(priority, debugTag, (String)fullMessage));
                break;
            }
            case 2: {
                this.logger.fine(this.buildLog$napier(priority, debugTag, (String)fullMessage));
                break;
            }
            case 3: {
                this.logger.info(this.buildLog$napier(priority, debugTag, (String)fullMessage));
                break;
            }
            case 4: {
                this.logger.warning(this.buildLog$napier(priority, debugTag, (String)fullMessage));
                break;
            }
            case 5: {
                this.logger.severe(this.buildLog$napier(priority, debugTag, (String)fullMessage));
                break;
            }
            case 6: {
                this.logger.severe(this.buildLog$napier(priority, debugTag, (String)fullMessage));
            }
        }
    }

    @NotNull
    public final String buildLog$napier(@NotNull LogLevel priority, @Nullable String tag2, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        StringBuilder stringBuilder = new StringBuilder().append(this.tagMap.get((Object)priority)).append(' ');
        String string = tag2;
        if (string == null) {
            string = this.performTag(this.defaultTag);
        }
        return stringBuilder.append(string).append(" - ").append(message).toString();
    }

    private final String performTag(String defaultTag) {
        String string;
        StackTraceElement[] thread2 = Thread.currentThread().getStackTrace();
        if (thread2.length >= 8) {
            StackTraceElement $this$performTag_u24lambda_u2d4 = thread2[8];
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $this$performTag_u24lambda_u2d4.getClassName();
            Intrinsics.checkNotNullExpressionValue(string2, "className");
            string = stringBuilder.append(this.createStackElementTag$napier(string2)).append('$').append($this$performTag_u24lambda_u2d4.getMethodName()).toString();
        } else {
            string = defaultTag;
        }
        return string;
    }

    @NotNull
    public final String createStackElementTag$napier(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        String tag2 = className;
        Matcher m4 = this.anonymousClass.matcher(tag2);
        if (m4.find()) {
            String string = m4.replaceAll("");
            Intrinsics.checkNotNullExpressionValue(string, "m.replaceAll(\"\")");
            tag2 = string;
        }
        String string = tag2.substring(StringsKt.lastIndexOf$default((CharSequence)tag2, '.', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return string;
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sw.toString()");
        return string;
    }

    public DebugAntilog() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/aakira/napier/DebugAntilog$Companion;", "", "()V", "CALL_STACK_INDEX", "", "napier"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            nArray[LogLevel.VERBOSE.ordinal()] = 1;
            nArray[LogLevel.DEBUG.ordinal()] = 2;
            nArray[LogLevel.INFO.ordinal()] = 3;
            nArray[LogLevel.WARNING.ordinal()] = 4;
            nArray[LogLevel.ERROR.ordinal()] = 5;
            nArray[LogLevel.ASSERT.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

