/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00100\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\f8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001d\u0010\nR\u0014\u0010\u001e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0014\u0010 \u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u0014\u0010\"\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b%\u0010\u0010R\u0014\u0010(\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0010R\u0014\u0010*\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\nR\u0014\u0010,\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0010R\u0014\u0010.\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0010\u00a8\u00061"}, d2={"Lio/ktor/server/netty/http1/NettyConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "(Lio/netty/handler/codec/http/HttpRequest;Lio/netty/channel/ChannelHandlerContext;)V", "defaultPort", "", "getDefaultPort", "()I", "host", "", "getHost$annotations", "()V", "getHost", "()Ljava/lang/String;", "localAddress", "getLocalAddress", "localHost", "getLocalHost", "localPort", "getLocalPort", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "port", "getPort$annotations", "getPort", "remoteAddress", "getRemoteAddress", "remoteHost", "getRemoteHost", "remotePort", "getRemotePort", "scheme", "getScheme", "scheme$delegate", "Lkotlin/Lazy;", "serverHost", "getServerHost", "serverPort", "getServerPort", "uri", "getUri", "version", "getVersion", "toString", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyConnectionPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyConnectionPoint.kt\nio/ktor/server/netty/http1/NettyConnectionPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class NettyConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final Lazy scheme$delegate;

    public NettyConnectionPoint(@NotNull HttpRequest request2, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter(request2, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        this.request = request2;
        this.context = context;
        this.scheme$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ NettyConnectionPoint this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NettyConnectionPoint.access$getContext$p(this.this$0).pipeline().context("ssl") == null ? "http" : "https";
            }
        });
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.request.protocolVersion().text();
        Intrinsics.checkNotNullExpressionValue(string, "request.protocolVersion().text()");
        return string;
    }

    @Override
    @NotNull
    public String getUri() {
        String string = this.request.uri();
        Intrinsics.checkNotNullExpressionValue(string, "request.uri()");
        return string;
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        String string = this.request.method().name();
        Intrinsics.checkNotNullExpressionValue(string, "request.method().name()");
        return HttpMethod.Companion.parse(string);
    }

    @Override
    @NotNull
    public String getScheme() {
        Lazy lazy2 = this.scheme$delegate;
        return (String)lazy2.getValue();
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBefore$default(string, ":", null, 2, null)) == null) {
            String string2;
            InetSocketAddress inetSocketAddress;
            SocketAddress socketAddress = this.context.channel().localAddress();
            InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
            if (inetSocketAddress != null) {
                InetSocketAddress it = inetSocketAddress;
                boolean bl = false;
                string2 = it.getHostName();
                if (string2 == null) {
                    string2 = it.getAddress().getHostAddress();
                }
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "localhost";
            }
        }
        return string;
    }

    @Deprecated(message="Use localHost or serverHost instead")
    public static /* synthetic */ void getHost$annotations() {
    }

    @Override
    public int getPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 80;
    }

    @Deprecated(message="Use localPort or serverPort instead")
    public static /* synthetic */ void getPort$annotations() {
    }

    @Override
    @NotNull
    public String getLocalHost() {
        String string;
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            InetSocketAddress it = inetSocketAddress;
            boolean bl = false;
            string = it.getHostName();
            if (string == null) {
                string = it.getHostString();
            }
        } else {
            string = null;
        }
        String string2 = string;
        return string2 == null ? "localhost" : string2;
    }

    @Override
    @NotNull
    public String getServerHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBefore$default(string, ":", null, 2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    @Override
    @NotNull
    public String getLocalAddress() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        String string = inetSocketAddress != null ? inetSocketAddress.getHostString() : null;
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    private final int getDefaultPort() {
        return URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @Override
    public int getLocalPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : this.getDefaultPort();
    }

    @Override
    public int getServerPort() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        return string != null && (string = StringsKt.substringAfter(string, ":", String.valueOf(this.getDefaultPort()))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    @Override
    @NotNull
    public String getRemoteHost() {
        String string;
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            InetSocketAddress it = inetSocketAddress;
            boolean bl = false;
            string = it.getHostName();
            if (string == null) {
                string = it.getAddress().getHostAddress();
            }
        } else {
            string = null;
        }
        String string2 = string;
        return string2 == null ? "unknown" : string2;
    }

    @Override
    public int getRemotePort() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 0;
    }

    @Override
    @NotNull
    public String getRemoteAddress() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        String string = inetSocketAddress != null ? inetSocketAddress.getHostString() : null;
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @NotNull
    public String toString() {
        return "NettyConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }

    public static final /* synthetic */ ChannelHandlerContext access$getContext$p(NettyConnectionPoint $this) {
        return $this.context;
    }
}

