/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import io.netty.handler.codec.marshalling.MarshallerProvider;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

@ChannelHandler.Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider provider2) {
        this.provider = provider2;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out2) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        int lengthPos = out2.writerIndex();
        out2.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput output2 = new ChannelBufferByteOutput(out2);
        marshaller.start((ByteOutput)output2);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        out2.setInt(lengthPos, out2.writerIndex() - lengthPos - 4);
    }
}

