/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.Option;

public class OptionGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> optionMap = new LinkedHashMap<String, Option>();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option option2) {
        this.optionMap.put(option2.getKey(), option2);
        return this;
    }

    public Collection<String> getNames() {
        return this.optionMap.keySet();
    }

    public Collection<Option> getOptions() {
        return this.optionMap.values();
    }

    public String getSelected() {
        return this.selected;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setSelected(Option option2) throws AlreadySelectedException {
        if (option2 == null) {
            this.selected = null;
            return;
        }
        if (this.selected != null && !this.selected.equals(option2.getKey())) {
            throw new AlreadySelectedException(this, option2);
        }
        this.selected = option2.getKey();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        Iterator<Option> iter = this.getOptions().iterator();
        buff.append("[");
        while (iter.hasNext()) {
            Option option2 = iter.next();
            if (option2.getOpt() != null) {
                buff.append("-");
                buff.append(option2.getOpt());
            } else {
                buff.append("--");
                buff.append(option2.getLongOpt());
            }
            if (option2.getDescription() != null) {
                buff.append(" ");
                buff.append(option2.getDescription());
            }
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }
}

