/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64;

import java.io.IOException;
import java.io.OutputStream;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Encoder;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i2;
        for (i2 = 0; i2 < this.decodingTable.length; ++i2) {
            this.decodingTable[i2] = -1;
        }
        for (i2 = 0; i2 < this.encodingTable.length; ++i2) {
            this.decodingTable[this.encodingTable[i2]] = (byte)i2;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data2, int off, int length, OutputStream out2) throws IOException {
        int modulus = length % 3;
        int dataLength = length - modulus;
        for (int i2 = off; i2 < off + dataLength; i2 += 3) {
            int a1 = data2[i2] & 0xFF;
            int a2 = data2[i2 + 1] & 0xFF;
            int a3 = data2[i2 + 2] & 0xFF;
            out2.write(this.encodingTable[a1 >>> 2 & 0x3F]);
            out2.write(this.encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F]);
            out2.write(this.encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F]);
            out2.write(this.encodingTable[a3 & 0x3F]);
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data2[off + dataLength] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                out2.write(this.encodingTable[b1]);
                out2.write(this.encodingTable[b2]);
                out2.write(this.padding);
                out2.write(this.padding);
                break;
            }
            case 2: {
                int d1 = data2[off + dataLength] & 0xFF;
                int d2 = data2[off + dataLength + 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                out2.write(this.encodingTable[b1]);
                out2.write(this.encodingTable[b2]);
                out2.write(this.encodingTable[b3]);
                out2.write(this.padding);
            }
        }
        return dataLength / 3 * 4 + (modulus == 0 ? 0 : 4);
    }

    private boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    @Override
    public int decode(byte[] data2, int off, int length, OutputStream out2) throws IOException {
        int finish;
        int end2;
        int outLen = 0;
        for (end2 = off + length; end2 > off && this.ignore((char)data2[end2 - 1]); --end2) {
        }
        if (end2 == 0) {
            return 0;
        }
        int i2 = 0;
        for (finish = end2; finish > off && i2 != 4; --finish) {
            if (this.ignore((char)data2[finish - 1])) continue;
            ++i2;
        }
        i2 = this.nextI(data2, off, finish);
        while (i2 < finish) {
            byte b4;
            byte b1 = this.decodingTable[data2[i2++]];
            i2 = this.nextI(data2, i2, finish);
            byte b2 = this.decodingTable[data2[i2++]];
            i2 = this.nextI(data2, i2, finish);
            byte b3 = this.decodingTable[data2[i2++]];
            i2 = this.nextI(data2, i2, finish);
            if ((b1 | b2 | b3 | (b4 = this.decodingTable[data2[i2++]])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            out2.write(b1 << 2 | b2 >> 4);
            out2.write(b2 << 4 | b3 >> 2);
            out2.write(b3 << 6 | b4);
            outLen += 3;
            i2 = this.nextI(data2, i2, finish);
        }
        int e0 = this.nextI(data2, i2, end2);
        int e1 = this.nextI(data2, e0 + 1, end2);
        int e2 = this.nextI(data2, e1 + 1, end2);
        int e3 = this.nextI(data2, e2 + 1, end2);
        return outLen += this.decodeLastBlock(out2, (char)data2[e0], (char)data2[e1], (char)data2[e2], (char)data2[e3]);
    }

    private int nextI(byte[] data2, int i2, int finish) {
        while (i2 < finish && this.ignore((char)data2[i2])) {
            ++i2;
        }
        return i2;
    }

    @Override
    public int decode(String data2, OutputStream out2) throws IOException {
        int finish;
        int end2;
        int length = 0;
        for (end2 = data2.length(); end2 > 0 && this.ignore(data2.charAt(end2 - 1)); --end2) {
        }
        if (end2 == 0) {
            return 0;
        }
        int i2 = 0;
        for (finish = end2; finish > 0 && i2 != 4; --finish) {
            if (this.ignore(data2.charAt(finish - 1))) continue;
            ++i2;
        }
        i2 = this.nextI(data2, 0, finish);
        while (i2 < finish) {
            byte b4;
            byte b1 = this.decodingTable[data2.charAt(i2++)];
            i2 = this.nextI(data2, i2, finish);
            byte b2 = this.decodingTable[data2.charAt(i2++)];
            i2 = this.nextI(data2, i2, finish);
            byte b3 = this.decodingTable[data2.charAt(i2++)];
            i2 = this.nextI(data2, i2, finish);
            if ((b1 | b2 | b3 | (b4 = this.decodingTable[data2.charAt(i2++)])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            out2.write(b1 << 2 | b2 >> 4);
            out2.write(b2 << 4 | b3 >> 2);
            out2.write(b3 << 6 | b4);
            length += 3;
            i2 = this.nextI(data2, i2, finish);
        }
        int e0 = this.nextI(data2, i2, end2);
        int e1 = this.nextI(data2, e0 + 1, end2);
        int e2 = this.nextI(data2, e1 + 1, end2);
        int e3 = this.nextI(data2, e2 + 1, end2);
        return length += this.decodeLastBlock(out2, data2.charAt(e0), data2.charAt(e1), data2.charAt(e2), data2.charAt(e3));
    }

    private int decodeLastBlock(OutputStream out2, char c1, char c2, char c3, char c4) throws IOException {
        if (c3 == this.padding) {
            if (c4 != this.padding) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            byte b1 = this.decodingTable[c1];
            byte b2 = this.decodingTable[c2];
            if ((b1 | b2) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            out2.write(b1 << 2 | b2 >> 4);
            return 1;
        }
        if (c4 == this.padding) {
            byte b1 = this.decodingTable[c1];
            byte b2 = this.decodingTable[c2];
            byte b3 = this.decodingTable[c3];
            if ((b1 | b2 | b3) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            out2.write(b1 << 2 | b2 >> 4);
            out2.write(b2 << 4 | b3 >> 2);
            return 2;
        }
        byte b1 = this.decodingTable[c1];
        byte b2 = this.decodingTable[c2];
        byte b3 = this.decodingTable[c3];
        byte b4 = this.decodingTable[c4];
        if ((b1 | b2 | b3 | b4) < 0) {
            throw new IOException("invalid characters encountered at end of base64 data");
        }
        out2.write(b1 << 2 | b2 >> 4);
        out2.write(b2 << 4 | b3 >> 2);
        out2.write(b3 << 6 | b4);
        return 3;
    }

    private int nextI(String data2, int i2, int finish) {
        while (i2 < finish && this.ignore(data2.charAt(i2))) {
            ++i2;
        }
        return i2;
    }
}

