/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentRequired
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependentRequired.class);
    private final Map<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();

    public DependentRequired(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENT_REQUIRED, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isArray()) continue;
            List dependencies = this.propertyDependencies.computeIfAbsent(pname, k -> new ArrayList());
            for (int i2 = 0; i2 < pvalue.size(); ++i2) {
                dependencies.add(pvalue.get(i2).asText());
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        DependentRequired.debug(logger, executionContext, node2, rootNode, instanceLocation);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator<String> it = node2.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            List<String> dependencies = this.propertyDependencies.get(pname);
            if (dependencies == null || dependencies.isEmpty()) continue;
            for (String field : dependencies) {
                if (node2.get(field) != null) continue;
                errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).property(pname)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(field, pname)).build());
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

