/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.jetbrains.annotations.NotNull;

public class CertPathSerializer
extends StdSerializer<CertPath> {
    public CertPathSerializer() {
        super(CertPath.class);
    }

    @Override
    public void serialize(@NotNull CertPath value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) throws IOException {
        try {
            gen.writeStartArray();
            for (Certificate certificate : value.getCertificates()) {
                gen.writeBinary(certificate.getEncoded());
            }
            gen.writeEndArray();
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

