/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.graphicapi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.graphicapi.InternalDirectXApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext;", "Ljava/lang/AutoCloseable;", "()V", "adapter", "", "Lorg/jetbrains/skia/impl/NativePointer;", "device", "directContext", "Lorg/jetbrains/skia/DirectContext;", "getDirectContext", "()Lorg/jetbrains/skia/DirectContext;", "close", "", "Texture", "skiko"})
@ExperimentalSkikoApi
public final class DirectXOffscreenContext
implements AutoCloseable {
    private final long adapter = InternalDirectXApi.INSTANCE.chooseAdapter(GpuPriority.Integrated);
    private final long device;
    @NotNull
    private final DirectContext directContext;

    /*
     * WARNING - void declaration
     */
    public DirectXOffscreenContext() {
        void it;
        long l;
        long l2 = l = InternalDirectXApi.INSTANCE.createDirectXOffscreenDevice(this.adapter);
        DirectXOffscreenContext directXOffscreenContext = this;
        boolean bl = false;
        if (it == 0L) {
            throw new RenderException("Failed to create DirectX12 device.", null, 2, null);
        }
        directXOffscreenContext.device = l;
        this.directContext = new DirectContext(InternalDirectXApi.INSTANCE.makeDirectXContext(this.device));
    }

    @NotNull
    public final DirectContext getDirectContext() {
        return this.directContext;
    }

    @Override
    public void close() {
        this.directContext.close();
        InternalDirectXApi.INSTANCE.disposeDevice(this.device);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext$Texture;", "Ljava/lang/AutoCloseable;", "desiredWidth", "", "desiredHeight", "(Lorg/jetbrains/skiko/graphicapi/DirectXOffscreenContext;II)V", "actualHeight", "getActualHeight", "()I", "actualWidth", "getActualWidth", "backendRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "getBackendRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "texture", "", "Lorg/jetbrains/skia/impl/NativePointer;", "close", "", "readPixels", "byteArray", "", "waitForCompletion", "skiko"})
    public final class Texture
    implements AutoCloseable {
        private final int actualWidth;
        private final int actualHeight;
        private final long texture;
        @NotNull
        private final BackendRenderTarget backendRenderTarget;

        /*
         * WARNING - void declaration
         */
        public Texture(int desiredWidth, int desiredHeight) {
            void it;
            long l;
            this.actualWidth = InternalDirectXApi.INSTANCE.alignedTextureWidth(desiredWidth);
            this.actualHeight = desiredHeight;
            long l2 = l = InternalDirectXApi.INSTANCE.makeDirectXTexture(DirectXOffscreenContext.this.device, 0L, this.actualWidth, this.actualHeight);
            Texture texture = this;
            boolean bl = false;
            if (it == 0L) {
                throw new RenderException("Can't allocate DirectX resources", null, 2, null);
            }
            texture.texture = l;
            this.backendRenderTarget = new BackendRenderTarget(InternalDirectXApi.INSTANCE.makeDirectXRenderTargetOffScreen(this.texture));
        }

        public final int getActualWidth() {
            return this.actualWidth;
        }

        public final int getActualHeight() {
            return this.actualHeight;
        }

        @NotNull
        public final BackendRenderTarget getBackendRenderTarget() {
            return this.backendRenderTarget;
        }

        @Override
        public void close() {
            this.backendRenderTarget.close();
            InternalDirectXApi.INSTANCE.disposeDirectXTexture(this.texture);
        }

        public final void waitForCompletion() {
            InternalDirectXApi.INSTANCE.waitForCompletion(DirectXOffscreenContext.this.device, this.texture);
        }

        public final void readPixels(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!InternalDirectXApi.INSTANCE.readPixels(this.texture, byteArray)) {
                throw new RenderException("Couldn't read pixels", null, 2, null);
            }
        }
    }
}

