/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.paging.PagingSource;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.coroutines.FlowUtil;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import io.ktor.http.Url;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.SchoolAppEntityDao;
import world.respect.datalayer.db.school.daos.SchoolAppEntityDao_Impl;
import world.respect.datalayer.db.school.entities.SchoolAppEntity;
import world.respect.datalayer.db.shared.SharedConverters;
import world.respect.datalayer.school.model.StatusEnum;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lworld/respect/datalayer/db/school/daos/SchoolAppEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/SchoolAppEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfSchoolAppEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/SchoolAppEntity;", "__sharedConverters", "Lworld/respect/datalayer/db/shared/SharedConverters;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "upsert", "", "list", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastModifiedByUidNum", "", "uidNum", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidNumList", "uidNumList", "includeDeleted", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listAsPagingSource", "Landroidx/paging/PagingSource;", "", "listAsFlow", "Lkotlinx/coroutines/flow/Flow;", "Companion", "respect-datalayer-db"})
public final class SchoolAppEntityDao_Impl
implements SchoolAppEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<SchoolAppEntity> __insertAdapterOfSchoolAppEntity;
    @NotNull
    private final SharedConverters __sharedConverters;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;

    public SchoolAppEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__sharedConverters = new SharedConverters();
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfSchoolAppEntity = (EntityInsertAdapter)new EntityInsertAdapter<SchoolAppEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `SchoolAppEntity` (`saUid`,`saUidNum`,`saManifestUrl`,`saStatus`,`saLastModified`,`saStored`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, SchoolAppEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getSaUid());
                statement.bindLong(2, entity.getSaUidNum());
                String _tmp = __sharedConverters.fromUrl(entity.getSaManifestUrl());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                int _tmp_1 = __schoolTypeConverters.fromStatusEnum(entity.getSaStatus());
                statement.bindLong(4, (long)_tmp_1);
                Long _tmp_2 = __sharedConverters.fromInstant(entity.getSaLastModified());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindLong(5, _tmp_2.longValue());
                }
                Long _tmp_3 = __sharedConverters.fromInstant(entity.getSaStored());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindLong(6, _tmp_3.longValue());
                }
            }
        };
    }

    @Override
    @Nullable
    public Object upsert(@NotNull List<SchoolAppEntity> list2, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> SchoolAppEntityDao_Impl.upsert$lambda$0(this, list2, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLastModifiedByUidNum(long uidNum, @NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT SchoolAppEntity.saLastModified\n          FROM SchoolAppEntity\n         WHERE SchoolAppEntity.saUidNum = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> SchoolAppEntityDao_Impl.getLastModifiedByUidNum$lambda$0(_sql, uidNum, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUidNumList(@NotNull List<Long> uidNumList, @NotNull Continuation<? super List<SchoolAppEntity>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT SchoolAppEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM SchoolAppEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE SchoolAppEntity.saUidNum IN (");
        int _inputSize = uidNumList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> SchoolAppEntityDao_Impl.findByUidNumList$lambda$0(_sql, uidNumList, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object list(boolean includeDeleted, @NotNull Continuation<? super List<SchoolAppEntity>> $completion) {
        String _sql = "\n        SELECT SchoolAppEntity.*\n          FROM SchoolAppEntity \n         WHERE (? OR SchoolAppEntity.saStatus = 1) \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> SchoolAppEntityDao_Impl.list$lambda$0(_sql, includeDeleted, this, arg_0), $completion);
    }

    @Override
    @NotNull
    public PagingSource<Integer, SchoolAppEntity> listAsPagingSource(boolean includeDeleted) {
        String _sql = "\n        SELECT SchoolAppEntity.*\n          FROM SchoolAppEntity \n         WHERE (? OR SchoolAppEntity.saStatus = 1)  \n    ";
        RoomRawQuery _rawQuery = new RoomRawQuery(_sql, arg_0 -> SchoolAppEntityDao_Impl.listAsPagingSource$lambda$0(includeDeleted, arg_0));
        RoomDatabase roomDatabase = this.__db;
        String[] stringArray = new String[]{"SchoolAppEntity"};
        String[] stringArray2 = stringArray;
        return (PagingSource)new LimitOffsetPagingSource<SchoolAppEntity>(_rawQuery, this, roomDatabase, stringArray2){
            final /* synthetic */ SchoolAppEntityDao_Impl this$0;
            {
                this.this$0 = $receiver;
                super($_rawQuery, $super_call_param$1, $super_call_param$2);
            }

            protected Object convertRows(RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<SchoolAppEntity>> $completion) {
                return DBUtil.performSuspending((RoomDatabase)SchoolAppEntityDao_Impl.access$get__db$p(this.this$0), (boolean)true, (boolean)false, arg_0 -> listAsPagingSource.1.convertRows$lambda$0(limitOffsetQuery, this.this$0, arg_0), $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final List convertRows$lambda$0(RoomRawQuery $limitOffsetQuery, SchoolAppEntityDao_Impl this$0, SQLiteConnection _connection) {
                List list2;
                Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
                SQLiteStatement _stmt = _connection.prepare($limitOffsetQuery.getSql());
                $limitOffsetQuery.getBindingFunction().invoke((Object)_stmt);
                try {
                    int _columnIndexOfSaUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUid");
                    int _columnIndexOfSaUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUidNum");
                    int _columnIndexOfSaManifestUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saManifestUrl");
                    int _columnIndexOfSaStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStatus");
                    int _columnIndexOfSaLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saLastModified");
                    int _columnIndexOfSaStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStored");
                    List _result = new ArrayList<E>();
                    while (_stmt.step()) {
                        SchoolAppEntity _item = null;
                        String _tmpSaUid = null;
                        _tmpSaUid = _stmt.getText(_columnIndexOfSaUid);
                        long _tmpSaUidNum = 0L;
                        _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum);
                        Url _tmpSaManifestUrl = null;
                        String _tmp_1 = null;
                        _tmp_1 = _stmt.isNull(_columnIndexOfSaManifestUrl) ? null : _stmt.getText(_columnIndexOfSaManifestUrl);
                        Url _tmp_2 = SchoolAppEntityDao_Impl.access$get__sharedConverters$p(this$0).toUrl(_tmp_1);
                        if (_tmp_2 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                        }
                        _tmpSaManifestUrl = _tmp_2;
                        StatusEnum _tmpSaStatus = null;
                        int _tmp_3 = 0;
                        _tmp_3 = (int)_stmt.getLong(_columnIndexOfSaStatus);
                        _tmpSaStatus = SchoolAppEntityDao_Impl.access$get__schoolTypeConverters$p(this$0).toStatusEnum(_tmp_3);
                        Instant _tmpSaLastModified = null;
                        Long _tmp_4 = null;
                        _tmp_4 = _stmt.isNull(_columnIndexOfSaLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaLastModified));
                        Instant _tmp_5 = SchoolAppEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_4);
                        if (_tmp_5 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpSaLastModified = _tmp_5;
                        Instant _tmpSaStored = null;
                        Long _tmp_6 = null;
                        _tmp_6 = _stmt.isNull(_columnIndexOfSaStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaStored));
                        Instant _tmp_7 = SchoolAppEntityDao_Impl.access$get__sharedConverters$p(this$0).toInstant(_tmp_6);
                        if (_tmp_7 == null) {
                            throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                        }
                        _tmpSaStored = _tmp_7;
                        _item = new SchoolAppEntity(_tmpSaUid, _tmpSaUidNum, _tmpSaManifestUrl, _tmpSaStatus, _tmpSaLastModified, _tmpSaStored);
                        _result.add(_item);
                    }
                    list2 = _result;
                }
                finally {
                    _stmt.close();
                }
                return list2;
            }
        };
    }

    @Override
    @NotNull
    public Flow<List<SchoolAppEntity>> listAsFlow(boolean includeDeleted) {
        String _sql = "\n        SELECT SchoolAppEntity.*\n          FROM SchoolAppEntity \n         WHERE (? OR SchoolAppEntity.saStatus = 1)  \n    ";
        String[] stringArray = new String[]{"SchoolAppEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> SchoolAppEntityDao_Impl.listAsFlow$lambda$0(_sql, includeDeleted, this, arg_0));
    }

    private static final Unit upsert$lambda$0(SchoolAppEntityDao_Impl this$0, List $list, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfSchoolAppEntity.insert(_connection, (Iterable)$list);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long getLastModifiedByUidNum$lambda$0(String $_sql, long $uidNum, SQLiteConnection _connection) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            Long _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : Long.valueOf(_stmt.getLong(0))) : null;
            l = _result;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByUidNumList$lambda$0(String $_sql, List $uidNumList, SchoolAppEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $uidNumList.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfSaUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUid");
            int _columnIndexOfSaUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUidNum");
            int _columnIndexOfSaManifestUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saManifestUrl");
            int _columnIndexOfSaStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStatus");
            int _columnIndexOfSaLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saLastModified");
            int _columnIndexOfSaStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStored");
            List _result = new ArrayList();
            while (_stmt.step()) {
                SchoolAppEntity _item_1 = null;
                String _tmpSaUid = null;
                _tmpSaUid = _stmt.getText(_columnIndexOfSaUid);
                long _tmpSaUidNum = 0L;
                _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum);
                Url _tmpSaManifestUrl = null;
                String _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfSaManifestUrl) ? null : _stmt.getText(_columnIndexOfSaManifestUrl);
                Url _tmp_1 = this$0.__sharedConverters.toUrl(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpSaManifestUrl = _tmp_1;
                StatusEnum _tmpSaStatus = null;
                int _tmp_2 = 0;
                _tmp_2 = (int)_stmt.getLong(_columnIndexOfSaStatus);
                _tmpSaStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_2);
                Instant _tmpSaLastModified = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfSaLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaLastModified));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaLastModified = _tmp_4;
                Instant _tmpSaStored = null;
                Long _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfSaStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaStored));
                Instant _tmp_6 = this$0.__sharedConverters.toInstant(_tmp_5);
                if (_tmp_6 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaStored = _tmp_6;
                _item_1 = new SchoolAppEntity(_tmpSaUid, _tmpSaUidNum, _tmpSaManifestUrl, _tmpSaStatus, _tmpSaLastModified, _tmpSaStored);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List list$lambda$0(String $_sql, boolean $includeDeleted, SchoolAppEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            int _tmp = $includeDeleted ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            int _columnIndexOfSaUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUid");
            int _columnIndexOfSaUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUidNum");
            int _columnIndexOfSaManifestUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saManifestUrl");
            int _columnIndexOfSaStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStatus");
            int _columnIndexOfSaLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saLastModified");
            int _columnIndexOfSaStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStored");
            List _result = new ArrayList();
            while (_stmt.step()) {
                SchoolAppEntity _item = null;
                String _tmpSaUid = null;
                _tmpSaUid = _stmt.getText(_columnIndexOfSaUid);
                long _tmpSaUidNum = 0L;
                _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum);
                Url _tmpSaManifestUrl = null;
                String _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfSaManifestUrl) ? null : _stmt.getText(_columnIndexOfSaManifestUrl);
                Url _tmp_2 = this$0.__sharedConverters.toUrl(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpSaManifestUrl = _tmp_2;
                StatusEnum _tmpSaStatus = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfSaStatus);
                _tmpSaStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_3);
                Instant _tmpSaLastModified = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfSaLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaLastModified));
                Instant _tmp_5 = this$0.__sharedConverters.toInstant(_tmp_4);
                if (_tmp_5 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaLastModified = _tmp_5;
                Instant _tmpSaStored = null;
                Long _tmp_6 = null;
                _tmp_6 = _stmt.isNull(_columnIndexOfSaStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaStored));
                Instant _tmp_7 = this$0.__sharedConverters.toInstant(_tmp_6);
                if (_tmp_7 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaStored = _tmp_7;
                _item = new SchoolAppEntity(_tmpSaUid, _tmpSaUidNum, _tmpSaManifestUrl, _tmpSaStatus, _tmpSaLastModified, _tmpSaStored);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    private static final Unit listAsPagingSource$lambda$0(boolean $includeDeleted, SQLiteStatement _stmt) {
        Intrinsics.checkNotNullParameter((Object)_stmt, (String)"_stmt");
        int _argIndex = 1;
        int _tmp = $includeDeleted ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List listAsFlow$lambda$0(String $_sql, boolean $includeDeleted, SchoolAppEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            int _tmp = $includeDeleted ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            int _columnIndexOfSaUid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUid");
            int _columnIndexOfSaUidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saUidNum");
            int _columnIndexOfSaManifestUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saManifestUrl");
            int _columnIndexOfSaStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStatus");
            int _columnIndexOfSaLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saLastModified");
            int _columnIndexOfSaStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"saStored");
            List _result = new ArrayList();
            while (_stmt.step()) {
                SchoolAppEntity _item = null;
                String _tmpSaUid = null;
                _tmpSaUid = _stmt.getText(_columnIndexOfSaUid);
                long _tmpSaUidNum = 0L;
                _tmpSaUidNum = _stmt.getLong(_columnIndexOfSaUidNum);
                Url _tmpSaManifestUrl = null;
                String _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfSaManifestUrl) ? null : _stmt.getText(_columnIndexOfSaManifestUrl);
                Url _tmp_2 = this$0.__sharedConverters.toUrl(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.".toString());
                }
                _tmpSaManifestUrl = _tmp_2;
                StatusEnum _tmpSaStatus = null;
                int _tmp_3 = 0;
                _tmp_3 = (int)_stmt.getLong(_columnIndexOfSaStatus);
                _tmpSaStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_3);
                Instant _tmpSaLastModified = null;
                Long _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfSaLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaLastModified));
                Instant _tmp_5 = this$0.__sharedConverters.toInstant(_tmp_4);
                if (_tmp_5 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaLastModified = _tmp_5;
                Instant _tmpSaStored = null;
                Long _tmp_6 = null;
                _tmp_6 = _stmt.isNull(_columnIndexOfSaStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfSaStored));
                Instant _tmp_7 = this$0.__sharedConverters.toInstant(_tmp_6);
                if (_tmp_7 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpSaStored = _tmp_7;
                _item = new SchoolAppEntity(_tmpSaUid, _tmpSaUidNum, _tmpSaManifestUrl, _tmpSaStatus, _tmpSaLastModified, _tmpSaStored);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    public static final /* synthetic */ RoomDatabase access$get__db$p(SchoolAppEntityDao_Impl $this) {
        return $this.__db;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/SchoolAppEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

