/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnevaluatedPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedPropertiesValidator.class);
    private final JsonSchema schema;

    public UnevaluatedPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (!node2.isObject()) {
            return Collections.emptySet();
        }
        UnevaluatedPropertiesValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        Predicate<JsonNodeAnnotation> validEvaluationPathFilter = a2 -> executionContext.getResults().isValid(instanceLocation, a2.getEvaluationPath());
        Predicate<JsonNodeAnnotation> adjacentEvaluationPathFilter = a2 -> a2.getEvaluationPath().startsWith(this.evaluationPath.getParent());
        List instanceLocationAnnotations = executionContext.getAnnotations().asMap().getOrDefault(instanceLocation, Collections.emptyList());
        LinkedHashSet<String> evaluatedProperties = new LinkedHashSet<String>();
        LinkedHashSet existingEvaluatedProperties = new LinkedHashSet();
        List properties = instanceLocationAnnotations.stream().filter(a2 -> "properties".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : properties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p2 = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p2);
        }
        List patternProperties = instanceLocationAnnotations.stream().filter(a2 -> "patternProperties".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : patternProperties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p3 = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p3);
        }
        List additionalProperties = instanceLocationAnnotations.stream().filter(a2 -> "additionalProperties".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (Object annotation : additionalProperties) {
            if (!(((JsonNodeAnnotation)annotation).getValue() instanceof Set)) continue;
            Set p4 = (Set)((JsonNodeAnnotation)annotation).getValue();
            existingEvaluatedProperties.addAll(p4);
        }
        List unevaluatedProperties = instanceLocationAnnotations.stream().filter(a2 -> "unevaluatedProperties".equals(a2.getKeyword())).filter(adjacentEvaluationPathFilter).filter(validEvaluationPathFilter).collect(Collectors.toList());
        for (JsonNodeAnnotation annotation : unevaluatedProperties) {
            if (!(annotation.getValue() instanceof Set)) continue;
            Set p5 = (Set)annotation.getValue();
            existingEvaluatedProperties.addAll(p5);
        }
        LinkedHashSet<ValidationMessage> messages = new LinkedHashSet<ValidationMessage>();
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            Iterator<String> it = node2.fieldNames();
            while (it.hasNext()) {
                String fieldName = it.next();
                if (existingEvaluatedProperties.contains(fieldName)) continue;
                evaluatedProperties.add(fieldName);
                if (this.schemaNode.isBoolean() && !this.schemaNode.booleanValue()) {
                    messages.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).property(fieldName)).arguments(fieldName)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).build());
                    continue;
                }
                messages.addAll(this.schema.validate(executionContext, node2.get(fieldName), node2, instanceLocation.append(fieldName)));
            }
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(evaluatedProperties).build());
        return messages == null || messages.isEmpty() ? Collections.emptySet() : messages;
    }
}

