/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Supplier;

public class ClasspathSchemaLoader
implements SchemaLoader {
    private final Supplier<ClassLoader> classLoaderSource;

    public ClasspathSchemaLoader() {
        this(ClasspathSchemaLoader::getClassLoader);
    }

    public ClasspathSchemaLoader(Supplier<ClassLoader> classLoaderSource) {
        this.classLoaderSource = classLoaderSource;
    }

    @Override
    public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
        String iri = absoluteIri != null ? absoluteIri.toString() : "";
        String name = null;
        if (iri.startsWith("classpath:")) {
            name = iri.substring(10);
        } else if (iri.startsWith("resource:")) {
            name = iri.substring(9);
        }
        if (name != null) {
            ClassLoader classLoader = this.classLoaderSource.get();
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            String resource2 = name;
            return () -> {
                InputStream result2 = classLoader.getResourceAsStream(resource2);
                if (result2 == null) {
                    result2 = classLoader.getResourceAsStream(resource2.substring(1));
                }
                if (result2 == null) {
                    throw new FileNotFoundException(iri);
                }
                return result2;
            };
        }
        return null;
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = SchemaLoader.class.getClassLoader();
        }
        return classLoader;
    }
}

