/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.DateTime;
import com.ethlo.time.Duration;
import com.ethlo.time.Field;
import com.ethlo.time.ParseConfig;
import com.ethlo.time.TemporalConsumer;
import com.ethlo.time.TemporalHandler;
import com.ethlo.time.TemporalType;
import com.ethlo.time.internal.ItuDurationParser;
import com.ethlo.time.internal.fixed.ITUFormatter;
import com.ethlo.time.internal.fixed.ITUParser;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;

public class ITU {
    private ITU() {
    }

    public static OffsetDateTime parseDateTime(String text) {
        return ITUParser.parseDateTime(text, 0);
    }

    public static Duration parseDuration(String text) {
        return ItuDurationParser.parse(text, 0);
    }

    public static Duration parseDuration(String text, int offset) {
        return ItuDurationParser.parse(text, offset);
    }

    public static OffsetDateTime parseDateTime(String text, ParsePosition position) {
        return ITU.parseLenient(text, ParseConfig.DEFAULT, position).toOffsetDatetime();
    }

    public static DateTime parseLenient(String text) {
        return ITUParser.parseLenient(text, ParseConfig.DEFAULT, 0);
    }

    public static DateTime parseLenient(String text, ParseConfig parseConfig) {
        return ITUParser.parseLenient(text, parseConfig, 0);
    }

    public static DateTime parseLenient(String text, ParseConfig parseConfig, ParsePosition position) {
        return ITUParser.parseLenient(text, parseConfig, position);
    }

    public static boolean isValid(String text) {
        try {
            ITU.parseDateTime(text);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    public static String formatUtc(OffsetDateTime offsetDateTime, int fractionDigits) {
        return ITUFormatter.formatUtc(offsetDateTime, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime offsetDateTime, Field lastIncluded) {
        return ITUFormatter.formatUtc(offsetDateTime, lastIncluded);
    }

    public static String format(OffsetDateTime offsetDateTime) {
        return ITUFormatter.format(offsetDateTime, offsetDateTime.getOffset(), 0);
    }

    public static String format(OffsetDateTime offsetDateTime, int fractionDigits) {
        return ITUFormatter.format(offsetDateTime, offsetDateTime.getOffset(), fractionDigits);
    }

    public static String formatUtc(OffsetDateTime offsetDateTime) {
        return ITUFormatter.formatUtc(offsetDateTime, 0);
    }

    public static String formatUtcMilli(OffsetDateTime offsetDateTime) {
        return ITUFormatter.formatUtc(offsetDateTime, 3);
    }

    public static String formatUtcMicro(OffsetDateTime offsetDateTime) {
        return ITUFormatter.formatUtc(offsetDateTime, 6);
    }

    public static String formatUtcNano(OffsetDateTime offsetDateTime) {
        return ITUFormatter.formatUtc(offsetDateTime, 9);
    }

    public static void parse(String text, TemporalConsumer temporalConsumer) {
        DateTime dateTime = ITUParser.parseLenient(text, ParseConfig.DEFAULT, 0);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                temporalConsumer.handle(dateTime.toOffsetDatetime());
            } else {
                temporalConsumer.handle(dateTime.toLocalDatetime());
            }
        } else if (dateTime.includesGranularity(Field.DAY)) {
            temporalConsumer.handle(dateTime.toLocalDate());
        } else if (dateTime.includesGranularity(Field.MONTH)) {
            temporalConsumer.handle(dateTime.toYearMonth());
        } else {
            temporalConsumer.handle(Year.of(dateTime.getYear()));
        }
    }

    public static <T> T parse(String text, TemporalHandler<T> temporalHandler) {
        DateTime dateTime = ITUParser.parseLenient(text, ParseConfig.DEFAULT, 0);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                return temporalHandler.handle(dateTime.toOffsetDatetime());
            }
            return temporalHandler.handle(dateTime.toLocalDatetime());
        }
        if (dateTime.includesGranularity(Field.DAY)) {
            return temporalHandler.handle(dateTime.toLocalDate());
        }
        if (dateTime.includesGranularity(Field.MONTH)) {
            return temporalHandler.handle(dateTime.toYearMonth());
        }
        return temporalHandler.handle(Year.of(dateTime.getYear()));
    }

    public static boolean isValid(String text, final TemporalType ... types) {
        try {
            return ITU.parse(text, new TemporalHandler<Boolean>(){

                @Override
                public Boolean handle(LocalDate localDate) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE, types);
                }

                @Override
                public Boolean handle(OffsetDateTime offsetDateTime) {
                    return ITU.isAllowed(TemporalType.OFFSET_DATE_TIME, types);
                }

                @Override
                public Boolean handle(LocalDateTime localDateTime) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE_TIME, types);
                }

                @Override
                public Boolean handle(YearMonth yearMonth) {
                    return ITU.isAllowed(TemporalType.YEAR_MONTH, types);
                }

                @Override
                public Boolean handle(Year year2) {
                    return ITU.isAllowed(TemporalType.YEAR, types);
                }
            });
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    private static boolean isAllowed(TemporalType needle, TemporalType ... allowed) {
        for (TemporalType t : allowed) {
            if (!t.equals((Object)needle)) continue;
            return true;
        }
        return false;
    }
}

