/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMTHA {
    private final TPMIAlgHash hashAlg;
    private final byte[] digest;

    public TPMTHA(@NotNull TPMIAlgHash hashAlg, @NotNull byte[] digest) {
        this.hashAlg = hashAlg;
        this.digest = digest;
    }

    @NotNull
    public TPMIAlgHash getHashAlg() {
        return this.hashAlg;
    }

    @NotNull
    public byte[] getDigest() {
        return ArrayUtil.clone(this.digest);
    }

    @NotNull
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.digest.length);
        buffer.put(UnsignedNumberUtil.toBytes(this.hashAlg.getValue()));
        buffer.put(this.digest);
        return buffer.array();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTHA tpmtha = (TPMTHA)o;
        return this.hashAlg == tpmtha.hashAlg && Arrays.equals(this.digest, tpmtha.digest);
    }

    public int hashCode() {
        int result2 = Objects.hash(new Object[]{this.hashAlg});
        result2 = 31 * result2 + Arrays.hashCode(this.digest);
        return result2;
    }
}

