/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationData {
    private final byte[] credentialId;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final byte[] clientDataHash;
    private final byte[] signature;

    public CoreAuthenticationData(@Nullable byte[] credentialId, @Nullable AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, @Nullable byte[] authenticatorDataBytes, @Nullable byte[] clientDataHash, @Nullable byte[] signature) {
        this.credentialId = ArrayUtil.clone(credentialId);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone(authenticatorDataBytes);
        this.clientDataHash = ArrayUtil.clone(clientDataHash);
        this.signature = ArrayUtil.clone(signature);
    }

    @Nullable
    public byte[] getCredentialId() {
        return ArrayUtil.clone(this.credentialId);
    }

    @Nullable
    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    @Nullable
    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone(this.authenticatorDataBytes);
    }

    @Nullable
    public byte[] getClientDataHash() {
        return ArrayUtil.clone(this.clientDataHash);
    }

    @Nullable
    public byte[] getSignature() {
        return ArrayUtil.clone(this.signature);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationData that = (CoreAuthenticationData)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.authenticatorData);
        result2 = 31 * result2 + Arrays.hashCode(this.credentialId);
        result2 = 31 * result2 + Arrays.hashCode(this.authenticatorDataBytes);
        result2 = 31 * result2 + Arrays.hashCode(this.clientDataHash);
        result2 = 31 * result2 + Arrays.hashCode(this.signature);
        return result2;
    }

    public String toString() {
        return "CoreAuthenticationData(credentialId=" + ArrayUtil.toHexString(this.credentialId) + ", authenticatorData=" + this.authenticatorData + ", clientDataHash=" + ArrayUtil.toHexString(this.clientDataHash) + ", signature=" + ArrayUtil.toHexString(this.signature) + ")";
    }
}

