/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.util;

import ch.qos.logback.core.pattern.util.IEscapeUtil;

public class RegularEscapeUtil
implements IEscapeUtil {
    @Override
    public void escape(String escapeChars, StringBuffer buf, char next2, int pointer) {
        if (escapeChars.indexOf(next2) >= 0) {
            buf.append(next2);
        } else {
            switch (next2) {
                case '_': {
                    break;
                }
                case '\\': {
                    buf.append(next2);
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                default: {
                    String commaSeperatedEscapeChars = this.formatEscapeCharsForListing(escapeChars);
                    throw new IllegalArgumentException("Illegal char '" + next2 + " at column " + pointer + ". Only \\\\, \\_" + commaSeperatedEscapeChars + ", \\t, \\n, \\r combinations are allowed as escape characters.");
                }
            }
        }
    }

    String formatEscapeCharsForListing(String escapeChars) {
        StringBuilder commaSeperatedEscapeChars = new StringBuilder();
        for (int i2 = 0; i2 < escapeChars.length(); ++i2) {
            commaSeperatedEscapeChars.append(", \\").append(escapeChars.charAt(i2));
        }
        return commaSeperatedEscapeChars.toString();
    }

    public static String basicEscape(String s2) {
        int len = s2.length();
        StringBuilder sbuf = new StringBuilder(len);
        int i2 = 0;
        while (i2 < len) {
            int c;
            if ((c = s2.charAt(i2++)) == 92 && i2 < len) {
                if ((c = s2.charAt(i2++)) == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 8) {
                    c = 8;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 92) {
                    c = 92;
                }
            }
            sbuf.append((char)c);
        }
        return sbuf.toString();
    }
}

