package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlin.time.Instant
import world.respect.datalayer.db.school.entities.PullSyncStatusEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PullSyncStatusEntityDao_Impl(
  __db: RoomDatabase,
) : PullSyncStatusEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPullSyncStatusEntity: EntityInsertAdapter<PullSyncStatusEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPullSyncStatusEntity = object : EntityInsertAdapter<PullSyncStatusEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PullSyncStatusEntity` (`pssAccountPersonUid`,`pssAccountPersonUidNum`,`pssTableId`,`pssLastConsistentThrough`,`pssPermissionsLastModified`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PullSyncStatusEntity) {
        statement.bindText(1, entity.pssAccountPersonUid)
        statement.bindLong(2, entity.pssAccountPersonUidNum)
        statement.bindLong(3, entity.pssTableId.toLong())
        val _tmp: Long? = __sharedConverters.fromInstant(entity.pssLastConsistentThrough)
        if (_tmp == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.pssPermissionsLastModified)
        if (_tmp_1 == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp_1)
        }
      }
    }
  }

  public override suspend fun upsert(statuses: List<PullSyncStatusEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPullSyncStatusEntity.insert(_connection, statuses)
  }

  public override suspend fun getStatus(personUidNum: Long, tableId: Int): PullSyncStatusEntity? {
    val _sql: String = """
        |
        |        SELECT PullSyncStatusEntity.*
        |          FROM PullSyncStatusEntity
        |         WHERE PullSyncStatusEntity.pssAccountPersonUidNum = ?
        |           AND PullSyncStatusEntity.pssTableId = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, tableId.toLong())
        val _columnIndexOfPssAccountPersonUid: Int = getColumnIndexOrThrow(_stmt, "pssAccountPersonUid")
        val _columnIndexOfPssAccountPersonUidNum: Int = getColumnIndexOrThrow(_stmt, "pssAccountPersonUidNum")
        val _columnIndexOfPssTableId: Int = getColumnIndexOrThrow(_stmt, "pssTableId")
        val _columnIndexOfPssLastConsistentThrough: Int = getColumnIndexOrThrow(_stmt, "pssLastConsistentThrough")
        val _columnIndexOfPssPermissionsLastModified: Int = getColumnIndexOrThrow(_stmt, "pssPermissionsLastModified")
        val _result: PullSyncStatusEntity?
        if (_stmt.step()) {
          val _tmpPssAccountPersonUid: String
          _tmpPssAccountPersonUid = _stmt.getText(_columnIndexOfPssAccountPersonUid)
          val _tmpPssAccountPersonUidNum: Long
          _tmpPssAccountPersonUidNum = _stmt.getLong(_columnIndexOfPssAccountPersonUidNum)
          val _tmpPssTableId: Int
          _tmpPssTableId = _stmt.getLong(_columnIndexOfPssTableId).toInt()
          val _tmpPssLastConsistentThrough: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPssLastConsistentThrough)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPssLastConsistentThrough)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPssLastConsistentThrough = _tmp_1
          }
          val _tmpPssPermissionsLastModified: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPssPermissionsLastModified)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPssPermissionsLastModified)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPssPermissionsLastModified = _tmp_3
          }
          _result = PullSyncStatusEntity(_tmpPssAccountPersonUid,_tmpPssAccountPersonUidNum,_tmpPssTableId,_tmpPssLastConsistentThrough,_tmpPssPermissionsLastModified)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
