/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.NavOptionsBuilder;
import androidx.navigation.NavOptionsBuilderKt;
import androidx.navigation.NavigatorState;
import androidx.savedstate.SavedState;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002,-B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\rH\u0017J\r\u0010\u0017\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001cH\u0016J5\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\n\u0010*\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010)\u001a\u00020%H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Landroidx/navigation/Navigator;", "D", "Landroidx/navigation/NavDestination;", "", "<init>", "()V", "name", "", "(Ljava/lang/String;)V", "_name", "getName$navigation_common", "()Ljava/lang/String;", "_state", "Landroidx/navigation/NavigatorState;", "state", "getState", "()Landroidx/navigation/NavigatorState;", "value", "", "isAttached", "()Z", "onAttach", "", "createDestination", "()Landroidx/navigation/NavDestination;", "navigate", "entries", "", "Landroidx/navigation/NavBackStackEntry;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "onLaunchSingleTop", "backStackEntry", "destination", "args", "Landroidx/savedstate/SavedState;", "(Landroidx/navigation/NavDestination;Landroidx/savedstate/SavedState;Landroidx/navigation/NavOptions;Landroidx/navigation/Navigator$Extras;)Landroidx/navigation/NavDestination;", "popBackStack", "popUpTo", "savedState", "onSaveState", "onRestoreState", "Name", "Extras", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Navigator.kt\nandroidx/navigation/Navigator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,260:1\n1321#2,2:261\n*S KotlinDebug\n*F\n+ 1 Navigator.kt\nandroidx/navigation/Navigator\n*L\n154#1:261,2\n*E\n"})
public abstract class Navigator<D extends NavDestination> {
    @Nullable
    private final String _name;
    @Nullable
    private NavigatorState _state;
    private boolean isAttached;

    public Navigator() {
        this._name = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Navigator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this._name = name;
    }

    @NotNull
    public final String getName$navigation_common() {
        String string = this._name;
        if (string == null) {
            String string2 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string2);
            string = StringsKt.removeSuffix((String)string2, (CharSequence)"Navigator");
        }
        return string;
    }

    @NotNull
    protected final NavigatorState getState() {
        NavigatorState navigatorState = this._state;
        if (navigatorState == null) {
            boolean bl = false;
            String string = "You cannot access the Navigator's state until the Navigator is attached";
            throw new IllegalStateException(string.toString());
        }
        return navigatorState;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    @CallSuper
    public void onAttach(@NotNull NavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state = state;
        this.isAttached = true;
    }

    @NotNull
    public abstract D createDestination();

    /*
     * WARNING - void declaration
     */
    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Extras navigatorExtras) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Sequence sequence = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entries), arg_0 -> Navigator.navigate$lambda$1(this, navOptions, navigatorExtras, arg_0)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NavBackStackEntry backStackEntry = (NavBackStackEntry)element$iv;
            boolean bl = false;
            this.getState().push(backStackEntry);
        }
    }

    public void onLaunchSingleTop(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavDestination navDestination = backStackEntry.getDestination();
        NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
        if (navDestination2 == null) {
            return;
        }
        NavDestination destination = navDestination2;
        this.navigate(destination, null, NavOptionsBuilderKt.navOptions((Function1<? super NavOptionsBuilder, Unit>)((Function1)Navigator::onLaunchSingleTop$lambda$3)), null);
        this.getState().onLaunchSingleTop(backStackEntry);
    }

    @Nullable
    public NavDestination navigate(@NotNull D destination, @Nullable SavedState args, @Nullable NavOptions navOptions, @Nullable Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        return destination;
    }

    public void popBackStack(@NotNull NavBackStackEntry popUpTo2, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        List backStack = (List)this.getState().getBackStack().getValue();
        if (!backStack.contains(popUpTo2)) {
            boolean $i$a$-check-Navigator$popBackStack$22 = false;
            String $i$a$-check-Navigator$popBackStack$22 = "popBackStack was called with " + popUpTo2 + " which does not exist in back stack " + backStack;
            throw new IllegalStateException($i$a$-check-Navigator$popBackStack$22.toString());
        }
        ListIterator iterator2 = backStack.listIterator(backStack.size());
        NavBackStackEntry lastPoppedEntry = null;
        while (this.popBackStack() && !Intrinsics.areEqual((Object)(lastPoppedEntry = (NavBackStackEntry)iterator2.previous()), (Object)popUpTo2)) {
        }
        if (lastPoppedEntry != null) {
            this.getState().pop(lastPoppedEntry, savedState);
        }
    }

    public boolean popBackStack() {
        return true;
    }

    @Nullable
    public SavedState onSaveState() {
        return null;
    }

    public void onRestoreState(@NotNull SavedState savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
    }

    private static final NavBackStackEntry navigate$lambda$1(Navigator this$0, NavOptions $navOptions, Extras $navigatorExtras, NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavDestination navDestination = backStackEntry.getDestination();
        NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
        if (navDestination2 == null) {
            return null;
        }
        NavDestination destination = navDestination2;
        NavDestination navigatedToDestination = this$0.navigate(destination, backStackEntry.getArguments(), $navOptions, $navigatorExtras);
        navDestination = navigatedToDestination;
        return navDestination == null ? null : (Intrinsics.areEqual((Object)navDestination, (Object)destination) ? backStackEntry : this$0.getState().createBackStackEntry(navigatedToDestination, navigatedToDestination.addInDefaultArgs(backStackEntry.getArguments())));
    }

    private static final Unit onLaunchSingleTop$lambda$3(NavOptionsBuilder $this$navOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$navOptions, (String)"$this$navOptions");
        $this$navOptions.setLaunchSingleTop(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Landroidx/navigation/Navigator$Extras;", "", "navigation-common"})
    public static interface Extras {
    }

    @Retention(value=AnnotationRetention.RUNTIME)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.ANNOTATION_CLASS, AnnotationTarget.CLASS})
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\u0002\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003R\u000f\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/navigation/Navigator$Name;", "", "value", "", "()Ljava/lang/String;", "navigation-common"})
    public static @interface Name {
        public String value();
    }
}

