/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditProcessor;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a[\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\fH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"cupertinoSetCursorOffsetFocused", "", "Landroidx/compose/foundation/text/TextFieldDelegate$Companion;", "position", "Landroidx/compose/ui/geometry/Offset;", "textLayoutResult", "Landroidx/compose/foundation/text/TextLayoutResultProxy;", "editProcessor", "Landroidx/compose/ui/text/input/EditProcessor;", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "showContextMenu", "Lkotlin/Function1;", "", "onValueChange", "Landroidx/compose/ui/text/input/TextFieldValue;", "cupertinoSetCursorOffsetFocused-60JtlcE", "(Landroidx/compose/foundation/text/TextFieldDelegate$Companion;JLandroidx/compose/foundation/text/TextLayoutResultProxy;Landroidx/compose/ui/text/input/EditProcessor;Landroidx/compose/ui/text/input/OffsetMapping;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "determineCursorDesiredOffset", "", "offset", "previousOffset", "Landroidx/compose/ui/text/TextLayoutResult;", "currentText", "", "isFirstHalfOfWordTapped", "caretOffset", "isLeftEdgeTapped", "isRightEdgeTapped", "foundation"})
public final class TextFieldDelegate_skikoKt {
    public static final void cupertinoSetCursorOffsetFocused-60JtlcE(@NotNull TextFieldDelegate.Companion $this$cupertinoSetCursorOffsetFocused_u2d60JtlcE, long position, @NotNull TextLayoutResultProxy textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMapping offsetMapping, @NotNull Function1<? super Boolean, Unit> showContextMenu, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
        Intrinsics.checkNotNullParameter((Object)$this$cupertinoSetCursorOffsetFocused_u2d60JtlcE, (String)"$this$cupertinoSetCursorOffsetFocused");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter(showContextMenu, (String)"showContextMenu");
        Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
        int offset = offsetMapping.transformedToOriginal(TextLayoutResultProxy.getOffsetForPosition-3MmeM6k$default(textLayoutResult, position, false, 2, null));
        TextFieldValue currentValue = editProcessor.toTextFieldValue();
        String currentText = textLayoutResult.getValue().getLayoutInput().getText().toString();
        int previousOffset = TextRange.getStart-impl((long)currentValue.getSelection-d9O1mEE());
        int cursorDesiredOffset = TextFieldDelegate_skikoKt.determineCursorDesiredOffset(offset, previousOffset, textLayoutResult.getValue(), currentText);
        showContextMenu.invoke((Object)(cursorDesiredOffset == offset && cursorDesiredOffset == previousOffset ? 1 : 0));
        onValueChange.invoke((Object)TextFieldValue.copy-3r_uNRQ$default((TextFieldValue)editProcessor.toTextFieldValue(), null, (long)TextRangeKt.TextRange((int)cursorDesiredOffset), null, (int)5, null));
    }

    public static final int determineCursorDesiredOffset(int offset, int previousOffset, @NotNull TextLayoutResult textLayoutResult, @NotNull String currentText) {
        int lineNumber;
        int n;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter((Object)currentText, (String)"currentText");
        if (offset == previousOffset) {
            n = offset;
        } else if (TextFieldDelegate_skikoKt.isLeftEdgeTapped(textLayoutResult, offset)) {
            lineNumber = textLayoutResult.getLineForOffset(offset);
            n = textLayoutResult.getLineStart(lineNumber);
        } else if (TextFieldDelegate_skikoKt.isRightEdgeTapped(textLayoutResult, offset)) {
            lineNumber = textLayoutResult.getLineForOffset(offset);
            n = TextLayoutResult.getLineEnd$default((TextLayoutResult)textLayoutResult, (int)lineNumber, (boolean)false, (int)2, null);
        } else {
            n = StringHelpers_skikoKt.isWhitespaceOrPunctuation(currentText, offset) ? StringHelpers_skikoKt.findNextNonWhitespaceSymbolsSubsequenceStartOffset(offset, currentText) : (TextFieldDelegate_skikoKt.isFirstHalfOfWordTapped(textLayoutResult, offset, currentText) ? TextRange.getStart-impl((long)textLayoutResult.getWordBoundary--jx7JFs(offset)) : TextRange.getEnd-impl((long)textLayoutResult.getWordBoundary--jx7JFs(offset)));
        }
        int caretOffsetPosition = n;
        return caretOffsetPosition;
    }

    private static final boolean isFirstHalfOfWordTapped(TextLayoutResult textLayoutResult, int caretOffset, String currentText) {
        long wordBoundary = textLayoutResult.getWordBoundary--jx7JFs(caretOffset);
        String string = currentText.substring(TextRange.getStart-impl((long)wordBoundary), TextRange.getEnd-impl((long)wordBoundary));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String word = string;
        int middleIndex = TextRange.getStart-impl((long)wordBoundary) + StringHelpers_skikoKt.midpointPositionWithUnicodeSymbols(word);
        return caretOffset < middleIndex;
    }

    private static final boolean isLeftEdgeTapped(TextLayoutResult textLayoutResult, int caretOffset) {
        int lineNumber = textLayoutResult.getLineForOffset(caretOffset);
        int lineStartOffset = textLayoutResult.getLineStart(lineNumber);
        return lineStartOffset == caretOffset;
    }

    private static final boolean isRightEdgeTapped(TextLayoutResult textLayoutResult, int caretOffset) {
        int lineNumber = textLayoutResult.getLineForOffset(caretOffset);
        int lineEndOffset = TextLayoutResult.getLineEnd$default((TextLayoutResult)textLayoutResult, (int)lineNumber, (boolean)false, (int)2, null);
        return lineEndOffset == caretOffset;
    }
}

