/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.options;

import androidx.compose.runtime.Immutable;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrix;
import io.github.alexzhirkevich.qrose.options.QrCodeShape;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/github/alexzhirkevich/qrose/options/Hexagon;", "Lio/github/alexzhirkevich/qrose/options/QrCodeShape;", "rotationDegree", "", "random", "Lkotlin/random/Random;", "precise", "", "(FLkotlin/random/Random;Z)V", "co", "", "isModulo60", "rad", "shapeSizeIncrease", "getShapeSizeIncrease", "()F", "si", "isInHexagon", "x1", "y1", "x2", "y2", "z", "rotate", "Lkotlin/Pair;", "x", "", "y", "transform", "Lio/github/alexzhirkevich/qrose/options/QrCodeMatrix;", "qrose"})
@Immutable
final class Hexagon
implements QrCodeShape {
    @NotNull
    private final Random random;
    private final boolean precise;
    private final float shapeSizeIncrease;
    private final double rad;
    private final double si;
    private final double co;
    private final boolean isModulo60;

    public Hexagon(float rotationDegree, @NotNull Random random, boolean precise) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
        this.precise = precise;
        this.shapeSizeIncrease = 1.6f;
        this.rad = (double)rotationDegree * 0.0174533;
        this.si = Math.sin(this.rad);
        this.co = Math.cos(this.rad);
        this.isModulo60 = MathKt.roundToInt((float)rotationDegree) % 60 == 0;
    }

    @Override
    public float getShapeSizeIncrease() {
        return this.shapeSizeIncrease;
    }

    @Override
    @NotNull
    public QrCodeMatrix transform(@NotNull QrCodeMatrix $this$transform) {
        Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"<this>");
        double a = Math.sqrt((double)($this$transform.getSize() * $this$transform.getSize()) / 1.268 / 1.268);
        int newSize = (int)(1.575f * (float)$this$transform.getSize());
        QrCodeMatrix newMatrix = new QrCodeMatrix(newSize, null, 2, null);
        Pair<Double, Double> pair = this.rotate(newSize / 2, newSize / 2);
        double x1 = ((Number)pair.component1()).doubleValue();
        double y1 = ((Number)pair.component2()).doubleValue();
        for (int i = 0; i < newSize; ++i) {
            int i2 = i;
            boolean bl = false;
            for (int j = 0; j < newSize; ++j) {
                double y;
                int j2 = j;
                boolean bl2 = false;
                Pair<Double, Double> pair2 = this.rotate(i2, j2);
                double x = ((Number)pair2.component1()).doubleValue();
                boolean inLarge = this.isInHexagon(x, y = ((Number)pair2.component2()).doubleValue(), x1, y1, a);
                if (!inLarge) continue;
                boolean inSmall = !this.precise || this.isInHexagon(x, y, x1, y1, a - 1.1);
                newMatrix.set(i2, j2, !inSmall || this.random.nextBoolean() ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.LightPixel);
            }
        }
        int diff = (newSize - $this$transform.getSize()) / 2;
        int n = $this$transform.getSize();
        for (int i = 0; i < n; ++i) {
            int i3 = i;
            boolean bl = false;
            int n2 = $this$transform.getSize();
            int n3 = 0;
            while (n3 < n2) {
                int j = n3++;
                boolean bl3 = false;
                newMatrix.set(diff + i3, diff + j, $this$transform.get(i3, j));
            }
        }
        return newMatrix;
    }

    private final boolean isInHexagon(double x1, double y1, double x2, double y2, double z) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        double py1 = z * 0.86602540378;
        double px2 = z * 0.5088190451;
        double py2 = z * 0.8592582628;
        double p_angle_01 = -x * (py1 - y) - x * y;
        double p_angle_20 = -y * (px2 - x) + x * (py2 - y);
        double p_angle_03 = y * z;
        double p_angle_12 = -x * (py2 - y) - (px2 - x) * (py1 - y);
        double p_angle_32 = (z - x) * (py2 - y) + y * (px2 - x);
        boolean is_inside_1 = p_angle_01 * p_angle_12 >= 0.0 && p_angle_12 * p_angle_20 >= 0.0;
        boolean is_inside_2 = p_angle_03 * p_angle_32 >= 0.0 && p_angle_32 * p_angle_20 >= 0.0;
        return is_inside_1 || is_inside_2;
    }

    private final Pair<Double, Double> rotate(int x, int y) {
        if (this.isModulo60) {
            return TuplesKt.to((Object)x, (Object)y);
        }
        return TuplesKt.to((Object)((double)x * this.co - (double)y * this.si), (Object)((double)x * this.si + (double)y * this.co));
    }
}

