/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.report.query;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.Flow;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.serializers.TimeZoneSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.shared.entities.ReportQueryResult;
import world.respect.datalayer.http.headers.directives.DirectivesToMapKt;
import world.respect.datalayer.school.model.report.ReportOptions;
import world.respect.datalayer.school.model.report.ReportSeries;
import world.respect.datalayer.school.model.report.StatementReportRow;
import world.respect.shared.domain.report.ext.ReportQueryResultExtKt;
import world.respect.shared.domain.report.query.RunReportUseCase$RunReportRequest$;
import world.respect.shared.domain.report.query.RunReportUseCase$RunReportResult$;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \t2\u00020\u0001:\u0003\u0007\b\tJ\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u00a6\u0002\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase;", "", "invoke", "Lkotlinx/coroutines/flow/Flow;", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;", "request", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "RunReportResult", "RunReportRequest", "Companion", "respect-lib-shared_release"})
public interface RunReportUseCase {
    @NotNull
    public static final Companion Companion = world.respect.shared.domain.report.query.RunReportUseCase$Companion.$$INSTANCE;
    public static final int DEFAULT_MAX_AGE = 3600;
    public static final float Y_RANGE_BUFFER_FACTOR = 1.1f;

    @NotNull
    public Flow<RunReportResult> invoke(@NotNull RunReportRequest var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J>\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$Companion;", "", "<init>", "()V", "fillIfNeeded", "", "Lworld/respect/datalayer/school/model/report/StatementReportRow;", "request", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "reportQueryResultsToResultStatementReportRows", "queryResults", "Lworld/respect/datalayer/db/shared/entities/ReportQueryResult;", "xAxisNameFn", "Lkotlin/Function1;", "", "DEFAULT_MAX_AGE", "", "Y_RANGE_BUFFER_FACTOR", "", "respect-lib-shared_release"})
    @SourceDebugExtension(value={"SMAP\nRunReportUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,239:1\n1563#2:240\n1634#2,3:241\n1208#2,2:245\n1236#2,4:247\n1563#2:251\n1634#2,3:252\n1491#2:255\n1516#2,3:256\n1519#2,3:266\n1563#2:272\n1634#2,3:273\n1617#2,9:277\n1869#2:286\n1870#2:288\n1626#2:289\n1#3:244\n1#3:287\n382#4,7:259\n126#5:269\n153#5,2:270\n155#5:276\n*S KotlinDebug\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$Companion\n*L\n179#1:240\n179#1:241,3\n182#1:245,2\n182#1:247,4\n192#1:251\n192#1:252,3\n211#1:255\n211#1:256,3\n211#1:266,3\n213#1:272\n213#1:273,3\n222#1:277,9\n222#1:286\n222#1:288\n222#1:289\n222#1:287\n211#1:259,7\n212#1:269\n212#1:270,2\n212#1:276\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int DEFAULT_MAX_AGE = 3600;
        public static final float Y_RANGE_BUFFER_FACTOR = 1.1f;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<StatementReportRow> fillIfNeeded(List<StatementReportRow> $this$fillIfNeeded, RunReportRequest request) {
            void $this$associateByTo$iv$iv;
            Iterable iterable;
            Object object;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$fillIfNeeded;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                StatementReportRow statementReportRow = (StatementReportRow)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getSubgroup());
            }
            $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if ($this$map$iv.isEmpty()) {
                boolean bl = false;
                iterable = CollectionsKt.listOf((Object)"");
            } else {
                iterable = $this$map$iv;
            }
            List allSubGroups = (List)iterable;
            DatePeriod datePeriod = request.getReportOptions().getXAxis().getDatePeriod();
            if (datePeriod == null) {
                return $this$fillIfNeeded;
            }
            DatePeriod datePeriod2 = datePeriod;
            List resultList = new ArrayList();
            Iterable $this$associateBy$iv = $this$fillIfNeeded;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            item$iv$iv2 = $this$associateBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                StatementReportRow statementReportRow = (StatementReportRow)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(new Pair((Object)it.getXAxis(), (Object)it.getSubgroup()), element$iv$iv);
            }
            Map rowMap = destination$iv$iv2;
            LocalDateTime fromDateTime = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(request.getReportOptions().getPeriod().periodStartMillis(request.getTimeZone())), (TimeZone)request.getTimeZone());
            long reportEndMs = request.getReportOptions().getPeriod().periodEndMillis(request.getTimeZone());
            while (TimeZoneKt.toInstant$default((LocalDateTime)fromDateTime, (TimeZone)request.getTimeZone(), null, (int)2, null).toEpochMilliseconds() < reportEndMs) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                String xAxisStr = fromDateTime.getDate().toString();
                destination$iv$iv2 = allSubGroups;
                object = resultList;
                boolean $i$f$map2 = false;
                Iterator iterator = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void subgroup;
                    String string2 = (String)item$iv$iv3;
                    Collection collection = destination$iv$iv3;
                    boolean bl = false;
                    StatementReportRow statementReportRow = (StatementReportRow)rowMap.get(new Pair((Object)xAxisStr, (Object)subgroup));
                    if (statementReportRow == null) {
                        statementReportRow = new StatementReportRow(0.0, xAxisStr, (String)subgroup, 1, null);
                    }
                    collection.add(statementReportRow);
                }
                object.addAll((List)destination$iv$iv3);
                fromDateTime = new LocalDateTime(LocalDateJvmKt.plus((LocalDate)fromDateTime.getDate(), (DatePeriod)datePeriod2), fromDateTime.getTime());
            }
            return CollectionsKt.toList((Iterable)resultList);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<List<StatementReportRow>> reportQueryResultsToResultStatementReportRows(@NotNull List<ReportQueryResult> queryResults, @NotNull RunReportRequest request, @NotNull Function1<? super String, String> xAxisNameFn) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            Object value$iv$iv$iv;
            Companion $this$getOrPut$iv$iv$iv;
            Integer key$iv$iv$iv;
            Object key$iv$iv;
            boolean bl;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(queryResults, (String)"queryResults");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(xAxisNameFn, (String)"xAxisNameFn");
            Object $this$groupBy$iv = queryResults;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object;
                ReportQueryResult it = (ReportQueryResult)t;
                bl = false;
                key$iv$iv = it.getRqrReportSeriesUid();
                Map map2 = destination$iv$iv;
                key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                Collection<StatementReportRow> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void entry2;
                list$iv$iv = entry;
                Object object = destination$iv$iv;
                bl = false;
                key$iv$iv = (Iterable)entry2.getValue();
                $this$getOrPut$iv$iv$iv = $$INSTANCE;
                key$iv$iv$iv = entry2.getKey();
                boolean $i$f$map2 = false;
                value$iv$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    ReportQueryResult reportQueryResult = (ReportQueryResult)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    StatementReportRow reportRow = ReportQueryResultExtKt.asStatementReportRow((ReportQueryResult)it);
                    boolean bl4 = false;
                    collection.add(StatementReportRow.copy$default((StatementReportRow)reportRow, (double)0.0, (String)((String)xAxisNameFn.invoke((Object)reportRow.getXAxis())), null, (int)5, null));
                }
                collection = (List)destination$iv$iv2;
                object.add(TuplesKt.to((Object)key$iv$iv$iv, $this$getOrPut$iv$iv$iv.fillIfNeeded((List<StatementReportRow>)collection, request)));
            }
            Map queryResultMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Iterable $this$mapNotNull$iv = request.getReportOptions().getSeries();
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                List it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                ReportSeries it = (ReportSeries)element$iv$iv;
                boolean bl5 = false;
                if ((List)queryResultMap.get(it.getReportSeriesUid()) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List reportQueryResultsToResultStatementReportRows$default(Companion companion, List list, RunReportRequest runReportRequest, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = Companion::reportQueryResultsToResultStatementReportRows$lambda$0;
            }
            return companion.reportQueryResultsToResultStatementReportRows(list, runReportRequest, (Function1<? super String, String>)function1);
        }

        private static final String reportQueryResultsToResultStatementReportRows$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u0001:\u000234B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fBI\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u000b\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J=\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u000eH\u00d6\u0001J\t\u0010*\u001a\u00020\bH\u00d6\u0001J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b2R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00065"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "", "reportUid", "", "reportOptions", "Lworld/respect/datalayer/school/model/report/ReportOptions;", "accountPersonUid", "cacheControl", "", "timeZone", "Lkotlinx/datetime/TimeZone;", "<init>", "(JLworld/respect/datalayer/school/model/report/ReportOptions;JLjava/lang/String;Lkotlinx/datetime/TimeZone;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJLworld/respect/datalayer/school/model/report/ReportOptions;JLjava/lang/String;Lkotlinx/datetime/TimeZone;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getReportUid", "()J", "getReportOptions", "()Lworld/respect/datalayer/school/model/report/ReportOptions;", "getAccountPersonUid", "getCacheControl", "()Ljava/lang/String;", "getTimeZone", "()Lkotlinx/datetime/TimeZone;", "maxFreshAge", "getMaxFreshAge", "()I", "maxFreshAge$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$respect_lib_shared_release", "$serializer", "Companion", "respect-lib-shared_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nRunReportUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
    public static final class RunReportRequest {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long reportUid;
        @NotNull
        private final ReportOptions reportOptions;
        private final long accountPersonUid;
        @Nullable
        private final String cacheControl;
        @NotNull
        private final TimeZone timeZone;
        @NotNull
        private final Lazy maxFreshAge$delegate;
        public static final int $stable = 8;

        public RunReportRequest(long reportUid, @NotNull ReportOptions reportOptions, long accountPersonUid, @Nullable String cacheControl, @NotNull TimeZone timeZone) {
            Intrinsics.checkNotNullParameter((Object)reportOptions, (String)"reportOptions");
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            this.reportUid = reportUid;
            this.reportOptions = reportOptions;
            this.accountPersonUid = accountPersonUid;
            this.cacheControl = cacheControl;
            this.timeZone = timeZone;
            this.maxFreshAge$delegate = LazyKt.lazy(() -> RunReportRequest.maxFreshAge_delegate$lambda$0(this));
        }

        public /* synthetic */ RunReportRequest(long l, ReportOptions reportOptions, long l2, String string2, TimeZone timeZone, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(l, reportOptions, l2, string2, timeZone);
        }

        public final long getReportUid() {
            return this.reportUid;
        }

        @NotNull
        public final ReportOptions getReportOptions() {
            return this.reportOptions;
        }

        public final long getAccountPersonUid() {
            return this.accountPersonUid;
        }

        @Nullable
        public final String getCacheControl() {
            return this.cacheControl;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        public final int getMaxFreshAge() {
            Lazy lazy = this.maxFreshAge$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public final long component1() {
            return this.reportUid;
        }

        @NotNull
        public final ReportOptions component2() {
            return this.reportOptions;
        }

        public final long component3() {
            return this.accountPersonUid;
        }

        @Nullable
        public final String component4() {
            return this.cacheControl;
        }

        @NotNull
        public final TimeZone component5() {
            return this.timeZone;
        }

        @NotNull
        public final RunReportRequest copy(long reportUid, @NotNull ReportOptions reportOptions, long accountPersonUid, @Nullable String cacheControl, @NotNull TimeZone timeZone) {
            Intrinsics.checkNotNullParameter((Object)reportOptions, (String)"reportOptions");
            Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
            return new RunReportRequest(reportUid, reportOptions, accountPersonUid, cacheControl, timeZone);
        }

        public static /* synthetic */ RunReportRequest copy$default(RunReportRequest runReportRequest, long l, ReportOptions reportOptions, long l2, String string2, TimeZone timeZone, int n, Object object) {
            if ((n & 1) != 0) {
                l = runReportRequest.reportUid;
            }
            if ((n & 2) != 0) {
                reportOptions = runReportRequest.reportOptions;
            }
            if ((n & 4) != 0) {
                l2 = runReportRequest.accountPersonUid;
            }
            if ((n & 8) != 0) {
                string2 = runReportRequest.cacheControl;
            }
            if ((n & 0x10) != 0) {
                timeZone = runReportRequest.timeZone;
            }
            return runReportRequest.copy(l, reportOptions, l2, string2, timeZone);
        }

        @NotNull
        public String toString() {
            return "RunReportRequest(reportUid=" + this.reportUid + ", reportOptions=" + this.reportOptions + ", accountPersonUid=" + this.accountPersonUid + ", cacheControl=" + this.cacheControl + ", timeZone=" + this.timeZone + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.reportUid);
            result = result * 31 + this.reportOptions.hashCode();
            result = result * 31 + Long.hashCode(this.accountPersonUid);
            result = result * 31 + (this.cacheControl == null ? 0 : this.cacheControl.hashCode());
            result = result * 31 + this.timeZone.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunReportRequest)) {
                return false;
            }
            RunReportRequest runReportRequest = (RunReportRequest)other;
            if (this.reportUid != runReportRequest.reportUid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.reportOptions, (Object)runReportRequest.reportOptions)) {
                return false;
            }
            if (this.accountPersonUid != runReportRequest.accountPersonUid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cacheControl, (Object)runReportRequest.cacheControl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeZone, (Object)runReportRequest.timeZone);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$respect_lib_shared_release(RunReportRequest self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeLongElement(serialDesc, 0, self.reportUid);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)ReportOptions.$serializer.INSTANCE, (Object)self.reportOptions);
            output.encodeLongElement(serialDesc, 2, self.accountPersonUid);
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.cacheControl != null) {
                output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.cacheControl);
            }
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)TimeZoneSerializer.INSTANCE, (Object)self.timeZone);
        }

        public /* synthetic */ RunReportRequest(int seen0, long reportUid, ReportOptions reportOptions, long accountPersonUid, String cacheControl, TimeZone timeZone, SerializationConstructorMarker serializationConstructorMarker) {
            if (23 != (0x17 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)23, (SerialDescriptor)RunReportRequest$$serializer.INSTANCE.getDescriptor());
            }
            this.reportUid = reportUid;
            this.reportOptions = reportOptions;
            this.accountPersonUid = accountPersonUid;
            this.cacheControl = (seen0 & 8) == 0 ? null : cacheControl;
            this.timeZone = timeZone;
            this.maxFreshAge$delegate = LazyKt.lazy(() -> RunReportRequest._init_$lambda$0(this));
        }

        private static final int maxFreshAge_delegate$lambda$0(RunReportRequest this$0) {
            int n;
            Map directives;
            Map map2;
            String string2 = this$0.cacheControl;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                map2 = DirectivesToMapKt.directivesToMap((String)it);
            } else {
                map2 = null;
            }
            Map map3 = directives = map2;
            String maxAgeVal = map3 != null ? (String)map3.get("max-age") : null;
            Map map4 = directives;
            boolean bl = map4 != null ? map4.containsKey("must-revalidate") : false;
            if (bl) {
                n = 0;
            } else {
                String string3 = maxAgeVal;
                n = string3 != null ? Integer.parseInt(string3) : 3600;
            }
            return n;
        }

        private static final int _init_$lambda$0(RunReportRequest this$0) {
            int n;
            Map directives;
            Map map2;
            String string2 = this$0.cacheControl;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                map2 = DirectivesToMapKt.directivesToMap((String)it);
            } else {
                map2 = null;
            }
            Map map3 = directives = map2;
            String maxAgeVal = map3 != null ? (String)map3.get("max-age") : null;
            Map map4 = directives;
            boolean bl = map4 != null ? map4.containsKey("must-revalidate") : false;
            if (bl) {
                n = 0;
            } else {
                String string3 = maxAgeVal;
                n = string3 != null ? Integer.parseInt(string3) : 3600;
            }
            return n;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "respect-lib-shared_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<RunReportRequest> serializer() {
                return (KSerializer)RunReportRequest$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\b\u0018\u0000 J2\u00020\u0001:\u0004GHIJB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fBK\b\u0010\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u000b\u0010\u0010J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\u0015\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007H\u00c6\u0003J\t\u00108\u001a\u00020\nH\u00c6\u0003J=\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020\nH\u00d6\u0001J\t\u0010>\u001a\u00020#H\u00d6\u0001J%\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0001\u00a2\u0006\u0002\bFR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001b\u0010\u0016R!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001d\u001a\u0004\b \u0010\u0016R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001d\u001a\u0004\b$\u0010\u0016R\u001d\u0010&\u001a\u0004\u0018\u00010'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001d\u001a\u0004\b(\u0010)R!\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u001d\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u00020#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u001d\u001a\u0004\b2\u00103\u00a8\u0006K"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;", "", "timestamp", "", "request", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "results", "", "Lworld/respect/datalayer/school/model/report/StatementReportRow;", "age", "", "<init>", "(JLworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;Ljava/util/List;I)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJLworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;Ljava/util/List;ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTimestamp", "()J", "getRequest", "()Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportRequest;", "getResults", "()Ljava/util/List;", "getAge", "()I", "resultSeries", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Series;", "getResultSeries", "resultSeries$delegate", "Lkotlin/Lazy;", "distinctSubgroups", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Subgroup;", "getDistinctSubgroups", "distinctSubgroups$delegate", "distinctXAxisValueSorted", "", "getDistinctXAxisValueSorted", "distinctXAxisValueSorted$delegate", "maxYValue", "", "getMaxYValue", "()Ljava/lang/Double;", "maxYValue$delegate", "yRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getYRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "yRange$delegate", "yAxisType", "getYAxisType", "()Ljava/lang/String;", "yAxisType$delegate", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$respect_lib_shared_release", "Series", "Subgroup", "$serializer", "Companion", "respect-lib-shared_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nRunReportUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1573#2:240\n1604#2,4:241\n1563#2:245\n1634#2,2:246\n1563#2:248\n1634#2,3:249\n1636#2:252\n1563#2:253\n1634#2,3:254\n1604#2,4:258\n1563#2:262\n1634#2,2:263\n1563#2:265\n1634#2,3:266\n1636#2:269\n1563#2:270\n1634#2,3:271\n1#3:257\n*S KotlinDebug\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult\n*L\n75#1:240\n75#1:241,4\n84#1:245\n84#1:246,2\n85#1:248\n85#1:249,3\n84#1:252\n92#1:253\n92#1:254,3\n75#1:258,4\n84#1:262\n84#1:263,2\n85#1:265\n85#1:266,3\n84#1:269\n92#1:270\n92#1:271,3\n*E\n"})
    public static final class RunReportResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long timestamp;
        @NotNull
        private final RunReportRequest request;
        @NotNull
        private final List<List<StatementReportRow>> results;
        private final int age;
        @NotNull
        private final Lazy resultSeries$delegate;
        @NotNull
        private final Lazy distinctSubgroups$delegate;
        @NotNull
        private final Lazy distinctXAxisValueSorted$delegate;
        @NotNull
        private final Lazy maxYValue$delegate;
        @NotNull
        private final Lazy yRange$delegate;
        @NotNull
        private final Lazy yAxisType$delegate;
        public static final int $stable = 8;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public RunReportResult(long timestamp, @NotNull RunReportRequest request, @NotNull List<? extends List<StatementReportRow>> results, int age) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.timestamp = timestamp;
            this.request = request;
            this.results = results;
            this.age = age;
            this.resultSeries$delegate = LazyKt.lazy(() -> RunReportResult.resultSeries_delegate$lambda$0(this));
            this.distinctSubgroups$delegate = LazyKt.lazy(() -> RunReportResult.distinctSubgroups_delegate$lambda$0(this));
            this.distinctXAxisValueSorted$delegate = LazyKt.lazy(() -> RunReportResult.distinctXAxisValueSorted_delegate$lambda$0(this));
            this.maxYValue$delegate = LazyKt.lazy(() -> RunReportResult.maxYValue_delegate$lambda$0(this));
            this.yRange$delegate = LazyKt.lazy(() -> RunReportResult.yRange_delegate$lambda$0(this));
            this.yAxisType$delegate = LazyKt.lazy(() -> RunReportResult.yAxisType_delegate$lambda$0(this));
        }

        public /* synthetic */ RunReportResult(long l, RunReportRequest runReportRequest, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            this(l, runReportRequest, list, n);
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final RunReportRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final List<List<StatementReportRow>> getResults() {
            return this.results;
        }

        public final int getAge() {
            return this.age;
        }

        @NotNull
        public final List<Series> getResultSeries() {
            Lazy lazy = this.resultSeries$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<Subgroup> getDistinctSubgroups() {
            Lazy lazy = this.distinctSubgroups$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<String> getDistinctXAxisValueSorted() {
            Lazy lazy = this.distinctXAxisValueSorted$delegate;
            return (List)lazy.getValue();
        }

        @Nullable
        public final Double getMaxYValue() {
            Lazy lazy = this.maxYValue$delegate;
            return (Double)lazy.getValue();
        }

        @NotNull
        public final ClosedFloatingPointRange<Float> getYRange() {
            Lazy lazy = this.yRange$delegate;
            return (ClosedFloatingPointRange)lazy.getValue();
        }

        @NotNull
        public final String getYAxisType() {
            Lazy lazy = this.yAxisType$delegate;
            return (String)lazy.getValue();
        }

        public final long component1() {
            return this.timestamp;
        }

        @NotNull
        public final RunReportRequest component2() {
            return this.request;
        }

        @NotNull
        public final List<List<StatementReportRow>> component3() {
            return this.results;
        }

        public final int component4() {
            return this.age;
        }

        @NotNull
        public final RunReportResult copy(long timestamp, @NotNull RunReportRequest request, @NotNull List<? extends List<StatementReportRow>> results, int age) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new RunReportResult(timestamp, request, results, age);
        }

        public static /* synthetic */ RunReportResult copy$default(RunReportResult runReportResult, long l, RunReportRequest runReportRequest, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = runReportResult.timestamp;
            }
            if ((n2 & 2) != 0) {
                runReportRequest = runReportResult.request;
            }
            if ((n2 & 4) != 0) {
                list = runReportResult.results;
            }
            if ((n2 & 8) != 0) {
                n = runReportResult.age;
            }
            return runReportResult.copy(l, runReportRequest, list, n);
        }

        @NotNull
        public String toString() {
            return "RunReportResult(timestamp=" + this.timestamp + ", request=" + this.request + ", results=" + this.results + ", age=" + this.age + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.timestamp);
            result = result * 31 + this.request.hashCode();
            result = result * 31 + ((Object)this.results).hashCode();
            result = result * 31 + Integer.hashCode(this.age);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunReportResult)) {
                return false;
            }
            RunReportResult runReportResult = (RunReportResult)other;
            if (this.timestamp != runReportResult.timestamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.request, (Object)runReportResult.request)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.results, runReportResult.results)) {
                return false;
            }
            return this.age == runReportResult.age;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$respect_lib_shared_release(RunReportResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeLongElement(serialDesc, 0, self.timestamp);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)RunReportRequest$$serializer.INSTANCE, (Object)self.request);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.results);
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.age != 0) {
                output.encodeIntElement(serialDesc, 3, self.age);
            }
        }

        public /* synthetic */ RunReportResult(int seen0, long timestamp, RunReportRequest request, List results, int age, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)RunReportResult$$serializer.INSTANCE.getDescriptor());
            }
            this.timestamp = timestamp;
            this.request = request;
            this.results = results;
            this.age = (seen0 & 8) == 0 ? 0 : age;
            this.resultSeries$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$0(this));
            this.distinctSubgroups$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$1(this));
            this.distinctXAxisValueSorted$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$2(this));
            this.maxYValue$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$3(this));
            this.yRange$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$4(this));
            this.yAxisType$delegate = LazyKt.lazy(() -> RunReportResult._init_$lambda$5(this));
        }

        /*
         * WARNING - void declaration
         */
        private static final List resultSeries_delegate$lambda$0(RunReportResult this$0) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this$0.request.getReportOptions().getSeries();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void reportSeriesOptions;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ReportSeries reportSeries = (ReportSeries)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Series((ReportSeries)reportSeriesOptions, this$0.results.get((int)index)));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List distinctSubgroups_delegate$lambda$0(RunReportResult this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this$0.getResultSeries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                void series;
                Series series2 = (Series)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = series.getData();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    StatementReportRow statementReportRow = (StatementReportRow)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getSubgroup());
                }
                $this$map$iv2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(new Subgroup(it, (Series)series));
                }
                collection2.add((List)destination$iv$iv2);
            }
            return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private static final List distinctXAxisValueSorted_delegate$lambda$0(RunReportResult this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)this$0.results);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StatementReportRow statementReportRow = (StatementReportRow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getXAxis());
            }
            return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        }

        private static final Double maxYValue_delegate$lambda$0(RunReportResult this$0) {
            Double d;
            Iterator iterator = ((Iterable)this$0.results).iterator();
            if (!iterator.hasNext()) {
                d = null;
            } else {
                double d2;
                Double d3;
                List resultList = (List)iterator.next();
                boolean bl = false;
                Iterator iterator2 = ((Iterable)resultList).iterator();
                if (!iterator2.hasNext()) {
                    d3 = null;
                } else {
                    StatementReportRow it = (StatementReportRow)iterator2.next();
                    boolean bl2 = false;
                    double d4 = it.getYAxis();
                    while (iterator2.hasNext()) {
                        StatementReportRow it2 = (StatementReportRow)iterator2.next();
                        $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1$1 = false;
                        double d5 = it2.getYAxis();
                        d4 = Math.max(d4, d5);
                    }
                    d3 = d4;
                }
                double d6 = d2 = d3 != null ? d3 : 0.0;
                while (iterator.hasNext()) {
                    Double d7;
                    List resultList2 = (List)iterator.next();
                    $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1 = false;
                    Iterator iterator3 = ((Iterable)resultList2).iterator();
                    if (!iterator3.hasNext()) {
                        d7 = null;
                    } else {
                        StatementReportRow it = (StatementReportRow)iterator3.next();
                        boolean bl3 = false;
                        double d8 = it.getYAxis();
                        while (iterator3.hasNext()) {
                            StatementReportRow it3 = (StatementReportRow)iterator3.next();
                            $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1$1 = false;
                            double d9 = it3.getYAxis();
                            d8 = Math.max(d8, d9);
                        }
                        d7 = d8;
                    }
                    double d10 = d7 != null ? d7 : 0.0;
                    d2 = Math.max(d2, d10);
                }
                d = d2;
            }
            return d;
        }

        private static final ClosedFloatingPointRange yRange_delegate$lambda$0(RunReportResult this$0) {
            Double d = this$0.getMaxYValue();
            double maxVal = d != null ? d : 0.0;
            return maxVal > 0.0 ? RangesKt.rangeTo((float)0.0f, (float)((float)maxVal * 1.1f)) : RangesKt.rangeTo((float)0.0f, (float)1.0f);
        }

        private static final String yAxisType_delegate$lambda$0(RunReportResult this$0) {
            return ((ReportSeries)CollectionsKt.first((List)this$0.request.getReportOptions().getSeries())).getReportSeriesYAxis().getType();
        }

        /*
         * WARNING - void declaration
         */
        private static final List _init_$lambda$0(RunReportResult this$0) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this$0.request.getReportOptions().getSeries();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void reportSeriesOptions;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ReportSeries reportSeries = (ReportSeries)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Series((ReportSeries)reportSeriesOptions, this$0.results.get((int)index)));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final List _init_$lambda$1(RunReportResult this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this$0.getResultSeries();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                void series;
                Series series2 = (Series)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = series.getData();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    StatementReportRow statementReportRow = (StatementReportRow)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getSubgroup());
                }
                $this$map$iv2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    it = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(new Subgroup(it, (Series)series));
                }
                collection2.add((List)destination$iv$iv2);
            }
            return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private static final List _init_$lambda$2(RunReportResult this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)this$0.results);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StatementReportRow statementReportRow = (StatementReportRow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getXAxis());
            }
            return CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        }

        private static final Double _init_$lambda$3(RunReportResult this$0) {
            Double d;
            Iterator iterator = ((Iterable)this$0.results).iterator();
            if (!iterator.hasNext()) {
                d = null;
            } else {
                double d2;
                Double d3;
                List resultList = (List)iterator.next();
                boolean bl = false;
                Iterator iterator2 = ((Iterable)resultList).iterator();
                if (!iterator2.hasNext()) {
                    d3 = null;
                } else {
                    StatementReportRow it = (StatementReportRow)iterator2.next();
                    boolean bl2 = false;
                    double d4 = it.getYAxis();
                    while (iterator2.hasNext()) {
                        StatementReportRow it2 = (StatementReportRow)iterator2.next();
                        $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1$1 = false;
                        double d5 = it2.getYAxis();
                        d4 = Math.max(d4, d5);
                    }
                    d3 = d4;
                }
                double d6 = d2 = d3 != null ? d3 : 0.0;
                while (iterator.hasNext()) {
                    Double d7;
                    List resultList2 = (List)iterator.next();
                    $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1 = false;
                    Iterator iterator3 = ((Iterable)resultList2).iterator();
                    if (!iterator3.hasNext()) {
                        d7 = null;
                    } else {
                        StatementReportRow it = (StatementReportRow)iterator3.next();
                        boolean bl3 = false;
                        double d8 = it.getYAxis();
                        while (iterator3.hasNext()) {
                            StatementReportRow it3 = (StatementReportRow)iterator3.next();
                            $i$a$-maxOfOrNull-RunReportUseCase$RunReportResult$maxYValue$2$1$1 = false;
                            double d9 = it3.getYAxis();
                            d8 = Math.max(d8, d9);
                        }
                        d7 = d8;
                    }
                    double d10 = d7 != null ? d7 : 0.0;
                    d2 = Math.max(d2, d10);
                }
                d = d2;
            }
            return d;
        }

        private static final ClosedFloatingPointRange _init_$lambda$4(RunReportResult this$0) {
            Double d = this$0.getMaxYValue();
            double maxVal = d != null ? d : 0.0;
            return maxVal > 0.0 ? RangesKt.rangeTo((float)0.0f, (float)((float)maxVal * 1.1f)) : RangesKt.rangeTo((float)0.0f, (float)1.0f);
        }

        private static final String _init_$lambda$5(RunReportResult this$0) {
            return ((ReportSeries)CollectionsKt.first((List)this$0.request.getReportOptions().getSeries())).getReportSeriesYAxis().getType();
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)new ArrayListSerializer((KSerializer)StatementReportRow.$serializer.INSTANCE))), null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;", "respect-lib-shared_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<RunReportResult> serializer() {
                return (KSerializer)RunReportResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Series;", "", "reportSeriesOptions", "Lworld/respect/datalayer/school/model/report/ReportSeries;", "data", "", "Lworld/respect/datalayer/school/model/report/StatementReportRow;", "<init>", "(Lworld/respect/datalayer/school/model/report/ReportSeries;Ljava/util/List;)V", "getReportSeriesOptions", "()Lworld/respect/datalayer/school/model/report/ReportSeries;", "getData", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "respect-lib-shared_release"})
        @StabilityInferred(parameters=0)
        public static final class Series {
            @NotNull
            private final ReportSeries reportSeriesOptions;
            @NotNull
            private final List<StatementReportRow> data;
            public static final int $stable = 8;

            public Series(@NotNull ReportSeries reportSeriesOptions, @NotNull List<StatementReportRow> data) {
                Intrinsics.checkNotNullParameter((Object)reportSeriesOptions, (String)"reportSeriesOptions");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                this.reportSeriesOptions = reportSeriesOptions;
                this.data = data;
            }

            @NotNull
            public final ReportSeries getReportSeriesOptions() {
                return this.reportSeriesOptions;
            }

            @NotNull
            public final List<StatementReportRow> getData() {
                return this.data;
            }

            @NotNull
            public final ReportSeries component1() {
                return this.reportSeriesOptions;
            }

            @NotNull
            public final List<StatementReportRow> component2() {
                return this.data;
            }

            @NotNull
            public final Series copy(@NotNull ReportSeries reportSeriesOptions, @NotNull List<StatementReportRow> data) {
                Intrinsics.checkNotNullParameter((Object)reportSeriesOptions, (String)"reportSeriesOptions");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                return new Series(reportSeriesOptions, data);
            }

            public static /* synthetic */ Series copy$default(Series series, ReportSeries reportSeries, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    reportSeries = series.reportSeriesOptions;
                }
                if ((n & 2) != 0) {
                    list = series.data;
                }
                return series.copy(reportSeries, list);
            }

            @NotNull
            public String toString() {
                return "Series(reportSeriesOptions=" + this.reportSeriesOptions + ", data=" + this.data + ")";
            }

            public int hashCode() {
                int result = this.reportSeriesOptions.hashCode();
                result = result * 31 + ((Object)this.data).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Series)) {
                    return false;
                }
                Series series = (Series)other;
                if (!Intrinsics.areEqual((Object)this.reportSeriesOptions, (Object)series.reportSeriesOptions)) {
                    return false;
                }
                return Intrinsics.areEqual(this.data, series.data);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Subgroup;", "", "value", "", "series", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Series;", "<init>", "(Ljava/lang/String;Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Series;)V", "getValue", "()Ljava/lang/String;", "getSeries", "()Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Series;", "subgroupData", "", "Lworld/respect/datalayer/school/model/report/StatementReportRow;", "getSubgroupData", "()Ljava/util/List;", "subgroupData$delegate", "Lkotlin/Lazy;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "respect-lib-shared_release"})
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nRunReportUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Subgroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n774#2:240\n865#2,2:241\n*S KotlinDebug\n*F\n+ 1 RunReportUseCase.kt\nworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult$Subgroup\n*L\n69#1:240\n69#1:241,2\n*E\n"})
        public static final class Subgroup {
            @NotNull
            private final String value;
            @NotNull
            private final Series series;
            @NotNull
            private final Lazy subgroupData$delegate;
            public static final int $stable = 8;

            public Subgroup(@NotNull String value, @NotNull Series series) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)series, (String)"series");
                this.value = value;
                this.series = series;
                this.subgroupData$delegate = LazyKt.lazy(() -> Subgroup.subgroupData_delegate$lambda$0(this));
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public final Series getSeries() {
                return this.series;
            }

            @NotNull
            public final List<StatementReportRow> getSubgroupData() {
                Lazy lazy = this.subgroupData$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final Series component2() {
                return this.series;
            }

            @NotNull
            public final Subgroup copy(@NotNull String value, @NotNull Series series) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)series, (String)"series");
                return new Subgroup(value, series);
            }

            public static /* synthetic */ Subgroup copy$default(Subgroup subgroup, String string2, Series series, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = subgroup.value;
                }
                if ((n & 2) != 0) {
                    series = subgroup.series;
                }
                return subgroup.copy(string2, series);
            }

            @NotNull
            public String toString() {
                return "Subgroup(value=" + this.value + ", series=" + this.series + ")";
            }

            public int hashCode() {
                int result = this.value.hashCode();
                result = result * 31 + this.series.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Subgroup)) {
                    return false;
                }
                Subgroup subgroup = (Subgroup)other;
                if (!Intrinsics.areEqual((Object)this.value, (Object)subgroup.value)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.series, (Object)subgroup.series);
            }

            /*
             * WARNING - void declaration
             */
            private static final List subgroupData_delegate$lambda$0(Subgroup this$0) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this$0.series.getData();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    StatementReportRow it = (StatementReportRow)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSubgroup(), (Object)this$0.value)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
    }
}

