/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00128\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u001eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00018\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R@\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "R", "", "defaultRenderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "redrawerFactory", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "renderApi", "oldRedrawer", "onRenderApiChanged", "Lkotlin/Function1;", "", "(Lorg/jetbrains/skiko/GraphicsApi;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "fallbackRenderApiQueue", "", "<set-?>", "redrawer", "getRedrawer", "()Ljava/lang/Object;", "Ljava/lang/Object;", "value", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "dispose", "findNextWorkingRenderApi", "recreation", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nRedrawerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,49:1\n159#2,4:50\n*S KotlinDebug\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n*L\n36#1:50,4\n*E\n"})
public final class RedrawerManager<R> {
    @NotNull
    private final Function2<GraphicsApi, R, R> redrawerFactory;
    @Nullable
    private final Function1<GraphicsApi, Unit> onRenderApiChanged;
    @NotNull
    private final List<GraphicsApi> fallbackRenderApiQueue;
    @Nullable
    private R redrawer;
    @NotNull
    private GraphicsApi renderApi;

    public RedrawerManager(@NotNull GraphicsApi defaultRenderApi, @NotNull Function2<? super GraphicsApi, ? super R, ? extends R> redrawerFactory, @Nullable Function1<? super GraphicsApi, Unit> onRenderApiChanged) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultRenderApi), (String)"defaultRenderApi");
        Intrinsics.checkNotNullParameter(redrawerFactory, (String)"redrawerFactory");
        this.redrawerFactory = redrawerFactory;
        this.onRenderApiChanged = onRenderApiChanged;
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue$skiko(defaultRenderApi));
        this.renderApi = this.fallbackRenderApiQueue.get(0);
    }

    public /* synthetic */ RedrawerManager(GraphicsApi graphicsApi, Function2 function2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(graphicsApi, function2, (Function1<? super GraphicsApi, Unit>)function1);
    }

    @Nullable
    public final R getRedrawer() {
        return this.redrawer;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.renderApi;
    }

    public final void setRenderApi(@NotNull GraphicsApi value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            this.renderApi = value;
            Function1<GraphicsApi, Unit> function1 = this.onRenderApiChanged;
            if (function1 == null) break block0;
            function1.invoke((Object)value);
        }
    }

    public final void findNextWorkingRenderApi(boolean recreation) {
        if (recreation) {
            this.fallbackRenderApiQueue.add(0, this.renderApi);
        }
        boolean thrown = false;
        do {
            thrown = false;
            try {
                this.setRenderApi(this.fallbackRenderApiQueue.remove(0));
                this.redrawer = this.redrawerFactory.invoke((Object)this.renderApi, this.redrawer);
            }
            catch (RenderException e) {
                this.redrawer = null;
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$warn = false;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = e;
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    String string = "Fallback to next API";
                    skikoLoggerInterface.warn(throwable, string);
                }
                thrown = true;
            }
        } while (thrown && !((Collection)this.fallbackRenderApiQueue).isEmpty());
        if (thrown) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    public static /* synthetic */ void findNextWorkingRenderApi$default(RedrawerManager redrawerManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        redrawerManager2.findNextWorkingRenderApi(bl);
    }

    public final void dispose() {
        this.redrawer = null;
    }
}

