/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;

public final class MessagePassingQueueUtil {
    public static <E> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, int limit) {
        E e;
        int i2;
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        for (i2 = 0; i2 < limit && (e = queue.relaxedPoll()) != null; ++i2) {
            c.accept(e);
        }
        return i2;
    }

    public static <E> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c) {
        E e;
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        int i2 = 0;
        while ((e = queue.relaxedPoll()) != null) {
            ++i2;
            c.accept(e);
        }
        return i2;
    }

    public static <E> void drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit2) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == wait) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == exit2) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int idleCounter = 0;
        while (exit2.keepRunning()) {
            E e = queue.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    public static <E> void fill(MessagePassingQueue<E> q2, MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit2) {
        if (null == wait) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == exit2) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int idleCounter = 0;
        while (exit2.keepRunning()) {
            if (q2.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }

    public static <E> int fillBounded(MessagePassingQueue<E> q2, MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(q2, s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH, q2.capacity());
    }

    public static <E> int fillInBatchesToLimit(MessagePassingQueue<E> q2, MessagePassingQueue.Supplier<E> s2, int batch, int limit) {
        int filled;
        long result2 = 0L;
        do {
            if ((filled = q2.fill(s2, batch)) != 0) continue;
            return (int)result2;
        } while ((result2 += (long)filled) <= (long)limit);
        return (int)result2;
    }

    public static <E> int fillUnbounded(MessagePassingQueue<E> q2, MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(q2, s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

