/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.consumers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.org.w3c.dom.events.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0001J\u0011\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0096\u0001J\"\u0010\"\u001a\u00020\u00072\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b%H\u0096\u0001J-\u0010&\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00062\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00070\u0005H\u0096\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0010j\b\u0012\u0004\u0012\u00020\u0006`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkotlinx/html/consumers/TraceConsumer;", "R", "Lkotlinx/html/TagConsumer;", "downstream", "println", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlinx/html/TagConsumer;Lkotlin/jvm/functions/Function1;)V", "getDownstream", "()Lkotlinx/html/TagConsumer;", "getPrintln", "()Lkotlin/jvm/functions/Function1;", "id", "path", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "onTagStart", "tag", "Lkotlinx/html/Tag;", "onTagEnd", "onTagAttributeChange", "attribute", "value", "finalize", "()Ljava/lang/Object;", "onTagComment", "content", "", "onTagContent", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lkotlinx/html/Unsafe;", "Lkotlin/ExtensionFunctionType;", "onTagEvent", "event", "Lkotlinx/html/org/w3c/dom/events/Event;", "kotlinx-html"})
public final class TraceConsumer<R>
implements TagConsumer<R> {
    @NotNull
    private final TagConsumer<R> downstream;
    @NotNull
    private final Function1<String, Unit> println;
    @NotNull
    private final String id;
    @NotNull
    private final ArrayList<String> path;

    public TraceConsumer(@NotNull TagConsumer<? extends R> downstream, @NotNull Function1<? super String, Unit> println) {
        Intrinsics.checkNotNullParameter(downstream, "downstream");
        Intrinsics.checkNotNullParameter(println, "println");
        this.downstream = downstream;
        this.println = println;
        this.id = "ID-" + this.hashCode();
        this.path = new ArrayList(1024);
    }

    @NotNull
    public final TagConsumer<R> getDownstream() {
        return this.downstream;
    }

    @NotNull
    public final Function1<String, Unit> getPrintln() {
        return this.println;
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.downstream.onTagStart(tag);
        this.path.add(tag.getTagName());
        this.println.invoke('[' + this.id + "]  open " + tag.getTagName() + " path: " + CollectionsKt.joinToString$default(this.path, " > ", null, null, 0, null, null, 62, null));
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.downstream.onTagEnd(tag);
        this.path.remove(CollectionsKt.getLastIndex((List)this.path));
        this.println.invoke('[' + this.id + "] close " + tag.getTagName() + " path: " + CollectionsKt.joinToString$default(this.path, " > ", null, null, 0, null, null, 62, null));
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        this.downstream.onTagAttributeChange(tag, attribute, value);
        this.println.invoke('[' + this.id + "]     " + tag.getTagName() + '.' + attribute + " changed to " + value);
    }

    @Override
    public R finalize() {
        R v = this.downstream.finalize();
        this.println.invoke('[' + this.id + "] finalized: " + v);
        return v;
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(value, "value");
        this.downstream.onTagEvent(tag, event, value);
    }

    @Override
    public void onTagContent(@NotNull CharSequence content2) {
        Intrinsics.checkNotNullParameter(content2, "content");
        this.downstream.onTagContent(content2);
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkNotNullParameter((Object)entity, "entity");
        this.downstream.onTagContentEntity(entity);
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        this.downstream.onTagContentUnsafe(block2);
    }

    @Override
    public void onTagComment(@NotNull CharSequence content2) {
        Intrinsics.checkNotNullParameter(content2, "content");
        this.downstream.onTagComment(content2);
    }
}

