/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0017\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004H\u00a7@\u00a2\u0006\u0004\b\n\u0010\bJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u0011\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u00a7@\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u00a7@\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001e\u0010\u0014\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u00a7@\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u00a7@\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u00a7@\u00a2\u0006\u0004\b\u0019\u0010\u0018J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\fH\u00a7@\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u001d\u001a\u00020\u0015H\u00a7@\u00a2\u0006\u0004\b\u001e\u0010\u0018J\u0010\u0010\u001f\u001a\u00020\fH\u00a7@\u00a2\u0006\u0004\b\u001f\u0010 J\u001e\u0010\"\u001a\u00020\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u00a7@\u00a2\u0006\u0004\b\"\u0010\u0012J0\u0010&\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u00a7@\u00a2\u0006\u0004\b&\u0010'J&\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0015H\u00a7@\u00a2\u0006\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/ustadmobile/libcache/db/dao/CacheEntryDao;", "", "<init>", "()V", "", "url", "Lcom/ustadmobile/libcache/db/entities/CacheEntry;", "findByUrlAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "key", "findEntryAndBodyByKey", "entry", "", "insertAsync", "(Lcom/ustadmobile/libcache/db/entities/CacheEntry;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "", "insertList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateList", "upsertList", "", "batchId", "findByRequestBatchId", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEntriesWithLock", "lastAccessTime", "updateLastAccessedTime", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "batchSize", "findEvictableEntries", "totalEvictableSize", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entries", "delete", "headers", "lastValidated", "lastAccessed", "updateValidation", "(Ljava/lang/String;Ljava/lang/String;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "offset", "limit", "getEntryUrlsInOrder", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respect-lib-cache"})
@Dao
public abstract class CacheEntryDao {
    @Query(value="\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.url = :url \n    ")
    @Nullable
    public abstract Object findByUrlAsync(@NotNull String var1, @NotNull Continuation<? super CacheEntry> var2);

    @Query(value="\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key = :key\n    ")
    @Nullable
    public abstract Object findEntryAndBodyByKey(@NotNull String var1, @NotNull Continuation<? super CacheEntry> var2);

    @Insert
    @Nullable
    public abstract Object insertAsync(@NotNull CacheEntry var1, @NotNull Continuation<? super Long> var2);

    @Insert
    @Nullable
    public abstract Object insertList(@NotNull List<CacheEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Update
    @Nullable
    public abstract Object updateList(@NotNull List<CacheEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(onConflict=1)
    @Nullable
    public abstract Object upsertList(@NotNull List<CacheEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key IN\n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = :batchId)\n    ")
    @Nullable
    public abstract Object findByRequestBatchId(int var1, @NotNull Continuation<? super List<CacheEntry>> var2);

    @Query(value="\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = :batchId\n           AND EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)\n    ")
    @Nullable
    public abstract Object findEntriesWithLock(int var1, @NotNull Continuation<? super List<String>> var2);

    @Query(value="\n        UPDATE CacheEntry\n           SET lastAccessed = :lastAccessTime\n         WHERE key = :key  \n    ")
    @Nullable
    public abstract Object updateLastAccessedTime(@NotNull String var1, long var2, @NotNull Continuation<? super Unit> var4);

    @Query(value="\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key) \n      ORDER BY lastAccessed ASC           \n         LIMIT :batchSize       \n      \n    ")
    @Nullable
    public abstract Object findEvictableEntries(int var1, @NotNull Continuation<? super List<CacheEntry>> var2);

    @Query(value="\n        SELECT SUM(CacheEntry.storageSize)\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key)  \n    ")
    @Nullable
    public abstract Object totalEvictableSize(@NotNull Continuation<? super Long> var1);

    @Delete
    @Nullable
    public abstract Object delete(@NotNull List<CacheEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        UPDATE CacheEntry\n           SET responseHeaders = :headers,\n               lastValidated = :lastValidated,\n               lastAccessed = :lastAccessed\n         WHERE key = :key      \n    ")
    @Nullable
    public abstract Object updateValidation(@NotNull String var1, @NotNull String var2, long var3, long var5, @NotNull Continuation<? super Unit> var7);

    @Query(value="\n        SELECT CacheEntry.url\n          FROM CacheEntry\n      ORDER BY CacheEntry.key \n         LIMIT :limit\n        OFFSET :offset\n       \n    ")
    @Nullable
    public abstract Object getEntryUrlsInOrder(int var1, int var2, @NotNull Continuation<? super List<String>> var3);
}

