/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.ExperimentalVelocityTrackerApi;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a1\u0010\u0003\u001a\u00020\u0004*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a!\u0010\r\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a#\u0010\u0015\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a#\u0010\u0017\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0014\u001a2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\b\b\u0002\u0010 \u001a\u00020\u001bH\u0000\u001a(\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0011\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0082\b\u001a\u0014\u0010(\u001a\u00020\u000b*\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0002\u001a\r\u0010*\u001a\u00020\u000b*\u00020\u001bH\u0082\b\u001a(\u0010+\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`,0\u00052\u0006\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010/\u001a,\u00100\u001a\u00020\u000b*\f\u0012\u0004\u0012\u00020\u001b0\u0005j\u0002`12\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00104\u001a4\u0010\u0003\u001a\u00020\u0004*\f\u0012\u0004\u0012\u00020\u001b0\u0005j\u0002`12\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u000bH\u0082\n\u00a2\u0006\u0002\u00106\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"$\u00107\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\"$\u0010>\u001a\u00020$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b?\u00109\u001a\u0004\b@\u0010;\"\u0004\bA\u0010=*\f\b\u0002\u0010'\"\u00020\u001b2\u00020\u001b*\u0018\b\u0002\u0010+\"\b\u0012\u0004\u0012\u00020\u001b0\u00052\b\u0012\u0004\u0012\u00020\u001b0\u0005\u00a8\u0006B"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "HorizonMilliseconds", "set", "", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "time", "", "dataPoint", "", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "addPointerInputChange", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "offset", "Landroidx/compose/ui/geometry/Offset;", "addPointerInputChange-0AR0LA0", "(Landroidx/compose/ui/input/pointer/util/VelocityTracker;Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "addPointerInputChangeLegacy", "addPointerInputChangeLegacy-0AR0LA0", "addPointerInputChangeWithFix", "addPointerInputChangeWithFix-0AR0LA0", "DefaultWeight", "polyFitLeastSquares", "", "x", "y", "sampleCount", "degree", "coefficients", "calculateImpulseVelocity", "dataPoints", "isDataDifferential", "", "kineticEnergyToVelocity", "kineticEnergy", "Vector", "dot", "a", "norm", "Matrix", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "value", "([[FIIF)V", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse$annotations", "getVelocityTrackerStrategyUseImpulse", "setVelocityTrackerStrategyUseImpulse", "ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,748:1\n710#1:759\n717#1,2:760\n713#1,6:762\n710#1:768\n710#1:769\n705#1:770\n692#1:772\n692#1:773\n35#2,5:749\n35#2,5:754\n69#3:771\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n529#1:759\n531#1:760,2\n533#1:762,6\n540#1:768\n542#1:769\n555#1:770\n677#1:772\n683#1:773\n426#1:749,5\n464#1:754,5\n555#1:771\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    private static final void set(DataPointAtTime[] $this$set, int index2, long time2, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index2];
        if (currentEntry == null) {
            $this$set[index2] = new DataPointAtTime(time2, dataPoint);
        } else {
            currentEntry.setTime(time2);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter($this$addPointerInputChange, "<this>");
        Intrinsics.checkNotNullParameter(event, "event");
        VelocityTrackerKt.addPointerInputChange-0AR0LA0($this$addPointerInputChange, event, Offset.Companion.getZero-F1C5BW0());
    }

    public static final void addPointerInputChange-0AR0LA0(@NotNull VelocityTracker $this$addPointerInputChange_u2d0AR0LA0, @NotNull PointerInputChange event, long offset) {
        Intrinsics.checkNotNullParameter($this$addPointerInputChange_u2d0AR0LA0, "$this$addPointerInputChange");
        Intrinsics.checkNotNullParameter(event, "event");
        if (VelocityTrackerAddPointsFix) {
            VelocityTrackerKt.addPointerInputChangeWithFix-0AR0LA0($this$addPointerInputChange_u2d0AR0LA0, event, offset);
        } else {
            VelocityTrackerKt.addPointerInputChangeLegacy-0AR0LA0($this$addPointerInputChange_u2d0AR0LA0, event, offset);
        }
    }

    private static final void addPointerInputChangeLegacy-0AR0LA0(VelocityTracker $this$addPointerInputChangeLegacy_u2d0AR0LA0, PointerInputChange event, long offset) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeLegacy_u2d0AR0LA0.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeLegacy_u2d0AR0LA0.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U(it.getPosition-F1C5BW0(), previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            $this$addPointerInputChangeLegacy_u2d0AR0LA0.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy_u2d0AR0LA0.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), historicalDelta));
            $this$addPointerInputChangeLegacy_u2d0AR0LA0.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy_u2d0AR0LA0.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), offset));
        }
        long delta = Offset.minus-MK-Hz9U(event.getPosition-F1C5BW0(), previousPointerPosition);
        $this$addPointerInputChangeLegacy_u2d0AR0LA0.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy_u2d0AR0LA0.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), delta));
        $this$addPointerInputChangeLegacy_u2d0AR0LA0.addPosition-Uv8p0NA(event.getUptimeMillis(), Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy_u2d0AR0LA0.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), offset));
    }

    private static final void addPointerInputChangeWithFix-0AR0LA0(VelocityTracker $this$addPointerInputChangeWithFix_u2d0AR0LA0, PointerInputChange event, long offset) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix_u2d0AR0LA0.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange item$iv;
                HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                $this$addPointerInputChangeWithFix_u2d0AR0LA0.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U(it.getOriginalEventPosition-F1C5BW0$ui(), offset));
            }
            $this$addPointerInputChangeWithFix_u2d0AR0LA0.addPosition-Uv8p0NA(event.getUptimeMillis(), Offset.plus-MK-Hz9U(event.getOriginalEventPosition-F1C5BW0$ui(), offset));
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChangeWithFix_u2d0AR0LA0.getLastMoveEventTimeStamp$ui() > 40L) {
            $this$addPointerInputChangeWithFix_u2d0AR0LA0.resetTracking();
        }
        $this$addPointerInputChangeWithFix_u2d0AR0LA0.setLastMoveEventTimeStamp$ui(event.getUptimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] polyFitLeastSquares(@NotNull float[] x2, @NotNull float[] y2, int sampleCount, int degree, @NotNull float[] coefficients) {
        int $i$f$get;
        int $i$f$set;
        Intrinsics.checkNotNullParameter(x2, "x");
        Intrinsics.checkNotNullParameter(y2, "y");
        Intrinsics.checkNotNullParameter(coefficients, "coefficients");
        if (degree < 1) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= sampleCount ? sampleCount - 1 : degree;
        int m = sampleCount;
        int n = truncatedDegree + 1;
        boolean $i$f$Matrix = false;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a2 = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a2;
            boolean bl = false;
            float value$iv22 = 1.0f;
            $i$f$set = 0;
            $this$set$iv[row$iv][h] = value$iv22;
            for (int i2 = 1; i2 < n; ++i2) {
                void $this$get$iv;
                float[][] row$iv = a2;
                float[][] value$iv22 = a2;
                int row$iv2 = i2 - 1;
                $i$f$get = 0;
                value$iv22 = $this$get$iv[row$iv2][h] * x2[h];
                $i$f$set = 0;
                $this$set$iv[i2][h] = value$iv22;
            }
        }
        boolean $i$f$Matrix2 = false;
        int $this$set$iv = 0;
        float[][] value$iv32 = new float[n][];
        while ($this$set$iv < n) {
            $i$f$set = $this$set$iv++;
            value$iv32[$i$f$set] = new float[m];
        }
        float[][] q2 = value$iv32;
        boolean $i$f$Matrix3 = false;
        int value$iv32 = 0;
        float[][] $i$f$set2 = new float[n][];
        while (value$iv32 < n) {
            $i$f$get = value$iv32++;
            $i$f$set2[$i$f$get] = new float[n];
        }
        float[][] r = $i$f$set2;
        for (int j = 0; j < n; ++j) {
            void $this$fastCoerceAtLeast$iv;
            float[] w = q2[j];
            ArraysKt.copyInto(a2[j], w, 0, 0, m);
            for (int i3 = 0; i3 < j; ++i3) {
                float[] z = q2[i3];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv22 = w;
            boolean $i$f$norm = false;
            float $this$norm$iv22 = (float)Math.sqrt(VelocityTrackerKt.dot($this$norm$iv22, $this$norm$iv22));
            float minimumValue$iv2 = 1.0E-6f;
            boolean $i$f$fastCoerceAtLeast = false;
            float inverseNorm = 1.0f / ($this$fastCoerceAtLeast$iv < minimumValue$iv2 ? minimumValue$iv2 : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int minimumValue$iv2 = h++;
                w[minimumValue$iv2] = w[minimumValue$iv2] * inverseNorm;
            }
            float[] v = r[j];
            for (int i4 = 0; i4 < n; ++i4) {
                v[i4] = i4 < j ? 0.0f : VelocityTrackerKt.dot(w, a2[i4]);
            }
        }
        float[] wy = y2;
        for (int i5 = n - 1; -1 < i5; --i5) {
            float c = VelocityTrackerKt.dot(q2[i5], wy);
            float[] ri = r[i5];
            int n5 = i5 + 1;
            int j = n - 1;
            if (n5 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == n5) break;
                    --j;
                }
            }
            coefficients[i5] = c / ri[i5];
        }
        return coefficients;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast(n2 + 1, 0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time2, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start2 = sampleCount - 1;
        float nextTime = time2[start2];
        for (int i2 = start2; 0 < i2; --i2) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time2[i2 - 1])) continue;
            float dataPointsDelta = isDataDifferential ? -dataPoints[i2 - 1] : dataPoints[i2] - dataPoints[i2 - 1];
            float vCurr = dataPointsDelta / (currentTime - nextTime);
            boolean $i$f$kineticEnergyToVelocity = false;
            float vPrev = Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i2 != start2) continue;
            work *= 0.5f;
        }
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(kineticEnergy) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy));
    }

    private static final float dot(float[] $this$dot, float[] a2) {
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2 += $this$dot[i2] * a2[i2];
        }
        return result2;
    }

    private static final float norm(float[] $this$norm) {
        boolean $i$f$norm = false;
        return (float)Math.sqrt(VelocityTrackerKt.dot($this$norm, $this$norm));
    }

    private static final float[][] Matrix(int rows, int cols) {
        boolean $i$f$Matrix = false;
        int n = 0;
        float[][] fArrayArray = new float[rows][];
        while (n < rows) {
            int n2 = n++;
            fArrayArray[n2] = new float[cols];
        }
        return fArrayArray;
    }

    private static final float get(float[][] $this$get, int row, int col2) {
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        boolean $i$f$get = false;
        return $this$get[row][col2];
    }

    private static final void set(float[][] $this$set, int row, int col2, float value) {
        Intrinsics.checkNotNullParameter($this$set, "<this>");
        boolean $i$f$set = false;
        $this$set[row][col2] = value;
    }

    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        VelocityTrackerAddPointsFix = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    public static final void setVelocityTrackerStrategyUseImpulse(boolean bl) {
        VelocityTrackerStrategyUseImpulse = bl;
    }

    @ExperimentalVelocityTrackerApi
    public static /* synthetic */ void getVelocityTrackerStrategyUseImpulse$annotations() {
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index2, long time2, float dataPoint) {
        VelocityTrackerKt.set($receiver, index2, time2, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time2, int sampleCount, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time2, sampleCount, isDataDifferential);
    }
}

