/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.FontHinting;
import androidx.compose.ui.text.FontSmoothing;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.Platform;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/FontRasterizationSettings;", "", "smoothing", "Landroidx/compose/ui/text/FontSmoothing;", "hinting", "Landroidx/compose/ui/text/FontHinting;", "subpixelPositioning", "", "autoHintingForced", "<init>", "(Landroidx/compose/ui/text/FontSmoothing;Landroidx/compose/ui/text/FontHinting;ZZ)V", "getSmoothing", "()Landroidx/compose/ui/text/FontSmoothing;", "getHinting", "()Landroidx/compose/ui/text/FontHinting;", "getSubpixelPositioning", "()Z", "getAutoHintingForced", "equals", "other", "hashCode", "", "toString", "", "Companion", "ui-text"})
@ExperimentalTextApi
@StabilityInferred(parameters=1)
public final class FontRasterizationSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FontSmoothing smoothing;
    @NotNull
    private final FontHinting hinting;
    private final boolean subpixelPositioning;
    private final boolean autoHintingForced;
    public static final int $stable;
    @NotNull
    private static final Lazy<FontRasterizationSettings> PlatformDefault$delegate;

    public FontRasterizationSettings(@NotNull FontSmoothing smoothing, @NotNull FontHinting hinting, boolean subpixelPositioning, boolean autoHintingForced) {
        Intrinsics.checkNotNullParameter((Object)smoothing, "smoothing");
        Intrinsics.checkNotNullParameter((Object)hinting, "hinting");
        this.smoothing = smoothing;
        this.hinting = hinting;
        this.subpixelPositioning = subpixelPositioning;
        this.autoHintingForced = autoHintingForced;
    }

    @NotNull
    public final FontSmoothing getSmoothing() {
        return this.smoothing;
    }

    @NotNull
    public final FontHinting getHinting() {
        return this.hinting;
    }

    public final boolean getSubpixelPositioning() {
        return this.subpixelPositioning;
    }

    public final boolean getAutoHintingForced() {
        return this.autoHintingForced;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FontRasterizationSettings cfr_ignored_0 = (FontRasterizationSettings)other;
        if (this.smoothing != ((FontRasterizationSettings)other).smoothing) {
            return false;
        }
        if (this.hinting != ((FontRasterizationSettings)other).hinting) {
            return false;
        }
        if (this.subpixelPositioning != ((FontRasterizationSettings)other).subpixelPositioning) {
            return false;
        }
        return this.autoHintingForced == ((FontRasterizationSettings)other).autoHintingForced;
    }

    public int hashCode() {
        int result2 = this.smoothing.hashCode();
        result2 = 31 * result2 + this.hinting.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.subpixelPositioning);
        result2 = 31 * result2 + Boolean.hashCode(this.autoHintingForced);
        return result2;
    }

    @NotNull
    public String toString() {
        return "FontRasterizationSettings(smoothing=" + this.smoothing + ", hinting=" + this.hinting + ", subpixelPositioning=" + this.subpixelPositioning + ", autoHintingForced=" + this.autoHintingForced + ")";
    }

    private static final FontRasterizationSettings PlatformDefault_delegate$lambda$0() {
        FontRasterizationSettings fontRasterizationSettings;
        switch (WhenMappings.$EnumSwitchMapping$0[DesktopFont_desktopKt.currentPlatform().ordinal()]) {
            case 1: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Normal;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 2: 
            case 3: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Slight;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 4: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Slight;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                FontSmoothing fontSmoothing = FontSmoothing.AntiAlias;
                FontHinting fontHinting = FontHinting.Normal;
                fontRasterizationSettings = new FontRasterizationSettings(fontSmoothing, fontHinting, true, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fontRasterizationSettings;
    }

    static {
        PlatformDefault$delegate = LazyKt.lazy(FontRasterizationSettings::PlatformDefault_delegate$lambda$0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Landroidx/compose/ui/text/FontRasterizationSettings$Companion;", "", "<init>", "()V", "PlatformDefault", "Landroidx/compose/ui/text/FontRasterizationSettings;", "getPlatformDefault", "()Landroidx/compose/ui/text/FontRasterizationSettings;", "PlatformDefault$delegate", "Lkotlin/Lazy;", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontRasterizationSettings getPlatformDefault() {
            Lazy lazy = PlatformDefault$delegate;
            return (FontRasterizationSettings)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Unknown.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.Android.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.MacOS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.IOS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.TvOS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.WatchOS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

