package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlinx.datetime.LocalDate
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.PersonRoleEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonRoleEntityDao_Impl(
  __db: RoomDatabase,
) : PersonRoleEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonRoleEntity: EntityInsertAdapter<PersonRoleEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonRoleEntity = object : EntityInsertAdapter<PersonRoleEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PersonRoleEntity` (`prUid`,`prPersonGuidHash`,`prIsPrimaryRole`,`prRoleEnum`,`prBeginDate`,`prEndDate`) VALUES (nullif(?, 0),?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonRoleEntity) {
        statement.bindLong(1, entity.prUid.toLong())
        statement.bindLong(2, entity.prPersonGuidHash)
        val _tmp: Int = if (entity.prIsPrimaryRole) 1 else 0
        statement.bindLong(3, _tmp.toLong())
        val _tmp_1: Int = __schoolTypeConverters.fromPersonRoleType(entity.prRoleEnum)
        statement.bindLong(4, _tmp_1.toLong())
        val _tmpPrBeginDate: LocalDate? = entity.prBeginDate
        val _tmp_2: Long? = __schoolTypeConverters.fromLocalDate(_tmpPrBeginDate)
        if (_tmp_2 == null) {
          statement.bindNull(5)
        } else {
          statement.bindLong(5, _tmp_2)
        }
        val _tmpPrEndDate: LocalDate? = entity.prEndDate
        val _tmp_3: Long? = __schoolTypeConverters.fromLocalDate(_tmpPrEndDate)
        if (_tmp_3 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_3)
        }
      }
    }
  }

  public override suspend fun upsertList(personRoleEntities: List<PersonRoleEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonRoleEntity.insert(_connection, personRoleEntities)
  }

  public override suspend fun deleteByPersonGuidHash(personGuidHash: Long) {
    val _sql: String = """
        |
        |        DELETE FROM PersonRoleEntity
        |         WHERE prPersonGuidHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personGuidHash)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
