import * as React from 'react';
/**
 * This hook registers our descendant by passing it into an array. We can then
 * search that array by to find its index when registering it in the component.
 * We use this for focus management, keyboard navigation, and typeahead
 * functionality for some components.
 *
 * The hook accepts the element node
 *
 * Our main goals with this are:
 *   1) maximum composability,
 *   2) minimal API friction
 *   3) SSR compatibility*
 *   4) concurrent safe
 *   5) index always up-to-date with the tree despite changes
 *   6) works with memoization of any component in the tree (hopefully)
 *
 * * As for SSR, the good news is that we don't actually need the index on the
 * server for most use-cases, as we are only using it to determine the order of
 * composed descendants for keyboard navigation.
 */
export declare function useDescendant(descendant: TreeItemDescendant): {
    parentId: string | null;
    index: number;
};
interface DescendantProviderProps {
    id?: string;
    children: React.ReactNode;
}
export declare function DescendantProvider(props: DescendantProviderProps): React.JSX.Element;
export declare namespace DescendantProvider {
    var propTypes: any;
}
export interface TreeItemDescendant {
    element: HTMLLIElement;
    id: string;
}
export {};
