import { jsxs as _, jsx as p, Fragment as Fe } from "react/jsx-runtime";
import y from "react";
import { styled as G } from "@mui/material/styles";
import Mt from "@mui/material/IconButton";
import { grey as sn } from "@mui/material/colors";
import we from "@mui/material/Typography";
import cn from "@mui/material/MenuItem";
import hn from "@mui/material/ListItemIcon";
import gn from "@mui/material/ListItemText";
import mn from "@mui/material/Menu";
import yn from "@mui/material/InputAdornment";
import pn from "@mui/material/TextField";
const vn = "data:image/png;base64,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", Rt = {
  AC: "data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 513 342'%3e%3cpath fill='%230052B4' d='M0 0h513v342H0z'/%3e%3cpath fill='white' d='M440.1 181.1c-.1 39.2-6.4 81.4-57.4 101.5-51.1-20.1-57.3-62.3-57.4-101.5h114.8z'/%3e%3cpath fill='%2329DBFF' d='M439.6 197.7c-2.8 34.9-12.4 67.4-57 85-44.4-17.6-54.5-51.2-56.9-84.9'/%3e%3cpath fill='white' d='M437.8 214.1c-3.2 24.3-16.7 53.5-55.1 68.6-38.4-15.1-50.5-42.5-55.1-68.4'/%3e%3cpath fill='%2329DBFF' d='M434.2 230.3c-5.7 17.7-19.3 39.4-51.3 52.8-32-12.6-45.2-33.8-51.4-53'/%3e%3cpath fill='white' d='M426.7 246.9c-6.5 11.3-17.7 25.4-44 35.9-27.5-11.5-37.4-25.3-44-36.1'/%3e%3cpath fill='%2329DBFF' d='M412.4 265.1c-8.1 7.2-12 11.2-29.6 17.9-20.1-7.9-22.6-11.6-29.2-17.5'/%3e%3cpath fill='%235CC85C' d='M383.3 231.6c-.2-.2-27.9 35.7-27.9 35.7-1.8-1.3-10-9.5-13.3-15l41.3-50.1 40.2 49.7c-3.9 6.5-11.4 13.6-13.2 15M382.6 85.3l-26.5 45h53z'/%3e%3cellipse transform='rotate(-82.3 291.431 225.686)' fill='%23F7A226' cx='291.4' cy='225.7' rx='48.7' ry='15.7'/%3e%3cellipse transform='rotate(-68.099 303.087 164.67)' fill='%23DDC7AB' cx='303.1' cy='164.7' rx='11.7' ry='7.2'/%3e%3cellipse transform='rotate(-81.738 291.697 271.697)' fill='%23DDC7AB' cx='291.7' cy='271.7' rx='11.4' ry='3.3'/%3e%3cellipse transform='matrix(.9986 -.05353 .05353 .9986 -13.992 16.424)' fill='%23DDC7AB' cx='299.6' cy='269.4' rx='3.3' ry='11'/%3e%3cellipse transform='rotate(-21.518 314.54 201.06)' fill='%23DDC7AB' cx='314.5' cy='201.1' rx='4.1' ry='13.7'/%3e%3cellipse transform='rotate(-21.518 317.511 178.077)' fill='%23DDC7AB' cx='317.5' cy='178.1' rx='13.7' ry='4.1'/%3e%3cellipse transform='rotate(-7.7 473.781 225.857)' fill='%23F7A226' cx='473.6' cy='225.9' rx='15.7' ry='48.7'/%3e%3cellipse transform='rotate(-21.901 462.057 164.866)' fill='%23DDC7AB' cx='462' cy='164.9' rx='7.2' ry='11.7'/%3e%3cellipse transform='rotate(-8.27 473.27 271.908)' fill='%23DDC7AB' cx='473.4' cy='271.9' rx='3.3' ry='11.4'/%3e%3cellipse transform='matrix(.05353 -.9986 .9986 .05353 171.34 719.998)' fill='%23DDC7AB' cx='465.5' cy='269.6' rx='11' ry='3.3'/%3e%3cellipse transform='rotate(-68.482 450.552 201.247)' fill='%23DDC7AB' cx='450.6' cy='201.2' rx='13.7' ry='4.1'/%3e%3cellipse transform='rotate(-68.482 447.58 178.265)' fill='%23DDC7AB' cx='447.6' cy='178.3' rx='4.1' ry='13.7'/%3e%3cpath fill='%23B0C6CC' d='M373.3 130.3L356.1 155l17.8 26.1H396l4.7-25.4-5.4-25.4z'/%3e%3cpath fill='white' d='M256 0v117.4h-46.1l46.1 30.7v22.6h-22.6L160 121.8v48.9H96v-48.9l-73.4 48.9H0v-22.6l46.1-30.7H0v-64h46.1L0 22.7V0h22.6L96 48.9V0h64v48.9L233.4 0z'/%3e%3cpath fill='%23D80027' d='M144 0h-32v69.4H0v32h112v69.3h32v-69.3h112v-32H144z'/%3e%3cpath fill='%232E52B2' d='M256 22.7v30.7h-46.1z'/%3e%3cpath fill='%23D80027' d='M0 170.7v-11l62.5-42.3h22.6L7.3 170.7zM7.3.1l77.8 53.2H62.5L0 11.1V.1zM256 .1v11l-62.5 42.3h-22.6L248.7.1zm-7.3 170.6l-77.8-53.3h22.6l62.5 42.3v11z'/%3e%3c/svg%3e",
  TA: "data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 341.3'%3e%3cpath fill='%230052B4' d='M0 0h512v341.3H0z'/%3e%3cpath fill='white' d='M256 0v117.4h-46.1l46.1 30.7v22.6h-22.6L160 121.8v48.9H96v-48.9l-73.4 48.9H0v-22.6l46.1-30.7H0v-64h46.1L0 22.7V0h22.6L96 48.9V0h64v48.9L233.4 0z'/%3e%3cg fill='%23D80027'%3e%3cpath d='M144 0h-32v69.4H0v32h112v69.3h32v-69.3h112v-32H144z'/%3e%3cpath d='M0 0v15.1l57.4 38.3H80zm256 0v15.1l-57.4 38.3H176z'/%3e%3c/g%3e%3cpath fill='%232E52B2' d='M256 22.7v30.7h-46.1z'/%3e%3cpath d='M0 0v15.1l57.4 38.3H80zm256 0v15.1l-57.4 38.3H176z' fill='%23D80027'/%3e%3cpath fill='%232E52B2' d='M256 22.7v30.7h-46.1z'/%3e%3cpath d='M0 170.7v-15.1l57.4-38.2H80zm256 0v-15.1l-57.4-38.2H176z' fill='%23D80027'/%3e%3cpath fill='%2329DBFF' d='M448.9 169.5c0 9.6-.3 29.6-1.4 39.2-4.1 34.9-23.5 68.8-62.1 85.9-45.3-17.9-60.8-51-64.9-85.9-1.1-9.6-1.5-19.4-1.5-29l.3-47.1h129.2l.4 36.9z'/%3e%3cpath fill='white' d='M447.5 208.7c-.2 1.6-.4 3.3-.6 4.9-4.8 33.1-22.9 65.4-61.5 81-43.2-17-59.4-47.9-64.2-81-.2-1.6-.4-3.2-.6-4.9'/%3e%3cpath fill='%2329DBFF' d='M385.4 251.7l-22.9-43h45.8z'/%3e%3cpath fill='white' d='M385.4 165.8l-22.9 42.9h45.8z'/%3e%3cellipse fill='%23FFBE57' cx='474.8' cy='236.8' rx='16.8' ry='43.3'/%3e%3cellipse fill='%23FFBE57' cx='295.3' cy='236.8' rx='16.8' ry='43.3'/%3e%3cpath fill='white' d='M385.4 31.5l-33.4 44h68.5zM315.5 280s33.8 29.5 69.9 29.5 67.1-29.5 67.1-29.5l8.5 14.6S439.2 326 385.4 326 307 294.6 307 294.6l8.5-14.6z'/%3e%3cellipse fill='%23A5A5A5' cx='386.3' cy='104.3' rx='34.3' ry='23.3'/%3e%3c/svg%3e"
}, $t = {
  Flag: G("span")(() => ({
    display: "flex",
    alignItems: "center"
  })),
  Picture: G("picture")(() => ({
    display: "flex",
    alignItems: "center"
  })),
  Span: G("span")(() => ({
    width: "1px",
    clip: "rect(0 0 0 0)",
    clipPath: "inset(100%)",
    height: "1px",
    overflow: "hidden",
    position: "absolute",
    whiteSpace: "nowrap"
  }))
}, Nn = (t) => t ? t === "TA" || t === "AC" ? {
  TA: Rt.TA,
  AC: Rt.AC
}[t] : "" : vn, mt = ({ size: t = "small", isoCode: n, countryName: e = "" }) => {
  const r = n ? n.toLowerCase() : "", d = Nn(n), i = t === "small" ? 40 : 80;
  return /* @__PURE__ */ _($t.Flag, { "data-testid": n, className: "MuiTelInput-Flag", children: [
    d ? /* @__PURE__ */ p(
      "img",
      {
        src: d,
        alt: e || "unknown",
        width: i / 2
      }
    ) : /* @__PURE__ */ _($t.Picture, { children: [
      /* @__PURE__ */ p(
        "source",
        {
          type: "image/webp",
          srcSet: `https://flagcdn.com/w${i}/${r}.webp`
        }
      ),
      /* @__PURE__ */ p(
        "source",
        {
          type: "image/png",
          srcSet: `https://flagcdn.com/w${i}/${r}.png`
        }
      ),
      /* @__PURE__ */ p(
        "img",
        {
          src: `https://flagcdn.com/w${i}/${r}.png`,
          width: i / 2,
          alt: e || "unknown",
          loading: "lazy"
        }
      )
    ] }),
    n ? /* @__PURE__ */ p($t.Span, { children: n }) : null
  ] });
}, Et = {
  EU: [
    "AD",
    "AL",
    "AT",
    "AX",
    "BA",
    "BE",
    "BG",
    "BY",
    "CH",
    "CY",
    "CZ",
    "DE",
    "DK",
    "EE",
    "ES",
    "FI",
    "FO",
    "FR",
    "GB",
    "GG",
    "GI",
    "GR",
    "HR",
    "HU",
    "IE",
    "IM",
    "IS",
    "IT",
    "JE",
    "LI",
    "LT",
    "LU",
    "LV",
    "MC",
    "MD",
    "ME",
    "MK",
    "MT",
    "NL",
    "NO",
    "PL",
    "PT",
    "RO",
    "RS",
    "RU",
    "SE",
    "SI",
    "SJ",
    "SK",
    "SM",
    "UA",
    "VA",
    "XK"
  ],
  AS: [
    "AE",
    "AF",
    "AM",
    "AZ",
    "BD",
    "BH",
    "BN",
    "BT",
    "CC",
    "CN",
    "CX",
    "GE",
    "HK",
    "ID",
    "IL",
    "IN",
    "IO",
    "IQ",
    "IR",
    "JO",
    "JP",
    "KG",
    "KH",
    "KP",
    "KR",
    "KW",
    "KZ",
    "LA",
    "LB",
    "LK",
    "MM",
    "MN",
    "MO",
    "MV",
    "MY",
    "NP",
    "OM",
    "PH",
    "PK",
    "PS",
    "QA",
    "SA",
    "SG",
    "SY",
    "TH",
    "TJ",
    "TM",
    "TR",
    "TW",
    "UZ",
    "VN",
    "YE"
  ],
  NA: [
    "AG",
    "AI",
    "AW",
    "BB",
    "BL",
    "BM",
    "BQ",
    "BS",
    "BZ",
    "CA",
    "CR",
    "CU",
    "CW",
    "DM",
    "DO",
    "GD",
    "GL",
    "GP",
    "GT",
    "HN",
    "HT",
    "JM",
    "KN",
    "KY",
    "LC",
    "MF",
    "MQ",
    "MS",
    "MX",
    "NI",
    "PA",
    "PM",
    "PR",
    "SV",
    "SX",
    "TC",
    "TT",
    "US",
    "VC",
    "VG",
    "VI"
  ],
  SA: [
    "AR",
    "BO",
    "BR",
    "CL",
    "CO",
    "EC",
    "FK",
    "GF",
    "GY",
    "PE",
    "PY",
    "SR",
    "UY",
    "VE"
  ],
  OC: [
    "AS",
    "AU",
    "CK",
    "FJ",
    "FM",
    "GU",
    "KI",
    "MH",
    "MP",
    "NC",
    "NF",
    "NR",
    "NU",
    "NZ",
    "PF",
    "PG",
    "PW",
    "SB",
    "TK",
    "TL",
    "TO",
    "TV",
    "VU",
    "WF",
    "WS"
  ],
  AF: [
    "AO",
    "BF",
    "BI",
    "BJ",
    "BW",
    "CD",
    "CF",
    "CG",
    "CI",
    "CM",
    "CV",
    "DJ",
    "DZ",
    "EG",
    "EH",
    "ER",
    "ET",
    "GA",
    "GH",
    "GM",
    "GN",
    "GQ",
    "GW",
    "KE",
    "KM",
    "LR",
    "LS",
    "LY",
    "MA",
    "MG",
    "ML",
    "MR",
    "MU",
    "MW",
    "MZ",
    "NA",
    "NE",
    "NG",
    "RE",
    "RW",
    "SC",
    "SD",
    "SH",
    "SL",
    "SN",
    "SO",
    "SS",
    "ST",
    "SZ",
    "TD",
    "TG",
    "TN",
    "TZ",
    "UG",
    "YT",
    "ZA",
    "ZM",
    "ZW"
  ]
}, Tt = { version: 4, country_calling_codes: { 1: ["US", "AG", "AI", "AS", "BB", "BM", "BS", "CA", "DM", "DO", "GD", "GU", "JM", "KN", "KY", "LC", "MP", "MS", "PR", "SX", "TC", "TT", "VC", "VG", "VI"], 7: ["RU", "KZ"], 20: ["EG"], 27: ["ZA"], 30: ["GR"], 31: ["NL"], 32: ["BE"], 33: ["FR"], 34: ["ES"], 36: ["HU"], 39: ["IT", "VA"], 40: ["RO"], 41: ["CH"], 43: ["AT"], 44: ["GB", "GG", "IM", "JE"], 45: ["DK"], 46: ["SE"], 47: ["NO", "SJ"], 48: ["PL"], 49: ["DE"], 51: ["PE"], 52: ["MX"], 53: ["CU"], 54: ["AR"], 55: ["BR"], 56: ["CL"], 57: ["CO"], 58: ["VE"], 60: ["MY"], 61: ["AU", "CC", "CX"], 62: ["ID"], 63: ["PH"], 64: ["NZ"], 65: ["SG"], 66: ["TH"], 81: ["JP"], 82: ["KR"], 84: ["VN"], 86: ["CN"], 90: ["TR"], 91: ["IN"], 92: ["PK"], 93: ["AF"], 94: ["LK"], 95: ["MM"], 98: ["IR"], 211: ["SS"], 212: ["MA", "EH"], 213: ["DZ"], 216: ["TN"], 218: ["LY"], 220: ["GM"], 221: ["SN"], 222: ["MR"], 223: ["ML"], 224: ["GN"], 225: ["CI"], 226: ["BF"], 227: ["NE"], 228: ["TG"], 229: ["BJ"], 230: ["MU"], 231: ["LR"], 232: ["SL"], 233: ["GH"], 234: ["NG"], 235: ["TD"], 236: ["CF"], 237: ["CM"], 238: ["CV"], 239: ["ST"], 240: ["GQ"], 241: ["GA"], 242: ["CG"], 243: ["CD"], 244: ["AO"], 245: ["GW"], 246: ["IO"], 247: ["AC"], 248: ["SC"], 249: ["SD"], 250: ["RW"], 251: ["ET"], 252: ["SO"], 253: ["DJ"], 254: ["KE"], 255: ["TZ"], 256: ["UG"], 257: ["BI"], 258: ["MZ"], 260: ["ZM"], 261: ["MG"], 262: ["RE", "YT"], 263: ["ZW"], 264: ["NA"], 265: ["MW"], 266: ["LS"], 267: ["BW"], 268: ["SZ"], 269: ["KM"], 290: ["SH", "TA"], 291: ["ER"], 297: ["AW"], 298: ["FO"], 299: ["GL"], 350: ["GI"], 351: ["PT"], 352: ["LU"], 353: ["IE"], 354: ["IS"], 355: ["AL"], 356: ["MT"], 357: ["CY"], 358: ["FI", "AX"], 359: ["BG"], 370: ["LT"], 371: ["LV"], 372: ["EE"], 373: ["MD"], 374: ["AM"], 375: ["BY"], 376: ["AD"], 377: ["MC"], 378: ["SM"], 380: ["UA"], 381: ["RS"], 382: ["ME"], 383: ["XK"], 385: ["HR"], 386: ["SI"], 387: ["BA"], 389: ["MK"], 420: ["CZ"], 421: ["SK"], 423: ["LI"], 500: ["FK"], 501: ["BZ"], 502: ["GT"], 503: ["SV"], 504: ["HN"], 505: ["NI"], 506: ["CR"], 507: ["PA"], 508: ["PM"], 509: ["HT"], 590: ["GP", "BL", "MF"], 591: ["BO"], 592: ["GY"], 593: ["EC"], 594: ["GF"], 595: ["PY"], 596: ["MQ"], 597: ["SR"], 598: ["UY"], 599: ["CW", "BQ"], 670: ["TL"], 672: ["NF"], 673: ["BN"], 674: ["NR"], 675: ["PG"], 676: ["TO"], 677: ["SB"], 678: ["VU"], 679: ["FJ"], 680: ["PW"], 681: ["WF"], 682: ["CK"], 683: ["NU"], 685: ["WS"], 686: ["KI"], 687: ["NC"], 688: ["TV"], 689: ["PF"], 690: ["TK"], 691: ["FM"], 692: ["MH"], 850: ["KP"], 852: ["HK"], 853: ["MO"], 855: ["KH"], 856: ["LA"], 880: ["BD"], 886: ["TW"], 960: ["MV"], 961: ["LB"], 962: ["JO"], 963: ["SY"], 964: ["IQ"], 965: ["KW"], 966: ["SA"], 967: ["YE"], 968: ["OM"], 970: ["PS"], 971: ["AE"], 972: ["IL"], 973: ["BH"], 974: ["QA"], 975: ["BT"], 976: ["MN"], 977: ["NP"], 992: ["TJ"], 993: ["TM"], 994: ["AZ"], 995: ["GE"], 996: ["KG"], 998: ["UZ"] }, countries: { AC: ["247", "00", "(?:[01589]\\d|[46])\\d{4}", [5, 6]], AD: ["376", "00", "(?:1|6\\d)\\d{7}|[135-9]\\d{5}", [6, 8, 9], [["(\\d{3})(\\d{3})", "$1 $2", ["[135-9]"]], ["(\\d{4})(\\d{4})", "$1 $2", ["1"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"]]]], AE: ["971", "00", "(?:[4-7]\\d|9[0-689])\\d{7}|800\\d{2,9}|[2-4679]\\d{7}", [5, 6, 7, 8, 9, 10, 11, 12], [["(\\d{3})(\\d{2,9})", "$1 $2", ["60|8"]], ["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[236]|[479][2-8]"], "0$1"], ["(\\d{3})(\\d)(\\d{5})", "$1 $2 $3", ["[479]"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["5"], "0$1"]], "0"], AF: ["93", "00", "[2-7]\\d{8}", [9], [["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"]], "0"], AG: ["1", "011", "(?:268|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([457]\\d{6})$|1", "268$1", 0, "268"], AI: ["1", "011", "(?:264|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2457]\\d{6})$|1", "264$1", 0, "264"], AL: ["355", "00", "(?:700\\d\\d|900)\\d{3}|8\\d{5,7}|(?:[2-5]|6\\d)\\d{7}", [6, 7, 8, 9], [["(\\d{3})(\\d{3,4})", "$1 $2", ["80|9"], "0$1"], ["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["4[2-6]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2358][2-5]|4"], "0$1"], ["(\\d{3})(\\d{5})", "$1 $2", ["[23578]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["6"], "0$1"]], "0"], AM: ["374", "00", "(?:[1-489]\\d|55|60|77)\\d{6}", [8], [["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[89]0"], "0 $1"], ["(\\d{3})(\\d{5})", "$1 $2", ["2|3[12]"], "(0$1)"], ["(\\d{2})(\\d{6})", "$1 $2", ["1|47"], "(0$1)"], ["(\\d{2})(\\d{6})", "$1 $2", ["[3-9]"], "0$1"]], "0"], AO: ["244", "00", "[29]\\d{8}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[29]"]]]], AR: ["54", "00", "(?:11|[89]\\d\\d)\\d{8}|[2368]\\d{9}", [10, 11], [["(\\d{4})(\\d{2})(\\d{4})", "$1 $2-$3", ["2(?:2[024-9]|3[0-59]|47|6[245]|9[02-8])|3(?:3[28]|4[03-9]|5[2-46-8]|7[1-578]|8[2-9])", "2(?:[23]02|6(?:[25]|4[6-8])|9(?:[02356]|4[02568]|72|8[23]))|3(?:3[28]|4(?:[04679]|3[5-8]|5[4-68]|8[2379])|5(?:[2467]|3[237]|8[2-5])|7[1-578]|8(?:[2469]|3[2578]|5[4-8]|7[36-8]|8[5-8]))|2(?:2[24-9]|3[1-59]|47)", "2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3[78]|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8[23])|7[1-578]|8(?:[2469]|3[278]|5[56][46]|86[3-6]))|2(?:2[24-9]|3[1-59]|47)|38(?:[58][78]|7[378])|3(?:4[35][56]|58[45]|8(?:[38]5|54|76))[4-6]", "2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3(?:5(?:4[0-25689]|[56])|[78])|58|8[2379])|5(?:[2467]|3[237]|8(?:[23]|4(?:[45]|60)|5(?:4[0-39]|5|64)))|7[1-578]|8(?:[2469]|3[278]|54(?:4|5[13-7]|6[89])|86[3-6]))|2(?:2[24-9]|3[1-59]|47)|38(?:[58][78]|7[378])|3(?:454|85[56])[46]|3(?:4(?:36|5[56])|8(?:[38]5|76))[4-6]"], "0$1", 1], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["1"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[68]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2-$3", ["[23]"], "0$1", 1], ["(\\d)(\\d{4})(\\d{2})(\\d{4})", "$2 15-$3-$4", ["9(?:2[2-469]|3[3-578])", "9(?:2(?:2[024-9]|3[0-59]|47|6[245]|9[02-8])|3(?:3[28]|4[03-9]|5[2-46-8]|7[1-578]|8[2-9]))", "9(?:2(?:[23]02|6(?:[25]|4[6-8])|9(?:[02356]|4[02568]|72|8[23]))|3(?:3[28]|4(?:[04679]|3[5-8]|5[4-68]|8[2379])|5(?:[2467]|3[237]|8[2-5])|7[1-578]|8(?:[2469]|3[2578]|5[4-8]|7[36-8]|8[5-8])))|92(?:2[24-9]|3[1-59]|47)", "9(?:2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3[78]|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8[23])|7[1-578]|8(?:[2469]|3[278]|5(?:[56][46]|[78])|7[378]|8(?:6[3-6]|[78]))))|92(?:2[24-9]|3[1-59]|47)|93(?:4[35][56]|58[45]|8(?:[38]5|54|76))[4-6]", "9(?:2(?:[23]02|6(?:[25]|4(?:64|[78]))|9(?:[02356]|4(?:[0268]|5[2-6])|72|8[23]))|3(?:3[28]|4(?:[04679]|3(?:5(?:4[0-25689]|[56])|[78])|5(?:4[46]|8)|8[2379])|5(?:[2467]|3[237]|8(?:[23]|4(?:[45]|60)|5(?:4[0-39]|5|64)))|7[1-578]|8(?:[2469]|3[278]|5(?:4(?:4|5[13-7]|6[89])|[56][46]|[78])|7[378]|8(?:6[3-6]|[78]))))|92(?:2[24-9]|3[1-59]|47)|93(?:4(?:36|5[56])|8(?:[38]5|76))[4-6]"], "0$1", 0, "$1 $2 $3-$4"], ["(\\d)(\\d{2})(\\d{4})(\\d{4})", "$2 15-$3-$4", ["91"], "0$1", 0, "$1 $2 $3-$4"], ["(\\d{3})(\\d{3})(\\d{5})", "$1-$2-$3", ["8"], "0$1"], ["(\\d)(\\d{3})(\\d{3})(\\d{4})", "$2 15-$3-$4", ["9"], "0$1", 0, "$1 $2 $3-$4"]], "0", 0, "0?(?:(11|2(?:2(?:02?|[13]|2[13-79]|4[1-6]|5[2457]|6[124-8]|7[1-4]|8[13-6]|9[1267])|3(?:02?|1[467]|2[03-6]|3[13-8]|[49][2-6]|5[2-8]|[67])|4(?:7[3-578]|9)|6(?:[0136]|2[24-6]|4[6-8]?|5[15-8])|80|9(?:0[1-3]|[19]|2\\d|3[1-6]|4[02568]?|5[2-4]|6[2-46]|72?|8[23]?))|3(?:3(?:2[79]|6|8[2578])|4(?:0[0-24-9]|[12]|3[5-8]?|4[24-7]|5[4-68]?|6[02-9]|7[126]|8[2379]?|9[1-36-8])|5(?:1|2[1245]|3[237]?|4[1-46-9]|6[2-4]|7[1-6]|8[2-5]?)|6[24]|7(?:[069]|1[1568]|2[15]|3[145]|4[13]|5[14-8]|7[2-57]|8[126])|8(?:[01]|2[15-7]|3[2578]?|4[13-6]|5[4-8]?|6[1-357-9]|7[36-8]?|8[5-8]?|9[124])))15)?", "9$1"], AS: ["1", "011", "(?:[58]\\d\\d|684|900)\\d{7}", [10], 0, "1", 0, "([267]\\d{6})$|1", "684$1", 0, "684"], AT: ["43", "00", "1\\d{3,12}|2\\d{6,12}|43(?:(?:0\\d|5[02-9])\\d{3,9}|2\\d{4,5}|[3467]\\d{4}|8\\d{4,6}|9\\d{4,7})|5\\d{4,12}|8\\d{7,12}|9\\d{8,12}|(?:[367]\\d|4[0-24-9])\\d{4,11}", [4, 5, 6, 7, 8, 9, 10, 11, 12, 13], [["(\\d)(\\d{3,12})", "$1 $2", ["1(?:11|[2-9])"], "0$1"], ["(\\d{3})(\\d{2})", "$1 $2", ["517"], "0$1"], ["(\\d{2})(\\d{3,5})", "$1 $2", ["5[079]"], "0$1"], ["(\\d{3})(\\d{3,10})", "$1 $2", ["(?:31|4)6|51|6(?:5[0-3579]|[6-9])|7(?:20|32|8)|[89]"], "0$1"], ["(\\d{4})(\\d{3,9})", "$1 $2", ["[2-467]|5[2-6]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["5"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4,7})", "$1 $2 $3", ["5"], "0$1"]], "0"], AU: ["61", "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "1(?:[0-79]\\d{7}(?:\\d(?:\\d{2})?)?|8[0-24-9]\\d{7})|[2-478]\\d{8}|1\\d{4,7}", [5, 6, 7, 8, 9, 10, 12], [["(\\d{2})(\\d{3,4})", "$1 $2", ["16"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["16"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["14|4"], "0$1"], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[2378]"], "(0$1)"], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:30|[89])"]]], "0", 0, "(183[12])|0", 0, 0, 0, [["(?:(?:2(?:[0-26-9]\\d|3[0-8]|4[02-9]|5[0135-9])|3(?:[0-3589]\\d|4[0-578]|6[1-9]|7[0-35-9])|7(?:[013-57-9]\\d|2[0-8]))\\d{3}|8(?:51(?:0(?:0[03-9]|[12479]\\d|3[2-9]|5[0-8]|6[1-9]|8[0-7])|1(?:[0235689]\\d|1[0-69]|4[0-589]|7[0-47-9])|2(?:0[0-79]|[18][13579]|2[14-9]|3[0-46-9]|[4-6]\\d|7[89]|9[0-4]))|(?:6[0-8]|[78]\\d)\\d{3}|9(?:[02-9]\\d{3}|1(?:(?:[0-58]\\d|6[0135-9])\\d|7(?:0[0-24-9]|[1-9]\\d)|9(?:[0-46-9]\\d|5[0-79])))))\\d{3}", [9]], ["4(?:(?:79|94)[01]|83[0-389])\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[0-26-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\d{6}", [9]], ["180(?:0\\d{3}|2)\\d{3}", [7, 10]], ["190[0-26]\\d{6}", [10]], 0, 0, 0, ["163\\d{2,6}", [5, 6, 7, 8, 9]], ["14(?:5(?:1[0458]|[23][458])|71\\d)\\d{4}", [9]], ["13(?:00\\d{6}(?:\\d{2})?|45[0-4]\\d{3})|13\\d{4}", [6, 8, 10, 12]]], "0011"], AW: ["297", "00", "(?:[25-79]\\d\\d|800)\\d{4}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[25-9]"]]]], AX: ["358", "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "2\\d{4,9}|35\\d{4,5}|(?:60\\d\\d|800)\\d{4,6}|7\\d{5,11}|(?:[14]\\d|3[0-46-9]|50)\\d{4,8}", [5, 6, 7, 8, 9, 10, 11, 12], 0, "0", 0, 0, 0, 0, "18", 0, "00"], AZ: ["994", "00", "365\\d{6}|(?:[124579]\\d|60|88)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["90"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[28]|2|365|46", "1[28]|2|365[45]|46", "1[28]|2|365(?:4|5[02])|46"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[13-9]"], "0$1"]], "0"], BA: ["387", "00", "6\\d{8}|(?:[35689]\\d|49|70)\\d{6}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[1-3]|[7-9]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2-$3", ["[3-5]|6[56]"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["6"], "0$1"]], "0"], BB: ["1", "011", "(?:246|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "246$1", 0, "246"], BD: ["880", "00", "[1-469]\\d{9}|8[0-79]\\d{7,8}|[2-79]\\d{8}|[2-9]\\d{7}|[3-9]\\d{6}|[57-9]\\d{5}", [6, 7, 8, 9, 10], [["(\\d{2})(\\d{4,6})", "$1-$2", ["31[5-8]|[459]1"], "0$1"], ["(\\d{3})(\\d{3,7})", "$1-$2", ["3(?:[67]|8[013-9])|4(?:6[168]|7|[89][18])|5(?:6[128]|9)|6(?:[15]|28|4[14])|7[2-589]|8(?:0[014-9]|[12])|9[358]|(?:3[2-5]|4[235]|5[2-578]|6[0389]|76|8[3-7]|9[24])1|(?:44|66)[01346-9]"], "0$1"], ["(\\d{4})(\\d{3,6})", "$1-$2", ["[13-9]|22"], "0$1"], ["(\\d)(\\d{7,8})", "$1-$2", ["2"], "0$1"]], "0"], BE: ["32", "00", "4\\d{8}|[1-9]\\d{7}", [8, 9], [["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["(?:80|9)0"], "0$1"], ["(\\d)(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[239]|4[23]"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[15-8]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["4"], "0$1"]], "0"], BF: ["226", "00", "[025-7]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[025-7]"]]]], BG: ["359", "00", "00800\\d{7}|[2-7]\\d{6,7}|[89]\\d{6,8}|2\\d{5}", [6, 7, 8, 9, 12], [["(\\d)(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["2"], "0$1"], ["(\\d{3})(\\d{4})", "$1 $2", ["43[1-6]|70[1-9]"], "0$1"], ["(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["[356]|4[124-7]|7[1-9]|8[1-6]|9[1-7]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["(?:70|8)0"], "0$1"], ["(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3", ["43[1-7]|7"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[48]|9[08]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"], "0$1"]], "0"], BH: ["973", "00", "[136-9]\\d{7}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["[13679]|8[02-4679]"]]]], BI: ["257", "00", "(?:[267]\\d|31)\\d{6}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2367]"]]]], BJ: ["229", "00", "[24-689]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[24-689]"]]]], BL: ["590", "00", "590\\d{6}|(?:69|80|9\\d)\\d{7}", [9], 0, "0", 0, 0, 0, 0, 0, [["590(?:2[7-9]|3[3-7]|5[12]|87)\\d{4}"], ["69(?:0\\d\\d|1(?:2[2-9]|3[0-5]))\\d{4}"], ["80[0-5]\\d{6}"], 0, 0, 0, 0, 0, ["9(?:(?:395|76[018])\\d|475[0-5])\\d{4}"]]], BM: ["1", "011", "(?:441|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "441$1", 0, "441"], BN: ["673", "00", "[2-578]\\d{6}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-578]"]]]], BO: ["591", "00(?:1\\d)?", "(?:[2-467]\\d\\d|8001)\\d{5}", [8, 9], [["(\\d)(\\d{7})", "$1 $2", ["[23]|4[46]"]], ["(\\d{8})", "$1", ["[67]"]], ["(\\d{3})(\\d{2})(\\d{4})", "$1 $2 $3", ["8"]]], "0", 0, "0(1\\d)?"], BQ: ["599", "00", "(?:[34]1|7\\d)\\d{5}", [7], 0, 0, 0, 0, 0, 0, "[347]"], BR: ["55", "00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)", "(?:[1-46-9]\\d\\d|5(?:[0-46-9]\\d|5[0-46-9]))\\d{8}|[1-9]\\d{9}|[3589]\\d{8}|[34]\\d{7}", [8, 9, 10, 11], [["(\\d{4})(\\d{4})", "$1-$2", ["300|4(?:0[02]|37)", "4(?:02|37)0|[34]00"]], ["(\\d{3})(\\d{2,3})(\\d{4})", "$1 $2 $3", ["(?:[358]|90)0"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2-$3", ["(?:[14689][1-9]|2[12478]|3[1-578]|5[13-5]|7[13-579])[2-57]"], "($1)"], ["(\\d{2})(\\d{5})(\\d{4})", "$1 $2-$3", ["[16][1-9]|[2-57-9]"], "($1)"]], "0", 0, "(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\\d{10,11}))?", "$2"], BS: ["1", "011", "(?:242|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([3-8]\\d{6})$|1", "242$1", 0, "242"], BT: ["975", "00", "[17]\\d{7}|[2-8]\\d{6}", [7, 8], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-68]|7[246]"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[67]|7"]]]], BW: ["267", "00", "(?:0800|(?:[37]|800)\\d)\\d{6}|(?:[2-6]\\d|90)\\d{5}", [7, 8, 10], [["(\\d{2})(\\d{5})", "$1 $2", ["90"]], ["(\\d{3})(\\d{4})", "$1 $2", ["[24-6]|3[15-9]"]], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[37]"]], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["0"]], ["(\\d{3})(\\d{4})(\\d{3})", "$1 $2 $3", ["8"]]]], BY: ["375", "810", "(?:[12]\\d|33|44|902)\\d{7}|8(?:0[0-79]\\d{5,7}|[1-7]\\d{9})|8(?:1[0-489]|[5-79]\\d)\\d{7}|8[1-79]\\d{6,7}|8[0-79]\\d{5}|8\\d{5}", [6, 7, 8, 9, 10, 11], [["(\\d{3})(\\d{3})", "$1 $2", ["800"], "8 $1"], ["(\\d{3})(\\d{2})(\\d{2,4})", "$1 $2 $3", ["800"], "8 $1"], ["(\\d{4})(\\d{2})(\\d{3})", "$1 $2-$3", ["1(?:5[169]|6[3-5]|7[179])|2(?:1[35]|2[34]|3[3-5])", "1(?:5[169]|6(?:3[1-3]|4|5[125])|7(?:1[3-9]|7[0-24-6]|9[2-7]))|2(?:1[35]|2[34]|3[3-5])"], "8 0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["1(?:[56]|7[467])|2[1-3]"], "8 0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[1-4]"], "8 0$1"], ["(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["[89]"], "8 $1"]], "8", 0, "0|80?", 0, 0, 0, 0, "8~10"], BZ: ["501", "00", "(?:0800\\d|[2-8])\\d{6}", [7, 11], [["(\\d{3})(\\d{4})", "$1-$2", ["[2-8]"]], ["(\\d)(\\d{3})(\\d{4})(\\d{3})", "$1-$2-$3-$4", ["0"]]]], CA: ["1", "011", "(?:[2-8]\\d|90)\\d{8}|3\\d{6}", [7, 10], 0, "1", 0, 0, 0, 0, 0, [["(?:2(?:04|[23]6|[48]9|50|63)|3(?:06|43|54|6[578]|82)|4(?:03|1[68]|[26]8|3[178]|50|74)|5(?:06|1[49]|48|79|8[147])|6(?:04|[18]3|39|47|72)|7(?:0[59]|42|53|78|8[02])|8(?:[06]7|19|25|73)|90[25])[2-9]\\d{6}", [10]], ["", [10]], ["8(?:00|33|44|55|66|77|88)[2-9]\\d{6}", [10]], ["900[2-9]\\d{6}", [10]], ["52(?:3(?:[2-46-9][02-9]\\d|5(?:[02-46-9]\\d|5[0-46-9]))|4(?:[2-478][02-9]\\d|5(?:[034]\\d|2[024-9]|5[0-46-9])|6(?:0[1-9]|[2-9]\\d)|9(?:[05-9]\\d|2[0-5]|49)))\\d{4}|52[34][2-9]1[02-9]\\d{4}|(?:5(?:00|2[125-9]|33|44|66|77|88)|622)[2-9]\\d{6}", [10]], 0, ["310\\d{4}", [7]], 0, ["600[2-9]\\d{6}", [10]]]], CC: ["61", "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "1(?:[0-79]\\d{8}(?:\\d{2})?|8[0-24-9]\\d{7})|[148]\\d{8}|1\\d{5,7}", [6, 7, 8, 9, 10, 12], 0, "0", 0, "([59]\\d{7})$|0", "8$1", 0, 0, [["8(?:51(?:0(?:02|31|60|89)|1(?:18|76)|223)|91(?:0(?:1[0-2]|29)|1(?:[28]2|50|79)|2(?:10|64)|3(?:[06]8|22)|4[29]8|62\\d|70[23]|959))\\d{3}", [9]], ["4(?:(?:79|94)[01]|83[0-389])\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[0-26-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\d{6}", [9]], ["180(?:0\\d{3}|2)\\d{3}", [7, 10]], ["190[0-26]\\d{6}", [10]], 0, 0, 0, 0, ["14(?:5(?:1[0458]|[23][458])|71\\d)\\d{4}", [9]], ["13(?:00\\d{6}(?:\\d{2})?|45[0-4]\\d{3})|13\\d{4}", [6, 8, 10, 12]]], "0011"], CD: ["243", "00", "[189]\\d{8}|[1-68]\\d{6}", [7, 9], [["(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["88"], "0$1"], ["(\\d{2})(\\d{5})", "$1 $2", ["[1-6]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]"], "0$1"]], "0"], CF: ["236", "00", "(?:[27]\\d{3}|8776)\\d{4}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[278]"]]]], CG: ["242", "00", "222\\d{6}|(?:0\\d|80)\\d{7}", [9], [["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["8"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[02]"]]]], CH: ["41", "00", "8\\d{11}|[2-9]\\d{8}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8[047]|90"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-79]|81"], "0$1"], ["(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["8"], "0$1"]], "0"], CI: ["225", "00", "[02]\\d{9}", [10], [["(\\d{2})(\\d{2})(\\d)(\\d{5})", "$1 $2 $3 $4", ["2"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3 $4", ["0"]]]], CK: ["682", "00", "[2-578]\\d{4}", [5], [["(\\d{2})(\\d{3})", "$1 $2", ["[2-578]"]]]], CL: ["56", "(?:0|1(?:1[0-69]|2[02-5]|5[13-58]|69|7[0167]|8[018]))0", "12300\\d{6}|6\\d{9,10}|[2-9]\\d{8}", [9, 10, 11], [["(\\d{5})(\\d{4})", "$1 $2", ["219", "2196"], "($1)"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["44"]], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2[1-36]"], "($1)"], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["9[2-9]"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["3[2-5]|[47]|5[1-3578]|6[13-57]|8(?:0[1-9]|[1-9])"], "($1)"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["60|8"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]], ["(\\d{3})(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["60"]]]], CM: ["237", "00", "[26]\\d{8}|88\\d{6,7}", [8, 9], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["88"]], ["(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[26]|88"]]]], CN: ["86", "00|1(?:[12]\\d|79)\\d\\d00", "1[127]\\d{8,9}|2\\d{9}(?:\\d{2})?|[12]\\d{6,7}|86\\d{6}|(?:1[03-689]\\d|6)\\d{7,9}|(?:[3-579]\\d|8[0-57-9])\\d{6,9}", [7, 8, 9, 10, 11, 12], [["(\\d{2})(\\d{5,6})", "$1 $2", ["(?:10|2[0-57-9])[19]", "(?:10|2[0-57-9])(?:10|9[56])", "10(?:10|9[56])|2[0-57-9](?:100|9[56])"], "0$1"], ["(\\d{3})(\\d{5,6})", "$1 $2", ["3(?:[157]|35|49|9[1-68])|4(?:[17]|2[179]|6[47-9]|8[23])|5(?:[1357]|2[37]|4[36]|6[1-46]|80)|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]|4[13]|5[1-5])|(?:4[35]|59|85)[1-9]", "(?:3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[1-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))[19]", "85[23](?:10|95)|(?:3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[14-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))(?:10|9[56])", "85[23](?:100|95)|(?:3(?:[157]\\d|35|49|9[1-68])|4(?:[17]\\d|2[179]|[35][1-9]|6[47-9]|8[23])|5(?:[1357]\\d|2[37]|4[36]|6[1-46]|80|9[1-9])|6(?:3[1-5]|6[0238]|9[12])|7(?:01|[1579]\\d|2[248]|3[014-9]|4[3-6]|6[023689])|8(?:1[236-8]|2[5-7]|[37]\\d|5[14-9]|8[36-8]|9[1-8])|9(?:0[1-3689]|1[1-79]|[379]\\d|4[13]|5[1-5]))(?:100|9[56])"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["(?:4|80)0"]], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10|2(?:[02-57-9]|1[1-9])", "10|2(?:[02-57-9]|1[1-9])", "10[0-79]|2(?:[02-57-9]|1[1-79])|(?:10|21)8(?:0[1-9]|[1-9])"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["3(?:[3-59]|7[02-68])|4(?:[26-8]|3[3-9]|5[2-9])|5(?:3[03-9]|[468]|7[028]|9[2-46-9])|6|7(?:[0-247]|3[04-9]|5[0-4689]|6[2368])|8(?:[1-358]|9[1-7])|9(?:[013479]|5[1-5])|(?:[34]1|55|79|87)[02-9]"], "0$1", 1], ["(\\d{3})(\\d{7,8})", "$1 $2", ["9"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["80"], "0$1", 1], ["(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["[3-578]"], "0$1", 1], ["(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["1[3-9]"]], ["(\\d{2})(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["[12]"], "0$1", 1]], "0", 0, "(1(?:[12]\\d|79)\\d\\d)|0", 0, 0, 0, 0, "00"], CO: ["57", "00(?:4(?:[14]4|56)|[579])", "(?:60\\d\\d|9101)\\d{6}|(?:1\\d|3)\\d{9}", [10, 11], [["(\\d{3})(\\d{7})", "$1 $2", ["6"], "($1)"], ["(\\d{3})(\\d{7})", "$1 $2", ["3[0-357]|91"]], ["(\\d)(\\d{3})(\\d{7})", "$1-$2-$3", ["1"], "0$1", 0, "$1 $2 $3"]], "0", 0, "0([3579]|4(?:[14]4|56))?"], CR: ["506", "00", "(?:8\\d|90)\\d{8}|(?:[24-8]\\d{3}|3005)\\d{4}", [8, 10], [["(\\d{4})(\\d{4})", "$1 $2", ["[2-7]|8[3-9]"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["[89]"]]], 0, 0, "(19(?:0[0-2468]|1[09]|20|66|77|99))"], CU: ["53", "119", "[27]\\d{6,7}|[34]\\d{5,7}|63\\d{6}|(?:5|8\\d\\d)\\d{7}", [6, 7, 8, 10], [["(\\d{2})(\\d{4,6})", "$1 $2", ["2[1-4]|[34]"], "(0$1)"], ["(\\d)(\\d{6,7})", "$1 $2", ["7"], "(0$1)"], ["(\\d)(\\d{7})", "$1 $2", ["[56]"], "0$1"], ["(\\d{3})(\\d{7})", "$1 $2", ["8"], "0$1"]], "0"], CV: ["238", "0", "(?:[2-59]\\d\\d|800)\\d{4}", [7], [["(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[2-589]"]]]], CW: ["599", "00", "(?:[34]1|60|(?:7|9\\d)\\d)\\d{5}", [7, 8], [["(\\d{3})(\\d{4})", "$1 $2", ["[3467]"]], ["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["9[4-8]"]]], 0, 0, 0, 0, 0, "[69]"], CX: ["61", "001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011", "1(?:[0-79]\\d{8}(?:\\d{2})?|8[0-24-9]\\d{7})|[148]\\d{8}|1\\d{5,7}", [6, 7, 8, 9, 10, 12], 0, "0", 0, "([59]\\d{7})$|0", "8$1", 0, 0, [["8(?:51(?:0(?:01|30|59|88)|1(?:17|46|75)|2(?:22|35))|91(?:00[6-9]|1(?:[28]1|49|78)|2(?:09|63)|3(?:12|26|75)|4(?:56|97)|64\\d|7(?:0[01]|1[0-2])|958))\\d{3}", [9]], ["4(?:(?:79|94)[01]|83[0-389])\\d{5}|4(?:[0-3]\\d|4[047-9]|5[0-25-9]|6[0-26-9]|7[02-8]|8[0-24-9]|9[0-37-9])\\d{6}", [9]], ["180(?:0\\d{3}|2)\\d{3}", [7, 10]], ["190[0-26]\\d{6}", [10]], 0, 0, 0, 0, ["14(?:5(?:1[0458]|[23][458])|71\\d)\\d{4}", [9]], ["13(?:00\\d{6}(?:\\d{2})?|45[0-4]\\d{3})|13\\d{4}", [6, 8, 10, 12]]], "0011"], CY: ["357", "00", "(?:[279]\\d|[58]0)\\d{6}", [8], [["(\\d{2})(\\d{6})", "$1 $2", ["[257-9]"]]]], CZ: ["420", "00", "(?:[2-578]\\d|60)\\d{7}|9\\d{8,11}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-8]|9[015-7]"]], ["(\\d{2})(\\d{3})(\\d{3})(\\d{2})", "$1 $2 $3 $4", ["96"]], ["(\\d{2})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9"]], ["(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9"]]]], DE: ["49", "00", "[2579]\\d{5,14}|49(?:[34]0|69|8\\d)\\d\\d?|49(?:37|49|60|7[089]|9\\d)\\d{1,3}|49(?:2[024-9]|3[2-689]|7[1-7])\\d{1,8}|(?:1|[368]\\d|4[0-8])\\d{3,13}|49(?:[015]\\d|2[13]|31|[46][1-8])\\d{1,9}", [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [["(\\d{2})(\\d{3,13})", "$1 $2", ["3[02]|40|[68]9"], "0$1"], ["(\\d{3})(\\d{3,12})", "$1 $2", ["2(?:0[1-389]|1[124]|2[18]|3[14])|3(?:[35-9][15]|4[015])|906|(?:2[4-9]|4[2-9]|[579][1-9]|[68][1-8])1", "2(?:0[1-389]|12[0-8])|3(?:[35-9][15]|4[015])|906|2(?:[13][14]|2[18])|(?:2[4-9]|4[2-9]|[579][1-9]|[68][1-8])1"], "0$1"], ["(\\d{4})(\\d{2,11})", "$1 $2", ["[24-6]|3(?:[3569][02-46-9]|4[2-4679]|7[2-467]|8[2-46-8])|70[2-8]|8(?:0[2-9]|[1-8])|90[7-9]|[79][1-9]", "[24-6]|3(?:3(?:0[1-467]|2[127-9]|3[124578]|7[1257-9]|8[1256]|9[145])|4(?:2[135]|4[13578]|9[1346])|5(?:0[14]|2[1-3589]|6[1-4]|7[13468]|8[13568])|6(?:2[1-489]|3[124-6]|6[13]|7[12579]|8[1-356]|9[135])|7(?:2[1-7]|4[145]|6[1-5]|7[1-4])|8(?:21|3[1468]|6|7[1467]|8[136])|9(?:0[12479]|2[1358]|4[134679]|6[1-9]|7[136]|8[147]|9[1468]))|70[2-8]|8(?:0[2-9]|[1-8])|90[7-9]|[79][1-9]|3[68]4[1347]|3(?:47|60)[1356]|3(?:3[46]|46|5[49])[1246]|3[4579]3[1357]"], "0$1"], ["(\\d{3})(\\d{4})", "$1 $2", ["138"], "0$1"], ["(\\d{5})(\\d{2,10})", "$1 $2", ["3"], "0$1"], ["(\\d{3})(\\d{5,11})", "$1 $2", ["181"], "0$1"], ["(\\d{3})(\\d)(\\d{4,10})", "$1 $2 $3", ["1(?:3|80)|9"], "0$1"], ["(\\d{3})(\\d{7,8})", "$1 $2", ["1[67]"], "0$1"], ["(\\d{3})(\\d{7,12})", "$1 $2", ["8"], "0$1"], ["(\\d{5})(\\d{6})", "$1 $2", ["185", "1850", "18500"], "0$1"], ["(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["7"], "0$1"], ["(\\d{4})(\\d{7})", "$1 $2", ["18[68]"], "0$1"], ["(\\d{5})(\\d{6})", "$1 $2", ["15[0568]"], "0$1"], ["(\\d{4})(\\d{7})", "$1 $2", ["15[1279]"], "0$1"], ["(\\d{3})(\\d{8})", "$1 $2", ["18"], "0$1"], ["(\\d{3})(\\d{2})(\\d{7,8})", "$1 $2 $3", ["1(?:6[023]|7)"], "0$1"], ["(\\d{4})(\\d{2})(\\d{7})", "$1 $2 $3", ["15[279]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{8})", "$1 $2 $3", ["15"], "0$1"]], "0"], DJ: ["253", "00", "(?:2\\d|77)\\d{6}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[27]"]]]], DK: ["45", "00", "[2-9]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-9]"]]]], DM: ["1", "011", "(?:[58]\\d\\d|767|900)\\d{7}", [10], 0, "1", 0, "([2-7]\\d{6})$|1", "767$1", 0, "767"], DO: ["1", "011", "(?:[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, 0, 0, 0, "8001|8[024]9"], DZ: ["213", "00", "(?:[1-4]|[5-79]\\d|80)\\d{7}", [8, 9], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[1-4]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["9"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[5-8]"], "0$1"]], "0"], EC: ["593", "00", "1\\d{9,10}|(?:[2-7]|9\\d)\\d{7}", [8, 9, 10, 11], [["(\\d)(\\d{3})(\\d{4})", "$1 $2-$3", ["[2-7]"], "(0$1)", 0, "$1-$2-$3"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1"]]], "0"], EE: ["372", "00", "8\\d{9}|[4578]\\d{7}|(?:[3-8]\\d|90)\\d{5}", [7, 8, 10], [["(\\d{3})(\\d{4})", "$1 $2", ["[369]|4[3-8]|5(?:[0-2]|5[0-478]|6[45])|7[1-9]|88", "[369]|4[3-8]|5(?:[02]|1(?:[0-8]|95)|5[0-478]|6(?:4[0-4]|5[1-589]))|7[1-9]|88"]], ["(\\d{4})(\\d{3,4})", "$1 $2", ["[45]|8(?:00|[1-49])", "[45]|8(?:00[1-9]|[1-49])"]], ["(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["7"]], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]]]], EG: ["20", "00", "[189]\\d{8,9}|[24-6]\\d{8}|[135]\\d{7}", [8, 9, 10], [["(\\d)(\\d{7,8})", "$1 $2", ["[23]"], "0$1"], ["(\\d{2})(\\d{6,7})", "$1 $2", ["1[35]|[4-6]|8[2468]|9[235-7]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[89]"], "0$1"], ["(\\d{2})(\\d{8})", "$1 $2", ["1"], "0$1"]], "0"], EH: ["212", "00", "[5-8]\\d{8}", [9], 0, "0", 0, 0, 0, 0, "528[89]"], ER: ["291", "00", "[178]\\d{6}", [7], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[178]"], "0$1"]], "0"], ES: ["34", "00", "[5-9]\\d{8}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[89]00"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[5-9]"]]]], ET: ["251", "00", "(?:11|[2-579]\\d)\\d{7}", [9], [["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1-579]"], "0$1"]], "0"], FI: ["358", "00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))", "[1-35689]\\d{4}|7\\d{10,11}|(?:[124-7]\\d|3[0-46-9])\\d{8}|[1-9]\\d{5,8}", [5, 6, 7, 8, 9, 10, 11, 12], [["(\\d)(\\d{4,9})", "$1 $2", ["[2568][1-8]|3(?:0[1-9]|[1-9])|9"], "0$1"], ["(\\d{3})(\\d{3,7})", "$1 $2", ["[12]00|[368]|70[07-9]"], "0$1"], ["(\\d{2})(\\d{4,8})", "$1 $2", ["[1245]|7[135]"], "0$1"], ["(\\d{2})(\\d{6,10})", "$1 $2", ["7"], "0$1"]], "0", 0, 0, 0, 0, "1[03-79]|[2-9]", 0, "00"], FJ: ["679", "0(?:0|52)", "45\\d{5}|(?:0800\\d|[235-9])\\d{6}", [7, 11], [["(\\d{3})(\\d{4})", "$1 $2", ["[235-9]|45"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]]], 0, 0, 0, 0, 0, 0, 0, "00"], FK: ["500", "00", "[2-7]\\d{4}", [5]], FM: ["691", "00", "(?:[39]\\d\\d|820)\\d{4}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[389]"]]]], FO: ["298", "00", "[2-9]\\d{5}", [6], [["(\\d{6})", "$1", ["[2-9]"]]], 0, 0, "(10(?:01|[12]0|88))"], FR: ["33", "00", "[1-9]\\d{8}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0 $1"], ["(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["[1-79]"], "0$1"]], "0"], GA: ["241", "00", "(?:[067]\\d|11)\\d{6}|[2-7]\\d{6}", [7, 8], [["(\\d)(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-7]"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["0"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["11|[67]"], "0$1"]], 0, 0, "0(11\\d{6}|60\\d{6}|61\\d{6}|6[256]\\d{6}|7[467]\\d{6})", "$1"], GB: ["44", "00", "[1-357-9]\\d{9}|[18]\\d{8}|8\\d{6}", [7, 9, 10], [["(\\d{3})(\\d{4})", "$1 $2", ["800", "8001", "80011", "800111", "8001111"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["845", "8454", "84546", "845464"], "0$1"], ["(\\d{3})(\\d{6})", "$1 $2", ["800"], "0$1"], ["(\\d{5})(\\d{4,5})", "$1 $2", ["1(?:38|5[23]|69|76|94)", "1(?:(?:38|69)7|5(?:24|39)|768|946)", "1(?:3873|5(?:242|39[4-6])|(?:697|768)[347]|9467)"], "0$1"], ["(\\d{4})(\\d{5,6})", "$1 $2", ["1(?:[2-69][02-9]|[78])"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[25]|7(?:0|6[02-9])", "[25]|7(?:0|6(?:[03-9]|2[356]))"], "0$1"], ["(\\d{4})(\\d{6})", "$1 $2", ["7"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1389]"], "0$1"]], "0", 0, 0, 0, 0, 0, [["(?:1(?:1(?:3(?:[0-58]\\d\\d|73[0235])|4(?:[0-5]\\d\\d|69[7-9]|70[0-79])|(?:(?:5[0-26-9]|[78][0-49])\\d|6(?:[0-4]\\d|50))\\d)|(?:2(?:(?:0[024-9]|2[3-9]|3[3-79]|4[1-689]|[58][02-9]|6[0-47-9]|7[013-9]|9\\d)\\d|1(?:[0-7]\\d|8[0-2]))|(?:3(?:0\\d|1[0-8]|[25][02-9]|3[02-579]|[468][0-46-9]|7[1-35-79]|9[2-578])|4(?:0[03-9]|[137]\\d|[28][02-57-9]|4[02-69]|5[0-8]|[69][0-79])|5(?:0[1-35-9]|[16]\\d|2[024-9]|3[015689]|4[02-9]|5[03-9]|7[0-35-9]|8[0-468]|9[0-57-9])|6(?:0[034689]|1\\d|2[0-35689]|[38][013-9]|4[1-467]|5[0-69]|6[13-9]|7[0-8]|9[0-24578])|7(?:0[0246-9]|2\\d|3[0236-8]|4[03-9]|5[0-46-9]|6[013-9]|7[0-35-9]|8[024-9]|9[02-9])|8(?:0[35-9]|2[1-57-9]|3[02-578]|4[0-578]|5[124-9]|6[2-69]|7\\d|8[02-9]|9[02569])|9(?:0[02-589]|[18]\\d|2[02-689]|3[1-57-9]|4[2-9]|5[0-579]|6[2-47-9]|7[0-24578]|9[2-57]))\\d)\\d)|2(?:0[013478]|3[0189]|4[017]|8[0-46-9]|9[0-2])\\d{3})\\d{4}|1(?:2(?:0(?:46[1-4]|87[2-9])|545[1-79]|76(?:2\\d|3[1-8]|6[1-6])|9(?:7(?:2[0-4]|3[2-5])|8(?:2[2-8]|7[0-47-9]|8[3-5])))|3(?:6(?:38[2-5]|47[23])|8(?:47[04-9]|64[0157-9]))|4(?:044[1-7]|20(?:2[23]|8\\d)|6(?:0(?:30|5[2-57]|6[1-8]|7[2-8])|140)|8(?:052|87[1-3]))|5(?:2(?:4(?:3[2-79]|6\\d)|76\\d)|6(?:26[06-9]|686))|6(?:06(?:4\\d|7[4-79])|295[5-7]|35[34]\\d|47(?:24|61)|59(?:5[08]|6[67]|74)|9(?:55[0-4]|77[23]))|7(?:26(?:6[13-9]|7[0-7])|(?:442|688)\\d|50(?:2[0-3]|[3-68]2|76))|8(?:27[56]\\d|37(?:5[2-5]|8[239])|843[2-58])|9(?:0(?:0(?:6[1-8]|85)|52\\d)|3583|4(?:66[1-8]|9(?:2[01]|81))|63(?:23|3[1-4])|9561))\\d{3}", [9, 10]], ["7(?:457[0-57-9]|700[01]|911[028])\\d{5}|7(?:[1-3]\\d\\d|4(?:[0-46-9]\\d|5[0-689])|5(?:0[0-8]|[13-9]\\d|2[0-35-9])|7(?:0[1-9]|[1-7]\\d|8[02-9]|9[0-689])|8(?:[014-9]\\d|[23][0-8])|9(?:[024-9]\\d|1[02-9]|3[0-689]))\\d{6}", [10]], ["80[08]\\d{7}|800\\d{6}|8001111"], ["(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[2-49]))\\d{7}|845464\\d", [7, 10]], ["70\\d{8}", [10]], 0, ["(?:3[0347]|55)\\d{8}", [10]], ["76(?:464|652)\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\d{6}", [10]], ["56\\d{8}", [10]]], 0, " x"], GD: ["1", "011", "(?:473|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "473$1", 0, "473"], GE: ["995", "00", "(?:[3-57]\\d\\d|800)\\d{6}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["70"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["32"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[57]"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[348]"], "0$1"]], "0"], GF: ["594", "00", "[56]94\\d{6}|(?:80|9\\d)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[56]|9[47]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[89]"], "0$1"]], "0"], GG: ["44", "00", "(?:1481|[357-9]\\d{3})\\d{6}|8\\d{6}(?:\\d{2})?", [7, 9, 10], 0, "0", 0, "([25-9]\\d{5})$|0", "1481$1", 0, 0, [["1481[25-9]\\d{5}", [10]], ["7(?:(?:781|839)\\d|911[17])\\d{5}", [10]], ["80[08]\\d{7}|800\\d{6}|8001111"], ["(?:8(?:4[2-5]|7[0-3])|9(?:[01]\\d|8[0-3]))\\d{7}|845464\\d", [7, 10]], ["70\\d{8}", [10]], 0, ["(?:3[0347]|55)\\d{8}", [10]], ["76(?:464|652)\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\d{6}", [10]], ["56\\d{8}", [10]]]], GH: ["233", "00", "(?:[235]\\d{3}|800)\\d{5}", [8, 9], [["(\\d{3})(\\d{5})", "$1 $2", ["8"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[235]"], "0$1"]], "0"], GI: ["350", "00", "(?:[25]\\d|60)\\d{6}", [8], [["(\\d{3})(\\d{5})", "$1 $2", ["2"]]]], GL: ["299", "00", "(?:19|[2-689]\\d|70)\\d{4}", [6], [["(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["19|[2-9]"]]]], GM: ["220", "00", "[2-9]\\d{6}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]]], GN: ["224", "00", "722\\d{6}|(?:3|6\\d)\\d{7}", [8, 9], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["3"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[67]"]]]], GP: ["590", "00", "590\\d{6}|(?:69|80|9\\d)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[569]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0$1"]], "0", 0, 0, 0, 0, 0, [["590(?:0[1-68]|[14][0-24-9]|2[0-68]|3[1-9]|5[3-579]|[68][0-689]|7[08]|9\\d)\\d{4}"], ["69(?:0\\d\\d|1(?:2[2-9]|3[0-5]))\\d{4}"], ["80[0-5]\\d{6}"], 0, 0, 0, 0, 0, ["9(?:(?:395|76[018])\\d|475[0-5])\\d{4}"]]], GQ: ["240", "00", "222\\d{6}|(?:3\\d|55|[89]0)\\d{7}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[235]"]], ["(\\d{3})(\\d{6})", "$1 $2", ["[89]"]]]], GR: ["30", "00", "5005000\\d{3}|8\\d{9,11}|(?:[269]\\d|70)\\d{8}", [10, 11, 12], [["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["21|7"]], ["(\\d{4})(\\d{6})", "$1 $2", ["2(?:2|3[2-57-9]|4[2-469]|5[2-59]|6[2-9]|7[2-69]|8[2-49])|5"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2689]"]], ["(\\d{3})(\\d{3,4})(\\d{5})", "$1 $2 $3", ["8"]]]], GT: ["502", "00", "(?:1\\d{3}|[2-7])\\d{7}", [8, 11], [["(\\d{4})(\\d{4})", "$1 $2", ["[2-7]"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]]], GU: ["1", "011", "(?:[58]\\d\\d|671|900)\\d{7}", [10], 0, "1", 0, "([3-9]\\d{6})$|1", "671$1", 0, "671"], GW: ["245", "00", "[49]\\d{8}|4\\d{6}", [7, 9], [["(\\d{3})(\\d{4})", "$1 $2", ["40"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[49]"]]]], GY: ["592", "001", "9008\\d{3}|(?:[2-467]\\d\\d|510|862)\\d{4}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]]], HK: ["852", "00(?:30|5[09]|[126-9]?)", "8[0-46-9]\\d{6,7}|9\\d{4,7}|(?:[2-7]|9\\d{3})\\d{7}", [5, 6, 7, 8, 9, 11], [["(\\d{3})(\\d{2,5})", "$1 $2", ["900", "9003"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[2-7]|8[1-4]|9(?:0[1-9]|[1-8])"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]], ["(\\d{3})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["9"]]], 0, 0, 0, 0, 0, 0, 0, "00"], HN: ["504", "00", "8\\d{10}|[237-9]\\d{7}", [8, 11], [["(\\d{4})(\\d{4})", "$1-$2", ["[237-9]"]]]], HR: ["385", "00", "(?:[24-69]\\d|3[0-79])\\d{7}|80\\d{5,7}|[1-79]\\d{7}|6\\d{5,6}", [6, 7, 8, 9], [["(\\d{2})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["6[01]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["8"], "0$1"], ["(\\d)(\\d{4})(\\d{3})", "$1 $2 $3", ["1"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[67]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-5]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"]], "0"], HT: ["509", "00", "(?:[2-489]\\d|55)\\d{6}", [8], [["(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["[2-589]"]]]], HU: ["36", "00", "[235-7]\\d{8}|[1-9]\\d{7}", [8, 9], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "(06 $1)"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[27][2-9]|3[2-7]|4[24-9]|5[2-79]|6|8[2-57-9]|9[2-69]"], "(06 $1)"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-9]"], "06 $1"]], "06"], ID: ["62", "00[89]", "(?:(?:00[1-9]|8\\d)\\d{4}|[1-36])\\d{6}|00\\d{10}|[1-9]\\d{8,10}|[2-9]\\d{7}", [7, 8, 9, 10, 11, 12, 13], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["15"]], ["(\\d{2})(\\d{5,9})", "$1 $2", ["2[124]|[36]1"], "(0$1)"], ["(\\d{3})(\\d{5,7})", "$1 $2", ["800"], "0$1"], ["(\\d{3})(\\d{5,8})", "$1 $2", ["[2-79]"], "(0$1)"], ["(\\d{3})(\\d{3,4})(\\d{3})", "$1-$2-$3", ["8[1-35-9]"], "0$1"], ["(\\d{3})(\\d{6,8})", "$1 $2", ["1"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["804"], "0$1"], ["(\\d{3})(\\d)(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["80"], "0$1"], ["(\\d{3})(\\d{4})(\\d{4,5})", "$1-$2-$3", ["8"], "0$1"]], "0"], IE: ["353", "00", "(?:1\\d|[2569])\\d{6,8}|4\\d{6,9}|7\\d{8}|8\\d{8,9}", [7, 8, 9, 10], [["(\\d{2})(\\d{5})", "$1 $2", ["2[24-9]|47|58|6[237-9]|9[35-9]"], "(0$1)"], ["(\\d{3})(\\d{5})", "$1 $2", ["[45]0"], "(0$1)"], ["(\\d)(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2569]|4[1-69]|7[14]"], "(0$1)"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["70"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["81"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[78]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["4"], "(0$1)"], ["(\\d{2})(\\d)(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["8"], "0$1"]], "0"], IL: ["972", "0(?:0|1[2-9])", "1\\d{6}(?:\\d{3,5})?|[57]\\d{8}|[1-489]\\d{7}", [7, 8, 9, 10, 11, 12], [["(\\d{4})(\\d{3})", "$1-$2", ["125"]], ["(\\d{4})(\\d{2})(\\d{2})", "$1-$2-$3", ["121"]], ["(\\d)(\\d{3})(\\d{4})", "$1-$2-$3", ["[2-489]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["[57]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3})", "$1-$2-$3", ["12"]], ["(\\d{4})(\\d{6})", "$1-$2", ["159"]], ["(\\d)(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3-$4", ["1[7-9]"]], ["(\\d{3})(\\d{1,2})(\\d{3})(\\d{4})", "$1-$2 $3-$4", ["15"]]], "0"], IM: ["44", "00", "1624\\d{6}|(?:[3578]\\d|90)\\d{8}", [10], 0, "0", 0, "([25-8]\\d{5})$|0", "1624$1", 0, "74576|(?:16|7[56])24"], IN: ["91", "00", "(?:000800|[2-9]\\d\\d)\\d{7}|1\\d{7,12}", [8, 9, 10, 11, 12, 13], [["(\\d{8})", "$1", ["5(?:0|2[23]|3[03]|[67]1|88)", "5(?:0|2(?:21|3)|3(?:0|3[23])|616|717|888)", "5(?:0|2(?:21|3)|3(?:0|3[23])|616|717|8888)"], 0, 1], ["(\\d{4})(\\d{4,5})", "$1 $2", ["180", "1800"], 0, 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["140"], 0, 1], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["11|2[02]|33|4[04]|79[1-7]|80[2-46]", "11|2[02]|33|4[04]|79(?:[1-6]|7[19])|80(?:[2-4]|6[0-589])", "11|2[02]|33|4[04]|79(?:[124-6]|3(?:[02-9]|1[0-24-9])|7(?:1|9[1-6]))|80(?:[2-4]|6[0-589])"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1(?:2[0-249]|3[0-25]|4[145]|[68]|7[1257])|2(?:1[257]|3[013]|4[01]|5[0137]|6[0158]|78|8[1568])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|5[12]|[78]1)|6(?:12|[2-4]1|5[17]|6[13]|80)|7(?:12|3[134]|4[47]|61|88)|8(?:16|2[014]|3[126]|6[136]|7[078]|8[34]|91)|(?:43|59|75)[15]|(?:1[59]|29|67|72)[14]", "1(?:2[0-24]|3[0-25]|4[145]|[59][14]|6[1-9]|7[1257]|8[1-57-9])|2(?:1[257]|3[013]|4[01]|5[0137]|6[058]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|[578]1|9[15])|674|7(?:(?:2[14]|3[34]|5[15])[2-6]|61[346]|88[0-8])|8(?:70[2-6]|84[235-7]|91[3-7])|(?:1(?:29|60|8[06])|261|552|6(?:12|[2-47]1|5[17]|6[13]|80)|7(?:12|31|4[47])|8(?:16|2[014]|3[126]|6[136]|7[78]|83))[2-7]", "1(?:2[0-24]|3[0-25]|4[145]|[59][14]|6[1-9]|7[1257]|8[1-57-9])|2(?:1[257]|3[013]|4[01]|5[0137]|6[058]|78|8[1568]|9[14])|3(?:26|4[1-3]|5[34]|6[01489]|7[02-46]|8[159])|4(?:1[36]|2[1-47]|3[15]|5[12]|6[0-26-9]|7[0-24-9]|8[013-57]|9[014-7])|5(?:1[025]|22|[36][25]|4[28]|[578]1|9[15])|6(?:12(?:[2-6]|7[0-8])|74[2-7])|7(?:(?:2[14]|5[15])[2-6]|3171|61[346]|88(?:[2-7]|82))|8(?:70[2-6]|84(?:[2356]|7[19])|91(?:[3-6]|7[19]))|73[134][2-6]|(?:74[47]|8(?:16|2[014]|3[126]|6[136]|7[78]|83))(?:[2-6]|7[19])|(?:1(?:29|60|8[06])|261|552|6(?:[2-4]1|5[17]|6[13]|7(?:1|4[0189])|80)|7(?:12|88[01]))[2-7]"], "0$1", 1], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1(?:[2-479]|5[0235-9])|[2-5]|6(?:1[1358]|2[2457-9]|3[2-5]|4[235-7]|5[2-689]|6[24578]|7[235689]|8[1-6])|7(?:1[013-9]|28|3[129]|4[1-35689]|5[29]|6[02-5]|70)|807", "1(?:[2-479]|5[0235-9])|[2-5]|6(?:1[1358]|2(?:[2457]|84|95)|3(?:[2-4]|55)|4[235-7]|5[2-689]|6[24578]|7[235689]|8[1-6])|7(?:1(?:[013-8]|9[6-9])|28[6-8]|3(?:17|2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4|5[0-367])|70[13-7])|807[19]", "1(?:[2-479]|5(?:[0236-9]|5[013-9]))|[2-5]|6(?:2(?:84|95)|355|83)|73179|807(?:1|9[1-3])|(?:1552|6(?:1[1358]|2[2457]|3[2-4]|4[235-7]|5[2-689]|6[24578]|7[235689]|8[124-6])\\d|7(?:1(?:[013-8]\\d|9[6-9])|28[6-8]|3(?:2[0-49]|9[2-57])|4(?:1[2-4]|[29][0-7]|3[0-8]|[56]\\d|8[0-24-7])|5(?:2[1-3]|9[0-6])|6(?:0[5689]|2[5-9]|3[02-8]|4\\d|5[0-367])|70[13-7]))[2-7]"], "0$1", 1], ["(\\d{5})(\\d{5})", "$1 $2", ["[6-9]"], "0$1", 1], ["(\\d{4})(\\d{2,4})(\\d{4})", "$1 $2 $3", ["1(?:6|8[06])", "1(?:6|8[06]0)"], 0, 1], ["(\\d{4})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["18"], 0, 1]], "0"], IO: ["246", "00", "3\\d{6}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["3"]]]], IQ: ["964", "00", "(?:1|7\\d\\d)\\d{7}|[2-6]\\d{7,8}", [8, 9, 10], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-6]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"]], "0"], IR: ["98", "00", "[1-9]\\d{9}|(?:[1-8]\\d\\d|9)\\d{3,4}", [4, 5, 6, 7, 10], [["(\\d{4,5})", "$1", ["96"], "0$1"], ["(\\d{2})(\\d{4,5})", "$1 $2", ["(?:1[137]|2[13-68]|3[1458]|4[145]|5[1468]|6[16]|7[1467]|8[13467])[12689]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["9"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["[1-8]"], "0$1"]], "0"], IS: ["354", "00|1(?:0(?:01|[12]0)|100)", "(?:38\\d|[4-9])\\d{6}", [7, 9], [["(\\d{3})(\\d{4})", "$1 $2", ["[4-9]"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["3"]]], 0, 0, 0, 0, 0, 0, 0, "00"], IT: ["39", "00", "0\\d{5,10}|1\\d{8,10}|3(?:[0-8]\\d{7,10}|9\\d{7,8})|(?:55|70)\\d{8}|8\\d{5}(?:\\d{2,4})?", [6, 7, 8, 9, 10, 11], [["(\\d{2})(\\d{4,6})", "$1 $2", ["0[26]"]], ["(\\d{3})(\\d{3,6})", "$1 $2", ["0[13-57-9][0159]|8(?:03|4[17]|9[2-5])", "0[13-57-9][0159]|8(?:03|4[17]|9(?:2|3[04]|[45][0-4]))"]], ["(\\d{4})(\\d{2,6})", "$1 $2", ["0(?:[13-579][2-46-8]|8[236-8])"]], ["(\\d{4})(\\d{4})", "$1 $2", ["894"]], ["(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[26]|5"]], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["1(?:44|[679])|[378]"]], ["(\\d{3})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["0[13-57-9][0159]|14"]], ["(\\d{2})(\\d{4})(\\d{5})", "$1 $2 $3", ["0[26]"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["0"]], ["(\\d{3})(\\d{4})(\\d{4,5})", "$1 $2 $3", ["3"]]], 0, 0, 0, 0, 0, 0, [["0669[0-79]\\d{1,6}|0(?:1(?:[0159]\\d|[27][1-5]|31|4[1-4]|6[1356]|8[2-57])|2\\d\\d|3(?:[0159]\\d|2[1-4]|3[12]|[48][1-6]|6[2-59]|7[1-7])|4(?:[0159]\\d|[23][1-9]|4[245]|6[1-5]|7[1-4]|81)|5(?:[0159]\\d|2[1-5]|3[2-6]|4[1-79]|6[4-6]|7[1-578]|8[3-8])|6(?:[0-57-9]\\d|6[0-8])|7(?:[0159]\\d|2[12]|3[1-7]|4[2-46]|6[13569]|7[13-6]|8[1-59])|8(?:[0159]\\d|2[3-578]|3[1-356]|[6-8][1-5])|9(?:[0159]\\d|[238][1-5]|4[12]|6[1-8]|7[1-6]))\\d{2,7}"], ["3[1-9]\\d{8}|3[2-9]\\d{7}", [9, 10]], ["80(?:0\\d{3}|3)\\d{3}", [6, 9]], ["(?:0878\\d{3}|89(?:2\\d|3[04]|4(?:[0-4]|[5-9]\\d\\d)|5[0-4]))\\d\\d|(?:1(?:44|6[346])|89(?:38|5[5-9]|9))\\d{6}", [6, 8, 9, 10]], ["1(?:78\\d|99)\\d{6}", [9, 10]], 0, 0, 0, ["55\\d{8}", [10]], ["84(?:[08]\\d{3}|[17])\\d{3}", [6, 9]]]], JE: ["44", "00", "1534\\d{6}|(?:[3578]\\d|90)\\d{8}", [10], 0, "0", 0, "([0-24-8]\\d{5})$|0", "1534$1", 0, 0, [["1534[0-24-8]\\d{5}"], ["7(?:(?:(?:50|82)9|937)\\d|7(?:00[378]|97[7-9]))\\d{5}"], ["80(?:07(?:35|81)|8901)\\d{4}"], ["(?:8(?:4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|90(?:066[59]|1810|71(?:07|55)))\\d{4}"], ["701511\\d{4}"], 0, ["(?:3(?:0(?:07(?:35|81)|8901)|3\\d{4}|4(?:4(?:4(?:05|42|69)|703)|5(?:041|800))|7(?:0002|1206))|55\\d{4})\\d{4}"], ["76(?:464|652)\\d{5}|76(?:0[0-28]|2[356]|34|4[01347]|5[49]|6[0-369]|77|8[14]|9[139])\\d{6}"], ["56\\d{8}"]]], JM: ["1", "011", "(?:[58]\\d\\d|658|900)\\d{7}", [10], 0, "1", 0, 0, 0, 0, "658|876"], JO: ["962", "00", "(?:(?:[2689]|7\\d)\\d|32|53)\\d{6}", [8, 9], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2356]|87"], "(0$1)"], ["(\\d{3})(\\d{5,6})", "$1 $2", ["[89]"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["70"], "0$1"], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["7"], "0$1"]], "0"], JP: ["81", "010", "00[1-9]\\d{6,14}|[257-9]\\d{9}|(?:00|[1-9]\\d\\d)\\d{6}", [8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [["(\\d{3})(\\d{3})(\\d{3})", "$1-$2-$3", ["(?:12|57|99)0"], "0$1"], ["(\\d{4})(\\d)(\\d{4})", "$1-$2-$3", ["1(?:26|3[79]|4[56]|5[4-68]|6[3-5])|499|5(?:76|97)|746|8(?:3[89]|47|51)|9(?:80|9[16])", "1(?:267|3(?:7[247]|9[278])|466|5(?:47|58|64)|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:76|97)9|7468|8(?:3(?:8[7-9]|96)|477|51[2-9])|9(?:802|9(?:1[23]|69))|1(?:45|58)[67]", "1(?:267|3(?:7[247]|9[278])|466|5(?:47|58|64)|6(?:3[245]|48|5[4-68]))|499[2468]|5(?:769|979[2-69])|7468|8(?:3(?:8[7-9]|96[2457-9])|477|51[2-9])|9(?:802|9(?:1[23]|69))|1(?:45|58)[67]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60"], "0$1"], ["(\\d)(\\d{4})(\\d{4})", "$1-$2-$3", ["[36]|4(?:2[09]|7[01])", "[36]|4(?:2(?:0|9[02-69])|7(?:0[019]|1))"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["1(?:1|5[45]|77|88|9[69])|2(?:2[1-37]|3[0-269]|4[59]|5|6[24]|7[1-358]|8[1369]|9[0-38])|4(?:[28][1-9]|3[0-57]|[45]|6[248]|7[2-579]|9[29])|5(?:2|3[0459]|4[0-369]|5[29]|8[02389]|9[0-389])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9[2-6])|8(?:2[124589]|3[26-9]|49|51|6|7[0-468]|8[68]|9[019])|9(?:[23][1-9]|4[15]|5[138]|6[1-3]|7[156]|8[189]|9[1-489])", "1(?:1|5(?:4[018]|5[017])|77|88|9[69])|2(?:2(?:[127]|3[014-9])|3[0-269]|4[59]|5(?:[1-3]|5[0-69]|9[19])|62|7(?:[1-35]|8[0189])|8(?:[16]|3[0134]|9[0-5])|9(?:[028]|17))|4(?:2(?:[13-79]|8[014-6])|3[0-57]|[45]|6[248]|7[2-47]|8[1-9]|9[29])|5(?:2|3(?:[045]|9[0-8])|4[0-369]|5[29]|8[02389]|9[0-3])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9(?:[23]|4[0-59]|5[01569]|6[0167]))|8(?:2(?:[1258]|4[0-39]|9[0-2469])|3(?:[29]|60)|49|51|6(?:[0-24]|36|5[0-3589]|7[23]|9[01459])|7[0-468]|8[68])|9(?:[23][1-9]|4[15]|5[138]|6[1-3]|7[156]|8[189]|9(?:[1289]|3[34]|4[0178]))|(?:264|837)[016-9]|2(?:57|93)[015-9]|(?:25[0468]|422|838)[01]|(?:47[59]|59[89]|8(?:6[68]|9))[019]", "1(?:1|5(?:4[018]|5[017])|77|88|9[69])|2(?:2[127]|3[0-269]|4[59]|5(?:[1-3]|5[0-69]|9(?:17|99))|6(?:2|4[016-9])|7(?:[1-35]|8[0189])|8(?:[16]|3[0134]|9[0-5])|9(?:[028]|17))|4(?:2(?:[13-79]|8[014-6])|3[0-57]|[45]|6[248]|7[2-47]|9[29])|5(?:2|3(?:[045]|9(?:[0-58]|6[4-9]|7[0-35689]))|4[0-369]|5[29]|8[02389]|9[0-3])|7(?:2[02-46-9]|34|[58]|6[0249]|7[57]|9(?:[23]|4[0-59]|5[01569]|6[0167]))|8(?:2(?:[1258]|4[0-39]|9[0169])|3(?:[29]|60|7(?:[017-9]|6[6-8]))|49|51|6(?:[0-24]|36[2-57-9]|5(?:[0-389]|5[23])|6(?:[01]|9[178])|7(?:2[2-468]|3[78])|9[0145])|7[0-468]|8[68])|9(?:4[15]|5[138]|7[156]|8[189]|9(?:[1289]|3(?:31|4[357])|4[0178]))|(?:8294|96)[1-3]|2(?:57|93)[015-9]|(?:223|8699)[014-9]|(?:25[0468]|422|838)[01]|(?:48|8292|9[23])[1-9]|(?:47[59]|59[89]|8(?:68|9))[019]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3", ["[14]|[289][2-9]|5[3-9]|7[2-4679]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3", ["800"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[257-9]"], "0$1"]], "0", 0, "(000[259]\\d{6})$|(?:(?:003768)0?)|0", "$1"], KE: ["254", "000", "(?:[17]\\d\\d|900)\\d{6}|(?:2|80)0\\d{6,7}|[4-6]\\d{6,8}", [7, 8, 9, 10], [["(\\d{2})(\\d{5,7})", "$1 $2", ["[24-6]"], "0$1"], ["(\\d{3})(\\d{6})", "$1 $2", ["[17]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[89]"], "0$1"]], "0"], KG: ["996", "00", "8\\d{9}|[235-9]\\d{8}", [9, 10], [["(\\d{4})(\\d{5})", "$1 $2", ["3(?:1[346]|[24-79])"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[235-79]|88"], "0$1"], ["(\\d{3})(\\d{3})(\\d)(\\d{2,3})", "$1 $2 $3 $4", ["8"], "0$1"]], "0"], KH: ["855", "00[14-9]", "1\\d{9}|[1-9]\\d{7,8}", [8, 9, 10], [["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[1-9]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], "0"], KI: ["686", "00", "(?:[37]\\d|6[0-79])\\d{6}|(?:[2-48]\\d|50)\\d{3}", [5, 8], 0, "0"], KM: ["269", "00", "[3478]\\d{6}", [7], [["(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[3478]"]]]], KN: ["1", "011", "(?:[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-7]\\d{6})$|1", "869$1", 0, "869"], KP: ["850", "00|99", "85\\d{6}|(?:19\\d|[2-7])\\d{7}", [8, 10], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"], "0$1"], ["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-7]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"]], "0"], KR: ["82", "00(?:[125689]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))", "00[1-9]\\d{8,11}|(?:[12]|5\\d{3})\\d{7}|[13-6]\\d{9}|(?:[1-6]\\d|80)\\d{7}|[3-6]\\d{4,5}|(?:00|7)0\\d{8}", [5, 6, 8, 9, 10, 11, 12, 13, 14], [["(\\d{2})(\\d{3,4})", "$1-$2", ["(?:3[1-3]|[46][1-4]|5[1-5])1"], "0$1"], ["(\\d{4})(\\d{4})", "$1-$2", ["1"]], ["(\\d)(\\d{3,4})(\\d{4})", "$1-$2-$3", ["2"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1-$2-$3", ["60|8"], "0$1"], ["(\\d{2})(\\d{3,4})(\\d{4})", "$1-$2-$3", ["[1346]|5[1-5]"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1-$2-$3", ["[57]"], "0$1"], ["(\\d{2})(\\d{5})(\\d{4})", "$1-$2-$3", ["5"], "0$1"]], "0", 0, "0(8(?:[1-46-8]|5\\d\\d))?"], KW: ["965", "00", "18\\d{5}|(?:[2569]\\d|41)\\d{6}", [7, 8], [["(\\d{4})(\\d{3,4})", "$1 $2", ["[169]|2(?:[235]|4[1-35-9])|52"]], ["(\\d{3})(\\d{5})", "$1 $2", ["[245]"]]]], KY: ["1", "011", "(?:345|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "345$1", 0, "345"], KZ: ["7", "810", "(?:33622|8\\d{8})\\d{5}|[78]\\d{9}", [10, 14], 0, "8", 0, 0, 0, 0, "33|7", 0, "8~10"], LA: ["856", "00", "[23]\\d{9}|3\\d{8}|(?:[235-8]\\d|41)\\d{6}", [8, 9, 10], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["2[13]|3[14]|[4-8]"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["30[013-9]"], "0$1"], ["(\\d{2})(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["[23]"], "0$1"]], "0"], LB: ["961", "00", "[27-9]\\d{7}|[13-9]\\d{6}", [7, 8], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[13-69]|7(?:[2-57]|62|8[0-7]|9[04-9])|8[02-9]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[27-9]"]]], "0"], LC: ["1", "011", "(?:[58]\\d\\d|758|900)\\d{7}", [10], 0, "1", 0, "([2-8]\\d{6})$|1", "758$1", 0, "758"], LI: ["423", "00", "[68]\\d{8}|(?:[2378]\\d|90)\\d{5}", [7, 9], [["(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3", ["[2379]|8(?:0[09]|7)", "[2379]|8(?:0(?:02|9)|7)"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["69"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"]]], "0", 0, "(1001)|0"], LK: ["94", "00", "[1-9]\\d{8}", [9], [["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[1-689]"], "0$1"]], "0"], LR: ["231", "00", "(?:[25]\\d|33|77|88)\\d{7}|(?:2\\d|[4-6])\\d{6}", [7, 8, 9], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[4-6]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[23578]"], "0$1"]], "0"], LS: ["266", "00", "(?:[256]\\d\\d|800)\\d{5}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["[2568]"]]]], LT: ["370", "00", "(?:[3469]\\d|52|[78]0)\\d{6}", [8], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["52[0-7]"], "(8-$1)", 1], ["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[7-9]"], "8 $1", 1], ["(\\d{2})(\\d{6})", "$1 $2", ["37|4(?:[15]|6[1-8])"], "(8-$1)", 1], ["(\\d{3})(\\d{5})", "$1 $2", ["[3-6]"], "(8-$1)", 1]], "8", 0, "[08]"], LU: ["352", "00", "35[013-9]\\d{4,8}|6\\d{8}|35\\d{2,4}|(?:[2457-9]\\d|3[0-46-9])\\d{2,9}", [4, 5, 6, 7, 8, 9, 10, 11], [["(\\d{2})(\\d{3})", "$1 $2", ["2(?:0[2-689]|[2-9])|[3-57]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])"]], ["(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["2(?:0[2-689]|[2-9])|[3-57]|8(?:0[2-9]|[13-9])|9(?:0[89]|[2-579])"]], ["(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["20[2-689]"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})", "$1 $2 $3 $4", ["2(?:[0367]|4[3-8])"]], ["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["80[01]|90[015]"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3 $4", ["20"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{1,2})", "$1 $2 $3 $4 $5", ["2(?:[0367]|4[3-8])"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{1,5})", "$1 $2 $3 $4", ["[3-57]|8[13-9]|9(?:0[89]|[2-579])|(?:2|80)[2-9]"]]], 0, 0, "(15(?:0[06]|1[12]|[35]5|4[04]|6[26]|77|88|99)\\d)"], LV: ["371", "00", "(?:[268]\\d|90)\\d{6}", [8], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[269]|8[01]"]]]], LY: ["218", "00", "[2-9]\\d{8}", [9], [["(\\d{2})(\\d{7})", "$1-$2", ["[2-9]"], "0$1"]], "0"], MA: ["212", "00", "[5-8]\\d{8}", [9], [["(\\d{5})(\\d{4})", "$1-$2", ["5(?:29|38)", "5(?:29[1289]|389)", "529(?:1[1-46-9]|2[013-8]|90)|5(?:298|389)[0-46-9]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["5[45]"], "0$1"], ["(\\d{4})(\\d{5})", "$1-$2", ["5(?:2[2-489]|3[5-9]|9)|892", "5(?:2(?:[2-49]|8[235-9])|3[5-9]|9)|892"], "0$1"], ["(\\d{2})(\\d{7})", "$1-$2", ["8"], "0$1"], ["(\\d{3})(\\d{6})", "$1-$2", ["[5-7]"], "0$1"]], "0", 0, 0, 0, 0, 0, [["5293[01]\\d{4}|5(?:2(?:[0-25-7]\\d|3[1-578]|4[02-46-8]|8[0235-7]|9[0-289])|3(?:[0-47]\\d|5[02-9]|6[02-8]|8[0189]|9[3-9])|(?:4[067]|5[03])\\d)\\d{5}"], ["(?:6(?:[0-79]\\d|8[0-247-9])|7(?:[017]\\d|2[0-2]|6[0-8]|8[0-3]))\\d{6}"], ["80\\d{7}"], ["89\\d{7}"], 0, 0, 0, 0, ["592(?:4[0-2]|93)\\d{4}"]]], MC: ["377", "00", "(?:[3489]|6\\d)\\d{7}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["4"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[389]"]], ["(\\d)(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4 $5", ["6"], "0$1"]], "0"], MD: ["373", "00", "(?:[235-7]\\d|[89]0)\\d{6}", [8], [["(\\d{3})(\\d{5})", "$1 $2", ["[89]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["22|3"], "0$1"], ["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["[25-7]"], "0$1"]], "0"], ME: ["382", "00", "(?:20|[3-79]\\d)\\d{6}|80\\d{6,7}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[2-9]"], "0$1"]], "0"], MF: ["590", "00", "590\\d{6}|(?:69|80|9\\d)\\d{7}", [9], 0, "0", 0, 0, 0, 0, 0, [["590(?:0[079]|[14]3|[27][79]|3[03-7]|5[0-268]|87)\\d{4}"], ["69(?:0\\d\\d|1(?:2[2-9]|3[0-5]))\\d{4}"], ["80[0-5]\\d{6}"], 0, 0, 0, 0, 0, ["9(?:(?:395|76[018])\\d|475[0-5])\\d{4}"]]], MG: ["261", "00", "[23]\\d{8}", [9], [["(\\d{2})(\\d{2})(\\d{3})(\\d{2})", "$1 $2 $3 $4", ["[23]"], "0$1"]], "0", 0, "([24-9]\\d{6})$|0", "20$1"], MH: ["692", "011", "329\\d{4}|(?:[256]\\d|45)\\d{5}", [7], [["(\\d{3})(\\d{4})", "$1-$2", ["[2-6]"]]], "1"], MK: ["389", "00", "[2-578]\\d{7}", [8], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2|34[47]|4(?:[37]7|5[47]|64)"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[347]"], "0$1"], ["(\\d{3})(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[58]"], "0$1"]], "0"], ML: ["223", "00", "[24-9]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[24-9]"]]]], MM: ["95", "00", "1\\d{5,7}|95\\d{6}|(?:[4-7]|9[0-46-9])\\d{6,8}|(?:2|8\\d)\\d{5,8}", [6, 7, 8, 9, 10], [["(\\d)(\\d{2})(\\d{3})", "$1 $2 $3", ["16|2"], "0$1"], ["(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["[45]|6(?:0[23]|[1-689]|7[235-7])|7(?:[0-4]|5[2-7])|8[1-6]"], "0$1"], ["(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[12]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[4-7]|8[1-35]"], "0$1"], ["(\\d)(\\d{3})(\\d{4,6})", "$1 $2 $3", ["9(?:2[0-4]|[35-9]|4[137-9])"], "0$1"], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"], "0$1"], ["(\\d)(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["92"], "0$1"], ["(\\d)(\\d{5})(\\d{4})", "$1 $2 $3", ["9"], "0$1"]], "0"], MN: ["976", "001", "[12]\\d{7,9}|[5-9]\\d{7}", [8, 9, 10], [["(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["[12]1"], "0$1"], ["(\\d{4})(\\d{4})", "$1 $2", ["[5-9]"]], ["(\\d{3})(\\d{5,6})", "$1 $2", ["[12]2[1-3]"], "0$1"], ["(\\d{4})(\\d{5,6})", "$1 $2", ["[12](?:27|3[2-8]|4[2-68]|5[1-4689])", "[12](?:27|3[2-8]|4[2-68]|5[1-4689])[0-3]"], "0$1"], ["(\\d{5})(\\d{4,5})", "$1 $2", ["[12]"], "0$1"]], "0"], MO: ["853", "00", "0800\\d{3}|(?:28|[68]\\d)\\d{6}", [7, 8], [["(\\d{4})(\\d{3})", "$1 $2", ["0"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[268]"]]]], MP: ["1", "011", "[58]\\d{9}|(?:67|90)0\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "670$1", 0, "670"], MQ: ["596", "00", "596\\d{6}|(?:69|80|9\\d)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[569]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0$1"]], "0"], MR: ["222", "00", "(?:[2-4]\\d\\d|800)\\d{5}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-48]"]]]], MS: ["1", "011", "(?:[58]\\d\\d|664|900)\\d{7}", [10], 0, "1", 0, "([34]\\d{6})$|1", "664$1", 0, "664"], MT: ["356", "00", "3550\\d{4}|(?:[2579]\\d\\d|800)\\d{5}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["[2357-9]"]]]], MU: ["230", "0(?:0|[24-7]0|3[03])", "(?:[57]|8\\d\\d)\\d{7}|[2-468]\\d{6}", [7, 8, 10], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-46]|8[013]"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[57]"]], ["(\\d{5})(\\d{5})", "$1 $2", ["8"]]], 0, 0, 0, 0, 0, 0, 0, "020"], MV: ["960", "0(?:0|19)", "(?:800|9[0-57-9]\\d)\\d{7}|[34679]\\d{6}", [7, 10], [["(\\d{3})(\\d{4})", "$1-$2", ["[34679]"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[89]"]]], 0, 0, 0, 0, 0, 0, 0, "00"], MW: ["265", "00", "(?:[1289]\\d|31|77)\\d{7}|1\\d{6}", [7, 9], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["1[2-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[137-9]"], "0$1"]], "0"], MX: ["52", "0[09]", "1(?:(?:[27]2|44|87|99)[1-9]|65[0-689])\\d{7}|(?:1(?:[01]\\d|2[13-9]|[35][1-9]|4[0-35-9]|6[0-46-9]|7[013-9]|8[1-69]|9[1-8])|[2-9]\\d)\\d{8}", [10, 11], [["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["33|5[56]|81"], 0, 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[2-9]"], 0, 1], ["(\\d)(\\d{2})(\\d{4})(\\d{4})", "$2 $3 $4", ["1(?:33|5[56]|81)"], 0, 1], ["(\\d)(\\d{3})(\\d{3})(\\d{4})", "$2 $3 $4", ["1"], 0, 1]], "01", 0, "0(?:[12]|4[45])|1", 0, 0, 0, 0, "00"], MY: ["60", "00", "1\\d{8,9}|(?:3\\d|[4-9])\\d{7}", [8, 9, 10], [["(\\d)(\\d{3})(\\d{4})", "$1-$2 $3", ["[4-79]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1-$2 $3", ["1(?:[02469]|[378][1-9]|53)|8", "1(?:[02469]|[37][1-9]|53|8(?:[1-46-9]|5[7-9]))|8"], "0$1"], ["(\\d)(\\d{4})(\\d{4})", "$1-$2 $3", ["3"], "0$1"], ["(\\d)(\\d{3})(\\d{2})(\\d{4})", "$1-$2-$3-$4", ["1(?:[367]|80)"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1-$2 $3", ["15"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4})", "$1-$2 $3", ["1"], "0$1"]], "0"], MZ: ["258", "00", "(?:2|8\\d)\\d{7}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2|8[2-79]"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["8"]]]], NA: ["264", "00", "[68]\\d{7,8}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["88"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["6"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["87"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"], "0$1"]], "0"], NC: ["687", "00", "(?:050|[2-57-9]\\d\\d)\\d{3}", [6], [["(\\d{2})(\\d{2})(\\d{2})", "$1.$2.$3", ["[02-57-9]"]]]], NE: ["227", "00", "[027-9]\\d{7}", [8], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["08"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[089]|2[013]|7[047]"]]]], NF: ["672", "00", "[13]\\d{5}", [6], [["(\\d{2})(\\d{4})", "$1 $2", ["1[0-3]"]], ["(\\d)(\\d{5})", "$1 $2", ["[13]"]]], 0, 0, "([0-258]\\d{4})$", "3$1"], NG: ["234", "009", "(?:[124-7]|9\\d{3})\\d{6}|[1-9]\\d{7}|[78]\\d{9,13}", [7, 8, 10, 11, 12, 13, 14], [["(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["78"], "0$1"], ["(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[12]|9(?:0[3-9]|[1-9])"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["[3-7]|8[2-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[7-9]"], "0$1"], ["(\\d{3})(\\d{4})(\\d{4,5})", "$1 $2 $3", ["[78]"], "0$1"], ["(\\d{3})(\\d{5})(\\d{5,6})", "$1 $2 $3", ["[78]"], "0$1"]], "0"], NI: ["505", "00", "(?:1800|[25-8]\\d{3})\\d{4}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["[125-8]"]]]], NL: ["31", "00", "(?:[124-7]\\d\\d|3(?:[02-9]\\d|1[0-8]))\\d{6}|8\\d{6,9}|9\\d{6,10}|1\\d{4,5}", [5, 6, 7, 8, 9, 10, 11], [["(\\d{3})(\\d{4,7})", "$1 $2", ["[89]0"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["66"], "0$1"], ["(\\d)(\\d{8})", "$1 $2", ["6"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["1[16-8]|2[259]|3[124]|4[17-9]|5[124679]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1-578]|91"], "0$1"], ["(\\d{3})(\\d{3})(\\d{5})", "$1 $2 $3", ["9"], "0$1"]], "0"], NO: ["47", "00", "(?:0|[2-9]\\d{3})\\d{4}", [5, 8], [["(\\d{3})(\\d{2})(\\d{3})", "$1 $2 $3", ["8"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2-79]"]]], 0, 0, 0, 0, 0, "[02-689]|7[0-8]"], NP: ["977", "00", "(?:1\\d|9)\\d{9}|[1-9]\\d{7}", [8, 10, 11], [["(\\d)(\\d{7})", "$1-$2", ["1[2-6]"], "0$1"], ["(\\d{2})(\\d{6})", "$1-$2", ["1[01]|[2-8]|9(?:[1-59]|[67][2-6])"], "0$1"], ["(\\d{3})(\\d{7})", "$1-$2", ["9"]]], "0"], NR: ["674", "00", "(?:444|(?:55|8\\d)\\d|666)\\d{4}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[4-68]"]]]], NU: ["683", "00", "(?:[47]|888\\d)\\d{3}", [4, 7], [["(\\d{3})(\\d{4})", "$1 $2", ["8"]]]], NZ: ["64", "0(?:0|161)", "[1289]\\d{9}|50\\d{5}(?:\\d{2,3})?|[27-9]\\d{7,8}|(?:[34]\\d|6[0-35-9])\\d{6}|8\\d{4,6}", [5, 6, 7, 8, 9, 10], [["(\\d{2})(\\d{3,8})", "$1 $2", ["8[1-79]"], "0$1"], ["(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["50[036-8]|8|90", "50(?:[0367]|88)|8|90"], "0$1"], ["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["24|[346]|7[2-57-9]|9[2-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2(?:10|74)|[589]"], "0$1"], ["(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["1|2[028]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,5})", "$1 $2 $3", ["2(?:[169]|7[0-35-9])|7"], "0$1"]], "0", 0, 0, 0, 0, 0, 0, "00"], OM: ["968", "00", "(?:1505|[279]\\d{3}|500)\\d{4}|800\\d{5,6}", [7, 8, 9], [["(\\d{3})(\\d{4,6})", "$1 $2", ["[58]"]], ["(\\d{2})(\\d{6})", "$1 $2", ["2"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[179]"]]]], PA: ["507", "00", "(?:00800|8\\d{3})\\d{6}|[68]\\d{7}|[1-57-9]\\d{6}", [7, 8, 10, 11], [["(\\d{3})(\\d{4})", "$1-$2", ["[1-57-9]"]], ["(\\d{4})(\\d{4})", "$1-$2", ["[68]"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]]]], PE: ["51", "00|19(?:1[124]|77|90)00", "(?:[14-8]|9\\d)\\d{7}", [8, 9], [["(\\d{3})(\\d{5})", "$1 $2", ["80"], "(0$1)"], ["(\\d)(\\d{7})", "$1 $2", ["1"], "(0$1)"], ["(\\d{2})(\\d{6})", "$1 $2", ["[4-8]"], "(0$1)"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"]]], "0", 0, 0, 0, 0, 0, 0, "00", " Anexo "], PF: ["689", "00", "4\\d{5}(?:\\d{2})?|8\\d{7,8}", [6, 8, 9], [["(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["44"]], ["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["4|8[7-9]"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"]]]], PG: ["675", "00|140[1-3]", "(?:180|[78]\\d{3})\\d{4}|(?:[2-589]\\d|64)\\d{5}", [7, 8], [["(\\d{3})(\\d{4})", "$1 $2", ["18|[2-69]|85"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[78]"]]], 0, 0, 0, 0, 0, 0, 0, "00"], PH: ["63", "00", "(?:[2-7]|9\\d)\\d{8}|2\\d{5}|(?:1800|8)\\d{7,9}", [6, 8, 9, 10, 11, 12, 13], [["(\\d)(\\d{5})", "$1 $2", ["2"], "(0$1)"], ["(\\d{4})(\\d{4,6})", "$1 $2", ["3(?:23|39|46)|4(?:2[3-6]|[35]9|4[26]|76)|544|88[245]|(?:52|64|86)2", "3(?:230|397|461)|4(?:2(?:35|[46]4|51)|396|4(?:22|63)|59[347]|76[15])|5(?:221|446)|642[23]|8(?:622|8(?:[24]2|5[13]))"], "(0$1)"], ["(\\d{5})(\\d{4})", "$1 $2", ["346|4(?:27|9[35])|883", "3469|4(?:279|9(?:30|56))|8834"], "(0$1)"], ["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["2"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[3-7]|8[2-8]"], "(0$1)"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["[89]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]], ["(\\d{4})(\\d{1,2})(\\d{3})(\\d{4})", "$1 $2 $3 $4", ["1"]]], "0"], PK: ["92", "00", "122\\d{6}|[24-8]\\d{10,11}|9(?:[013-9]\\d{8,10}|2(?:[01]\\d\\d|2(?:[06-8]\\d|1[01]))\\d{7})|(?:[2-8]\\d{3}|92(?:[0-7]\\d|8[1-9]))\\d{6}|[24-9]\\d{8}|[89]\\d{7}", [8, 9, 10, 11, 12], [["(\\d{3})(\\d{3})(\\d{2,7})", "$1 $2 $3", ["[89]0"], "0$1"], ["(\\d{4})(\\d{5})", "$1 $2", ["1"]], ["(\\d{3})(\\d{6,7})", "$1 $2", ["2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:2[2-8]|3[27-9]|4[2-6]|6[3569]|9[25-8])", "9(?:2[3-8]|98)|(?:2(?:3[2358]|4[2-4]|9[2-8])|45[3479]|54[2-467]|60[468]|72[236]|8(?:2[2-689]|3[23578]|4[3478]|5[2356])|9(?:22|3[27-9]|4[2-6]|6[3569]|9[25-7]))[2-9]"], "(0$1)"], ["(\\d{2})(\\d{7,8})", "$1 $2", ["(?:2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91)[2-9]"], "(0$1)"], ["(\\d{5})(\\d{5})", "$1 $2", ["58"], "(0$1)"], ["(\\d{3})(\\d{7})", "$1 $2", ["3"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["2[125]|4[0-246-9]|5[1-35-7]|6[1-8]|7[14]|8[16]|91"], "(0$1)"], ["(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["[24-9]"], "(0$1)"]], "0"], PL: ["48", "00", "(?:6|8\\d\\d)\\d{7}|[1-9]\\d{6}(?:\\d{2})?|[26]\\d{5}", [6, 7, 8, 9, 10], [["(\\d{5})", "$1", ["19"]], ["(\\d{3})(\\d{3})", "$1 $2", ["11|20|64"]], ["(\\d{2})(\\d{2})(\\d{3})", "$1 $2 $3", ["(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])1", "(?:1[2-8]|2[2-69]|3[2-4]|4[1-468]|5[24-689]|6[1-3578]|7[14-7]|8[1-79]|9[145])19"]], ["(\\d{3})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["64"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["21|39|45|5[0137]|6[0469]|7[02389]|8(?:0[14]|8)"]], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["1[2-8]|[2-7]|8[1-79]|9[145]"]], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["8"]]]], PM: ["508", "00", "[45]\\d{5}|(?:708|80\\d)\\d{6}", [6, 9], [["(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["[45]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"], "0$1"]], "0"], PR: ["1", "011", "(?:[589]\\d\\d|787)\\d{7}", [10], 0, "1", 0, 0, 0, 0, "787|939"], PS: ["970", "00", "[2489]2\\d{6}|(?:1\\d|5)\\d{8}", [8, 9, 10], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["[2489]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["5"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], "0"], PT: ["351", "00", "1693\\d{5}|(?:[26-9]\\d|30)\\d{7}", [9], [["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["2[12]"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["16|[236-9]"]]]], PW: ["680", "01[12]", "(?:[24-8]\\d\\d|345|900)\\d{4}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-9]"]]]], PY: ["595", "00", "59\\d{4,6}|9\\d{5,10}|(?:[2-46-8]\\d|5[0-8])\\d{4,7}", [6, 7, 8, 9, 10, 11], [["(\\d{3})(\\d{3,6})", "$1 $2", ["[2-9]0"], "0$1"], ["(\\d{2})(\\d{5})", "$1 $2", ["[26]1|3[289]|4[1246-8]|7[1-3]|8[1-36]"], "(0$1)"], ["(\\d{3})(\\d{4,5})", "$1 $2", ["2[279]|3[13-5]|4[359]|5|6(?:[34]|7[1-46-8])|7[46-8]|85"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2[14-68]|3[26-9]|4[1246-8]|6(?:1|75)|7[1-35]|8[1-36]"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["87"]], ["(\\d{3})(\\d{6})", "$1 $2", ["9(?:[5-79]|8[1-6])"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-8]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["9"]]], "0"], QA: ["974", "00", "800\\d{4}|(?:2|800)\\d{6}|(?:0080|[3-7])\\d{7}", [7, 8, 9, 11], [["(\\d{3})(\\d{4})", "$1 $2", ["2[16]|8"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[3-7]"]]]], RE: ["262", "00", "(?:26|[689]\\d)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2689]"], "0$1"]], "0", 0, 0, 0, 0, 0, [["26(?:2\\d\\d|3(?:0\\d|1[0-5]))\\d{4}"], ["69(?:2\\d\\d|3(?:[06][0-6]|1[013]|2[0-2]|3[0-39]|4\\d|5[0-5]|7[0-27]|8[0-8]|9[0-479]))\\d{4}"], ["80\\d{7}"], ["89[1-37-9]\\d{6}"], 0, 0, 0, 0, ["9(?:399[0-3]|479[0-5]|76(?:2[27]|3[0-37]))\\d{4}"], ["8(?:1[019]|2[0156]|84|90)\\d{6}"]]], RO: ["40", "00", "(?:[2378]\\d|90)\\d{7}|[23]\\d{5}", [6, 9], [["(\\d{3})(\\d{3})", "$1 $2", ["2[3-6]", "2[3-6]\\d9"], "0$1"], ["(\\d{2})(\\d{4})", "$1 $2", ["219|31"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[23]1"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[237-9]"], "0$1"]], "0", 0, 0, 0, 0, 0, 0, 0, " int "], RS: ["381", "00", "38[02-9]\\d{6,9}|6\\d{7,9}|90\\d{4,8}|38\\d{5,6}|(?:7\\d\\d|800)\\d{3,9}|(?:[12]\\d|3[0-79])\\d{5,10}", [6, 7, 8, 9, 10, 11, 12], [["(\\d{3})(\\d{3,9})", "$1 $2", ["(?:2[389]|39)0|[7-9]"], "0$1"], ["(\\d{2})(\\d{5,10})", "$1 $2", ["[1-36]"], "0$1"]], "0"], RU: ["7", "810", "8\\d{13}|[347-9]\\d{9}", [10, 14], [["(\\d{4})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["7(?:1[0-8]|2[1-9])", "7(?:1(?:[0-356]2|4[29]|7|8[27])|2(?:1[23]|[2-9]2))", "7(?:1(?:[0-356]2|4[29]|7|8[27])|2(?:13[03-69]|62[013-9]))|72[1-57-9]2"], "8 ($1)", 1], ["(\\d{5})(\\d)(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["7(?:1[0-68]|2[1-9])", "7(?:1(?:[06][3-6]|[18]|2[35]|[3-5][3-5])|2(?:[13][3-5]|[24-689]|7[457]))", "7(?:1(?:0(?:[356]|4[023])|[18]|2(?:3[013-9]|5)|3[45]|43[013-79]|5(?:3[1-8]|4[1-7]|5)|6(?:3[0-35-9]|[4-6]))|2(?:1(?:3[178]|[45])|[24-689]|3[35]|7[457]))|7(?:14|23)4[0-8]|71(?:33|45)[1-79]"], "8 ($1)", 1], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "8 ($1)", 1], ["(\\d{3})(\\d{3})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[349]|8(?:[02-7]|1[1-8])"], "8 ($1)", 1], ["(\\d{4})(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["8"], "8 ($1)"]], "8", 0, 0, 0, 0, "3[04-689]|[489]", 0, "8~10"], RW: ["250", "00", "(?:06|[27]\\d\\d|[89]00)\\d{6}", [8, 9], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["0"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["2"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[7-9]"], "0$1"]], "0"], SA: ["966", "00", "92\\d{7}|(?:[15]|8\\d)\\d{8}", [9, 10], [["(\\d{4})(\\d{5})", "$1 $2", ["9"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["5"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["81"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]]], "0"], SB: ["677", "0[01]", "(?:[1-6]|[7-9]\\d\\d)\\d{4}", [5, 7], [["(\\d{2})(\\d{5})", "$1 $2", ["7|8[4-9]|9(?:[1-8]|9[0-8])"]]]], SC: ["248", "010|0[0-2]", "800\\d{4}|(?:[249]\\d|64)\\d{5}", [7], [["(\\d)(\\d{3})(\\d{3})", "$1 $2 $3", ["[246]|9[57]"]]], 0, 0, 0, 0, 0, 0, 0, "00"], SD: ["249", "00", "[19]\\d{8}", [9], [["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[19]"], "0$1"]], "0"], SE: ["46", "00", "(?:[26]\\d\\d|9)\\d{9}|[1-9]\\d{8}|[1-689]\\d{7}|[1-4689]\\d{6}|2\\d{5}", [6, 7, 8, 9, 10], [["(\\d{2})(\\d{2,3})(\\d{2})", "$1-$2 $3", ["20"], "0$1", 0, "$1 $2 $3"], ["(\\d{3})(\\d{4})", "$1-$2", ["9(?:00|39|44|9)"], "0$1", 0, "$1 $2"], ["(\\d{2})(\\d{3})(\\d{2})", "$1-$2 $3", ["[12][136]|3[356]|4[0246]|6[03]|90[1-9]"], "0$1", 0, "$1 $2 $3"], ["(\\d)(\\d{2,3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["8"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d{3})(\\d{2,3})(\\d{2})", "$1-$2 $3", ["1[2457]|2(?:[247-9]|5[0138])|3[0247-9]|4[1357-9]|5[0-35-9]|6(?:[125689]|4[02-57]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"], "0$1", 0, "$1 $2 $3"], ["(\\d{3})(\\d{2,3})(\\d{3})", "$1-$2 $3", ["9(?:00|39|44)"], "0$1", 0, "$1 $2 $3"], ["(\\d{2})(\\d{2,3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["1[13689]|2[0136]|3[1356]|4[0246]|54|6[03]|90[1-9]"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["10|7"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d)(\\d{3})(\\d{3})(\\d{2})", "$1-$2 $3 $4", ["8"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1-$2 $3 $4", ["[13-5]|2(?:[247-9]|5[0138])|6(?:[124-689]|7[0-2])|9(?:[125-8]|3[02-5]|4[0-3])"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d{3})(\\d{2})(\\d{2})(\\d{3})", "$1-$2 $3 $4", ["9"], "0$1", 0, "$1 $2 $3 $4"], ["(\\d{3})(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1-$2 $3 $4 $5", ["[26]"], "0$1", 0, "$1 $2 $3 $4 $5"]], "0"], SG: ["65", "0[0-3]\\d", "(?:(?:1\\d|8)\\d\\d|7000)\\d{7}|[3689]\\d{7}", [8, 10, 11], [["(\\d{4})(\\d{4})", "$1 $2", ["[369]|8(?:0[1-8]|[1-9])"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"]], ["(\\d{4})(\\d{4})(\\d{3})", "$1 $2 $3", ["7"]], ["(\\d{4})(\\d{3})(\\d{4})", "$1 $2 $3", ["1"]]]], SH: ["290", "00", "(?:[256]\\d|8)\\d{3}", [4, 5], 0, 0, 0, 0, 0, 0, "[256]"], SI: ["386", "00|10(?:22|66|88|99)", "[1-7]\\d{7}|8\\d{4,7}|90\\d{4,6}", [5, 6, 7, 8], [["(\\d{2})(\\d{3,6})", "$1 $2", ["8[09]|9"], "0$1"], ["(\\d{3})(\\d{5})", "$1 $2", ["59|8"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[37][01]|4[0139]|51|6"], "0$1"], ["(\\d)(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[1-57]"], "(0$1)"]], "0", 0, 0, 0, 0, 0, 0, "00"], SJ: ["47", "00", "0\\d{4}|(?:[489]\\d|79)\\d{6}", [5, 8], 0, 0, 0, 0, 0, 0, "79"], SK: ["421", "00", "[2-689]\\d{8}|[2-59]\\d{6}|[2-5]\\d{5}", [6, 7, 9], [["(\\d)(\\d{2})(\\d{3,4})", "$1 $2 $3", ["21"], "0$1"], ["(\\d{2})(\\d{2})(\\d{2,3})", "$1 $2 $3", ["[3-5][1-8]1", "[3-5][1-8]1[67]"], "0$1"], ["(\\d)(\\d{3})(\\d{3})(\\d{2})", "$1/$2 $3 $4", ["2"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[689]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1/$2 $3 $4", ["[3-5]"], "0$1"]], "0"], SL: ["232", "00", "(?:[237-9]\\d|66)\\d{6}", [8], [["(\\d{2})(\\d{6})", "$1 $2", ["[236-9]"], "(0$1)"]], "0"], SM: ["378", "00", "(?:0549|[5-7]\\d)\\d{6}", [8, 10], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[5-7]"]], ["(\\d{4})(\\d{6})", "$1 $2", ["0"]]], 0, 0, "([89]\\d{5})$", "0549$1"], SN: ["221", "00", "(?:[378]\\d|93)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"]], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[379]"]]]], SO: ["252", "00", "[346-9]\\d{8}|[12679]\\d{7}|[1-5]\\d{6}|[1348]\\d{5}", [6, 7, 8, 9], [["(\\d{2})(\\d{4})", "$1 $2", ["8[125]"]], ["(\\d{6})", "$1", ["[134]"]], ["(\\d)(\\d{6})", "$1 $2", ["[15]|2[0-79]|3[0-46-8]|4[0-7]"]], ["(\\d)(\\d{7})", "$1 $2", ["(?:2|90)4|[67]"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[348]|64|79|90"]], ["(\\d{2})(\\d{5,7})", "$1 $2", ["1|28|6[0-35-9]|77|9[2-9]"]]], "0"], SR: ["597", "00", "(?:[2-5]|68|[78]\\d)\\d{5}", [6, 7], [["(\\d{2})(\\d{2})(\\d{2})", "$1-$2-$3", ["56"]], ["(\\d{3})(\\d{3})", "$1-$2", ["[2-5]"]], ["(\\d{3})(\\d{4})", "$1-$2", ["[6-8]"]]]], SS: ["211", "00", "[19]\\d{8}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[19]"], "0$1"]], "0"], ST: ["239", "00", "(?:22|9\\d)\\d{5}", [7], [["(\\d{3})(\\d{4})", "$1 $2", ["[29]"]]]], SV: ["503", "00", "[267]\\d{7}|[89]00\\d{4}(?:\\d{4})?", [7, 8, 11], [["(\\d{3})(\\d{4})", "$1 $2", ["[89]"]], ["(\\d{4})(\\d{4})", "$1 $2", ["[267]"]], ["(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["[89]"]]]], SX: ["1", "011", "7215\\d{6}|(?:[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "(5\\d{6})$|1", "721$1", 0, "721"], SY: ["963", "00", "[1-39]\\d{8}|[1-5]\\d{7}", [8, 9], [["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[1-5]"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"], "0$1", 1]], "0"], SZ: ["268", "00", "0800\\d{4}|(?:[237]\\d|900)\\d{6}", [8, 9], [["(\\d{4})(\\d{4})", "$1 $2", ["[0237]"]], ["(\\d{5})(\\d{4})", "$1 $2", ["9"]]]], TA: ["290", "00", "8\\d{3}", [4], 0, 0, 0, 0, 0, 0, "8"], TC: ["1", "011", "(?:[58]\\d\\d|649|900)\\d{7}", [10], 0, "1", 0, "([2-479]\\d{6})$|1", "649$1", 0, "649"], TD: ["235", "00|16", "(?:22|[69]\\d|77)\\d{6}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[2679]"]]], 0, 0, 0, 0, 0, 0, 0, "00"], TG: ["228", "00", "[279]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[279]"]]]], TH: ["66", "00[1-9]", "(?:001800|[2-57]|[689]\\d)\\d{7}|1\\d{7,9}", [8, 9, 10, 13], [["(\\d)(\\d{3})(\\d{4})", "$1 $2 $3", ["2"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[13-9]"], "0$1"], ["(\\d{4})(\\d{3})(\\d{3})", "$1 $2 $3", ["1"]]], "0"], TJ: ["992", "810", "[0-57-9]\\d{8}", [9], [["(\\d{6})(\\d)(\\d{2})", "$1 $2 $3", ["331", "3317"]], ["(\\d{3})(\\d{2})(\\d{4})", "$1 $2 $3", ["44[04]|[34]7"]], ["(\\d{4})(\\d)(\\d{4})", "$1 $2 $3", ["3[1-5]"]], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[0-57-9]"]]], 0, 0, 0, 0, 0, 0, 0, "8~10"], TK: ["690", "00", "[2-47]\\d{3,6}", [4, 5, 6, 7]], TL: ["670", "00", "7\\d{7}|(?:[2-47]\\d|[89]0)\\d{5}", [7, 8], [["(\\d{3})(\\d{4})", "$1 $2", ["[2-489]|70"]], ["(\\d{4})(\\d{4})", "$1 $2", ["7"]]]], TM: ["993", "810", "[1-6]\\d{7}", [8], [["(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["12"], "(8 $1)"], ["(\\d{3})(\\d)(\\d{2})(\\d{2})", "$1 $2-$3-$4", ["[1-5]"], "(8 $1)"], ["(\\d{2})(\\d{6})", "$1 $2", ["6"], "8 $1"]], "8", 0, 0, 0, 0, 0, 0, "8~10"], TN: ["216", "00", "[2-57-9]\\d{7}", [8], [["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-57-9]"]]]], TO: ["676", "00", "(?:0800|(?:[5-8]\\d\\d|999)\\d)\\d{3}|[2-8]\\d{4}", [5, 7], [["(\\d{2})(\\d{3})", "$1-$2", ["[2-4]|50|6[09]|7[0-24-69]|8[05]"]], ["(\\d{4})(\\d{3})", "$1 $2", ["0"]], ["(\\d{3})(\\d{4})", "$1 $2", ["[5-9]"]]]], TR: ["90", "00", "4\\d{6}|8\\d{11,12}|(?:[2-58]\\d\\d|900)\\d{7}", [7, 10, 12, 13], [["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["512|8[01589]|90"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["5(?:[0-59]|61)", "5(?:[0-59]|61[06])", "5(?:[0-59]|61[06]1)"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[24][1-8]|3[1-9]"], "(0$1)", 1], ["(\\d{3})(\\d{3})(\\d{6,7})", "$1 $2 $3", ["80"], "0$1", 1]], "0"], TT: ["1", "011", "(?:[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-46-8]\\d{6})$|1", "868$1", 0, "868"], TV: ["688", "00", "(?:2|7\\d\\d|90)\\d{4}", [5, 6, 7], [["(\\d{2})(\\d{3})", "$1 $2", ["2"]], ["(\\d{2})(\\d{4})", "$1 $2", ["90"]], ["(\\d{2})(\\d{5})", "$1 $2", ["7"]]]], TW: ["886", "0(?:0[25-79]|19)", "[2-689]\\d{8}|7\\d{9,10}|[2-8]\\d{7}|2\\d{6}", [7, 8, 9, 10, 11], [["(\\d{2})(\\d)(\\d{4})", "$1 $2 $3", ["202"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[258]0"], "0$1"], ["(\\d)(\\d{3,4})(\\d{4})", "$1 $2 $3", ["[23568]|4(?:0[02-48]|[1-47-9])|7[1-9]", "[23568]|4(?:0[2-48]|[1-47-9])|(?:400|7)[1-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[49]"], "0$1"], ["(\\d{2})(\\d{4})(\\d{4,5})", "$1 $2 $3", ["7"], "0$1"]], "0", 0, 0, 0, 0, 0, 0, 0, "#"], TZ: ["255", "00[056]", "(?:[25-8]\\d|41|90)\\d{7}", [9], [["(\\d{3})(\\d{2})(\\d{4})", "$1 $2 $3", ["[89]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[24]"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["5"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[67]"], "0$1"]], "0"], UA: ["380", "00", "[89]\\d{9}|[3-9]\\d{8}", [9, 10], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["6[12][29]|(?:3[1-8]|4[136-8]|5[12457]|6[49])2|(?:56|65)[24]", "6[12][29]|(?:35|4[1378]|5[12457]|6[49])2|(?:56|65)[24]|(?:3[1-46-8]|46)2[013-9]"], "0$1"], ["(\\d{4})(\\d{5})", "$1 $2", ["3[1-8]|4(?:[1367]|[45][6-9]|8[4-6])|5(?:[1-5]|6[0135689]|7[4-6])|6(?:[12][3-7]|[459])", "3[1-8]|4(?:[1367]|[45][6-9]|8[4-6])|5(?:[1-5]|6(?:[015689]|3[02389])|7[4-6])|6(?:[12][3-7]|[459])"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[3-7]|89|9[1-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[89]"], "0$1"]], "0", 0, 0, 0, 0, 0, 0, "0~0"], UG: ["256", "00[057]", "800\\d{6}|(?:[29]0|[347]\\d)\\d{7}", [9], [["(\\d{4})(\\d{5})", "$1 $2", ["202", "2024"], "0$1"], ["(\\d{3})(\\d{6})", "$1 $2", ["[27-9]|4(?:6[45]|[7-9])"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["[34]"], "0$1"]], "0"], US: ["1", "011", "[2-9]\\d{9}|3\\d{6}", [10], [["(\\d{3})(\\d{4})", "$1-$2", ["310"], 0, 1], ["(\\d{3})(\\d{3})(\\d{4})", "($1) $2-$3", ["[2-9]"], 0, 1, "$1-$2-$3"]], "1", 0, 0, 0, 0, 0, [["5056(?:[0-35-9]\\d|4[46])\\d{4}|(?:4722|505[2-57-9]|983[29])\\d{6}|(?:2(?:0[1-35-9]|1[02-9]|2[03-589]|3[149]|4[08]|5[1-46]|6[0279]|7[0269]|8[13])|3(?:0[1-57-9]|1[02-9]|2[01356]|3[0-24679]|4[167]|5[0-2]|6[014]|8[056])|4(?:0[124-9]|1[02-579]|2[3-5]|3[0245]|4[023578]|58|6[349]|7[0589]|8[04])|5(?:0[1-47-9]|1[0235-8]|20|3[0149]|4[01]|5[179]|6[1-47]|7[0-5]|8[0256])|6(?:0[1-35-9]|1[024-9]|2[03689]|[34][016]|5[01679]|6[0-279]|78|8[0-29])|7(?:0[1-46-8]|1[2-9]|2[04-7]|3[1247]|4[037]|5[47]|6[02359]|7[0-59]|8[156])|8(?:0[1-68]|1[02-8]|2[068]|3[0-2589]|4[03578]|5[046-9]|6[02-5]|7[028])|9(?:0[1346-9]|1[02-9]|2[0589]|3[0146-8]|4[01357-9]|5[12469]|7[0-389]|8[04-69]))[2-9]\\d{6}"], [""], ["8(?:00|33|44|55|66|77|88)[2-9]\\d{6}"], ["900[2-9]\\d{6}"], ["52(?:3(?:[2-46-9][02-9]\\d|5(?:[02-46-9]\\d|5[0-46-9]))|4(?:[2-478][02-9]\\d|5(?:[034]\\d|2[024-9]|5[0-46-9])|6(?:0[1-9]|[2-9]\\d)|9(?:[05-9]\\d|2[0-5]|49)))\\d{4}|52[34][2-9]1[02-9]\\d{4}|5(?:00|2[125-9]|33|44|66|77|88)[2-9]\\d{6}"]]], UY: ["598", "0(?:0|1[3-9]\\d)", "0004\\d{2,9}|[1249]\\d{7}|(?:[49]\\d|80)\\d{5}", [6, 7, 8, 9, 10, 11, 12, 13], [["(\\d{3})(\\d{3,4})", "$1 $2", ["0"]], ["(\\d{3})(\\d{4})", "$1 $2", ["[49]0|8"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["9"], "0$1"], ["(\\d{4})(\\d{4})", "$1 $2", ["[124]"]], ["(\\d{3})(\\d{3})(\\d{2,4})", "$1 $2 $3", ["0"]], ["(\\d{3})(\\d{3})(\\d{3})(\\d{2,4})", "$1 $2 $3 $4", ["0"]]], "0", 0, 0, 0, 0, 0, 0, "00", " int. "], UZ: ["998", "810", "200\\d{6}|(?:33|[5-79]\\d|88)\\d{7}", [9], [["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["[235-9]"], "8 $1"]], "8", 0, 0, 0, 0, 0, 0, "8~10"], VA: ["39", "00", "0\\d{5,10}|3[0-8]\\d{7,10}|55\\d{8}|8\\d{5}(?:\\d{2,4})?|(?:1\\d|39)\\d{7,8}", [6, 7, 8, 9, 10, 11], 0, 0, 0, 0, 0, 0, "06698"], VC: ["1", "011", "(?:[58]\\d\\d|784|900)\\d{7}", [10], 0, "1", 0, "([2-7]\\d{6})$|1", "784$1", 0, "784"], VE: ["58", "00", "[68]00\\d{7}|(?:[24]\\d|[59]0)\\d{8}", [10], [["(\\d{3})(\\d{7})", "$1-$2", ["[24-689]"], "0$1"]], "0"], VG: ["1", "011", "(?:284|[58]\\d\\d|900)\\d{7}", [10], 0, "1", 0, "([2-578]\\d{6})$|1", "284$1", 0, "284"], VI: ["1", "011", "[58]\\d{9}|(?:34|90)0\\d{7}", [10], 0, "1", 0, "([2-9]\\d{6})$|1", "340$1", 0, "340"], VN: ["84", "00", "[12]\\d{9}|[135-9]\\d{8}|[16]\\d{7}|[16-8]\\d{6}", [7, 8, 9, 10], [["(\\d{2})(\\d{5})", "$1 $2", ["80"], "0$1", 1], ["(\\d{4})(\\d{4,6})", "$1 $2", ["1"], 0, 1], ["(\\d{2})(\\d{3})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["6"], "0$1", 1], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[357-9]"], "0$1", 1], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["2[48]"], "0$1", 1], ["(\\d{3})(\\d{4})(\\d{3})", "$1 $2 $3", ["2"], "0$1", 1]], "0"], VU: ["678", "00", "[57-9]\\d{6}|(?:[238]\\d|48)\\d{3}", [5, 7], [["(\\d{3})(\\d{4})", "$1 $2", ["[57-9]"]]]], WF: ["681", "00", "(?:40|72)\\d{4}|8\\d{5}(?:\\d{3})?", [6, 9], [["(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3", ["[478]"]], ["(\\d{3})(\\d{2})(\\d{2})(\\d{2})", "$1 $2 $3 $4", ["8"]]]], WS: ["685", "0", "(?:[2-6]|8\\d{5})\\d{4}|[78]\\d{6}|[68]\\d{5}", [5, 6, 7, 10], [["(\\d{5})", "$1", ["[2-5]|6[1-9]"]], ["(\\d{3})(\\d{3,7})", "$1 $2", ["[68]"]], ["(\\d{2})(\\d{5})", "$1 $2", ["7"]]]], XK: ["383", "00", "[23]\\d{7,8}|(?:4\\d\\d|[89]00)\\d{5}", [8, 9], [["(\\d{3})(\\d{5})", "$1 $2", ["[89]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3})", "$1 $2 $3", ["[2-4]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[23]"], "0$1"]], "0"], YE: ["967", "00", "(?:1|7\\d)\\d{7}|[1-7]\\d{6}", [7, 8, 9], [["(\\d)(\\d{3})(\\d{3,4})", "$1 $2 $3", ["[1-6]|7(?:[24-6]|8[0-7])"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["7"], "0$1"]], "0"], YT: ["262", "00", "(?:80|9\\d)\\d{7}|(?:26|63)9\\d{6}", [9], 0, "0", 0, 0, 0, 0, 0, [["269(?:0[0-467]|5[0-4]|6\\d|[78]0)\\d{4}"], ["639(?:0[0-79]|1[019]|[267]\\d|3[09]|40|5[05-9]|9[04-79])\\d{4}"], ["80\\d{7}"], 0, 0, 0, 0, 0, ["9(?:(?:39|47)8[01]|769\\d)\\d{4}"]]], ZA: ["27", "00", "[1-79]\\d{8}|8\\d{4,9}", [5, 6, 7, 8, 9, 10], [["(\\d{2})(\\d{3,4})", "$1 $2", ["8[1-4]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{2,3})", "$1 $2 $3", ["8[1-4]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["860"], "0$1"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["[1-9]"], "0$1"], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["8"], "0$1"]], "0"], ZM: ["260", "00", "800\\d{6}|(?:21|63|[79]\\d)\\d{7}", [9], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[28]"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["[79]"], "0$1"]], "0"], ZW: ["263", "00", "2(?:[0-57-9]\\d{6,8}|6[0-24-9]\\d{6,7})|[38]\\d{9}|[35-8]\\d{8}|[3-6]\\d{7}|[1-689]\\d{6}|[1-3569]\\d{5}|[1356]\\d{4}", [5, 6, 7, 8, 9, 10], [["(\\d{3})(\\d{3,5})", "$1 $2", ["2(?:0[45]|2[278]|[49]8)|3(?:[09]8|17)|6(?:[29]8|37|75)|[23][78]|(?:33|5[15]|6[68])[78]"], "0$1"], ["(\\d)(\\d{3})(\\d{2,4})", "$1 $2 $3", ["[49]"], "0$1"], ["(\\d{3})(\\d{4})", "$1 $2", ["80"], "0$1"], ["(\\d{2})(\\d{7})", "$1 $2", ["24|8[13-59]|(?:2[05-79]|39|5[45]|6[15-8])2", "2(?:02[014]|4|[56]20|[79]2)|392|5(?:42|525)|6(?:[16-8]21|52[013])|8[13-59]"], "(0$1)"], ["(\\d{2})(\\d{3})(\\d{4})", "$1 $2 $3", ["7"], "0$1"], ["(\\d{3})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["2(?:1[39]|2[0157]|[378]|[56][14])|3(?:12|29)", "2(?:1[39]|2[0157]|[378]|[56][14])|3(?:123|29)"], "0$1"], ["(\\d{4})(\\d{6})", "$1 $2", ["8"], "0$1"], ["(\\d{2})(\\d{3,5})", "$1 $2", ["1|2(?:0[0-36-9]|12|29|[56])|3(?:1[0-689]|[24-6])|5(?:[0236-9]|1[2-4])|6(?:[013-59]|7[0-46-9])|(?:33|55|6[68])[0-69]|(?:29|3[09]|62)[0-79]"], "0$1"], ["(\\d{2})(\\d{3})(\\d{3,4})", "$1 $2 $3", ["29[013-9]|39|54"], "0$1"], ["(\\d{4})(\\d{3,5})", "$1 $2", ["(?:25|54)8", "258|5483"], "0$1"]], "0"] }, nonGeographic: { 800: ["800", 0, "(?:00|[1-9]\\d)\\d{6}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["\\d"]]], 0, 0, 0, 0, 0, 0, [0, 0, ["(?:00|[1-9]\\d)\\d{6}"]]], 808: ["808", 0, "[1-9]\\d{7}", [8], [["(\\d{4})(\\d{4})", "$1 $2", ["[1-9]"]]], 0, 0, 0, 0, 0, 0, [0, 0, 0, 0, 0, 0, 0, 0, 0, ["[1-9]\\d{7}"]]], 870: ["870", 0, "7\\d{11}|[35-7]\\d{8}", [9, 12], [["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["[35-7]"]]], 0, 0, 0, 0, 0, 0, [0, ["(?:[356]|774[45])\\d{8}|7[6-8]\\d{7}"]]], 878: ["878", 0, "10\\d{10}", [12], [["(\\d{2})(\\d{5})(\\d{5})", "$1 $2 $3", ["1"]]], 0, 0, 0, 0, 0, 0, [0, 0, 0, 0, 0, 0, 0, 0, ["10\\d{10}"]]], 881: ["881", 0, "6\\d{9}|[0-36-9]\\d{8}", [9, 10], [["(\\d)(\\d{3})(\\d{5})", "$1 $2 $3", ["[0-37-9]"]], ["(\\d)(\\d{3})(\\d{5,6})", "$1 $2 $3", ["6"]]], 0, 0, 0, 0, 0, 0, [0, ["6\\d{9}|[0-36-9]\\d{8}"]]], 882: ["882", 0, "[13]\\d{6}(?:\\d{2,5})?|[19]\\d{7}|(?:[25]\\d\\d|4)\\d{7}(?:\\d{2})?", [7, 8, 9, 10, 11, 12], [["(\\d{2})(\\d{5})", "$1 $2", ["16|342"]], ["(\\d{2})(\\d{6})", "$1 $2", ["49"]], ["(\\d{2})(\\d{2})(\\d{4})", "$1 $2 $3", ["1[36]|9"]], ["(\\d{2})(\\d{4})(\\d{3})", "$1 $2 $3", ["3[23]"]], ["(\\d{2})(\\d{3,4})(\\d{4})", "$1 $2 $3", ["16"]], ["(\\d{2})(\\d{4})(\\d{4})", "$1 $2 $3", ["10|23|3(?:[15]|4[57])|4|51"]], ["(\\d{3})(\\d{4})(\\d{4})", "$1 $2 $3", ["34"]], ["(\\d{2})(\\d{4,5})(\\d{5})", "$1 $2 $3", ["[1-35]"]]], 0, 0, 0, 0, 0, 0, [0, ["342\\d{4}|(?:337|49)\\d{6}|(?:3(?:2|47|7\\d{3})|50\\d{3})\\d{7}", [7, 8, 9, 10, 12]], 0, 0, 0, 0, 0, 0, ["1(?:3(?:0[0347]|[13][0139]|2[035]|4[013568]|6[0459]|7[06]|8[15-8]|9[0689])\\d{4}|6\\d{5,10})|(?:345\\d|9[89])\\d{6}|(?:10|2(?:3|85\\d)|3(?:[15]|[69]\\d\\d)|4[15-8]|51)\\d{8}"]]], 883: ["883", 0, "(?:[1-4]\\d|51)\\d{6,10}", [8, 9, 10, 11, 12], [["(\\d{3})(\\d{3})(\\d{2,8})", "$1 $2 $3", ["[14]|2[24-689]|3[02-689]|51[24-9]"]], ["(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3", ["510"]], ["(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3", ["21"]], ["(\\d{4})(\\d{4})(\\d{4})", "$1 $2 $3", ["51[13]"]], ["(\\d{3})(\\d{3})(\\d{3})(\\d{3})", "$1 $2 $3 $4", ["[235]"]]], 0, 0, 0, 0, 0, 0, [0, 0, 0, 0, 0, 0, 0, 0, ["(?:2(?:00\\d\\d|10)|(?:370[1-9]|51\\d0)\\d)\\d{7}|51(?:00\\d{5}|[24-9]0\\d{4,7})|(?:1[013-79]|2[24-689]|3[02-689]|4[0-4])0\\d{5,9}"]]], 888: ["888", 0, "\\d{11}", [11], [["(\\d{3})(\\d{3})(\\d{5})", "$1 $2 $3"]], 0, 0, 0, 0, 0, 0, [0, 0, 0, 0, 0, 0, ["\\d{11}"]]], 979: ["979", 0, "[1359]\\d{8}", [9], [["(\\d)(\\d{4})(\\d{4})", "$1 $2 $3", ["[1359]"]]], 0, 0, 0, 0, 0, 0, [0, 0, 0, ["[1359]\\d{8}"]]] } };
function bn(t) {
  return typeof t == "object" && !Array.isArray(t) && t !== null;
}
const Cn = Object.keys, B = Tt.countries, Pn = Cn(B), An = "US";
function E(t, n) {
  const e = Array.isArray(t);
  return n ? e && t.length > 0 : e;
}
function In(t, n) {
  return t.find((e) => n.includes(e)) || null;
}
function J(t) {
  return B[t]?.[0];
}
function xn(t) {
  return t || An;
}
function _t(t, n) {
  return [...new Set(n.concat(t))];
}
function On(t) {
  return t.flatMap((n) => Et[n]);
}
function Sn(t, n) {
  return t.filter((e) => n.includes(e));
}
function En(t, n) {
  return E(n, !0) ? t.filter((e) => !n.includes(e)) : t;
}
function Tn(t, n) {
  const { onlyCountries: e, excludedCountries: r, continents: d, preferredCountries: i } = n;
  if (E(e, !0)) {
    const u = Sn(t, e);
    return E(i, !0) ? _t(u, i) : u;
  }
  const a = E(d, !0) ? On(d) : t, o = E(i, !0) ? _t(a, i) : a;
  return E(r, !0) ? En(o, r) : o;
}
function Fn(t, n) {
  return t.some((e) => Et[e].includes(n));
}
function wn(t, n) {
  return [...t].sort((e, r) => {
    const d = n.of(e), i = n.of(r);
    return d.localeCompare(i);
  });
}
const Dn = {
  CallingCodeSplitted: G(we)({
    borderRight: `1px solid ${sn[300]}`,
    paddingRight: 10,
    cursor: "default",
    pointerEvents: "none"
  })
}, Mn = ({
  disableDropdown: t = !1,
  forceCallingCode: n = !1,
  flagSize: e = "small",
  isFlagsMenuOpened: r = !1,
  isoCode: d,
  ...i
}) => /* @__PURE__ */ _(Fe, { children: [
  t ? /* @__PURE__ */ p(
    Mt,
    {
      tabIndex: -1,
      className: "MuiTelInput-IconButton",
      role: "",
      disableRipple: !0,
      sx: { pointerEvents: "none", aspectRatio: "1 / 1" },
      component: "span",
      children: /* @__PURE__ */ p(mt, { size: e, isoCode: d })
    }
  ) : /* @__PURE__ */ p(
    Mt,
    {
      ...i,
      "aria-label": "Select country",
      className: "MuiTelInput-IconButton",
      "aria-haspopup": "listbox",
      sx: { aspectRatio: "1 / 1" },
      "aria-controls": r ? "select-country" : void 0,
      "aria-expanded": r ? "true" : "false",
      children: /* @__PURE__ */ p(mt, { size: e, isoCode: d })
    }
  ),
  n && d ? /* @__PURE__ */ _(Dn.CallingCodeSplitted, { children: [
    "+",
    J(d)
  ] }) : null
] }), Lt = {
  ListItemIcon: G(hn)({
    marginRight: "10px"
  }),
  ListItemText: G(gn)({
    marginRight: "10px"
  })
}, Rn = ({
  isoCode: t,
  onSelectCountry: n,
  countryName: e,
  flagSize: r = "small",
  ...d
}) => /* @__PURE__ */ _(
  cn,
  {
    ...d,
    onClick: (a) => {
      a.preventDefault(), n(t);
    },
    role: "option",
    "data-testid": `option-${t}`,
    className: "MuiTelInput-MenuItem",
    children: [
      /* @__PURE__ */ p(Lt.ListItemIcon, { className: "MuiTelInput-ListItemIcon-flag", children: /* @__PURE__ */ p(mt, { size: r, isoCode: t, countryName: e }) }),
      /* @__PURE__ */ p(Lt.ListItemText, { className: "MuiTelInput-ListItemText-country", children: e }),
      /* @__PURE__ */ _(
        we,
        {
          variant: "body2",
          color: "text.secondary",
          className: "MuiTelInput-Typography-calling-code",
          children: [
            "+",
            B[t]?.[0]
          ]
        }
      )
    ]
  }
), _n = y.memo(Rn), yt = "en";
function k(...t) {
  process.env.NODE_ENV !== "production" && console.error(...t);
}
function Ln(t = yt) {
  try {
    return new Intl.DisplayNames(t, {
      type: "region"
    });
  } catch (n) {
    return k(n), new Intl.DisplayNames(yt, {
      type: "region"
    });
  }
}
const kn = [], Gn = [], Bn = [], jn = [], Un = ({
  anchorEl: t,
  isoCode: n,
  onSelectCountry: e,
  excludedCountries: r = kn,
  onlyCountries: d = Gn,
  langOfCountryName: i = yt,
  continents: a = Bn,
  preferredCountries: o = jn,
  className: u,
  flagSize: $ = "small",
  ...l
}) => {
  const c = y.useMemo(() => Ln(i), [i]), s = wn(
    Pn,
    c
  ), h = Tn(s, {
    onlyCountries: d,
    excludedCountries: r,
    continents: a,
    preferredCountries: o
  });
  return /* @__PURE__ */ p(
    mn,
    {
      anchorEl: t,
      open: !!t,
      id: "select-country",
      className: `MuiTelInput-Menu ${u || ""}`,
      MenuListProps: {
        role: "listbox",
        "aria-activedescendant": n ? `country-${n}` : "",
        "aria-labelledby": "select-country"
      },
      ...l,
      children: h.map((g) => /* @__PURE__ */ p(
        _n,
        {
          onSelectCountry: e,
          isoCode: g,
          countryName: c.of(g),
          selected: g === n,
          id: `country-${g}`,
          flagSize: $
        },
        g
      ))
    }
  );
};
function Wn(t) {
  t.focus();
  const { length: n } = t.value;
  t.setSelectionRange(n, n);
}
function lt(t, n) {
  typeof n == "function" ? n(t) : n && bn(n) && "current" in n && (n.current = t);
}
function De(t, n) {
  return t.replace(n, "");
}
function Hn(t) {
  const {
    defaultCountry: n,
    onlyCountries: e,
    excludedCountries: r,
    continents: d,
    forceCallingCode: i
  } = t;
  y.useEffect(() => {
    if (e && r) {
      const a = In(
        e,
        r
      );
      a && k(
        `[mui-tel-input] Not expected to have the country ${a} to be included in the 'onlyCountries' AND 'excludedCountries' props`
      );
    }
  }, [e, r]), y.useEffect(() => {
    n && r && r.includes(n) && k(
      `[mui-tel-input] Not expected to have the 'defaultCountry' (${n}) prop excluded by the 'excludedCountries' prop`
    );
  }, [n, r]), y.useEffect(() => {
    n && e && !e.includes(n) && k(
      `[mui-tel-input] Not expected to have a 'defaultCountry' prop (${n}) and a 'onlyCountries' prop but without included the 'defaultCountry' (${n})`
    );
  }, [n, e]), y.useEffect(() => {
    n && d && d.length > 0 && (d.some((o) => Et[o].includes(n)) || k(
      `[mui-tel-input] Not expected to have a 'defaultCountry' prop (${n}) and a 'continents' prop that are not contain the country (${n})`
    ));
  }, [n, d]), y.useEffect(() => {
    i && !n && k(
      "[mui-tel-input] 'forceCallingCode' needs 'defaultCountry' defined. Will default to US."
    );
  }, [n, i]);
}
function Me(t, n) {
  var e = Array.prototype.slice.call(n);
  return e.push(Tt), t.apply(this, e);
}
function pt(t) {
  "@babel/helpers - typeof";
  return pt = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(n) {
    return typeof n;
  } : function(n) {
    return n && typeof Symbol == "function" && n.constructor === Symbol && n !== Symbol.prototype ? "symbol" : typeof n;
  }, pt(t);
}
function kt(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function Vn(t, n, e) {
  return n && kt(t.prototype, n), e && kt(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
function Zn(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function zn(t, n) {
  if (typeof n != "function" && n !== null)
    throw new TypeError("Super expression must either be null or a function");
  t.prototype = Object.create(n && n.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), n && V(t, n);
}
function Yn(t) {
  var n = _e();
  return function() {
    var r = Z(t), d;
    if (n) {
      var i = Z(this).constructor;
      d = Reflect.construct(r, arguments, i);
    } else
      d = r.apply(this, arguments);
    return Xn(this, d);
  };
}
function Xn(t, n) {
  if (n && (pt(n) === "object" || typeof n == "function"))
    return n;
  if (n !== void 0)
    throw new TypeError("Derived constructors may only return object or undefined");
  return Re(t);
}
function Re(t) {
  if (t === void 0)
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  return t;
}
function vt(t) {
  var n = typeof Map == "function" ? /* @__PURE__ */ new Map() : void 0;
  return vt = function(r) {
    if (r === null || !Kn(r))
      return r;
    if (typeof r != "function")
      throw new TypeError("Super expression must either be null or a function");
    if (typeof n < "u") {
      if (n.has(r))
        return n.get(r);
      n.set(r, d);
    }
    function d() {
      return K(r, arguments, Z(this).constructor);
    }
    return d.prototype = Object.create(r.prototype, { constructor: { value: d, enumerable: !1, writable: !0, configurable: !0 } }), V(d, r);
  }, vt(t);
}
function K(t, n, e) {
  return _e() ? K = Reflect.construct : K = function(d, i, a) {
    var o = [null];
    o.push.apply(o, i);
    var u = Function.bind.apply(d, o), $ = new u();
    return a && V($, a.prototype), $;
  }, K.apply(null, arguments);
}
function _e() {
  if (typeof Reflect > "u" || !Reflect.construct || Reflect.construct.sham)
    return !1;
  if (typeof Proxy == "function")
    return !0;
  try {
    return Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    })), !0;
  } catch {
    return !1;
  }
}
function Kn(t) {
  return Function.toString.call(t).indexOf("[native code]") !== -1;
}
function V(t, n) {
  return V = Object.setPrototypeOf || function(r, d) {
    return r.__proto__ = d, r;
  }, V(t, n);
}
function Z(t) {
  return Z = Object.setPrototypeOf ? Object.getPrototypeOf : function(e) {
    return e.__proto__ || Object.getPrototypeOf(e);
  }, Z(t);
}
var S = /* @__PURE__ */ function(t) {
  zn(e, t);
  var n = Yn(e);
  function e(r) {
    var d;
    return Zn(this, e), d = n.call(this, r), Object.setPrototypeOf(Re(d), e.prototype), d.name = d.constructor.name, d;
  }
  return Vn(e);
}(/* @__PURE__ */ vt(Error)), Ft = 2, Qn = 17, Jn = 3, b = "0-9０-９٠-٩۰-۹", qn = "-‐-―−ー－", tr = "／/", er = "．.", nr = "  ­​⁠　", rr = "()（）［］\\[\\]", dr = "~⁓∼～", I = "".concat(qn).concat(tr).concat(er).concat(nr).concat(rr).concat(dr), et = "+＋";
function Gt(t, n) {
  t = t.split("-"), n = n.split("-");
  for (var e = t[0].split("."), r = n[0].split("."), d = 0; d < 3; d++) {
    var i = Number(e[d]), a = Number(r[d]);
    if (i > a)
      return 1;
    if (a > i)
      return -1;
    if (!isNaN(i) && isNaN(a))
      return 1;
    if (isNaN(i) && !isNaN(a))
      return -1;
  }
  return t[1] && n[1] ? t[1] > n[1] ? 1 : t[1] < n[1] ? -1 : 0 : !t[1] && n[1] ? 1 : t[1] && !n[1] ? -1 : 0;
}
var ir = {}.constructor;
function R(t) {
  return t != null && t.constructor === ir;
}
function Nt(t) {
  "@babel/helpers - typeof";
  return Nt = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(n) {
    return typeof n;
  } : function(n) {
    return n && typeof Symbol == "function" && n.constructor === Symbol && n !== Symbol.prototype ? "symbol" : typeof n;
  }, Nt(t);
}
function nt(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function Bt(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function rt(t, n, e) {
  return n && Bt(t.prototype, n), e && Bt(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var ar = "1.2.0", or = "1.7.35", jt = " ext. ", ur = /^\d+$/, N = /* @__PURE__ */ function() {
  function t(n) {
    nt(this, t), sr(n), this.metadata = n, Le.call(this, n);
  }
  return rt(t, [{
    key: "getCountries",
    value: function() {
      return Object.keys(this.metadata.countries).filter(function(e) {
        return e !== "001";
      });
    }
  }, {
    key: "getCountryMetadata",
    value: function(e) {
      return this.metadata.countries[e];
    }
  }, {
    key: "nonGeographic",
    value: function() {
      if (!(this.v1 || this.v2 || this.v3))
        return this.metadata.nonGeographic || this.metadata.nonGeographical;
    }
  }, {
    key: "hasCountry",
    value: function(e) {
      return this.getCountryMetadata(e) !== void 0;
    }
  }, {
    key: "hasCallingCode",
    value: function(e) {
      if (this.getCountryCodesForCallingCode(e))
        return !0;
      if (this.nonGeographic()) {
        if (this.nonGeographic()[e])
          return !0;
      } else {
        var r = this.countryCallingCodes()[e];
        if (r && r.length === 1 && r[0] === "001")
          return !0;
      }
    }
  }, {
    key: "isNonGeographicCallingCode",
    value: function(e) {
      return this.nonGeographic() ? !!this.nonGeographic()[e] : !this.getCountryCodesForCallingCode(e);
    }
    // Deprecated.
  }, {
    key: "country",
    value: function(e) {
      return this.selectNumberingPlan(e);
    }
  }, {
    key: "selectNumberingPlan",
    value: function(e, r) {
      if (e && ur.test(e) && (r = e, e = null), e && e !== "001") {
        if (!this.hasCountry(e))
          throw new Error("Unknown country: ".concat(e));
        this.numberingPlan = new Ut(this.getCountryMetadata(e), this);
      } else if (r) {
        if (!this.hasCallingCode(r))
          throw new Error("Unknown calling code: ".concat(r));
        this.numberingPlan = new Ut(this.getNumberingPlanMetadata(r), this);
      } else
        this.numberingPlan = void 0;
      return this;
    }
  }, {
    key: "getCountryCodesForCallingCode",
    value: function(e) {
      var r = this.countryCallingCodes()[e];
      if (r)
        return r.length === 1 && r[0].length === 3 ? void 0 : r;
    }
  }, {
    key: "getCountryCodeForCallingCode",
    value: function(e) {
      var r = this.getCountryCodesForCallingCode(e);
      if (r)
        return r[0];
    }
  }, {
    key: "getNumberingPlanMetadata",
    value: function(e) {
      var r = this.getCountryCodeForCallingCode(e);
      if (r)
        return this.getCountryMetadata(r);
      if (this.nonGeographic()) {
        var d = this.nonGeographic()[e];
        if (d)
          return d;
      } else {
        var i = this.countryCallingCodes()[e];
        if (i && i.length === 1 && i[0] === "001")
          return this.metadata.countries["001"];
      }
    }
    // Deprecated.
  }, {
    key: "countryCallingCode",
    value: function() {
      return this.numberingPlan.callingCode();
    }
    // Deprecated.
  }, {
    key: "IDDPrefix",
    value: function() {
      return this.numberingPlan.IDDPrefix();
    }
    // Deprecated.
  }, {
    key: "defaultIDDPrefix",
    value: function() {
      return this.numberingPlan.defaultIDDPrefix();
    }
    // Deprecated.
  }, {
    key: "nationalNumberPattern",
    value: function() {
      return this.numberingPlan.nationalNumberPattern();
    }
    // Deprecated.
  }, {
    key: "possibleLengths",
    value: function() {
      return this.numberingPlan.possibleLengths();
    }
    // Deprecated.
  }, {
    key: "formats",
    value: function() {
      return this.numberingPlan.formats();
    }
    // Deprecated.
  }, {
    key: "nationalPrefixForParsing",
    value: function() {
      return this.numberingPlan.nationalPrefixForParsing();
    }
    // Deprecated.
  }, {
    key: "nationalPrefixTransformRule",
    value: function() {
      return this.numberingPlan.nationalPrefixTransformRule();
    }
    // Deprecated.
  }, {
    key: "leadingDigits",
    value: function() {
      return this.numberingPlan.leadingDigits();
    }
    // Deprecated.
  }, {
    key: "hasTypes",
    value: function() {
      return this.numberingPlan.hasTypes();
    }
    // Deprecated.
  }, {
    key: "type",
    value: function(e) {
      return this.numberingPlan.type(e);
    }
    // Deprecated.
  }, {
    key: "ext",
    value: function() {
      return this.numberingPlan.ext();
    }
  }, {
    key: "countryCallingCodes",
    value: function() {
      return this.v1 ? this.metadata.country_phone_code_to_countries : this.metadata.country_calling_codes;
    }
    // Deprecated.
  }, {
    key: "chooseCountryByCountryCallingCode",
    value: function(e) {
      return this.selectNumberingPlan(e);
    }
  }, {
    key: "hasSelectedNumberingPlan",
    value: function() {
      return this.numberingPlan !== void 0;
    }
  }]), t;
}(), Ut = /* @__PURE__ */ function() {
  function t(n, e) {
    nt(this, t), this.globalMetadataObject = e, this.metadata = n, Le.call(this, e.metadata);
  }
  return rt(t, [{
    key: "callingCode",
    value: function() {
      return this.metadata[0];
    }
    // Formatting information for regions which share
    // a country calling code is contained by only one region
    // for performance reasons. For example, for NANPA region
    // ("North American Numbering Plan Administration",
    //  which includes USA, Canada, Cayman Islands, Bahamas, etc)
    // it will be contained in the metadata for `US`.
  }, {
    key: "getDefaultCountryMetadataForRegion",
    value: function() {
      return this.globalMetadataObject.getNumberingPlanMetadata(this.callingCode());
    }
    // Is always present.
  }, {
    key: "IDDPrefix",
    value: function() {
      if (!(this.v1 || this.v2))
        return this.metadata[1];
    }
    // Is only present when a country supports multiple IDD prefixes.
  }, {
    key: "defaultIDDPrefix",
    value: function() {
      if (!(this.v1 || this.v2))
        return this.metadata[12];
    }
  }, {
    key: "nationalNumberPattern",
    value: function() {
      return this.v1 || this.v2 ? this.metadata[1] : this.metadata[2];
    }
    // "possible length" data is always present in Google's metadata.
  }, {
    key: "possibleLengths",
    value: function() {
      if (!this.v1)
        return this.metadata[this.v2 ? 2 : 3];
    }
  }, {
    key: "_getFormats",
    value: function(e) {
      return e[this.v1 ? 2 : this.v2 ? 3 : 4];
    }
    // For countries of the same region (e.g. NANPA)
    // formats are all stored in the "main" country for that region.
    // E.g. "RU" and "KZ", "US" and "CA".
  }, {
    key: "formats",
    value: function() {
      var e = this, r = this._getFormats(this.metadata) || this._getFormats(this.getDefaultCountryMetadataForRegion()) || [];
      return r.map(function(d) {
        return new $r(d, e);
      });
    }
  }, {
    key: "nationalPrefix",
    value: function() {
      return this.metadata[this.v1 ? 3 : this.v2 ? 4 : 5];
    }
  }, {
    key: "_getNationalPrefixFormattingRule",
    value: function(e) {
      return e[this.v1 ? 4 : this.v2 ? 5 : 6];
    }
    // For countries of the same region (e.g. NANPA)
    // national prefix formatting rule is stored in the "main" country for that region.
    // E.g. "RU" and "KZ", "US" and "CA".
  }, {
    key: "nationalPrefixFormattingRule",
    value: function() {
      return this._getNationalPrefixFormattingRule(this.metadata) || this._getNationalPrefixFormattingRule(this.getDefaultCountryMetadataForRegion());
    }
  }, {
    key: "_nationalPrefixForParsing",
    value: function() {
      return this.metadata[this.v1 ? 5 : this.v2 ? 6 : 7];
    }
  }, {
    key: "nationalPrefixForParsing",
    value: function() {
      return this._nationalPrefixForParsing() || this.nationalPrefix();
    }
  }, {
    key: "nationalPrefixTransformRule",
    value: function() {
      return this.metadata[this.v1 ? 6 : this.v2 ? 7 : 8];
    }
  }, {
    key: "_getNationalPrefixIsOptionalWhenFormatting",
    value: function() {
      return !!this.metadata[this.v1 ? 7 : this.v2 ? 8 : 9];
    }
    // For countries of the same region (e.g. NANPA)
    // "national prefix is optional when formatting" flag is
    // stored in the "main" country for that region.
    // E.g. "RU" and "KZ", "US" and "CA".
  }, {
    key: "nationalPrefixIsOptionalWhenFormattingInNationalFormat",
    value: function() {
      return this._getNationalPrefixIsOptionalWhenFormatting(this.metadata) || this._getNationalPrefixIsOptionalWhenFormatting(this.getDefaultCountryMetadataForRegion());
    }
  }, {
    key: "leadingDigits",
    value: function() {
      return this.metadata[this.v1 ? 8 : this.v2 ? 9 : 10];
    }
  }, {
    key: "types",
    value: function() {
      return this.metadata[this.v1 ? 9 : this.v2 ? 10 : 11];
    }
  }, {
    key: "hasTypes",
    value: function() {
      return this.types() && this.types().length === 0 ? !1 : !!this.types();
    }
  }, {
    key: "type",
    value: function(e) {
      if (this.hasTypes() && Wt(this.types(), e))
        return new fr(Wt(this.types(), e), this);
    }
  }, {
    key: "ext",
    value: function() {
      return this.v1 || this.v2 ? jt : this.metadata[13] || jt;
    }
  }]), t;
}(), $r = /* @__PURE__ */ function() {
  function t(n, e) {
    nt(this, t), this._format = n, this.metadata = e;
  }
  return rt(t, [{
    key: "pattern",
    value: function() {
      return this._format[0];
    }
  }, {
    key: "format",
    value: function() {
      return this._format[1];
    }
  }, {
    key: "leadingDigitsPatterns",
    value: function() {
      return this._format[2] || [];
    }
  }, {
    key: "nationalPrefixFormattingRule",
    value: function() {
      return this._format[3] || this.metadata.nationalPrefixFormattingRule();
    }
  }, {
    key: "nationalPrefixIsOptionalWhenFormattingInNationalFormat",
    value: function() {
      return !!this._format[4] || this.metadata.nationalPrefixIsOptionalWhenFormattingInNationalFormat();
    }
  }, {
    key: "nationalPrefixIsMandatoryWhenFormattingInNationalFormat",
    value: function() {
      return this.usesNationalPrefix() && !this.nationalPrefixIsOptionalWhenFormattingInNationalFormat();
    }
    // Checks whether national prefix formatting rule contains national prefix.
  }, {
    key: "usesNationalPrefix",
    value: function() {
      return !!(this.nationalPrefixFormattingRule() && // Check that national prefix formatting rule is not a "dummy" one.
      !lr.test(this.nationalPrefixFormattingRule()));
    }
  }, {
    key: "internationalFormat",
    value: function() {
      return this._format[5] || this.format();
    }
  }]), t;
}(), lr = /^\(?\$1\)?$/, fr = /* @__PURE__ */ function() {
  function t(n, e) {
    nt(this, t), this.type = n, this.metadata = e;
  }
  return rt(t, [{
    key: "pattern",
    value: function() {
      return this.metadata.v1 ? this.type : this.type[0];
    }
  }, {
    key: "possibleLengths",
    value: function() {
      if (!this.metadata.v1)
        return this.type[1] || this.metadata.possibleLengths();
    }
  }]), t;
}();
function Wt(t, n) {
  switch (n) {
    case "FIXED_LINE":
      return t[0];
    case "MOBILE":
      return t[1];
    case "TOLL_FREE":
      return t[2];
    case "PREMIUM_RATE":
      return t[3];
    case "PERSONAL_NUMBER":
      return t[4];
    case "VOICEMAIL":
      return t[5];
    case "UAN":
      return t[6];
    case "PAGER":
      return t[7];
    case "VOIP":
      return t[8];
    case "SHARED_COST":
      return t[9];
  }
}
function sr(t) {
  if (!t)
    throw new Error("[libphonenumber-js] `metadata` argument not passed. Check your arguments.");
  if (!R(t) || !R(t.countries))
    throw new Error("[libphonenumber-js] `metadata` argument was passed but it's not a valid metadata. Must be an object having `.countries` child object property. Got ".concat(R(t) ? "an object of shape: { " + Object.keys(t).join(", ") + " }" : "a " + cr(t) + ": " + t, "."));
}
var cr = function(n) {
  return Nt(n);
};
function wt(t, n) {
  if (n = new N(n), n.hasCountry(t))
    return n.country(t).countryCallingCode();
  throw new Error("Unknown country: ".concat(t));
}
function hr(t, n) {
  return n.countries.hasOwnProperty(t);
}
function Le(t) {
  var n = t.version;
  typeof n == "number" ? (this.v1 = n === 1, this.v2 = n === 2, this.v3 = n === 3, this.v4 = n === 4) : n ? Gt(n, ar) === -1 ? this.v2 = !0 : Gt(n, or) === -1 ? this.v3 = !0 : this.v4 = !0 : this.v1 = !0;
}
var gr = ";ext=", L = function(n) {
  return "([".concat(b, "]{1,").concat(n, "})");
};
function ke(t) {
  var n = "20", e = "15", r = "9", d = "6", i = "[  \\t,]*", a = "[:\\.．]?[  \\t,-]*", o = "#?", u = "(?:e?xt(?:ensi(?:ó?|ó))?n?|ｅ?ｘｔｎ?|доб|anexo)", $ = "(?:[xｘ#＃~～]|int|ｉｎｔ)", l = "[- ]+", c = "[  \\t]*", s = "(?:,{2}|;)", h = gr + L(n), g = i + u + a + L(n) + o, C = i + $ + a + L(r) + o, v = l + L(d) + "#", D = c + s + a + L(e) + o, U = c + "(?:,)+" + a + L(r) + o;
  return h + "|" + g + "|" + C + "|" + v + "|" + D + "|" + U;
}
var mr = "[" + b + "]{" + Ft + "}", yr = "[" + et + "]{0,1}(?:[" + I + "]*[" + b + "]){3,}[" + I + b + "]*", pr = new RegExp("^[" + et + "]{0,1}(?:[" + I + "]*[" + b + "]){1,2}$", "i"), vr = yr + // Phone number extensions
"(?:" + ke() + ")?", Nr = new RegExp(
  // Either a short two-digit-only phone number
  "^" + mr + "$|^" + vr + "$",
  "i"
);
function bt(t) {
  return t.length >= Ft && Nr.test(t);
}
function br(t) {
  return pr.test(t);
}
var Ht = new RegExp("(?:" + ke() + ")$", "i");
function Cr(t) {
  var n = t.search(Ht);
  if (n < 0)
    return {};
  for (var e = t.slice(0, n), r = t.match(Ht), d = 1; d < r.length; ) {
    if (r[d])
      return {
        number: e,
        ext: r[d]
      };
    d++;
  }
}
function Pr(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Ar(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Ar(t, n) {
  if (t) {
    if (typeof t == "string")
      return Vt(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Vt(t, n);
  }
}
function Vt(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
var Ir = {
  0: "0",
  1: "1",
  2: "2",
  3: "3",
  4: "4",
  5: "5",
  6: "6",
  7: "7",
  8: "8",
  9: "9",
  "０": "0",
  // Fullwidth digit 0
  "１": "1",
  // Fullwidth digit 1
  "２": "2",
  // Fullwidth digit 2
  "３": "3",
  // Fullwidth digit 3
  "４": "4",
  // Fullwidth digit 4
  "５": "5",
  // Fullwidth digit 5
  "６": "6",
  // Fullwidth digit 6
  "７": "7",
  // Fullwidth digit 7
  "８": "8",
  // Fullwidth digit 8
  "９": "9",
  // Fullwidth digit 9
  "٠": "0",
  // Arabic-indic digit 0
  "١": "1",
  // Arabic-indic digit 1
  "٢": "2",
  // Arabic-indic digit 2
  "٣": "3",
  // Arabic-indic digit 3
  "٤": "4",
  // Arabic-indic digit 4
  "٥": "5",
  // Arabic-indic digit 5
  "٦": "6",
  // Arabic-indic digit 6
  "٧": "7",
  // Arabic-indic digit 7
  "٨": "8",
  // Arabic-indic digit 8
  "٩": "9",
  // Arabic-indic digit 9
  "۰": "0",
  // Eastern-Arabic digit 0
  "۱": "1",
  // Eastern-Arabic digit 1
  "۲": "2",
  // Eastern-Arabic digit 2
  "۳": "3",
  // Eastern-Arabic digit 3
  "۴": "4",
  // Eastern-Arabic digit 4
  "۵": "5",
  // Eastern-Arabic digit 5
  "۶": "6",
  // Eastern-Arabic digit 6
  "۷": "7",
  // Eastern-Arabic digit 7
  "۸": "8",
  // Eastern-Arabic digit 8
  "۹": "9"
  // Eastern-Arabic digit 9
};
function Ge(t) {
  return Ir[t];
}
function q(t) {
  for (var n = "", e = Pr(t.split("")), r; !(r = e()).done; ) {
    var d = r.value, i = Ge(d);
    i && (n += i);
  }
  return n;
}
function xr(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Or(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Or(t, n) {
  if (t) {
    if (typeof t == "string")
      return Zt(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Zt(t, n);
  }
}
function Zt(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function zt(t) {
  for (var n = "", e = xr(t.split("")), r; !(r = e()).done; ) {
    var d = r.value;
    n += Sr(d, n) || "";
  }
  return n;
}
function Sr(t, n) {
  return t === "+" ? n ? void 0 : "+" : Ge(t);
}
function Er(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Tr(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Tr(t, n) {
  if (t) {
    if (typeof t == "string")
      return Yt(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Yt(t, n);
  }
}
function Yt(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Fr(t, n) {
  for (var e = t.slice(), r = Er(n), d; !(d = r()).done; ) {
    var i = d.value;
    t.indexOf(i) < 0 && e.push(i);
  }
  return e.sort(function(a, o) {
    return a - o;
  });
}
function dt(t, n) {
  return Be(t, void 0, n);
}
function Be(t, n, e) {
  var r = e.type(n), d = r && r.possibleLengths() || e.possibleLengths();
  if (!d)
    return "IS_POSSIBLE";
  if (n === "FIXED_LINE_OR_MOBILE") {
    if (!e.type("FIXED_LINE"))
      return Be(t, "MOBILE", e);
    var i = e.type("MOBILE");
    i && (d = Fr(d, i.possibleLengths()));
  } else if (n && !r)
    return "INVALID_LENGTH";
  var a = t.length, o = d[0];
  return o === a ? "IS_POSSIBLE" : o > a ? "TOO_SHORT" : d[d.length - 1] < a ? "TOO_LONG" : d.indexOf(a, 1) >= 0 ? "IS_POSSIBLE" : "INVALID_LENGTH";
}
function wr(t, n, e) {
  if (n === void 0 && (n = {}), e = new N(e), n.v2) {
    if (!t.countryCallingCode)
      throw new Error("Invalid phone number object passed");
    e.selectNumberingPlan(t.countryCallingCode);
  } else {
    if (!t.phone)
      return !1;
    if (t.country) {
      if (!e.hasCountry(t.country))
        throw new Error("Unknown country: ".concat(t.country));
      e.country(t.country);
    } else {
      if (!t.countryCallingCode)
        throw new Error("Invalid phone number object passed");
      e.selectNumberingPlan(t.countryCallingCode);
    }
  }
  if (e.possibleLengths())
    return je(t.phone || t.nationalNumber, e);
  if (t.countryCallingCode && e.isNonGeographicCallingCode(t.countryCallingCode))
    return !0;
  throw new Error('Missing "possibleLengths" in metadata. Perhaps the metadata has been generated before v1.0.18.');
}
function je(t, n) {
  switch (dt(t, n)) {
    case "IS_POSSIBLE":
      return !0;
    default:
      return !1;
  }
}
function T(t, n) {
  return t = t || "", new RegExp("^(?:" + n + ")$").test(t);
}
function Dr(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Mr(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Mr(t, n) {
  if (t) {
    if (typeof t == "string")
      return Xt(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Xt(t, n);
  }
}
function Xt(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
var Rr = ["MOBILE", "PREMIUM_RATE", "TOLL_FREE", "SHARED_COST", "VOIP", "PERSONAL_NUMBER", "PAGER", "UAN", "VOICEMAIL"];
function it(t, n, e) {
  if (n = n || {}, !(!t.country && !t.countryCallingCode)) {
    e = new N(e), e.selectNumberingPlan(t.country, t.countryCallingCode);
    var r = n.v2 ? t.nationalNumber : t.phone;
    if (T(r, e.nationalNumberPattern())) {
      if (ft(r, "FIXED_LINE", e))
        return e.type("MOBILE") && e.type("MOBILE").pattern() === "" || !e.type("MOBILE") || ft(r, "MOBILE", e) ? "FIXED_LINE_OR_MOBILE" : "FIXED_LINE";
      for (var d = Dr(Rr), i; !(i = d()).done; ) {
        var a = i.value;
        if (ft(r, a, e))
          return a;
      }
    }
  }
}
function ft(t, n, e) {
  return n = e.type(n), !n || !n.pattern() || n.possibleLengths() && n.possibleLengths().indexOf(t.length) < 0 ? !1 : T(t, n.pattern());
}
function _r(t, n, e) {
  if (n = n || {}, e = new N(e), e.selectNumberingPlan(t.country, t.countryCallingCode), e.hasTypes())
    return it(t, n, e.metadata) !== void 0;
  var r = n.v2 ? t.nationalNumber : t.phone;
  return T(r, e.nationalNumberPattern());
}
function Lr(t, n, e) {
  var r = new N(e), d = r.getCountryCodesForCallingCode(t);
  return d ? d.filter(function(i) {
    return kr(n, i, e);
  }) : [];
}
function kr(t, n, e) {
  var r = new N(e);
  return r.selectNumberingPlan(n), r.numberingPlan.possibleLengths().indexOf(t.length) >= 0;
}
function Ue(t) {
  return t.replace(new RegExp("[".concat(I, "]+"), "g"), " ").trim();
}
var We = /(\$\d)/;
function He(t, n, e) {
  var r = e.useInternationalFormat, d = e.withNationalPrefix;
  e.carrierCode, e.metadata;
  var i = t.replace(new RegExp(n.pattern()), r ? n.internationalFormat() : (
    // This library doesn't use `domestic_carrier_code_formatting_rule`,
    // because that one is only used when formatting phone numbers
    // for dialing from a mobile phone, and this is not a dialing library.
    // carrierCode && format.domesticCarrierCodeFormattingRule()
    // 	// First, replace the $CC in the formatting rule with the desired carrier code.
    // 	// Then, replace the $FG in the formatting rule with the first group
    // 	// and the carrier code combined in the appropriate way.
    // 	? format.format().replace(FIRST_GROUP_PATTERN, format.domesticCarrierCodeFormattingRule().replace('$CC', carrierCode))
    // 	: (
    // 		withNationalPrefix && format.nationalPrefixFormattingRule()
    // 			? format.format().replace(FIRST_GROUP_PATTERN, format.nationalPrefixFormattingRule())
    // 			: format.format()
    // 	)
    d && n.nationalPrefixFormattingRule() ? n.format().replace(We, n.nationalPrefixFormattingRule()) : n.format()
  ));
  return r ? Ue(i) : i;
}
var Gr = /^[\d]+(?:[~\u2053\u223C\uFF5E][\d]+)?$/;
function Br(t, n, e) {
  var r = new N(e);
  if (r.selectNumberingPlan(t, n), r.defaultIDDPrefix())
    return r.defaultIDDPrefix();
  if (Gr.test(r.IDDPrefix()))
    return r.IDDPrefix();
}
function jr(t) {
  var n = t.number, e = t.ext;
  if (!n)
    return "";
  if (n[0] !== "+")
    throw new Error('"formatRFC3966()" expects "number" to be in E.164 format.');
  return "tel:".concat(n).concat(e ? ";ext=" + e : "");
}
function Ur(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Wr(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Wr(t, n) {
  if (t) {
    if (typeof t == "string")
      return Kt(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Kt(t, n);
  }
}
function Kt(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Qt(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function Jt(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? Qt(Object(e), !0).forEach(function(r) {
      Hr(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : Qt(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function Hr(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
var qt = {
  formatExtension: function(n, e, r) {
    return "".concat(n).concat(r.ext()).concat(e);
  }
};
function Vr(t, n, e, r) {
  if (e ? e = Jt(Jt({}, qt), e) : e = qt, r = new N(r), t.country && t.country !== "001") {
    if (!r.hasCountry(t.country))
      throw new Error("Unknown country: ".concat(t.country));
    r.country(t.country);
  } else if (t.countryCallingCode)
    r.selectNumberingPlan(t.countryCallingCode);
  else
    return t.phone || "";
  var d = r.countryCallingCode(), i = e.v2 ? t.nationalNumber : t.phone, a;
  switch (n) {
    case "NATIONAL":
      return i ? (a = tt(i, t.carrierCode, "NATIONAL", r, e), st(a, t.ext, r, e.formatExtension)) : "";
    case "INTERNATIONAL":
      return i ? (a = tt(i, null, "INTERNATIONAL", r, e), a = "+".concat(d, " ").concat(a), st(a, t.ext, r, e.formatExtension)) : "+".concat(d);
    case "E.164":
      return "+".concat(d).concat(i);
    case "RFC3966":
      return jr({
        number: "+".concat(d).concat(i),
        ext: t.ext
      });
    case "IDD":
      if (!e.fromCountry)
        return;
      var o = zr(i, t.carrierCode, d, e.fromCountry, r);
      return st(o, t.ext, r, e.formatExtension);
    default:
      throw new Error('Unknown "format" argument passed to "formatNumber()": "'.concat(n, '"'));
  }
}
function tt(t, n, e, r, d) {
  var i = Zr(r.formats(), t);
  return i ? He(t, i, {
    useInternationalFormat: e === "INTERNATIONAL",
    withNationalPrefix: !(i.nationalPrefixIsOptionalWhenFormattingInNationalFormat() && d && d.nationalPrefix === !1),
    carrierCode: n,
    metadata: r
  }) : t;
}
function Zr(t, n) {
  for (var e = Ur(t), r; !(r = e()).done; ) {
    var d = r.value;
    if (d.leadingDigitsPatterns().length > 0) {
      var i = d.leadingDigitsPatterns()[d.leadingDigitsPatterns().length - 1];
      if (n.search(i) !== 0)
        continue;
    }
    if (T(n, d.pattern()))
      return d;
  }
}
function st(t, n, e, r) {
  return n ? r(t, n, e) : t;
}
function zr(t, n, e, r, d) {
  var i = wt(r, d.metadata);
  if (i === e) {
    var a = tt(t, n, "NATIONAL", d);
    return e === "1" ? e + " " + a : a;
  }
  var o = Br(r, void 0, d.metadata);
  if (o)
    return "".concat(o, " ").concat(e, " ").concat(tt(t, null, "INTERNATIONAL", d));
}
function te(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function ee(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? te(Object(e), !0).forEach(function(r) {
      Yr(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : te(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function Yr(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
function Xr(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function ne(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function Kr(t, n, e) {
  return n && ne(t.prototype, n), e && ne(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var Ve = /* @__PURE__ */ function() {
  function t(n, e, r) {
    if (Xr(this, t), !n)
      throw new TypeError("`country` or `countryCallingCode` not passed");
    if (!e)
      throw new TypeError("`nationalNumber` not passed");
    if (!r)
      throw new TypeError("`metadata` not passed");
    var d = Jr(n, r), i = d.country, a = d.countryCallingCode;
    this.country = i, this.countryCallingCode = a, this.nationalNumber = e, this.number = "+" + this.countryCallingCode + this.nationalNumber, this.getMetadata = function() {
      return r;
    };
  }
  return Kr(t, [{
    key: "setExt",
    value: function(e) {
      this.ext = e;
    }
  }, {
    key: "getPossibleCountries",
    value: function() {
      return this.country ? [this.country] : Lr(this.countryCallingCode, this.nationalNumber, this.getMetadata());
    }
  }, {
    key: "isPossible",
    value: function() {
      return wr(this, {
        v2: !0
      }, this.getMetadata());
    }
  }, {
    key: "isValid",
    value: function() {
      return _r(this, {
        v2: !0
      }, this.getMetadata());
    }
  }, {
    key: "isNonGeographic",
    value: function() {
      var e = new N(this.getMetadata());
      return e.isNonGeographicCallingCode(this.countryCallingCode);
    }
  }, {
    key: "isEqual",
    value: function(e) {
      return this.number === e.number && this.ext === e.ext;
    }
    // This function was originally meant to be an equivalent for `validatePhoneNumberLength()`,
    // but later it was found out that it doesn't include the possible `TOO_SHORT` result
    // returned from `parsePhoneNumberWithError()` in the original `validatePhoneNumberLength()`,
    // so eventually I simply commented out this method from the `PhoneNumber` class
    // and just left the `validatePhoneNumberLength()` function, even though that one would require
    // and additional step to also validate the actual country / calling code of the phone number.
    // validateLength() {
    // 	const metadata = new Metadata(this.getMetadata())
    // 	metadata.selectNumberingPlan(this.countryCallingCode)
    // 	const result = checkNumberLength(this.nationalNumber, metadata)
    // 	if (result !== 'IS_POSSIBLE') {
    // 		return result
    // 	}
    // }
  }, {
    key: "getType",
    value: function() {
      return it(this, {
        v2: !0
      }, this.getMetadata());
    }
  }, {
    key: "format",
    value: function(e, r) {
      return Vr(this, e, r ? ee(ee({}, r), {}, {
        v2: !0
      }) : {
        v2: !0
      }, this.getMetadata());
    }
  }, {
    key: "formatNational",
    value: function(e) {
      return this.format("NATIONAL", e);
    }
  }, {
    key: "formatInternational",
    value: function(e) {
      return this.format("INTERNATIONAL", e);
    }
  }, {
    key: "getURI",
    value: function(e) {
      return this.format("RFC3966", e);
    }
  }]), t;
}(), Qr = function(n) {
  return /^[A-Z]{2}$/.test(n);
};
function Jr(t, n) {
  var e, r, d = new N(n);
  return Qr(t) ? (e = t, d.selectNumberingPlan(e), r = d.countryCallingCode()) : r = t, {
    country: e,
    countryCallingCode: r
  };
}
var qr = new RegExp("([" + b + "])");
function Ze(t, n, e, r) {
  if (n) {
    var d = new N(r);
    d.selectNumberingPlan(n, e);
    var i = new RegExp(d.IDDPrefix());
    if (t.search(i) === 0) {
      t = t.slice(t.match(i)[0].length);
      var a = t.match(qr);
      if (!(a && a[1] != null && a[1].length > 0 && a[1] === "0"))
        return t;
    }
  }
}
function Ct(t, n) {
  if (t && n.numberingPlan.nationalPrefixForParsing()) {
    var e = new RegExp("^(?:" + n.numberingPlan.nationalPrefixForParsing() + ")"), r = e.exec(t);
    if (r) {
      var d, i, a = r.length - 1, o = a > 0 && r[a];
      if (n.nationalPrefixTransformRule() && o)
        d = t.replace(e, n.nationalPrefixTransformRule()), a > 1 && (i = r[1]);
      else {
        var u = r[0];
        d = t.slice(u.length), o && (i = r[1]);
      }
      var $;
      if (o) {
        var l = t.indexOf(r[1]), c = t.slice(0, l);
        c === n.numberingPlan.nationalPrefix() && ($ = n.numberingPlan.nationalPrefix());
      } else
        $ = r[0];
      return {
        nationalNumber: d,
        nationalPrefix: $,
        carrierCode: i
      };
    }
  }
  return {
    nationalNumber: t
  };
}
function Pt(t, n) {
  var e = Ct(t, n), r = e.carrierCode, d = e.nationalNumber;
  if (d !== t) {
    if (!td(t, d, n))
      return {
        nationalNumber: t
      };
    if (n.possibleLengths() && !ed(d, n))
      return {
        nationalNumber: t
      };
  }
  return {
    nationalNumber: d,
    carrierCode: r
  };
}
function td(t, n, e) {
  return !(T(t, e.nationalNumberPattern()) && !T(n, e.nationalNumberPattern()));
}
function ed(t, n) {
  switch (dt(t, n)) {
    case "TOO_SHORT":
    case "INVALID_LENGTH":
      return !1;
    default:
      return !0;
  }
}
function ze(t, n, e, r) {
  var d = n ? wt(n, r) : e;
  if (t.indexOf(d) === 0) {
    r = new N(r), r.selectNumberingPlan(n, e);
    var i = t.slice(d.length), a = Pt(i, r), o = a.nationalNumber, u = Pt(t, r), $ = u.nationalNumber;
    if (!T($, r.nationalNumberPattern()) && T(o, r.nationalNumberPattern()) || dt($, r) === "TOO_LONG")
      return {
        countryCallingCode: d,
        number: i
      };
  }
  return {
    number: t
  };
}
function Ye(t, n, e, r) {
  if (!t)
    return {};
  var d;
  if (t[0] !== "+") {
    var i = Ze(t, n, e, r);
    if (i && i !== t)
      d = !0, t = "+" + i;
    else {
      if (n || e) {
        var a = ze(t, n, e, r), o = a.countryCallingCode, u = a.number;
        if (o)
          return {
            countryCallingCodeSource: "FROM_NUMBER_WITHOUT_PLUS_SIGN",
            countryCallingCode: o,
            number: u
          };
      }
      return {
        // No need to set it to `UNSPECIFIED`. It can be just `undefined`.
        // countryCallingCodeSource: 'UNSPECIFIED',
        number: t
      };
    }
  }
  if (t[1] === "0")
    return {};
  r = new N(r);
  for (var $ = 2; $ - 1 <= Jn && $ <= t.length; ) {
    var l = t.slice(1, $);
    if (r.hasCallingCode(l))
      return r.selectNumberingPlan(l), {
        countryCallingCodeSource: d ? "FROM_NUMBER_WITH_IDD" : "FROM_NUMBER_WITH_PLUS_SIGN",
        countryCallingCode: l,
        number: t.slice($)
      };
    $++;
  }
  return {};
}
function nd(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = rd(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function rd(t, n) {
  if (t) {
    if (typeof t == "string")
      return re(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return re(t, n);
  }
}
function re(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Xe(t, n) {
  var e = n.countries, r = n.defaultCountry, d = n.metadata;
  d = new N(d);
  for (var i = [], a = nd(e), o; !(o = a()).done; ) {
    var u = o.value;
    if (d.country(u), d.leadingDigits()) {
      if (t && t.search(d.leadingDigits()) === 0)
        return u;
    } else if (it({
      phone: t,
      country: u
    }, void 0, d.metadata))
      if (r) {
        if (u === r)
          return u;
        i.push(u);
      } else
        return u;
  }
  if (i.length > 0)
    return i[0];
}
var dd = !1;
function Ke(t, n) {
  var e = n.nationalNumber, r = n.defaultCountry, d = n.metadata;
  if (dd && d.isNonGeographicCallingCode(t))
    return "001";
  var i = d.getCountryCodesForCallingCode(t);
  if (i)
    return i.length === 1 ? i[0] : Xe(e, {
      countries: i,
      defaultCountry: r,
      metadata: d.metadata
    });
}
var Qe = "+", id = "[\\-\\.\\(\\)]?", de = "([" + b + "]|" + id + ")", ad = "^\\" + Qe + de + "*[" + b + "]" + de + "*$", od = new RegExp(ad, "g"), At = b, ud = "[" + At + "]+((\\-)*[" + At + "])*", $d = "a-zA-Z", ld = "[" + $d + "]+((\\-)*[" + At + "])*", fd = "^(" + ud + "\\.)*" + ld + "\\.?$", sd = new RegExp(fd, "g"), ie = "tel:", It = ";phone-context=", cd = ";isub=";
function hd(t) {
  var n = t.indexOf(It);
  if (n < 0)
    return null;
  var e = n + It.length;
  if (e >= t.length)
    return "";
  var r = t.indexOf(";", e);
  return r >= 0 ? t.substring(e, r) : t.substring(e);
}
function gd(t) {
  return t === null ? !0 : t.length === 0 ? !1 : od.test(t) || sd.test(t);
}
function md(t, n) {
  var e = n.extractFormattedPhoneNumber, r = hd(t);
  if (!gd(r))
    throw new S("NOT_A_NUMBER");
  var d;
  if (r === null)
    d = e(t) || "";
  else {
    d = "", r.charAt(0) === Qe && (d += r);
    var i = t.indexOf(ie), a;
    i >= 0 ? a = i + ie.length : a = 0;
    var o = t.indexOf(It);
    d += t.substring(a, o);
  }
  var u = d.indexOf(cd);
  if (u > 0 && (d = d.substring(0, u)), d !== "")
    return d;
}
var yd = 250, pd = new RegExp("[" + et + b + "]"), vd = new RegExp("[^" + b + "#]+$");
function xt(t, n, e) {
  if (n = n || {}, e = new N(e), n.defaultCountry && !e.hasCountry(n.defaultCountry))
    throw n.v2 ? new S("INVALID_COUNTRY") : new Error("Unknown country: ".concat(n.defaultCountry));
  var r = bd(t, n.v2, n.extract), d = r.number, i = r.ext, a = r.error;
  if (!d) {
    if (n.v2)
      throw a === "TOO_SHORT" ? new S("TOO_SHORT") : new S("NOT_A_NUMBER");
    return {};
  }
  var o = Pd(d, n.defaultCountry, n.defaultCallingCode, e), u = o.country, $ = o.nationalNumber, l = o.countryCallingCode, c = o.countryCallingCodeSource, s = o.carrierCode;
  if (!e.hasSelectedNumberingPlan()) {
    if (n.v2)
      throw new S("INVALID_COUNTRY");
    return {};
  }
  if (!$ || $.length < Ft) {
    if (n.v2)
      throw new S("TOO_SHORT");
    return {};
  }
  if ($.length > Qn) {
    if (n.v2)
      throw new S("TOO_LONG");
    return {};
  }
  if (n.v2) {
    var h = new Ve(l, $, e.metadata);
    return u && (h.country = u), s && (h.carrierCode = s), i && (h.ext = i), h.__countryCallingCodeSource = c, h;
  }
  var g = (n.extended ? e.hasSelectedNumberingPlan() : u) ? T($, e.nationalNumberPattern()) : !1;
  return n.extended ? {
    country: u,
    countryCallingCode: l,
    carrierCode: s,
    valid: g,
    possible: g ? !0 : !!(n.extended === !0 && e.possibleLengths() && je($, e)),
    phone: $,
    ext: i
  } : g ? Cd(u, $, i) : {};
}
function Nd(t, n, e) {
  if (t) {
    if (t.length > yd) {
      if (e)
        throw new S("TOO_LONG");
      return;
    }
    if (n === !1)
      return t;
    var r = t.search(pd);
    if (!(r < 0))
      return t.slice(r).replace(vd, "");
  }
}
function bd(t, n, e) {
  var r = md(t, {
    extractFormattedPhoneNumber: function(a) {
      return Nd(a, e, n);
    }
  });
  if (!r)
    return {};
  if (!bt(r))
    return br(r) ? {
      error: "TOO_SHORT"
    } : {};
  var d = Cr(r);
  return d.ext ? d : {
    number: r
  };
}
function Cd(t, n, e) {
  var r = {
    country: t,
    phone: n
  };
  return e && (r.ext = e), r;
}
function Pd(t, n, e, r) {
  var d = Ye(zt(t), n, e, r.metadata), i = d.countryCallingCodeSource, a = d.countryCallingCode, o = d.number, u;
  if (a)
    r.selectNumberingPlan(a);
  else if (o && (n || e))
    r.selectNumberingPlan(n, e), n && (u = n), a = e || wt(n, r.metadata);
  else
    return {};
  if (!o)
    return {
      countryCallingCodeSource: i,
      countryCallingCode: a
    };
  var $ = Pt(zt(o), r), l = $.nationalNumber, c = $.carrierCode, s = Ke(a, {
    nationalNumber: l,
    defaultCountry: n,
    metadata: r
  });
  return s && (u = s, s === "001" || r.country(u)), {
    country: u,
    countryCallingCode: a,
    countryCallingCodeSource: i,
    nationalNumber: l,
    carrierCode: c
  };
}
function ae(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function oe(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? ae(Object(e), !0).forEach(function(r) {
      Ad(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : ae(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function Ad(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
function Id(t, n, e) {
  return xt(t, oe(oe({}, n), {}, {
    v2: !0
  }), e);
}
function ue(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function xd(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? ue(Object(e), !0).forEach(function(r) {
      Od(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : ue(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function Od(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
function Sd(t, n) {
  return wd(t) || Fd(t, n) || Td(t, n) || Ed();
}
function Ed() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Td(t, n) {
  if (t) {
    if (typeof t == "string")
      return $e(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return $e(t, n);
  }
}
function $e(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Fd(t, n) {
  var e = t == null ? null : typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e != null) {
    var r = [], d = !0, i = !1, a, o;
    try {
      for (e = e.call(t); !(d = (a = e.next()).done) && (r.push(a.value), !(n && r.length === n)); d = !0)
        ;
    } catch (u) {
      i = !0, o = u;
    } finally {
      try {
        !d && e.return != null && e.return();
      } finally {
        if (i)
          throw o;
      }
    }
    return r;
  }
}
function wd(t) {
  if (Array.isArray(t))
    return t;
}
function Dd(t) {
  var n = Array.prototype.slice.call(t), e = Sd(n, 4), r = e[0], d = e[1], i = e[2], a = e[3], o, u, $;
  if (typeof r == "string")
    o = r;
  else
    throw new TypeError("A text for parsing must be a string.");
  if (!d || typeof d == "string")
    a ? (u = i, $ = a) : (u = void 0, $ = i), d && (u = xd({
      defaultCountry: d
    }, u));
  else if (R(d))
    i ? (u = d, $ = i) : $ = d;
  else
    throw new Error("Invalid second argument: ".concat(d));
  return {
    text: o,
    options: u,
    metadata: $
  };
}
function le(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function fe(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? le(Object(e), !0).forEach(function(r) {
      Md(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : le(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function Md(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
function Rd(t, n, e) {
  n && n.defaultCountry && !hr(n.defaultCountry, e) && (n = fe(fe({}, n), {}, {
    defaultCountry: void 0
  }));
  try {
    return Id(t, n, e);
  } catch (r) {
    if (!(r instanceof S))
      throw r;
  }
}
function se(t, n) {
  var e = Object.keys(t);
  if (Object.getOwnPropertySymbols) {
    var r = Object.getOwnPropertySymbols(t);
    n && (r = r.filter(function(d) {
      return Object.getOwnPropertyDescriptor(t, d).enumerable;
    })), e.push.apply(e, r);
  }
  return e;
}
function ce(t) {
  for (var n = 1; n < arguments.length; n++) {
    var e = arguments[n] != null ? arguments[n] : {};
    n % 2 ? se(Object(e), !0).forEach(function(r) {
      _d(t, r, e[r]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t, Object.getOwnPropertyDescriptors(e)) : se(Object(e)).forEach(function(r) {
      Object.defineProperty(t, r, Object.getOwnPropertyDescriptor(e, r));
    });
  }
  return t;
}
function _d(t, n, e) {
  return n in t ? Object.defineProperty(t, n, { value: e, enumerable: !0, configurable: !0, writable: !0 }) : t[n] = e, t;
}
function Ld() {
  var t = Dd(arguments), n = t.text, e = t.options, r = t.metadata;
  e = ce(ce({}, e), {}, {
    extract: !1
  });
  var d = Rd(n, e, r);
  return d && d.isValid() || !1;
}
function kd(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function he(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function Gd(t, n, e) {
  return n && he(t.prototype, n), e && he(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var Bd = /* @__PURE__ */ function() {
  function t(n) {
    var e = n.onCountryChange, r = n.onCallingCodeChange;
    kd(this, t), this.onCountryChange = e, this.onCallingCodeChange = r;
  }
  return Gd(t, [{
    key: "reset",
    value: function(e) {
      var r = e.country, d = e.callingCode;
      this.international = !1, this.missingPlus = !1, this.IDDPrefix = void 0, this.callingCode = void 0, this.digits = "", this.resetNationalSignificantNumber(), this.initCountryAndCallingCode(r, d);
    }
  }, {
    key: "resetNationalSignificantNumber",
    value: function() {
      this.nationalSignificantNumber = this.getNationalDigits(), this.nationalSignificantNumberMatchesInput = !0, this.nationalPrefix = void 0, this.carrierCode = void 0, this.complexPrefixBeforeNationalSignificantNumber = void 0;
    }
  }, {
    key: "update",
    value: function(e) {
      for (var r = 0, d = Object.keys(e); r < d.length; r++) {
        var i = d[r];
        this[i] = e[i];
      }
    }
  }, {
    key: "initCountryAndCallingCode",
    value: function(e, r) {
      this.setCountry(e), this.setCallingCode(r);
    }
  }, {
    key: "setCountry",
    value: function(e) {
      this.country = e, this.onCountryChange(e);
    }
  }, {
    key: "setCallingCode",
    value: function(e) {
      this.callingCode = e, this.onCallingCodeChange(e, this.country);
    }
  }, {
    key: "startInternationalNumber",
    value: function(e, r) {
      this.international = !0, this.initCountryAndCallingCode(e, r);
    }
  }, {
    key: "appendDigits",
    value: function(e) {
      this.digits += e;
    }
  }, {
    key: "appendNationalSignificantNumberDigits",
    value: function(e) {
      this.nationalSignificantNumber += e;
    }
    /**
     * Returns the part of `this.digits` that corresponds to the national number.
     * Basically, all digits that have been input by the user, except for the
     * international prefix and the country calling code part
     * (if the number is an international one).
     * @return {string}
     */
  }, {
    key: "getNationalDigits",
    value: function() {
      return this.international ? this.digits.slice((this.IDDPrefix ? this.IDDPrefix.length : 0) + (this.callingCode ? this.callingCode.length : 0)) : this.digits;
    }
  }, {
    key: "getDigitsWithoutInternationalPrefix",
    value: function() {
      return this.international && this.IDDPrefix ? this.digits.slice(this.IDDPrefix.length) : this.digits;
    }
  }]), t;
}();
function jd(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = Ud(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Ud(t, n) {
  if (t) {
    if (typeof t == "string")
      return ge(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return ge(t, n);
  }
}
function ge(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
var A = "x", ct = new RegExp(A);
function Q(t, n) {
  if (n < 1)
    return "";
  for (var e = ""; n > 1; )
    n & 1 && (e += t), n >>= 1, t += t;
  return e + t;
}
function me(t, n) {
  return t[n] === ")" && n++, Wd(t.slice(0, n));
}
function Wd(t) {
  for (var n = [], e = 0; e < t.length; )
    t[e] === "(" ? n.push(e) : t[e] === ")" && n.pop(), e++;
  var r = 0, d = "";
  n.push(t.length);
  for (var i = 0, a = n; i < a.length; i++) {
    var o = a[i];
    d += t.slice(r, o), r = o + 1;
  }
  return d;
}
function Hd(t, n, e) {
  for (var r = jd(e.split("")), d; !(d = r()).done; ) {
    var i = d.value;
    if (t.slice(n + 1).search(ct) < 0)
      return;
    n = t.search(ct), t = t.replace(ct, i);
  }
  return [t, n];
}
function Vd(t, n, e) {
  var r = e.metadata, d = e.shouldTryNationalPrefixFormattingRule, i = e.getSeparatorAfterNationalPrefix, a = new RegExp("^(?:".concat(n.pattern(), ")$"));
  if (a.test(t.nationalSignificantNumber))
    return zd(t, n, {
      metadata: r,
      shouldTryNationalPrefixFormattingRule: d,
      getSeparatorAfterNationalPrefix: i
    });
}
function Zd(t, n) {
  return dt(t, n) === "IS_POSSIBLE";
}
function zd(t, n, e) {
  var r = e.metadata, d = e.shouldTryNationalPrefixFormattingRule, i = e.getSeparatorAfterNationalPrefix;
  if (t.nationalSignificantNumber, t.international, t.nationalPrefix, t.carrierCode, d(n)) {
    var a = ye(t, n, {
      useNationalPrefixFormattingRule: !0,
      getSeparatorAfterNationalPrefix: i,
      metadata: r
    });
    if (a)
      return a;
  }
  return ye(t, n, {
    useNationalPrefixFormattingRule: !1,
    getSeparatorAfterNationalPrefix: i,
    metadata: r
  });
}
function ye(t, n, e) {
  var r = e.metadata, d = e.useNationalPrefixFormattingRule, i = e.getSeparatorAfterNationalPrefix, a = He(t.nationalSignificantNumber, n, {
    carrierCode: t.carrierCode,
    useInternationalFormat: t.international,
    withNationalPrefix: d,
    metadata: r
  });
  if (d || (t.nationalPrefix ? a = t.nationalPrefix + i(n) + a : t.complexPrefixBeforeNationalSignificantNumber && (a = t.complexPrefixBeforeNationalSignificantNumber + " " + a)), Yd(a, t))
    return a;
}
function Yd(t, n) {
  return q(t) === n.getNationalDigits();
}
function Xd(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function pe(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function Kd(t, n, e) {
  return n && pe(t.prototype, n), e && pe(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var Qd = /* @__PURE__ */ function() {
  function t() {
    Xd(this, t);
  }
  return Kd(t, [{
    key: "parse",
    value: function(e) {
      if (this.context = [{
        or: !0,
        instructions: []
      }], this.parsePattern(e), this.context.length !== 1)
        throw new Error("Non-finalized contexts left when pattern parse ended");
      var r = this.context[0], d = r.branches, i = r.instructions;
      if (d)
        return {
          op: "|",
          args: d.concat([ht(i)])
        };
      if (i.length === 0)
        throw new Error("Pattern is required");
      return i.length === 1 ? i[0] : i;
    }
  }, {
    key: "startContext",
    value: function(e) {
      this.context.push(e);
    }
  }, {
    key: "endContext",
    value: function() {
      this.context.pop();
    }
  }, {
    key: "getContext",
    value: function() {
      return this.context[this.context.length - 1];
    }
  }, {
    key: "parsePattern",
    value: function(e) {
      if (!e)
        throw new Error("Pattern is required");
      var r = e.match(ti);
      if (!r) {
        if (qd.test(e))
          throw new Error("Illegal characters found in a pattern: ".concat(e));
        this.getContext().instructions = this.getContext().instructions.concat(e.split(""));
        return;
      }
      var d = r[1], i = e.slice(0, r.index), a = e.slice(r.index + d.length);
      switch (d) {
        case "(?:":
          i && this.parsePattern(i), this.startContext({
            or: !0,
            instructions: [],
            branches: []
          });
          break;
        case ")":
          if (!this.getContext().or)
            throw new Error('")" operator must be preceded by "(?:" operator');
          if (i && this.parsePattern(i), this.getContext().instructions.length === 0)
            throw new Error('No instructions found after "|" operator in an "or" group');
          var o = this.getContext(), u = o.branches;
          u.push(ht(this.getContext().instructions)), this.endContext(), this.getContext().instructions.push({
            op: "|",
            args: u
          });
          break;
        case "|":
          if (!this.getContext().or)
            throw new Error('"|" operator can only be used inside "or" groups');
          if (i && this.parsePattern(i), !this.getContext().branches)
            if (this.context.length === 1)
              this.getContext().branches = [];
            else
              throw new Error('"branches" not found in an "or" group context');
          this.getContext().branches.push(ht(this.getContext().instructions)), this.getContext().instructions = [];
          break;
        case "[":
          i && this.parsePattern(i), this.startContext({
            oneOfSet: !0
          });
          break;
        case "]":
          if (!this.getContext().oneOfSet)
            throw new Error('"]" operator must be preceded by "[" operator');
          this.endContext(), this.getContext().instructions.push({
            op: "[]",
            args: Jd(i)
          });
          break;
        default:
          throw new Error("Unknown operator: ".concat(d));
      }
      a && this.parsePattern(a);
    }
  }]), t;
}();
function Jd(t) {
  for (var n = [], e = 0; e < t.length; ) {
    if (t[e] === "-") {
      if (e === 0 || e === t.length - 1)
        throw new Error("Couldn't parse a one-of set pattern: ".concat(t));
      for (var r = t[e - 1].charCodeAt(0) + 1, d = t[e + 1].charCodeAt(0) - 1, i = r; i <= d; )
        n.push(String.fromCharCode(i)), i++;
    } else
      n.push(t[e]);
    e++;
  }
  return n;
}
var qd = /[\(\)\[\]\?\:\|]/, ti = new RegExp(
  // any of:
  "(\\||\\(\\?\\:|\\)|\\[|\\])"
);
function ht(t) {
  return t.length === 1 ? t[0] : t;
}
function ve(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = ei(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function ei(t, n) {
  if (t) {
    if (typeof t == "string")
      return Ne(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Ne(t, n);
  }
}
function Ne(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function ni(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function be(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function ri(t, n, e) {
  return n && be(t.prototype, n), e && be(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var di = /* @__PURE__ */ function() {
  function t(n) {
    ni(this, t), this.matchTree = new Qd().parse(n);
  }
  return ri(t, [{
    key: "match",
    value: function(e) {
      var r = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {}, d = r.allowOverflow;
      if (!e)
        throw new Error("String is required");
      var i = Ot(e.split(""), this.matchTree, !0);
      if (i && i.match && delete i.matchedChars, !(i && i.overflow && !d))
        return i;
    }
  }]), t;
}();
function Ot(t, n, e) {
  if (typeof n == "string") {
    var r = t.join("");
    return n.indexOf(r) === 0 ? t.length === n.length ? {
      match: !0,
      matchedChars: t
    } : {
      partialMatch: !0
      // matchedChars: characters
    } : r.indexOf(n) === 0 ? e && t.length > n.length ? {
      overflow: !0
    } : {
      match: !0,
      matchedChars: t.slice(0, n.length)
    } : void 0;
  }
  if (Array.isArray(n)) {
    for (var d = t.slice(), i = 0; i < n.length; ) {
      var a = n[i], o = Ot(d, a, e && i === n.length - 1);
      if (o) {
        if (o.overflow)
          return o;
        if (o.match) {
          if (d = d.slice(o.matchedChars.length), d.length === 0)
            return i === n.length - 1 ? {
              match: !0,
              matchedChars: t
            } : {
              partialMatch: !0
              // matchedChars: characters
            };
        } else {
          if (o.partialMatch)
            return {
              partialMatch: !0
              // matchedChars: characters
            };
          throw new Error(`Unsupported match result:
`.concat(JSON.stringify(o, null, 2)));
        }
      } else
        return;
      i++;
    }
    return e ? {
      overflow: !0
    } : {
      match: !0,
      matchedChars: t.slice(0, t.length - d.length)
    };
  }
  switch (n.op) {
    case "|":
      for (var u, $ = ve(n.args), l; !(l = $()).done; ) {
        var c = l.value, s = Ot(t, c, e);
        if (s) {
          if (s.overflow)
            return s;
          if (s.match)
            return {
              match: !0,
              matchedChars: s.matchedChars
            };
          if (s.partialMatch)
            u = !0;
          else
            throw new Error(`Unsupported match result:
`.concat(JSON.stringify(s, null, 2)));
        }
      }
      return u ? {
        partialMatch: !0
        // matchedChars: ...
      } : void 0;
    case "[]":
      for (var h = ve(n.args), g; !(g = h()).done; ) {
        var C = g.value;
        if (t[0] === C)
          return t.length === 1 ? {
            match: !0,
            matchedChars: t
          } : e ? {
            overflow: !0
          } : {
            match: !0,
            matchedChars: [C]
          };
      }
      return;
    default:
      throw new Error("Unsupported instruction tree: ".concat(n));
  }
}
function Ce(t, n) {
  var e = typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e)
    return (e = e.call(t)).next.bind(e);
  if (Array.isArray(t) || (e = ii(t)) || n && t && typeof t.length == "number") {
    e && (t = e);
    var r = 0;
    return function() {
      return r >= t.length ? { done: !0 } : { done: !1, value: t[r++] };
    };
  }
  throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function ii(t, n) {
  if (t) {
    if (typeof t == "string")
      return Pe(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Pe(t, n);
  }
}
function Pe(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function ai(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function Ae(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function oi(t, n, e) {
  return n && Ae(t.prototype, n), e && Ae(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var St = "9", ui = 15, $i = Q(St, ui), li = /[- ]/, fi = function() {
  return /\[([^\[\]])*\]/g;
}, si = function() {
  return /\d(?=[^,}][^,}])/g;
}, ci = new RegExp("[" + I + "]*\\$1[" + I + "]*(\\$\\d[" + I + "]*)*$"), Ie = 3, hi = /* @__PURE__ */ function() {
  function t(n) {
    n.state;
    var e = n.metadata;
    ai(this, t), this.metadata = e, this.resetFormat();
  }
  return oi(t, [{
    key: "resetFormat",
    value: function() {
      this.chosenFormat = void 0, this.template = void 0, this.nationalNumberTemplate = void 0, this.populatedNationalNumberTemplate = void 0, this.populatedNationalNumberTemplatePosition = -1;
    }
  }, {
    key: "reset",
    value: function(e, r) {
      this.resetFormat(), e ? (this.isNANP = e.callingCode() === "1", this.matchingFormats = e.formats(), r.nationalSignificantNumber && this.narrowDownMatchingFormats(r)) : (this.isNANP = void 0, this.matchingFormats = []);
    }
    /**
     * Formats an updated phone number.
     * @param  {string} nextDigits — Additional phone number digits.
     * @param  {object} state — `AsYouType` state.
     * @return {[string]} Returns undefined if the updated phone number can't be formatted using any of the available formats.
     */
  }, {
    key: "format",
    value: function(e, r) {
      var d = this;
      if (Zd(r.nationalSignificantNumber, this.metadata))
        for (var i = Ce(this.matchingFormats), a; !(a = i()).done; ) {
          var o = a.value, u = Vd(r, o, {
            metadata: this.metadata,
            shouldTryNationalPrefixFormattingRule: function(l) {
              return d.shouldTryNationalPrefixFormattingRule(l, {
                international: r.international,
                nationalPrefix: r.nationalPrefix
              });
            },
            getSeparatorAfterNationalPrefix: function(l) {
              return d.getSeparatorAfterNationalPrefix(l);
            }
          });
          if (u)
            return this.resetFormat(), this.chosenFormat = o, this.setNationalNumberTemplate(u.replace(/\d/g, A), r), this.populatedNationalNumberTemplate = u, this.populatedNationalNumberTemplatePosition = this.template.lastIndexOf(A), u;
        }
      return this.formatNationalNumberWithNextDigits(e, r);
    }
    // Formats the next phone number digits.
  }, {
    key: "formatNationalNumberWithNextDigits",
    value: function(e, r) {
      var d = this.chosenFormat, i = this.chooseFormat(r);
      if (i)
        return i === d ? this.formatNextNationalNumberDigits(e) : this.formatNextNationalNumberDigits(r.getNationalDigits());
    }
  }, {
    key: "narrowDownMatchingFormats",
    value: function(e) {
      var r = this, d = e.nationalSignificantNumber, i = e.nationalPrefix, a = e.international, o = d, u = o.length - Ie;
      u < 0 && (u = 0), this.matchingFormats = this.matchingFormats.filter(function($) {
        return r.formatSuits($, a, i) && r.formatMatches($, o, u);
      }), this.chosenFormat && this.matchingFormats.indexOf(this.chosenFormat) === -1 && this.resetFormat();
    }
  }, {
    key: "formatSuits",
    value: function(e, r, d) {
      return !(d && !e.usesNationalPrefix() && // !format.domesticCarrierCodeFormattingRule() &&
      !e.nationalPrefixIsOptionalWhenFormattingInNationalFormat() || !r && !d && e.nationalPrefixIsMandatoryWhenFormattingInNationalFormat());
    }
  }, {
    key: "formatMatches",
    value: function(e, r, d) {
      var i = e.leadingDigitsPatterns().length;
      if (i === 0)
        return !0;
      d = Math.min(d, i - 1);
      var a = e.leadingDigitsPatterns()[d];
      if (r.length < Ie)
        try {
          return new di(a).match(r, {
            allowOverflow: !0
          }) !== void 0;
        } catch (o) {
          return console.error(o), !0;
        }
      return new RegExp("^(".concat(a, ")")).test(r);
    }
  }, {
    key: "getFormatFormat",
    value: function(e, r) {
      return r ? e.internationalFormat() : e.format();
    }
  }, {
    key: "chooseFormat",
    value: function(e) {
      for (var r = this, d = function() {
        var $ = a.value;
        return r.chosenFormat === $ ? "break" : ci.test(r.getFormatFormat($, e.international)) ? r.createTemplateForFormat($, e) ? (r.chosenFormat = $, "break") : (r.matchingFormats = r.matchingFormats.filter(function(l) {
          return l !== $;
        }), "continue") : "continue";
      }, i = Ce(this.matchingFormats.slice()), a; !(a = i()).done; ) {
        var o = d();
        if (o === "break")
          break;
      }
      return this.chosenFormat || this.resetFormat(), this.chosenFormat;
    }
  }, {
    key: "createTemplateForFormat",
    value: function(e, r) {
      if (!(e.pattern().indexOf("|") >= 0)) {
        var d = this.getTemplateForFormat(e, r);
        if (d)
          return this.setNationalNumberTemplate(d, r), !0;
      }
    }
  }, {
    key: "getSeparatorAfterNationalPrefix",
    value: function(e) {
      return this.isNANP || e && e.nationalPrefixFormattingRule() && li.test(e.nationalPrefixFormattingRule()) ? " " : "";
    }
  }, {
    key: "getInternationalPrefixBeforeCountryCallingCode",
    value: function(e, r) {
      var d = e.IDDPrefix, i = e.missingPlus;
      return d ? r && r.spacing === !1 ? d : d + " " : i ? "" : "+";
    }
  }, {
    key: "getTemplate",
    value: function(e) {
      if (this.template) {
        for (var r = -1, d = 0, i = e.international ? this.getInternationalPrefixBeforeCountryCallingCode(e, {
          spacing: !1
        }) : ""; d < i.length + e.getDigitsWithoutInternationalPrefix().length; )
          r = this.template.indexOf(A, r + 1), d++;
        return me(this.template, r + 1);
      }
    }
  }, {
    key: "setNationalNumberTemplate",
    value: function(e, r) {
      this.nationalNumberTemplate = e, this.populatedNationalNumberTemplate = e, this.populatedNationalNumberTemplatePosition = -1, r.international ? this.template = this.getInternationalPrefixBeforeCountryCallingCode(r).replace(/[\d\+]/g, A) + Q(A, r.callingCode.length) + " " + e : this.template = e;
    }
    /**
     * Generates formatting template for a national phone number,
     * optionally containing a national prefix, for a format.
     * @param  {Format} format
     * @param  {string} nationalPrefix
     * @return {string}
     */
  }, {
    key: "getTemplateForFormat",
    value: function(e, r) {
      var d = r.nationalSignificantNumber, i = r.international, a = r.nationalPrefix, o = r.complexPrefixBeforeNationalSignificantNumber, u = e.pattern();
      u = u.replace(fi(), "\\d").replace(si(), "\\d");
      var $ = $i.match(u)[0];
      if (!(d.length > $.length)) {
        var l = new RegExp("^" + u + "$"), c = d.replace(/\d/g, St);
        l.test(c) && ($ = c);
        var s = this.getFormatFormat(e, i), h;
        if (this.shouldTryNationalPrefixFormattingRule(e, {
          international: i,
          nationalPrefix: a
        })) {
          var g = s.replace(We, e.nationalPrefixFormattingRule());
          if (q(e.nationalPrefixFormattingRule()) === (a || "") + q("$1") && (s = g, h = !0, a))
            for (var C = a.length; C > 0; )
              s = s.replace(/\d/, A), C--;
        }
        var v = $.replace(new RegExp(u), s).replace(new RegExp(St, "g"), A);
        return h || (o ? v = Q(A, o.length) + " " + v : a && (v = Q(A, a.length) + this.getSeparatorAfterNationalPrefix(e) + v)), i && (v = Ue(v)), v;
      }
    }
  }, {
    key: "formatNextNationalNumberDigits",
    value: function(e) {
      var r = Hd(this.populatedNationalNumberTemplate, this.populatedNationalNumberTemplatePosition, e);
      if (!r) {
        this.resetFormat();
        return;
      }
      return this.populatedNationalNumberTemplate = r[0], this.populatedNationalNumberTemplatePosition = r[1], me(this.populatedNationalNumberTemplate, this.populatedNationalNumberTemplatePosition + 1);
    }
  }, {
    key: "shouldTryNationalPrefixFormattingRule",
    value: function(e, r) {
      var d = r.international, i = r.nationalPrefix;
      if (e.nationalPrefixFormattingRule()) {
        var a = e.usesNationalPrefix();
        if (a && i || !a && !d)
          return !0;
      }
    }
  }]), t;
}();
function Je(t, n) {
  return pi(t) || yi(t, n) || mi(t, n) || gi();
}
function gi() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function mi(t, n) {
  if (t) {
    if (typeof t == "string")
      return xe(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return xe(t, n);
  }
}
function xe(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function yi(t, n) {
  var e = t == null ? null : typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e != null) {
    var r = [], d = !0, i = !1, a, o;
    try {
      for (e = e.call(t); !(d = (a = e.next()).done) && (r.push(a.value), !(n && r.length === n)); d = !0)
        ;
    } catch (u) {
      i = !0, o = u;
    } finally {
      try {
        !d && e.return != null && e.return();
      } finally {
        if (i)
          throw o;
      }
    }
    return r;
  }
}
function pi(t) {
  if (Array.isArray(t))
    return t;
}
function vi(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function Oe(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function Ni(t, n, e) {
  return n && Oe(t.prototype, n), e && Oe(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var bi = "[" + I + b + "]+", Ci = new RegExp("^" + bi + "$", "i"), Pi = "(?:[" + et + "][" + I + b + "]*|[" + I + b + "]+)", Ai = new RegExp("[^" + I + b + "]+.*$"), Ii = /[^\d\[\]]/, xi = /* @__PURE__ */ function() {
  function t(n) {
    var e = n.defaultCountry, r = n.defaultCallingCode, d = n.metadata, i = n.onNationalSignificantNumberChange;
    vi(this, t), this.defaultCountry = e, this.defaultCallingCode = r, this.metadata = d, this.onNationalSignificantNumberChange = i;
  }
  return Ni(t, [{
    key: "input",
    value: function(e, r) {
      var d = Ei(e), i = Je(d, 2), a = i[0], o = i[1], u = q(a), $;
      return o && (r.digits || (r.startInternationalNumber(), u || ($ = !0))), u && this.inputDigits(u, r), {
        digits: u,
        justLeadingPlus: $
      };
    }
    /**
     * Inputs "next" phone number digits.
     * @param  {string} digits
     * @return {string} [formattedNumber] Formatted national phone number (if it can be formatted at this stage). Returning `undefined` means "don't format the national phone number at this stage".
     */
  }, {
    key: "inputDigits",
    value: function(e, r) {
      var d = r.digits, i = d.length < 3 && d.length + e.length >= 3;
      if (r.appendDigits(e), i && this.extractIddPrefix(r), this.isWaitingForCountryCallingCode(r)) {
        if (!this.extractCountryCallingCode(r))
          return;
      } else
        r.appendNationalSignificantNumberDigits(e);
      r.international || this.hasExtractedNationalSignificantNumber || this.extractNationalSignificantNumber(r.getNationalDigits(), function(a) {
        return r.update(a);
      });
    }
  }, {
    key: "isWaitingForCountryCallingCode",
    value: function(e) {
      var r = e.international, d = e.callingCode;
      return r && !d;
    }
    // Extracts a country calling code from a number
    // being entered in internatonal format.
  }, {
    key: "extractCountryCallingCode",
    value: function(e) {
      var r = Ye("+" + e.getDigitsWithoutInternationalPrefix(), this.defaultCountry, this.defaultCallingCode, this.metadata.metadata), d = r.countryCallingCode, i = r.number;
      if (d)
        return e.setCallingCode(d), e.update({
          nationalSignificantNumber: i
        }), !0;
    }
  }, {
    key: "reset",
    value: function(e) {
      if (e) {
        this.hasSelectedNumberingPlan = !0;
        var r = e._nationalPrefixForParsing();
        this.couldPossiblyExtractAnotherNationalSignificantNumber = r && Ii.test(r);
      } else
        this.hasSelectedNumberingPlan = void 0, this.couldPossiblyExtractAnotherNationalSignificantNumber = void 0;
    }
    /**
     * Extracts a national (significant) number from user input.
     * Google's library is different in that it only applies `national_prefix_for_parsing`
     * and doesn't apply `national_prefix_transform_rule` after that.
     * https://github.com/google/libphonenumber/blob/a3d70b0487875475e6ad659af404943211d26456/java/libphonenumber/src/com/google/i18n/phonenumbers/AsYouTypeFormatter.java#L539
     * @return {boolean} [extracted]
     */
  }, {
    key: "extractNationalSignificantNumber",
    value: function(e, r) {
      if (this.hasSelectedNumberingPlan) {
        var d = Ct(e, this.metadata), i = d.nationalPrefix, a = d.nationalNumber, o = d.carrierCode;
        if (a !== e)
          return this.onExtractedNationalNumber(i, o, a, e, r), !0;
      }
    }
    /**
     * In Google's code this function is called "attempt to extract longer NDD".
     * "Some national prefixes are a substring of others", they say.
     * @return {boolean} [result] — Returns `true` if extracting a national prefix produced different results from what they were.
     */
  }, {
    key: "extractAnotherNationalSignificantNumber",
    value: function(e, r, d) {
      if (!this.hasExtractedNationalSignificantNumber)
        return this.extractNationalSignificantNumber(e, d);
      if (this.couldPossiblyExtractAnotherNationalSignificantNumber) {
        var i = Ct(e, this.metadata), a = i.nationalPrefix, o = i.nationalNumber, u = i.carrierCode;
        if (o !== r)
          return this.onExtractedNationalNumber(a, u, o, e, d), !0;
      }
    }
  }, {
    key: "onExtractedNationalNumber",
    value: function(e, r, d, i, a) {
      var o, u, $ = i.lastIndexOf(d);
      if ($ >= 0 && $ === i.length - d.length) {
        u = !0;
        var l = i.slice(0, $);
        l !== e && (o = l);
      }
      a({
        nationalPrefix: e,
        carrierCode: r,
        nationalSignificantNumber: d,
        nationalSignificantNumberMatchesInput: u,
        complexPrefixBeforeNationalSignificantNumber: o
      }), this.hasExtractedNationalSignificantNumber = !0, this.onNationalSignificantNumberChange();
    }
  }, {
    key: "reExtractNationalSignificantNumber",
    value: function(e) {
      if (this.extractAnotherNationalSignificantNumber(e.getNationalDigits(), e.nationalSignificantNumber, function(r) {
        return e.update(r);
      }))
        return !0;
      if (this.extractIddPrefix(e))
        return this.extractCallingCodeAndNationalSignificantNumber(e), !0;
      if (this.fixMissingPlus(e))
        return this.extractCallingCodeAndNationalSignificantNumber(e), !0;
    }
  }, {
    key: "extractIddPrefix",
    value: function(e) {
      var r = e.international, d = e.IDDPrefix, i = e.digits;
      if (e.nationalSignificantNumber, !(r || d)) {
        var a = Ze(i, this.defaultCountry, this.defaultCallingCode, this.metadata.metadata);
        if (a !== void 0 && a !== i)
          return e.update({
            IDDPrefix: i.slice(0, i.length - a.length)
          }), this.startInternationalNumber(e, {
            country: void 0,
            callingCode: void 0
          }), !0;
      }
    }
  }, {
    key: "fixMissingPlus",
    value: function(e) {
      if (!e.international) {
        var r = ze(e.digits, this.defaultCountry, this.defaultCallingCode, this.metadata.metadata), d = r.countryCallingCode;
        if (r.number, d)
          return e.update({
            missingPlus: !0
          }), this.startInternationalNumber(e, {
            country: e.country,
            callingCode: d
          }), !0;
      }
    }
  }, {
    key: "startInternationalNumber",
    value: function(e, r) {
      var d = r.country, i = r.callingCode;
      e.startInternationalNumber(d, i), e.nationalSignificantNumber && (e.resetNationalSignificantNumber(), this.onNationalSignificantNumberChange(), this.hasExtractedNationalSignificantNumber = void 0);
    }
  }, {
    key: "extractCallingCodeAndNationalSignificantNumber",
    value: function(e) {
      this.extractCountryCallingCode(e) && this.extractNationalSignificantNumber(e.getNationalDigits(), function(r) {
        return e.update(r);
      });
    }
  }]), t;
}();
function Oi(t) {
  var n = t.search(Pi);
  if (!(n < 0)) {
    t = t.slice(n);
    var e;
    return t[0] === "+" && (e = !0, t = t.slice(1)), t = t.replace(Ai, ""), e && (t = "+" + t), t;
  }
}
function Si(t) {
  var n = Oi(t) || "";
  return n[0] === "+" ? [n.slice(1), !0] : [n];
}
function Ei(t) {
  var n = Si(t), e = Je(n, 2), r = e[0], d = e[1];
  return Ci.test(r) || (r = ""), [r, d];
}
function Ti(t, n) {
  return Mi(t) || Di(t, n) || wi(t, n) || Fi();
}
function Fi() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function wi(t, n) {
  if (t) {
    if (typeof t == "string")
      return Se(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Se(t, n);
  }
}
function Se(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Di(t, n) {
  var e = t == null ? null : typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e != null) {
    var r = [], d = !0, i = !1, a, o;
    try {
      for (e = e.call(t); !(d = (a = e.next()).done) && (r.push(a.value), !(n && r.length === n)); d = !0)
        ;
    } catch (u) {
      i = !0, o = u;
    } finally {
      try {
        !d && e.return != null && e.return();
      } finally {
        if (i)
          throw o;
      }
    }
    return r;
  }
}
function Mi(t) {
  if (Array.isArray(t))
    return t;
}
function Ri(t, n) {
  if (!(t instanceof n))
    throw new TypeError("Cannot call a class as a function");
}
function Ee(t, n) {
  for (var e = 0; e < n.length; e++) {
    var r = n[e];
    r.enumerable = r.enumerable || !1, r.configurable = !0, "value" in r && (r.writable = !0), Object.defineProperty(t, r.key, r);
  }
}
function _i(t, n, e) {
  return n && Ee(t.prototype, n), e && Ee(t, e), Object.defineProperty(t, "prototype", { writable: !1 }), t;
}
var qe = /* @__PURE__ */ function() {
  function t(n, e) {
    Ri(this, t), this.metadata = new N(e);
    var r = this.getCountryAndCallingCode(n), d = Ti(r, 2), i = d[0], a = d[1];
    this.defaultCountry = i, this.defaultCallingCode = a, this.reset();
  }
  return _i(t, [{
    key: "getCountryAndCallingCode",
    value: function(e) {
      var r, d;
      return e && (R(e) ? (r = e.defaultCountry, d = e.defaultCallingCode) : r = e), r && !this.metadata.hasCountry(r) && (r = void 0), [r, d];
    }
    /**
     * Inputs "next" phone number characters.
     * @param  {string} text
     * @return {string} Formatted phone number characters that have been input so far.
     */
  }, {
    key: "input",
    value: function(e) {
      var r = this.parser.input(e, this.state), d = r.digits, i = r.justLeadingPlus;
      if (i)
        this.formattedOutput = "+";
      else if (d) {
        this.determineTheCountryIfNeeded(), this.state.nationalSignificantNumber && this.formatter.narrowDownMatchingFormats(this.state);
        var a;
        if (this.metadata.hasSelectedNumberingPlan() && (a = this.formatter.format(d, this.state)), a === void 0 && this.parser.reExtractNationalSignificantNumber(this.state)) {
          this.determineTheCountryIfNeeded();
          var o = this.state.getNationalDigits();
          o && (a = this.formatter.format(o, this.state));
        }
        this.formattedOutput = a ? this.getFullNumber(a) : this.getNonFormattedNumber();
      }
      return this.formattedOutput;
    }
  }, {
    key: "reset",
    value: function() {
      var e = this;
      return this.state = new Bd({
        onCountryChange: function(d) {
          e.country = d;
        },
        onCallingCodeChange: function(d, i) {
          e.metadata.selectNumberingPlan(i, d), e.formatter.reset(e.metadata.numberingPlan, e.state), e.parser.reset(e.metadata.numberingPlan);
        }
      }), this.formatter = new hi({
        state: this.state,
        metadata: this.metadata
      }), this.parser = new xi({
        defaultCountry: this.defaultCountry,
        defaultCallingCode: this.defaultCallingCode,
        metadata: this.metadata,
        state: this.state,
        onNationalSignificantNumberChange: function() {
          e.determineTheCountryIfNeeded(), e.formatter.reset(e.metadata.numberingPlan, e.state);
        }
      }), this.state.reset({
        country: this.defaultCountry,
        callingCode: this.defaultCallingCode
      }), this.formattedOutput = "", this;
    }
    /**
     * Returns `true` if the phone number is being input in international format.
     * In other words, returns `true` if and only if the parsed phone number starts with a `"+"`.
     * @return {boolean}
     */
  }, {
    key: "isInternational",
    value: function() {
      return this.state.international;
    }
    /**
     * Returns the "calling code" part of the phone number when it's being input
     * in an international format.
     * If no valid calling code has been entered so far, returns `undefined`.
     * @return {string} [callingCode]
     */
  }, {
    key: "getCallingCode",
    value: function() {
      if (this.isInternational())
        return this.state.callingCode;
    }
    // A legacy alias.
  }, {
    key: "getCountryCallingCode",
    value: function() {
      return this.getCallingCode();
    }
    /**
     * Returns a two-letter country code of the phone number.
     * Returns `undefined` for "non-geographic" phone numbering plans.
     * Returns `undefined` if no phone number has been input yet.
     * @return {string} [country]
     */
  }, {
    key: "getCountry",
    value: function() {
      var e = this.state.digits;
      if (e)
        return this._getCountry();
    }
    /**
     * Returns a two-letter country code of the phone number.
     * Returns `undefined` for "non-geographic" phone numbering plans.
     * @return {string} [country]
     */
  }, {
    key: "_getCountry",
    value: function() {
      var e = this.state.country;
      return e;
    }
  }, {
    key: "determineTheCountryIfNeeded",
    value: function() {
      (!this.state.country || this.isCountryCallingCodeAmbiguous()) && this.determineTheCountry();
    }
    // Prepends `+CountryCode ` in case of an international phone number
  }, {
    key: "getFullNumber",
    value: function(e) {
      var r = this;
      if (this.isInternational()) {
        var d = function(o) {
          return r.formatter.getInternationalPrefixBeforeCountryCallingCode(r.state, {
            spacing: !!o
          }) + o;
        }, i = this.state.callingCode;
        return d(i ? e ? "".concat(i, " ").concat(e) : i : "".concat(this.state.getDigitsWithoutInternationalPrefix()));
      }
      return e;
    }
  }, {
    key: "getNonFormattedNationalNumberWithPrefix",
    value: function() {
      var e = this.state, r = e.nationalSignificantNumber, d = e.complexPrefixBeforeNationalSignificantNumber, i = e.nationalPrefix, a = r, o = d || i;
      return o && (a = o + a), a;
    }
  }, {
    key: "getNonFormattedNumber",
    value: function() {
      var e = this.state.nationalSignificantNumberMatchesInput;
      return this.getFullNumber(e ? this.getNonFormattedNationalNumberWithPrefix() : this.state.getNationalDigits());
    }
  }, {
    key: "getNonFormattedTemplate",
    value: function() {
      var e = this.getNonFormattedNumber();
      if (e)
        return e.replace(/[\+\d]/g, A);
    }
  }, {
    key: "isCountryCallingCodeAmbiguous",
    value: function() {
      var e = this.state.callingCode, r = this.metadata.getCountryCodesForCallingCode(e);
      return r && r.length > 1;
    }
    // Determines the country of the phone number
    // entered so far based on the country phone code
    // and the national phone number.
  }, {
    key: "determineTheCountry",
    value: function() {
      this.state.setCountry(Ke(this.isInternational() ? this.state.callingCode : this.defaultCallingCode, {
        nationalNumber: this.state.nationalSignificantNumber,
        defaultCountry: this.defaultCountry,
        metadata: this.metadata
      }));
    }
    /**
     * Returns a E.164 phone number value for the user's input.
     *
     * For example, for country `"US"` and input `"(222) 333-4444"`
     * it will return `"+12223334444"`.
     *
     * For international phone number input, it will also auto-correct
     * some minor errors such as using a national prefix when writing
     * an international phone number. For example, if the user inputs
     * `"+44 0 7400 000000"` then it will return an auto-corrected
     * `"+447400000000"` phone number value.
     *
     * Will return `undefined` if no digits have been input,
     * or when inputting a phone number in national format and no
     * default country or default "country calling code" have been set.
     *
     * @return {string} [value]
     */
  }, {
    key: "getNumberValue",
    value: function() {
      var e = this.state, r = e.digits, d = e.callingCode, i = e.country, a = e.nationalSignificantNumber;
      if (r) {
        if (this.isInternational())
          return d ? "+" + d + a : "+" + r;
        if (i || d) {
          var o = i ? this.metadata.countryCallingCode() : d;
          return "+" + o + a;
        }
      }
    }
    /**
     * Returns an instance of `PhoneNumber` class.
     * Will return `undefined` if no national (significant) number
     * digits have been entered so far, or if no `defaultCountry` has been
     * set and the user enters a phone number not in international format.
     */
  }, {
    key: "getNumber",
    value: function() {
      var e = this.state, r = e.nationalSignificantNumber, d = e.carrierCode, i = e.callingCode, a = this._getCountry();
      if (r && !(!a && !i)) {
        if (a && a === this.defaultCountry) {
          var o = new N(this.metadata.metadata);
          o.selectNumberingPlan(a);
          var u = o.numberingPlan.callingCode(), $ = this.metadata.getCountryCodesForCallingCode(u);
          if ($.length > 1) {
            var l = Xe(r, {
              countries: $,
              defaultCountry: this.defaultCountry,
              metadata: this.metadata.metadata
            });
            l && (a = l);
          }
        }
        var c = new Ve(a || i, r, this.metadata.metadata);
        return d && (c.carrierCode = d), c;
      }
    }
    /**
     * Returns `true` if the phone number is "possible".
     * Is just a shortcut for `PhoneNumber.isPossible()`.
     * @return {boolean}
     */
  }, {
    key: "isPossible",
    value: function() {
      var e = this.getNumber();
      return e ? e.isPossible() : !1;
    }
    /**
     * Returns `true` if the phone number is "valid".
     * Is just a shortcut for `PhoneNumber.isValid()`.
     * @return {boolean}
     */
  }, {
    key: "isValid",
    value: function() {
      var e = this.getNumber();
      return e ? e.isValid() : !1;
    }
    /**
     * @deprecated
     * This method is used in `react-phone-number-input/source/input-control.js`
     * in versions before `3.0.16`.
     */
  }, {
    key: "getNationalNumber",
    value: function() {
      return this.state.nationalSignificantNumber;
    }
    /**
     * Returns the phone number characters entered by the user.
     * @return {string}
     */
  }, {
    key: "getChars",
    value: function() {
      return (this.state.international ? "+" : "") + this.state.digits;
    }
    /**
     * Returns the template for the formatted phone number.
     * @return {string}
     */
  }, {
    key: "getTemplate",
    value: function() {
      return this.formatter.getTemplate(this.state) || this.getNonFormattedTemplate() || "";
    }
  }]), t;
}();
function d1() {
  return Me(Ld, arguments);
}
function j(t) {
  return qe.call(this, t, Tt);
}
j.prototype = Object.create(qe.prototype, {});
j.prototype.constructor = j;
function Li(t, n) {
  return ji(t) || Bi(t, n) || Gi(t, n) || ki();
}
function ki() {
  throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`);
}
function Gi(t, n) {
  if (t) {
    if (typeof t == "string")
      return Te(t, n);
    var e = Object.prototype.toString.call(t).slice(8, -1);
    if (e === "Object" && t.constructor && (e = t.constructor.name), e === "Map" || e === "Set")
      return Array.from(t);
    if (e === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e))
      return Te(t, n);
  }
}
function Te(t, n) {
  (n == null || n > t.length) && (n = t.length);
  for (var e = 0, r = new Array(n); e < n; e++)
    r[e] = t[e];
  return r;
}
function Bi(t, n) {
  var e = t == null ? null : typeof Symbol < "u" && t[Symbol.iterator] || t["@@iterator"];
  if (e != null) {
    var r = [], d = !0, i = !1, a, o;
    try {
      for (e = e.call(t); !(d = (a = e.next()).done) && (r.push(a.value), !(n && r.length === n)); d = !0)
        ;
    } catch (u) {
      i = !0, o = u;
    } finally {
      try {
        !d && e.return != null && e.return();
      } finally {
        if (i)
          throw o;
      }
    }
    return r;
  }
}
function ji(t) {
  if (Array.isArray(t))
    return t;
}
function Ui() {
  var t = Wi(arguments), n = t.input, e = t.options, r = t.metadata;
  if (n.phone)
    return it(n, e, r);
}
function Wi(t) {
  var n = Array.prototype.slice.call(t), e = Li(n, 4), r = e[0], d = e[1], i = e[2], a = e[3], o, u = {}, $;
  if (typeof r == "string")
    R(d) ? (i ? (u = d, $ = i) : $ = d, bt(r) ? o = xt(r, void 0, $) : o = {}) : (a ? (u = i, $ = a) : $ = i, bt(r) ? o = xt(r, {
      defaultCountry: d
    }, $) : o = {});
  else if (R(r))
    o = r, i ? (u = d, $ = i) : $ = d;
  else
    throw new TypeError("A phone number must either be a string or an object of shape { phone, [country] }.");
  return {
    input: o,
    options: u,
    metadata: $
  };
}
function i1() {
  return Me(Ui, arguments);
}
function gt(t) {
  const { defaultCountry: n, initialValue: e, disableFormatting: r, forceCallingCode: d } = t, i = n ? `+${B[n]?.[0]}` : "", a = new j(n);
  let o = a.input(e);
  d && o === "+" && n && (o = `+${B[n]?.[0]}`);
  const u = a.getNumberValue();
  return r && u && (o = u), {
    inputValue: o || i,
    isoCode: a.getCountry() || n || null
  };
}
function Hi(t, n) {
  const { excludedCountries: e, onlyCountries: r, continents: d } = n;
  return !(E(e, !0) && e.includes(t) || E(r) && !r.includes(t) || E(d) && !Fn(d, t));
}
function Vi({
  value: t,
  onChange: n,
  defaultCountry: e,
  onlyCountries: r,
  excludedCountries: d,
  continents: i,
  disableFormatting: a,
  forceCallingCode: o
}) {
  const u = y.useRef(
    e || null
  ), $ = y.useRef(new j(e)), l = y.useRef(null), [c, s] = y.useState(e), [h, g] = y.useState(() => gt({
    initialValue: t,
    defaultCountry: e,
    disableFormatting: a,
    forceCallingCode: o
  })), [C, v] = y.useState(t), D = (f) => ({
    countryCallingCode: $.current.getCallingCode() || null,
    countryCode: $.current.getCountry() || null,
    nationalNumber: $.current.getNationalNumber(),
    numberType: $.current.getNumber()?.getType() ?? null,
    numberValue: $.current.getNumberValue() || null,
    reason: f
  }), U = (f) => f && Hi(f, {
    onlyCountries: r,
    excludedCountries: d,
    continents: i
  }), W = (f) => ($.current.reset(), $.current.input(f)), at = (f) => f.startsWith("+") || f === "" ? f : `+${f}`, ot = (f, x) => `+${J(x)}${f}`, ut = (f) => {
    const x = o ? ot(
      f.target.value,
      h.isoCode
    ) : at(f.target.value), M = W(x), F = $.current.getCountry(), w = o ? (
      // always the same country, can't change
      h.isoCode
    ) : F || u.current, P = $.current.getNumberValue() || "";
    u.current = w;
    const Y = D("input");
    if (P && (!w || !U(w)))
      n?.(P, {
        ...Y,
        // we show the input value but without any formatting, or country..
        countryCode: null,
        countryCallingCode: null,
        nationalNumber: null
      }), v(P), g({
        isoCode: null,
        inputValue: P
      });
    else {
      const O = a ? P : M;
      n?.(O, Y), v(O), g({
        isoCode: w,
        inputValue: O
      });
    }
  };
  y.useEffect(() => {
    if (t !== C) {
      v(t);
      const f = gt({
        initialValue: t,
        defaultCountry: e,
        forceCallingCode: o,
        disableFormatting: a
      });
      u.current = f.isoCode, g(f);
    }
  }, [
    t,
    C,
    e,
    o,
    a
  ]), y.useEffect(() => {
    if (e !== c) {
      s(e), $.current = new j(e);
      const { inputValue: f, isoCode: x } = gt({
        initialValue: "",
        defaultCountry: e,
        forceCallingCode: o,
        disableFormatting: a
      });
      v(f), $.current.input(f), u.current = $.current.getCountry() || null, n?.(f, D("country")), g({
        inputValue: f,
        isoCode: x
      });
    }
  }, [
    e,
    c,
    n,
    o,
    a
  ]);
  const z = (f) => {
    if (f === h.isoCode)
      return;
    const x = B[f]?.[0], { inputValue: M, isoCode: F } = h, w = F ? De(M, `+${J(F)}`) : M;
    let P = `+${x}${w}`;
    a || (P = W(P)), n?.(P, {
      ...D("country"),
      // Some country have the same calling code, so we choose what the user has selected
      countryCode: f
    }), u.current = f, v(P), g({
      isoCode: f,
      inputValue: P
    });
  };
  return {
    inputValue: h.inputValue,
    isoCode: h.isoCode,
    onInputChange: ut,
    onCountryChange: z,
    inputRef: l
  };
}
const a1 = y.forwardRef(
  (t, n) => {
    const {
      forceCallingCode: e = !1,
      onlyCountries: r,
      excludedCountries: d,
      defaultCountry: i,
      onDoubleClick: a,
      onFocus: o,
      onCopy: u,
      value: $ = "",
      inputProps: l,
      InputProps: c,
      inputRef: s,
      disabled: h,
      onChange: g,
      disableDropdown: C,
      disableFormatting: v = !1,
      focusOnSelectCountry: D,
      langOfCountryName: U,
      continents: W,
      preferredCountries: at,
      MenuProps: ot,
      className: ut,
      flagSize: z = "small",
      ...f
    } = t, x = y.useRef(null), [M, F] = y.useState(null), w = e ? xn(i) : i;
    Hn(t);
    const { onInputChange: P, onCountryChange: Y, inputRef: O, isoCode: X, inputValue: Dt } = Vi({
      forceCallingCode: e,
      defaultCountry: w,
      value: $ ?? "",
      onChange: g,
      excludedCountries: d,
      onlyCountries: r,
      disableFormatting: v,
      continents: W
    }), tn = (m) => {
      m.preventDefault(), (!h || !C) && F(x.current);
    }, en = (m) => {
      F(null), Y(m), D && O.current && O.current.focus();
    }, nn = (m) => {
      setTimeout(() => {
        O.current && Wn(O.current);
      }, 0), o?.(m);
    }, rn = (m) => {
      const H = O.current;
      H.setSelectionRange(0, H.value.length), a?.(m);
    }, dn = (m) => {
      if (u) {
        u(m);
        return;
      }
      const H = window.getSelection();
      if (H) {
        const fn = H.toString().replaceAll(" ", "");
        m.clipboardData.setData("text/plain", fn), m.preventDefault();
      }
    }, an = (m) => {
      O.current = m, c?.inputRef && lt(m, c.inputRef), s && lt(m, s);
    }, on = (m) => {
      x.current = m, n && lt(m, n);
    }, un = () => {
      F(null);
    }, $n = X ? `+${J(X)}` : "", ln = e ? (
      // We removed the isoCode but no necessarily the space after
      De(Dt, $n).trimStart()
    ) : Dt;
    return /* @__PURE__ */ _(Fe, { children: [
      /* @__PURE__ */ p(
        pn,
        {
          type: "tel",
          disabled: h,
          value: ln,
          ref: on,
          onDoubleClick: rn,
          inputRef: an,
          className: `MuiTelInput-TextField ${ut || ""}`,
          onChange: P,
          inputProps: {
            onCopy: dn,
            ...l
          },
          onFocus: nn,
          InputProps: {
            startAdornment: /* @__PURE__ */ p(yn, { position: "start", sx: { flexShrink: 0 }, children: /* @__PURE__ */ p(
              Mn,
              {
                isFlagsMenuOpened: !!M,
                isoCode: X,
                forceCallingCode: e,
                onClick: tn,
                disabled: h,
                flagSize: z,
                disableDropdown: !!C
              }
            ) }),
            ...c
          },
          ...f
        }
      ),
      C ? null : /* @__PURE__ */ p(
        Un,
        {
          onlyCountries: r,
          excludedCountries: d,
          continents: W,
          anchorEl: M,
          isoCode: X,
          preferredCountries: at,
          onClose: un,
          langOfCountryName: U,
          onSelectCountry: en,
          flagSize: z,
          ...ot
        }
      )
    ] });
  }
);
export {
  j as AsYouType,
  a1 as MuiTelInput,
  i1 as getNumberType,
  d1 as matchIsValidTel
};
