import defaultMoment from "moment";
import { IUtils, DateIOFormats, Unit } from "@date-io/core/IUtils";
interface Opts {
    locale?: string;
    instance?: typeof defaultMoment;
    formats?: Partial<DateIOFormats>;
}
declare type Moment = defaultMoment.Moment;
export default class MomentUtils implements IUtils<defaultMoment.Moment> {
    moment: typeof defaultMoment;
    lib: string;
    locale?: string;
    formats: DateIOFormats;
    constructor({ locale, formats, instance }?: Opts);
    is12HourCycleInCurrentLocale: () => boolean;
    getFormatHelperText: (format: string) => string;
    getCurrentLocaleCode: () => string;
    parseISO: (isoString: string) => defaultMoment.Moment;
    toISO: (value: Moment) => string;
    parse: (value: string, format: string) => defaultMoment.Moment;
    date: (value?: any) => defaultMoment.Moment;
    toJsDate: (value: Moment) => Date;
    isValid: (value: any) => boolean;
    isNull: (date: Moment) => boolean;
    getDiff: (date: Moment, comparing: Moment | string, unit?: Unit) => number;
    isAfter: (date: Moment, value: Moment) => boolean;
    isBefore: (date: Moment, value: Moment) => boolean;
    isAfterDay: (date: Moment, value: Moment) => boolean;
    isBeforeDay: (date: Moment, value: Moment) => boolean;
    isBeforeYear: (date: Moment, value: Moment) => boolean;
    isAfterYear: (date: Moment, value: Moment) => boolean;
    startOfDay: (date: Moment) => defaultMoment.Moment;
    endOfDay: (date: Moment) => defaultMoment.Moment;
    format: (date: Moment, formatKey: keyof DateIOFormats) => string;
    formatByString: (date: Moment, formatString: string) => string;
    formatNumber: (numberToFormat: string) => string;
    getHours: (date: Moment) => number;
    addSeconds: (date: Moment, count: number) => defaultMoment.Moment;
    addMinutes: (date: Moment, count: number) => defaultMoment.Moment;
    addHours: (date: Moment, count: number) => defaultMoment.Moment;
    addDays: (date: Moment, count: number) => defaultMoment.Moment;
    addWeeks: (date: Moment, count: number) => defaultMoment.Moment;
    addMonths: (date: Moment, count: number) => defaultMoment.Moment;
    setHours: (date: Moment, count: number) => defaultMoment.Moment;
    getMinutes: (date: Moment) => number;
    setMinutes: (date: Moment, count: number) => defaultMoment.Moment;
    getSeconds: (date: Moment) => number;
    setSeconds: (date: Moment, count: number) => defaultMoment.Moment;
    getMonth: (date: Moment) => number;
    getDaysInMonth: (date: Moment) => number;
    isSameDay: (date: Moment, comparing: Moment) => boolean;
    isSameMonth: (date: Moment, comparing: Moment) => boolean;
    isSameYear: (date: Moment, comparing: Moment) => boolean;
    isSameHour: (date: Moment, comparing: Moment) => boolean;
    setMonth: (date: Moment, count: number) => defaultMoment.Moment;
    getMeridiemText: (ampm: "am" | "pm") => string;
    startOfYear: (date: Moment) => defaultMoment.Moment;
    endOfYear: (date: Moment) => defaultMoment.Moment;
    startOfMonth: (date: Moment) => defaultMoment.Moment;
    endOfMonth: (date: Moment) => defaultMoment.Moment;
    startOfWeek: (date: Moment) => defaultMoment.Moment;
    endOfWeek: (date: Moment) => defaultMoment.Moment;
    getNextMonth: (date: Moment) => defaultMoment.Moment;
    getPreviousMonth: (date: Moment) => defaultMoment.Moment;
    getMonthArray: (date: Moment) => defaultMoment.Moment[];
    getYear: (date: Moment) => number;
    setYear: (date: Moment, year: number) => defaultMoment.Moment;
    mergeDateAndTime: (date: Moment, time: Moment) => defaultMoment.Moment;
    getWeekdays: () => string[];
    isEqual: (value: any, comparing: any) => boolean;
    getWeekArray: (date: Moment) => defaultMoment.Moment[][];
    getYearRange: (start: Moment, end: Moment) => defaultMoment.Moment[];
    isWithinRange: (date: Moment, [start, end]: [Moment, Moment]) => boolean;
}
export {};
