import { TreeViewInstance } from '../../models';
import { UseTreeViewNodesSignature } from '../useTreeViewNodes';
/**
 * This is used to determine the start and end of a selection range so
 * we can get the nodes between the two border nodes.
 *
 * It finds the nodes' common ancestor using
 * a naive implementation of a lowest common ancestor algorithm
 * (https://en.wikipedia.org/wiki/Lowest_common_ancestor).
 * Then compares the ancestor's 2 children that are ancestors of nodeA and NodeB
 * so we can compare their indexes to work out which node comes first in a depth first search.
 * (https://en.wikipedia.org/wiki/Depth-first_search)
 *
 * Another way to put it is which node is shallower in a trémaux tree
 * https://en.wikipedia.org/wiki/Tr%C3%A9maux_tree
 */
export declare const findOrderInTremauxTree: (instance: TreeViewInstance<[UseTreeViewNodesSignature]>, nodeAId: string, nodeBId: string) => string[];
