"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/suspense.ts
var suspense_exports = {};
__export(suspense_exports, {
  defaultThrowOnError: () => defaultThrowOnError,
  ensureStaleTime: () => ensureStaleTime,
  fetchOptimistic: () => fetchOptimistic,
  shouldSuspend: () => shouldSuspend,
  willFetch: () => willFetch
});
module.exports = __toCommonJS(suspense_exports);
var defaultThrowOnError = (_error, query) => query.state.data === void 0;
var ensureStaleTime = (defaultedOptions) => {
  if (defaultedOptions.suspense) {
    if (typeof defaultedOptions.staleTime !== "number") {
      defaultedOptions.staleTime = 1e3;
    }
  }
};
var willFetch = (result, isRestoring) => result.isLoading && result.isFetching && !isRestoring;
var shouldSuspend = (defaultedOptions, result) => defaultedOptions?.suspense && result.isPending;
var fetchOptimistic = (defaultedOptions, observer, errorResetBoundary) => observer.fetchOptimistic(defaultedOptions).catch(() => {
  errorResetBoundary.clearReset();
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  defaultThrowOnError,
  ensureStaleTime,
  fetchOptimistic,
  shouldSuspend,
  willFetch
});
//# sourceMappingURL=suspense.cjs.map