/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010\u000fJ\u0011\u0010\"\u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lio/ktor/server/sessions/serialization/ListLikeDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "", "string", "<init>", "(Lkotlinx/serialization/modules/SerializersModule;Ljava/lang/String;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "", "decodeBoolean", "()Z", "", "decodeChar", "()C", "", "decodeDouble", "()D", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "decodeString", "()Ljava/lang/String;", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentIndex", "I", "", "items", "Ljava/util/List;", "ktor-server-sessions"})
public final class ListLikeDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @NotNull
    private final List<String> items;

    public ListLikeDecoder(@NotNull SerializersModule serializersModule, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.serializersModule = serializersModule;
        this.currentIndex = -1;
        String[] stringArray = new String[]{"&"};
        this.items = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ++this.currentIndex;
        if (this.currentIndex == this.items.size()) {
            return -1;
        }
        return this.currentIndex;
    }

    public boolean decodeBoolean() {
        return Intrinsics.areEqual((Object)this.items.get(this.currentIndex), (Object)"#bot");
    }

    public char decodeChar() {
        return this.items.get(this.currentIndex).charAt(3);
    }

    public double decodeDouble() {
        return Double.parseDouble(StringsKt.drop((String)this.items.get(this.currentIndex), (int)2));
    }

    public float decodeFloat() {
        return Float.parseFloat(StringsKt.drop((String)this.items.get(this.currentIndex), (int)2));
    }

    public int decodeInt() {
        return Integer.parseInt(StringsKt.drop((String)this.items.get(this.currentIndex), (int)2));
    }

    public long decodeLong() {
        return Long.parseLong(StringsKt.drop((String)this.items.get(this.currentIndex), (int)2));
    }

    @NotNull
    public String decodeString() {
        return StringsKt.drop((String)this.items.get(this.currentIndex), (int)2);
    }

    public boolean decodeNotNullMark() {
        return !Intrinsics.areEqual((Object)this.items.get(this.currentIndex), (Object)"#n");
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new IllegalStateException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

