/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeRegion;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquare;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquareInfo;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquareType;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J;\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00162\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\rH\u0002\u00a2\u0006\u0002\u0010\u001fJ+\u0010 \u001a\u00020\u00062\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010!J)\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r\u00a2\u0006\u0002\u0010$J;\u0010%\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r\u00a2\u0006\u0002\u0010$J+\u0010(\u001a\u00020\u00062\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010!J+\u0010)\u001a\u00020\u00062\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010!J9\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r\u00a2\u0006\u0002\u0010-J1\u0010.\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSetup;", "", "()V", "DEFAULT_PROBE_SIZE", "", "applyMaskPattern", "", "data", "", "maskPattern", "Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;", "moduleCount", "modules", "", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;", "([ILio/github/alexzhirkevich/qrose/qrcode/MaskPattern;I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "findSquareRegion", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeRegion;", "row", "col", "probeSize", "isInsideModules", "", "rowOffset", "colOffset", "modulesSize", "isLeftRightColSquare", "isMidSquare", "isTopBottomRowSquare", "set", "value", "(IIZ[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "setupBottomLeftPositionProbePattern", "([[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;I)V", "setupPositionAdjustPattern", "type", "(I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "setupPositionProbePattern", "(II[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;I)V", "setupTimingPattern", "setupTopLeftPositionProbePattern", "setupTopRightPositionProbePattern", "setupTypeInfo", "errorCorrectionLevel", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "(Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;I[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "setupTypeNumber", "(II[[Lio/github/alexzhirkevich/qrose/qrcode/internals/QRCodeSquare;)V", "qrose"})
@StabilityInferred(parameters=1)
public final class QRCodeSetup {
    @NotNull
    public static final QRCodeSetup INSTANCE = new QRCodeSetup();
    private static final int DEFAULT_PROBE_SIZE = 7;
    public static final int $stable;

    private QRCodeSetup() {
    }

    public final void setupTopLeftPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        this.setupPositionProbePattern(0, 0, modules, probeSize);
    }

    public static /* synthetic */ void setupTopLeftPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupTopLeftPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupTopRightPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        this.setupPositionProbePattern(((Object[])modules).length - probeSize, 0, modules, probeSize);
    }

    public static /* synthetic */ void setupTopRightPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupTopRightPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupBottomLeftPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        this.setupPositionProbePattern(0, ((Object[])modules).length - probeSize, modules, probeSize);
    }

    public static /* synthetic */ void setupBottomLeftPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupBottomLeftPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupPositionProbePattern(int rowOffset, int colOffset, @NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        int modulesSize = ((Object[])modules).length;
        int row = -1;
        if (row <= probeSize) {
            while (true) {
                int col2;
                if ((col2 = -1) <= probeSize) {
                    while (true) {
                        if (this.isInsideModules(row, rowOffset, col2, colOffset, modulesSize)) {
                            boolean isDark = this.isTopBottomRowSquare(row, col2, probeSize) || this.isLeftRightColSquare(row, col2, probeSize) || this.isMidSquare(row, col2, probeSize);
                            QRCodeRegion region = this.findSquareRegion(row, col2, probeSize);
                            int n = row + rowOffset;
                            int n2 = col2 + colOffset;
                            QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_PROBE, region);
                            modules[row + rowOffset][col2 + colOffset] = new QRCodeSquare(isDark, n, n2, modulesSize, qRCodeSquareInfo);
                        }
                        if (col2 == probeSize) break;
                        ++col2;
                    }
                }
                if (row == probeSize) break;
                ++row;
            }
        }
    }

    public static /* synthetic */ void setupPositionProbePattern$default(QRCodeSetup qRCodeSetup, int n, int n2, QRCodeSquare[][] qRCodeSquareArray, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 7;
        }
        qRCodeSetup.setupPositionProbePattern(n, n2, qRCodeSquareArray, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideModules(int row, int rowOffset, int col2, int colOffset, int modulesSize) {
        int n = row + rowOffset;
        if (0 > n) return false;
        if (n >= modulesSize) return false;
        boolean bl = true;
        if (!bl) return false;
        n = col2 + colOffset;
        if (0 > n) return false;
        if (n >= modulesSize) return false;
        return true;
    }

    private final boolean isTopBottomRowSquare(int row, int col2, int probeSize) {
        return (0 <= col2 ? col2 < probeSize : false) && (row == 0 || row == probeSize - 1);
    }

    private final boolean isLeftRightColSquare(int row, int col2, int probeSize) {
        return (0 <= row ? row < probeSize : false) && (col2 == 0 || col2 == probeSize - 1);
    }

    private final boolean isMidSquare(int row, int col2, int probeSize) {
        return (2 <= row ? row < probeSize - 2 : false) && 2 <= col2 && col2 <= probeSize - 3;
    }

    private final QRCodeRegion findSquareRegion(int row, int col2, int probeSize) {
        int n;
        int n2;
        int n3;
        int n4 = row;
        QRCodeRegion qRCodeRegion = n4 == 0 ? ((n3 = col2) == 0 ? QRCodeRegion.TOP_LEFT_CORNER : (n3 == probeSize - 1 ? QRCodeRegion.TOP_RIGHT_CORNER : (n3 == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.TOP_MID))) : (n4 == probeSize - 1 ? ((n2 = col2) == 0 ? QRCodeRegion.BOTTOM_LEFT_CORNER : (n2 == probeSize - 1 ? QRCodeRegion.BOTTOM_RIGHT_CORNER : (n2 == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.BOTTOM_MID))) : (n4 == probeSize ? QRCodeRegion.MARGIN : ((n = col2) == 0 ? QRCodeRegion.LEFT_MID : (n == probeSize - 1 ? QRCodeRegion.RIGHT_MID : (n == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.CENTER)))));
        return qRCodeRegion;
    }

    public final void setupPositionAdjustPattern(int type2, @NotNull QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        int[] pos = QRUtil.INSTANCE.getPatternPosition(type2);
        int n = pos.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = pos.length;
            for (int j = 0; j < n2; ++j) {
                int row = pos[i2];
                int col2 = pos[j];
                if (modules[row][col2] != null) continue;
                for (int r = -2; r < 3; ++r) {
                    for (int c = -2; c < 3; ++c) {
                        boolean bl = r == -2 || r == 2 || c == -2 || c == 2 || r == 0 && c == 0;
                        int n3 = row + r;
                        int n4 = col2 + c;
                        QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_ADJUST, QRCodeRegion.UNKNOWN);
                        int n5 = ((Object[])modules).length;
                        modules[row + r][col2 + c] = new QRCodeSquare(bl, n3, n4, n5, qRCodeSquareInfo);
                    }
                }
            }
        }
    }

    public final void setupTimingPattern(int moduleCount, @NotNull QRCodeSquare[][] modules) {
        int n;
        QRCodeSquareInfo qRCodeSquareInfo;
        boolean bl;
        Intrinsics.checkNotNullParameter(modules, "modules");
        int n2 = moduleCount - 8;
        for (int r = 8; r < n2; ++r) {
            if (modules[r][6] != null) continue;
            bl = r % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n = ((Object[])modules).length;
            modules[r][6] = new QRCodeSquare(bl, r, 6, n, qRCodeSquareInfo);
        }
        n2 = moduleCount - 8;
        for (int c = 8; c < n2; ++c) {
            if (modules[6][c] != null) continue;
            bl = c % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n = ((Object[])modules).length;
            modules[6][c] = new QRCodeSquare(bl, 6, c, n, qRCodeSquareInfo);
        }
    }

    public final void setupTypeInfo(@NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull MaskPattern maskPattern, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        boolean mod;
        int i2;
        Intrinsics.checkNotNullParameter((Object)errorCorrectionLevel, "errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)maskPattern, "maskPattern");
        Intrinsics.checkNotNullParameter(modules, "modules");
        int data2 = errorCorrectionLevel.getValue() << 3 | maskPattern.ordinal();
        int bits = QRUtil.INSTANCE.getBCHTypeInfo(data2);
        for (i2 = 0; i2 < 15; ++i2) {
            boolean bl = mod = (bits >> i2 & 1) == 1;
            if (i2 < 6) {
                this.set(i2, 8, mod, modules);
                continue;
            }
            if (i2 < 8) {
                this.set(i2 + 1, 8, mod, modules);
                continue;
            }
            this.set(moduleCount - 15 + i2, 8, mod, modules);
        }
        for (i2 = 0; i2 < 15; ++i2) {
            boolean bl = mod = (bits >> i2 & 1) == 1;
            if (i2 < 8) {
                this.set(8, moduleCount - i2 - 1, mod, modules);
                continue;
            }
            if (i2 < 9) {
                this.set(8, 15 - i2, mod, modules);
                continue;
            }
            this.set(8, 15 - i2 - 1, mod, modules);
        }
        this.set(moduleCount - 8, 8, true, modules);
    }

    public final void setupTypeNumber(int type2, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        boolean mod;
        int i2;
        Intrinsics.checkNotNullParameter(modules, "modules");
        int bits = QRUtil.INSTANCE.getBCHTypeNumber(type2);
        for (i2 = 0; i2 < 18; ++i2) {
            mod = (bits >> i2 & 1) == 1;
            this.set(i2 / 3, i2 % 3 + moduleCount - 8 - 3, mod, modules);
        }
        for (i2 = 0; i2 < 18; ++i2) {
            mod = (bits >> i2 & 1) == 1;
            this.set(i2 % 3 + moduleCount - 8 - 3, i2 / 3, mod, modules);
        }
    }

    public final void applyMaskPattern(@NotNull int[] data2, @NotNull MaskPattern maskPattern, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter((Object)maskPattern, "maskPattern");
        Intrinsics.checkNotNullParameter(modules, "modules");
        int inc = -1;
        int bitIndex = 7;
        int byteIndex = 0;
        int row = moduleCount - 1;
        for (int col2 = moduleCount - 1; col2 > 0; col2 -= 2) {
            if (col2 == 6) {
                --col2;
            }
            do {
                for (int c = 0; c < 2; ++c) {
                    boolean mask;
                    if (modules[row][col2 - c] != null) continue;
                    boolean dark = false;
                    if (byteIndex < data2.length) {
                        boolean bl = dark = (data2[byteIndex] >>> bitIndex & 1) == 1;
                    }
                    if (mask = QRUtil.INSTANCE.getMask(maskPattern, row, col2 - c)) {
                        dark = !dark;
                    }
                    this.set(row, col2 - c, dark, modules);
                    if (--bitIndex != -1) continue;
                    ++byteIndex;
                    bitIndex = 7;
                }
            } while ((row += inc) >= 0 && moduleCount > row);
            row -= inc;
            inc = -inc;
        }
    }

    private final void set(int row, int col2, boolean value, QRCodeSquare[][] modules) {
        QRCodeSquare qrCodeSquare = modules[row][col2];
        if (qrCodeSquare != null) {
            qrCodeSquare.setDark(value);
        } else {
            modules[row][col2] = new QRCodeSquare(value, row, col2, ((Object[])modules).length, null, 16, null);
        }
    }
}

