/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.credential.CoreCredentialRecord;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AssertionSignatureVerifier;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.AuthenticatorExtensionVerifier;
import com.webauthn4j.verifier.BeanAssertUtil;
import com.webauthn4j.verifier.ChallengeVerifier;
import com.webauthn4j.verifier.ClientExtensionVerifier;
import com.webauthn4j.verifier.CoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.CustomAuthenticationVerifier;
import com.webauthn4j.verifier.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.OriginVerifierImpl;
import com.webauthn4j.verifier.RpIdHashVerifier;
import com.webauthn4j.verifier.TokenBindingVerifier;
import com.webauthn4j.verifier.exception.BadBackupEligibleFlagException;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.CrossOriginException;
import com.webauthn4j.verifier.exception.IllegalBackupStateException;
import com.webauthn4j.verifier.exception.InconsistentClientDataTypeException;
import com.webauthn4j.verifier.exception.NotAllowedCredentialIdException;
import com.webauthn4j.verifier.exception.UserNotPresentException;
import com.webauthn4j.verifier.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationDataVerifier {
    private final ChallengeVerifier challengeVerifier = new ChallengeVerifier();
    private final TokenBindingVerifier tokenBindingVerifier = new TokenBindingVerifier();
    private final RpIdHashVerifier rpIdHashVerifier = new RpIdHashVerifier();
    private final AssertionSignatureVerifier assertionSignatureVerifier = new AssertionSignatureVerifier();
    private final ClientExtensionVerifier clientExtensionVerifier = new ClientExtensionVerifier();
    private final AuthenticatorExtensionVerifier authenticatorExtensionVerifier = new AuthenticatorExtensionVerifier();
    private final List<CustomAuthenticationVerifier> customAuthenticationVerifiers;
    private OriginVerifier originVerifier = new OriginVerifierImpl();
    private CoreMaliciousCounterValueHandler maliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();
    private boolean crossOriginAllowed = false;

    public AuthenticationDataVerifier(@NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers) {
        AssertUtil.notNull(customAuthenticationVerifiers, (String)"customAuthenticationVerifiers must not be null");
        this.customAuthenticationVerifiers = customAuthenticationVerifiers;
    }

    public AuthenticationDataVerifier() {
        this.customAuthenticationVerifiers = new ArrayList<CustomAuthenticationVerifier>();
    }

    public void verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull((Object)authenticationParameters, (String)"authenticationParameters must not be null");
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationData.getClientExtensions();
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        this.verifyCredentialId(credentialId, allowCredentials);
        byte[] cData = authenticationData.getCollectedClientDataBytes();
        byte[] aData = authenticationData.getAuthenticatorDataBytes();
        CollectedClientData collectedClientData = authenticationData.getCollectedClientData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        ServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(authenticatorData);
        this.verifyAuthenticatorData(authenticatorData);
        Authenticator authenticator = authenticationParameters.getAuthenticator();
        AuthenticationObject authenticationObject = new AuthenticationObject(credentialId, authenticatorData, aData, collectedClientData, cData, clientExtensions, serverProperty, authenticator);
        if (!Objects.equals(collectedClientData.getType(), ClientDataType.WEBAUTHN_GET)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'get' on authentication, but it isn't.");
        }
        this.challengeVerifier.verify(collectedClientData, serverProperty);
        this.originVerifier.verify(authenticationObject);
        this.verifyClientDataCrossOrigin(collectedClientData);
        this.tokenBindingVerifier.verify(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashVerifier.verify(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Verifier is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Verifier is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        this.verifyBEBSFlags(authenticatorData);
        AuthenticationDataVerifier.verifyBEFlag(authenticator, authenticatorData);
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.clientExtensionVerifier.verify(clientExtensions);
        this.authenticatorExtensionVerifier.verify(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureVerifier.verify(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if ((presentedSignCount > 0L || storedSignCount > 0L) && presentedSignCount <= storedSignCount) {
            this.maliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
        }
        AuthenticationDataVerifier.updateRecord(authenticator, authenticatorData);
        for (CustomAuthenticationVerifier customAuthenticationVerifier : this.customAuthenticationVerifiers) {
            customAuthenticationVerifier.verify(authenticationObject);
        }
    }

    static void verifyBEFlag(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        CoreCredentialRecord coreCredentialRecord;
        Boolean backEligibleRecordValue;
        if (authenticator instanceof CoreCredentialRecord && (backEligibleRecordValue = (coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator)).isBackupEligible()) != null) {
            if (backEligibleRecordValue.booleanValue()) {
                if (!authenticatorData.isFlagBE()) {
                    throw new BadBackupEligibleFlagException("Although credential record BE flag is set, current BE flag is not set");
                }
            } else if (authenticatorData.isFlagBE()) {
                throw new BadBackupEligibleFlagException("Although credential record BE flag is not set, current BE flag is set");
            }
        }
    }

    static void updateRecord(Authenticator authenticator, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        authenticator.setCounter(authenticatorData.getSignCount());
        if (authenticator instanceof CoreCredentialRecord) {
            CoreCredentialRecord coreCredentialRecord = (CoreCredentialRecord)((Object)authenticator);
            coreCredentialRecord.setBackedUp(authenticatorData.isFlagBS());
            Boolean uvInitializedRecord = coreCredentialRecord.isUvInitialized();
            if (Objects.isNull(uvInitializedRecord) || Boolean.FALSE.equals(uvInitializedRecord)) {
                coreCredentialRecord.setUvInitialized(authenticatorData.isFlagUV());
            }
        }
    }

    void verifyCredentialId(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item -> Arrays.equals(item, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }

    void verifyClientDataCrossOrigin(CollectedClientData collectedClientData) {
        if (!this.crossOriginAllowed && Objects.equals(true, collectedClientData.getCrossOrigin())) {
            throw new CrossOriginException("Cross-origin request is prohibited. Relax AuthenticationDataVerifier config if necessary.");
        }
    }

    void verifyAuthenticatorData(@NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    void verifyBEBSFlags(AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (!authenticatorData.isFlagBE() && authenticatorData.isFlagBS()) {
            throw new IllegalBackupStateException("Backup state bit must not be set if backup eligibility bit is not set");
        }
    }

    @NotNull
    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.maliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NotNull CoreMaliciousCounterValueHandler maliciousCounterValueHandler) {
        AssertUtil.notNull((Object)maliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.maliciousCounterValueHandler = maliciousCounterValueHandler;
    }

    public OriginVerifier getOriginVerifier() {
        return this.originVerifier;
    }

    public void setOriginVerifier(OriginVerifier originVerifier) {
        this.originVerifier = originVerifier;
    }

    @NotNull
    public List<CustomAuthenticationVerifier> getCustomAuthenticationVerifiers() {
        return this.customAuthenticationVerifiers;
    }

    public boolean isCrossOriginAllowed() {
        return this.crossOriginAllowed;
    }

    public void setCrossOriginAllowed(boolean crossOriginAllowed) {
        this.crossOriginAllowed = crossOriginAllowed;
    }
}

