package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.entities.PersonPasswordEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonPasswordEntityDao_Impl(
  __db: RoomDatabase,
) : PersonPasswordEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonPasswordEntity: EntityInsertAdapter<PersonPasswordEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonPasswordEntity = object : EntityInsertAdapter<PersonPasswordEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PersonPasswordEntity` (`ppwGuidNum`,`ppwGuid`,`authAlgorithm`,`authEncoded`,`authSalt`,`authIterations`,`authKeyLen`,`ppwLastModified`,`ppwStored`) VALUES (?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonPasswordEntity) {
        statement.bindLong(1, entity.ppwGuidNum)
        statement.bindText(2, entity.ppwGuid)
        statement.bindText(3, entity.authAlgorithm)
        statement.bindText(4, entity.authEncoded)
        statement.bindText(5, entity.authSalt)
        statement.bindLong(6, entity.authIterations.toLong())
        statement.bindLong(7, entity.authKeyLen.toLong())
        val _tmp: Long? = __sharedConverters.fromInstant(entity.ppwLastModified)
        if (_tmp == null) {
          statement.bindNull(8)
        } else {
          statement.bindLong(8, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.ppwStored)
        if (_tmp_1 == null) {
          statement.bindNull(9)
        } else {
          statement.bindLong(9, _tmp_1)
        }
      }
    }
  }

  public override suspend fun upsert(personPasswordEntity: PersonPasswordEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonPasswordEntity.insert(_connection, personPasswordEntity)
  }

  public override suspend fun upsertAsyncList(list: List<PersonPasswordEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonPasswordEntity.insert(_connection, list)
  }

  public override suspend fun findByUid(uidNum: Long): PersonPasswordEntity? {
    val _sql: String = """
        |
        |           SELECT PersonPasswordEntity.* 
        |             FROM PersonPasswordEntity
        |            WHERE ppwGuidNum = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _columnIndexOfPpwGuidNum: Int = getColumnIndexOrThrow(_stmt, "ppwGuidNum")
        val _columnIndexOfPpwGuid: Int = getColumnIndexOrThrow(_stmt, "ppwGuid")
        val _columnIndexOfAuthAlgorithm: Int = getColumnIndexOrThrow(_stmt, "authAlgorithm")
        val _columnIndexOfAuthEncoded: Int = getColumnIndexOrThrow(_stmt, "authEncoded")
        val _columnIndexOfAuthSalt: Int = getColumnIndexOrThrow(_stmt, "authSalt")
        val _columnIndexOfAuthIterations: Int = getColumnIndexOrThrow(_stmt, "authIterations")
        val _columnIndexOfAuthKeyLen: Int = getColumnIndexOrThrow(_stmt, "authKeyLen")
        val _columnIndexOfPpwLastModified: Int = getColumnIndexOrThrow(_stmt, "ppwLastModified")
        val _columnIndexOfPpwStored: Int = getColumnIndexOrThrow(_stmt, "ppwStored")
        val _result: PersonPasswordEntity?
        if (_stmt.step()) {
          val _tmpPpwGuidNum: Long
          _tmpPpwGuidNum = _stmt.getLong(_columnIndexOfPpwGuidNum)
          val _tmpPpwGuid: String
          _tmpPpwGuid = _stmt.getText(_columnIndexOfPpwGuid)
          val _tmpAuthAlgorithm: String
          _tmpAuthAlgorithm = _stmt.getText(_columnIndexOfAuthAlgorithm)
          val _tmpAuthEncoded: String
          _tmpAuthEncoded = _stmt.getText(_columnIndexOfAuthEncoded)
          val _tmpAuthSalt: String
          _tmpAuthSalt = _stmt.getText(_columnIndexOfAuthSalt)
          val _tmpAuthIterations: Int
          _tmpAuthIterations = _stmt.getLong(_columnIndexOfAuthIterations).toInt()
          val _tmpAuthKeyLen: Int
          _tmpAuthKeyLen = _stmt.getLong(_columnIndexOfAuthKeyLen).toInt()
          val _tmpPpwLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpwLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpwLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwLastModified = _tmp_1
          }
          val _tmpPpwStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpwStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpwStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwStored = _tmp_3
          }
          _result = PersonPasswordEntity(_tmpPpwGuidNum,_tmpPpwGuid,_tmpAuthAlgorithm,_tmpAuthEncoded,_tmpAuthSalt,_tmpAuthIterations,_tmpAuthKeyLen,_tmpPpwLastModified,_tmpPpwStored)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedByPersonUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT PersonPasswordEntity.ppwLastModified
        |          FROM PersonPasswordEntity
        |         WHERE PersonPasswordEntity.ppwGuidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidList(uids: List<Long>): List<PersonPasswordEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT PersonPasswordEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM PersonPasswordEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE PersonPasswordEntity.ppwGuidNum IN (")
    val _inputSize: Int = uids.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uids) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfPpwGuidNum: Int = getColumnIndexOrThrow(_stmt, "ppwGuidNum")
        val _columnIndexOfPpwGuid: Int = getColumnIndexOrThrow(_stmt, "ppwGuid")
        val _columnIndexOfAuthAlgorithm: Int = getColumnIndexOrThrow(_stmt, "authAlgorithm")
        val _columnIndexOfAuthEncoded: Int = getColumnIndexOrThrow(_stmt, "authEncoded")
        val _columnIndexOfAuthSalt: Int = getColumnIndexOrThrow(_stmt, "authSalt")
        val _columnIndexOfAuthIterations: Int = getColumnIndexOrThrow(_stmt, "authIterations")
        val _columnIndexOfAuthKeyLen: Int = getColumnIndexOrThrow(_stmt, "authKeyLen")
        val _columnIndexOfPpwLastModified: Int = getColumnIndexOrThrow(_stmt, "ppwLastModified")
        val _columnIndexOfPpwStored: Int = getColumnIndexOrThrow(_stmt, "ppwStored")
        val _result: MutableList<PersonPasswordEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: PersonPasswordEntity
          val _tmpPpwGuidNum: Long
          _tmpPpwGuidNum = _stmt.getLong(_columnIndexOfPpwGuidNum)
          val _tmpPpwGuid: String
          _tmpPpwGuid = _stmt.getText(_columnIndexOfPpwGuid)
          val _tmpAuthAlgorithm: String
          _tmpAuthAlgorithm = _stmt.getText(_columnIndexOfAuthAlgorithm)
          val _tmpAuthEncoded: String
          _tmpAuthEncoded = _stmt.getText(_columnIndexOfAuthEncoded)
          val _tmpAuthSalt: String
          _tmpAuthSalt = _stmt.getText(_columnIndexOfAuthSalt)
          val _tmpAuthIterations: Int
          _tmpAuthIterations = _stmt.getLong(_columnIndexOfAuthIterations).toInt()
          val _tmpAuthKeyLen: Int
          _tmpAuthKeyLen = _stmt.getLong(_columnIndexOfAuthKeyLen).toInt()
          val _tmpPpwLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpwLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpwLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwLastModified = _tmp_1
          }
          val _tmpPpwStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpwStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpwStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwStored = _tmp_3
          }
          _item_1 = PersonPasswordEntity(_tmpPpwGuidNum,_tmpPpwGuid,_tmpAuthAlgorithm,_tmpAuthEncoded,_tmpAuthSalt,_tmpAuthIterations,_tmpAuthKeyLen,_tmpPpwLastModified,_tmpPpwStored)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAll(authenticatedPersonUidNum: Long, personGuidNum: Long): List<PersonPasswordEntity> {
    val _sql: String = """
        |
        |          WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |               
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |        
        |        SELECT PersonPasswordEntity.*
        |          FROM PersonPasswordEntity
        |               JOIN PersonEntity 
        |                    ON PersonEntity.pGuidHash = PersonPasswordEntity.ppwGuidNum
        |         WHERE PersonPasswordEntity.ppwGuidNum = ?
        |           AND (
        |                PersonEntity.pGuidHash = ?
        |             OR PersonEntity.pGuidHash IN 
        |                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum
        |                   FROM PersonRelatedPersonEntity
        |                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM SchoolPermissionGrantEntity
        |                     WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                           (SELECT PersonRoleEntity.prRoleEnum
        |                              FROM PersonRoleEntity
        |                             WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ))
        |                               AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |              WHEN 6 THEN 4
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM AuthenticatedPersonClassPermissions
        |                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN 
        |                           (SELECT EnrollmentEntity.eClassUidNum
        |                              FROM EnrollmentEntity
        |                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)
        |                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |              WHEN 6 THEN 4
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |        )
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 5
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 6
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        val _columnIndexOfPpwGuidNum: Int = getColumnIndexOrThrow(_stmt, "ppwGuidNum")
        val _columnIndexOfPpwGuid: Int = getColumnIndexOrThrow(_stmt, "ppwGuid")
        val _columnIndexOfAuthAlgorithm: Int = getColumnIndexOrThrow(_stmt, "authAlgorithm")
        val _columnIndexOfAuthEncoded: Int = getColumnIndexOrThrow(_stmt, "authEncoded")
        val _columnIndexOfAuthSalt: Int = getColumnIndexOrThrow(_stmt, "authSalt")
        val _columnIndexOfAuthIterations: Int = getColumnIndexOrThrow(_stmt, "authIterations")
        val _columnIndexOfAuthKeyLen: Int = getColumnIndexOrThrow(_stmt, "authKeyLen")
        val _columnIndexOfPpwLastModified: Int = getColumnIndexOrThrow(_stmt, "ppwLastModified")
        val _columnIndexOfPpwStored: Int = getColumnIndexOrThrow(_stmt, "ppwStored")
        val _result: MutableList<PersonPasswordEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasswordEntity
          val _tmpPpwGuidNum: Long
          _tmpPpwGuidNum = _stmt.getLong(_columnIndexOfPpwGuidNum)
          val _tmpPpwGuid: String
          _tmpPpwGuid = _stmt.getText(_columnIndexOfPpwGuid)
          val _tmpAuthAlgorithm: String
          _tmpAuthAlgorithm = _stmt.getText(_columnIndexOfAuthAlgorithm)
          val _tmpAuthEncoded: String
          _tmpAuthEncoded = _stmt.getText(_columnIndexOfAuthEncoded)
          val _tmpAuthSalt: String
          _tmpAuthSalt = _stmt.getText(_columnIndexOfAuthSalt)
          val _tmpAuthIterations: Int
          _tmpAuthIterations = _stmt.getLong(_columnIndexOfAuthIterations).toInt()
          val _tmpAuthKeyLen: Int
          _tmpAuthKeyLen = _stmt.getLong(_columnIndexOfAuthKeyLen).toInt()
          val _tmpPpwLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpwLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpwLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwLastModified = _tmp_1
          }
          val _tmpPpwStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpwStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpwStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwStored = _tmp_3
          }
          _item = PersonPasswordEntity(_tmpPpwGuidNum,_tmpPpwGuid,_tmpAuthAlgorithm,_tmpAuthEncoded,_tmpAuthSalt,_tmpAuthIterations,_tmpAuthKeyLen,_tmpPpwLastModified,_tmpPpwStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsFlow(authenticatedPersonUidNum: Long, personGuidNum: Long): Flow<List<PersonPasswordEntity>> {
    val _sql: String = """
        |
        |          WITH 
        |            AuthenticatedPermissionPersonUids(uidNum) AS (
        |                SELECT ? AS uidNum
        |                UNION
        |                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum
        |                  FROM PersonRelatedPersonEntity
        |                 WHERE 5 IN 
        |                       (SELECT PersonRoleEntity.prRoleEnum
        |                          FROM PersonRoleEntity
        |                         WHERE PersonRoleEntity.prPersonGuidHash = ?)
        |                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     
        |        ,  
        |               
        |            AuthenticatedPersonClassPermissions AS (
        |                SELECT ClassPermissionEntity.*
        |                  FROM ClassPermissionEntity
        |                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN 
        |                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum
        |                          FROM EnrollmentEntity
        |                         WHERE EnrollmentEntity.ePersonUidNum IN 
        |                               (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        )
        |                           AND EnrollmentEntity.eStatus = 1)
        |            )
        |        
        |        
        |        SELECT PersonPasswordEntity.*
        |          FROM PersonPasswordEntity
        |               JOIN PersonEntity 
        |                    ON PersonEntity.pGuidHash = PersonPasswordEntity.ppwGuidNum
        |         WHERE PersonPasswordEntity.ppwGuidNum = ?
        |           AND (
        |                PersonEntity.pGuidHash = ?
        |             OR PersonEntity.pGuidHash IN 
        |                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum
        |                   FROM PersonRelatedPersonEntity
        |                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM SchoolPermissionGrantEntity
        |                     WHERE SchoolPermissionGrantEntity.spgToRole IN 
        |                           (SELECT PersonRoleEntity.prRoleEnum
        |                              FROM PersonRoleEntity
        |                             WHERE PersonRoleEntity.prPersonGuidHash IN 
        |                                   (
        |            SELECT AuthenticatedPermissionPersonUids.uidNum
        |              FROM AuthenticatedPermissionPersonUids
        |        ))
        |                               AND (SchoolPermissionGrantEntity.spgPermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |              WHEN 6 THEN 4
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |             OR EXISTS(
        |                    SELECT 1
        |                      FROM AuthenticatedPersonClassPermissions
        |                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN 
        |                           (SELECT EnrollmentEntity.eClassUidNum
        |                              FROM EnrollmentEntity
        |                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)
        |                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (
        |            CASE(SELECT PersonRoleEntity.prRoleEnum
        |                   FROM PersonRoleEntity
        |                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash
        |                  LIMIT 1)                    
        |                 
        |             WHEN 1 THEN 256
        |             WHEN 3 THEN 256
        |             WHEN 4 THEN 64
        |             WHEN 2 THEN 4
        |             WHEN 5 THEN 16
        |              WHEN 6 THEN 4
        |             ELSE 9223372036854775807
        |        
        |            END     
        |        )) > 0)
        |        )
        |        
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonRelatedPersonEntity", "PersonRoleEntity", "ClassPermissionEntity", "EnrollmentEntity", "PersonPasswordEntity", "PersonEntity", "SchoolPermissionGrantEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 2
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 3
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 4
        _stmt.bindLong(_argIndex, personGuidNum)
        _argIndex = 5
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        _argIndex = 6
        _stmt.bindLong(_argIndex, authenticatedPersonUidNum)
        val _columnIndexOfPpwGuidNum: Int = getColumnIndexOrThrow(_stmt, "ppwGuidNum")
        val _columnIndexOfPpwGuid: Int = getColumnIndexOrThrow(_stmt, "ppwGuid")
        val _columnIndexOfAuthAlgorithm: Int = getColumnIndexOrThrow(_stmt, "authAlgorithm")
        val _columnIndexOfAuthEncoded: Int = getColumnIndexOrThrow(_stmt, "authEncoded")
        val _columnIndexOfAuthSalt: Int = getColumnIndexOrThrow(_stmt, "authSalt")
        val _columnIndexOfAuthIterations: Int = getColumnIndexOrThrow(_stmt, "authIterations")
        val _columnIndexOfAuthKeyLen: Int = getColumnIndexOrThrow(_stmt, "authKeyLen")
        val _columnIndexOfPpwLastModified: Int = getColumnIndexOrThrow(_stmt, "ppwLastModified")
        val _columnIndexOfPpwStored: Int = getColumnIndexOrThrow(_stmt, "ppwStored")
        val _result: MutableList<PersonPasswordEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonPasswordEntity
          val _tmpPpwGuidNum: Long
          _tmpPpwGuidNum = _stmt.getLong(_columnIndexOfPpwGuidNum)
          val _tmpPpwGuid: String
          _tmpPpwGuid = _stmt.getText(_columnIndexOfPpwGuid)
          val _tmpAuthAlgorithm: String
          _tmpAuthAlgorithm = _stmt.getText(_columnIndexOfAuthAlgorithm)
          val _tmpAuthEncoded: String
          _tmpAuthEncoded = _stmt.getText(_columnIndexOfAuthEncoded)
          val _tmpAuthSalt: String
          _tmpAuthSalt = _stmt.getText(_columnIndexOfAuthSalt)
          val _tmpAuthIterations: Int
          _tmpAuthIterations = _stmt.getLong(_columnIndexOfAuthIterations).toInt()
          val _tmpAuthKeyLen: Int
          _tmpAuthKeyLen = _stmt.getLong(_columnIndexOfAuthKeyLen).toInt()
          val _tmpPpwLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPpwLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPpwLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwLastModified = _tmp_1
          }
          val _tmpPpwStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPpwStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPpwStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPpwStored = _tmp_3
          }
          _item = PersonPasswordEntity(_tmpPpwGuidNum,_tmpPpwGuid,_tmpAuthAlgorithm,_tmpAuthEncoded,_tmpAuthSalt,_tmpAuthIterations,_tmpAuthKeyLen,_tmpPpwLastModified,_tmpPpwStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
