/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.school.ext;

import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.exceptions.ForbiddenException;
import world.respect.datalayer.school.ext.JsonObjectBuilderExtKt;
import world.respect.datalayer.school.model.DeviceInfo;
import world.respect.datalayer.school.model.Invite2;
import world.respect.datalayer.school.model.Person;
import world.respect.datalayer.school.model.PersonRole;
import world.respect.datalayer.school.model.PersonRoleEnum;
import world.respect.datalayer.school.model.PersonStatusEnum;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\f\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\f*\u00020\u0002\u00a8\u0006\u0012"}, d2={"assertPersonHasRole", "", "Lworld/respect/datalayer/school/model/Person;", "role", "Lworld/respect/datalayer/school/model/PersonRoleEnum;", "primaryRole", "copyWithInviteInfo", "invite", "Lworld/respect/datalayer/school/model/Invite2;", "deviceInfo", "Lworld/respect/datalayer/school/model/DeviceInfo;", "inviteCodeOrNull", "", "inviteUidOrNull", "deviceModelOrNull", "devicePlatformOrNull", "deviceOsVersionOrNull", "getDeviceDisplayName", "respect-datalayer_release"})
@SourceDebugExtension(value={"SMAP\nPersonExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersonExt.kt\nworld/respect/datalayer/school/ext/PersonExtKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,82:1\n1761#2,3:83\n230#2,2:86\n29#3,3:88\n*S KotlinDebug\n*F\n+ 1 PersonExt.kt\nworld/respect/datalayer/school/ext/PersonExtKt\n*L\n17#1:83,3\n23#1:86,2\n34#1:88,3\n*E\n"})
public final class PersonExtKt {
    public static final void assertPersonHasRole(@Nullable Person $this$assertPersonHasRole, @NotNull PersonRoleEnum role) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Object object = $this$assertPersonHasRole;
        if (object != null && (object = ((Person)object).getRoles()) != null) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PersonRole it = (PersonRole)element$iv;
                        boolean bl3 = false;
                        if (!(it.getRoleEnum() == role)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (!bl) {
            throw new ForbiddenException("Person does not have " + role.getValue() + " role", null, 2, null);
        }
    }

    @NotNull
    public static final PersonRoleEnum primaryRole(@NotNull Person $this$primaryRole) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$primaryRole, (String)"<this>");
            Iterable $this$first$iv = $this$primaryRole.getRoles();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PersonRole it = (PersonRole)element$iv2;
                boolean bl = false;
                if (!it.isPrimaryRole()) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((PersonRole)element$iv2).getRoleEnum();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Person copyWithInviteInfo(@NotNull Person $this$copyWithInviteInfo, @NotNull Invite2 invite, @Nullable DeviceInfo deviceInfo) {
        void $this$copyWithInviteInfo_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)$this$copyWithInviteInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)invite, (String)"invite");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        Instant instant = null;
        Instant instant2 = null;
        PersonStatusEnum personStatusEnum = null;
        boolean bl = false;
        String string = null;
        Person person = $this$copyWithInviteInfo;
        boolean bl2 = false;
        JsonObject jsonObject = $this$copyWithInviteInfo.getMetadata();
        if (jsonObject != null) {
            JsonObject jsonObject2;
            JsonObject it = jsonObject2 = jsonObject;
            boolean bl3 = false;
            JsonObjectBuilderExtKt.putAll((JsonObjectBuilder)$this$copyWithInviteInfo_u24lambda_u240, it);
        }
        $this$copyWithInviteInfo_u24lambda_u240.put("inviteCode", (JsonElement)JsonElementKt.JsonPrimitive((String)invite.getCode()));
        $this$copyWithInviteInfo_u24lambda_u240.put("inviteUid", (JsonElement)JsonElementKt.JsonPrimitive((String)invite.getUid()));
        if (deviceInfo != null) {
            $this$copyWithInviteInfo_u24lambda_u240.put("deviceInfo", (JsonElement)JsonElementKt.JsonPrimitive((String)deviceInfo.toString()));
            $this$copyWithInviteInfo_u24lambda_u240.put("deviceModel", (JsonElement)JsonElementKt.JsonPrimitive((String)deviceInfo.getModel()));
            $this$copyWithInviteInfo_u24lambda_u240.put("devicePlatform", (JsonElement)JsonElementKt.JsonPrimitive((String)deviceInfo.getPlatform().name()));
            $this$copyWithInviteInfo_u24lambda_u240.put("deviceOsVersion", (JsonElement)JsonElementKt.JsonPrimitive((String)deviceInfo.getVersion()));
        }
        Unit unit = Unit.INSTANCE;
        return Person.copy$default(person, string, bl, personStatusEnum, instant2, instant, builder$iv.build(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x1FFFDF, null);
    }

    public static /* synthetic */ Person copyWithInviteInfo$default(Person person, Invite2 invite2, DeviceInfo deviceInfo, int n, Object object) {
        if ((n & 2) != 0) {
            deviceInfo = null;
        }
        return PersonExtKt.copyWithInviteInfo(person, invite2, deviceInfo);
    }

    @Nullable
    public static final String inviteCodeOrNull(@NotNull Person $this$inviteCodeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$inviteCodeOrNull, (String)"<this>");
        JsonObject jsonObject = $this$inviteCodeOrNull.getMetadata();
        return jsonObject != null && (jsonObject = (JsonElement)jsonObject.get((Object)"inviteCode")) != null && (jsonObject = JsonElementKt.getJsonPrimitive((JsonElement)jsonObject)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonObject) : null;
    }

    @Nullable
    public static final String inviteUidOrNull(@NotNull Person $this$inviteUidOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$inviteUidOrNull, (String)"<this>");
        JsonObject jsonObject = $this$inviteUidOrNull.getMetadata();
        return jsonObject != null && (jsonObject = (JsonElement)jsonObject.get((Object)"inviteUid")) != null && (jsonObject = JsonElementKt.getJsonPrimitive((JsonElement)jsonObject)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonObject) : null;
    }

    @Nullable
    public static final String deviceModelOrNull(@NotNull Person $this$deviceModelOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceModelOrNull, (String)"<this>");
        JsonObject jsonObject = $this$deviceModelOrNull.getMetadata();
        return jsonObject != null && (jsonObject = JsonElementKt.getJsonObject((JsonElement)((JsonElement)jsonObject))) != null && (jsonObject = (JsonElement)jsonObject.get((Object)"deviceModel")) != null && (jsonObject = JsonElementKt.getJsonPrimitive((JsonElement)jsonObject)) != null ? jsonObject.getContent() : null;
    }

    @Nullable
    public static final String devicePlatformOrNull(@NotNull Person $this$devicePlatformOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$devicePlatformOrNull, (String)"<this>");
        JsonObject jsonObject = $this$devicePlatformOrNull.getMetadata();
        return jsonObject != null && (jsonObject = JsonElementKt.getJsonObject((JsonElement)((JsonElement)jsonObject))) != null && (jsonObject = (JsonElement)jsonObject.get((Object)"devicePlatform")) != null && (jsonObject = JsonElementKt.getJsonPrimitive((JsonElement)jsonObject)) != null ? jsonObject.getContent() : null;
    }

    @Nullable
    public static final String deviceOsVersionOrNull(@NotNull Person $this$deviceOsVersionOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceOsVersionOrNull, (String)"<this>");
        JsonObject jsonObject = $this$deviceOsVersionOrNull.getMetadata();
        return jsonObject != null && (jsonObject = JsonElementKt.getJsonObject((JsonElement)((JsonElement)jsonObject))) != null && (jsonObject = (JsonElement)jsonObject.get((Object)"deviceOsVersion")) != null && (jsonObject = JsonElementKt.getJsonPrimitive((JsonElement)jsonObject)) != null ? jsonObject.getContent() : null;
    }

    @NotNull
    public static final String getDeviceDisplayName(@NotNull Person $this$getDeviceDisplayName) {
        String string;
        String platform;
        Intrinsics.checkNotNullParameter((Object)$this$getDeviceDisplayName, (String)"<this>");
        String string2 = PersonExtKt.deviceModelOrNull($this$getDeviceDisplayName);
        if (string2 == null) {
            return $this$getDeviceDisplayName.getGivenName();
        }
        String model = string2;
        String string3 = PersonExtKt.devicePlatformOrNull($this$getDeviceDisplayName);
        if (string3 == null) {
            string3 = platform = "Android";
        }
        if ((string = PersonExtKt.deviceOsVersionOrNull($this$getDeviceDisplayName)) == null) {
            string = "";
        }
        String osVersion = string;
        String deviceType = StringsKt.contains((CharSequence)model, (CharSequence)"tab", (boolean)true) || StringsKt.contains((CharSequence)model, (CharSequence)"pad", (boolean)true) ? "Tablet" : "Mobile";
        return deviceType + " (" + platform + " " + osVersion + ")";
    }
}

