/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.handler.codec.http.CompressionEncoderFactory;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final BrotliOptions brotliOptions;
    private final GzipOptions gzipOptions;
    private final DeflateOptions deflateOptions;
    private final ZstdOptions zstdOptions;
    private final SnappyOptions snappyOptions;
    private final int contentSizeThreshold;
    private ChannelHandlerContext ctx;
    private final Map<String, CompressionEncoderFactory> factories;

    public HttpContentCompressor() {
        this(0, (CompressionOptions[])null);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel) {
        this(compressionLevel, 15, 8, 0);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel, int windowBits, int memLevel) {
        this(compressionLevel, windowBits, memLevel, 0);
    }

    @Deprecated
    public HttpContentCompressor(int compressionLevel, int windowBits, int memLevel, int contentSizeThreshold) {
        this(contentSizeThreshold, HttpContentCompressor.defaultCompressionOptions(StandardCompressionOptions.gzip(ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel"), ObjectUtil.checkInRange(windowBits, 9, 15, "windowBits"), ObjectUtil.checkInRange(memLevel, 1, 9, "memLevel")), StandardCompressionOptions.deflate(ObjectUtil.checkInRange(compressionLevel, 0, 9, "compressionLevel"), ObjectUtil.checkInRange(windowBits, 9, 15, "windowBits"), ObjectUtil.checkInRange(memLevel, 1, 9, "memLevel"))));
    }

    public HttpContentCompressor(CompressionOptions ... compressionOptions) {
        this(0, compressionOptions);
    }

    public HttpContentCompressor(int contentSizeThreshold, CompressionOptions ... compressionOptions) {
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero(contentSizeThreshold, "contentSizeThreshold");
        BrotliOptions brotliOptions = null;
        GzipOptions gzipOptions = null;
        DeflateOptions deflateOptions = null;
        ZstdOptions zstdOptions = null;
        SnappyOptions snappyOptions = null;
        if (compressionOptions == null || compressionOptions.length == 0) {
            compressionOptions = HttpContentCompressor.defaultCompressionOptions(StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate());
        }
        ObjectUtil.deepCheckNotNull("compressionOptions", compressionOptions);
        for (CompressionOptions compressionOption : compressionOptions) {
            if (Brotli.isAvailable() && compressionOption instanceof BrotliOptions) {
                brotliOptions = (BrotliOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof GzipOptions) {
                gzipOptions = (GzipOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof DeflateOptions) {
                deflateOptions = (DeflateOptions)compressionOption;
                continue;
            }
            if (Zstd.isAvailable() && compressionOption instanceof ZstdOptions) {
                zstdOptions = (ZstdOptions)compressionOption;
                continue;
            }
            if (compressionOption instanceof SnappyOptions) {
                snappyOptions = (SnappyOptions)compressionOption;
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOption);
        }
        this.gzipOptions = gzipOptions;
        this.deflateOptions = deflateOptions;
        this.brotliOptions = brotliOptions;
        this.zstdOptions = zstdOptions;
        this.snappyOptions = snappyOptions;
        this.factories = new HashMap<String, CompressionEncoderFactory>();
        if (this.gzipOptions != null) {
            this.factories.put("gzip", new GzipEncoderFactory());
        }
        if (this.deflateOptions != null) {
            this.factories.put("deflate", new DeflateEncoderFactory());
        }
        if (Brotli.isAvailable() && this.brotliOptions != null) {
            this.factories.put("br", new BrEncoderFactory());
        }
        if (this.zstdOptions != null) {
            this.factories.put("zstd", new ZstdEncoderFactory());
        }
        if (this.snappyOptions != null) {
            this.factories.put("snappy", new SnappyEncoderFactory());
        }
    }

    private static CompressionOptions[] defaultCompressionOptions(GzipOptions gzipOptions, DeflateOptions deflateOptions) {
        ArrayList<CompressionOptions> options2 = new ArrayList<CompressionOptions>(5);
        options2.add(gzipOptions);
        options2.add(deflateOptions);
        options2.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            options2.add(StandardCompressionOptions.brotli());
        }
        if (Zstd.isAvailable()) {
            options2.add(StandardCompressionOptions.zstd());
        }
        return options2.toArray(new CompressionOptions[0]);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).content().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        String contentEncoding = httpResponse.headers().get(HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return null;
        }
        String targetContentEncoding = this.determineEncoding(acceptEncoding);
        if (targetContentEncoding == null) {
            return null;
        }
        CompressionEncoderFactory encoderFactory = this.factories.get(targetContentEncoding);
        if (encoderFactory == null) {
            throw new IllegalStateException("Couldn't find CompressionEncoderFactory: " + targetContentEncoding);
        }
        return new HttpContentEncoder.Result(targetContentEncoding, new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), encoderFactory.createEncoder()));
    }

    protected String determineEncoding(String acceptEncoding) {
        float starQ = -1.0f;
        float brQ = -1.0f;
        float zstdQ = -1.0f;
        float snappyQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        int start2 = 0;
        int length = acceptEncoding.length();
        while (start2 < length) {
            int comma = acceptEncoding.indexOf(44, start2);
            if (comma == -1) {
                comma = length;
            }
            String encoding = acceptEncoding.substring(start2, comma);
            float q2 = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q2 = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q2 = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q2;
            } else if (encoding.contains("br") && q2 > brQ) {
                brQ = q2;
            } else if (encoding.contains("zstd") && q2 > zstdQ) {
                zstdQ = q2;
            } else if (encoding.contains("snappy") && q2 > snappyQ) {
                snappyQ = q2;
            } else if (encoding.contains("gzip") && q2 > gzipQ) {
                gzipQ = q2;
            } else if (encoding.contains("deflate") && q2 > deflateQ) {
                deflateQ = q2;
            }
            start2 = comma + 1;
        }
        if (brQ > 0.0f || zstdQ > 0.0f || snappyQ > 0.0f || gzipQ > 0.0f || deflateQ > 0.0f) {
            if (brQ != -1.0f && brQ >= zstdQ && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ != -1.0f && zstdQ >= snappyQ && this.zstdOptions != null) {
                return "zstd";
            }
            if (snappyQ != -1.0f && snappyQ >= gzipQ && this.snappyOptions != null) {
                return "snappy";
            }
            if (gzipQ != -1.0f && gzipQ >= deflateQ && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ != -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        if (starQ > 0.0f) {
            if (brQ == -1.0f && this.brotliOptions != null) {
                return "br";
            }
            if (zstdQ == -1.0f && this.zstdOptions != null) {
                return "zstd";
            }
            if (snappyQ == -1.0f && this.snappyOptions != null) {
                return "snappy";
            }
            if (gzipQ == -1.0f && this.gzipOptions != null) {
                return "gzip";
            }
            if (deflateQ == -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        return null;
    }

    @Deprecated
    protected ZlibWrapper determineWrapper(String acceptEncoding) {
        float starQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding.split(",")) {
            float q2 = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q2 = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q2 = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q2;
                continue;
            }
            if (encoding.contains("gzip") && q2 > gzipQ) {
                gzipQ = q2;
                continue;
            }
            if (!encoding.contains("deflate") || !(q2 > deflateQ)) continue;
            deflateQ = q2;
        }
        if (gzipQ > 0.0f || deflateQ > 0.0f) {
            if (gzipQ >= deflateQ) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (starQ > 0.0f) {
            if (gzipQ == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (deflateQ == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }

    private static final class SnappyEncoderFactory
    implements CompressionEncoderFactory {
        private SnappyEncoderFactory() {
        }

        @Override
        public MessageToByteEncoder<ByteBuf> createEncoder() {
            return new SnappyFrameEncoder();
        }
    }

    private final class ZstdEncoderFactory
    implements CompressionEncoderFactory {
        private ZstdEncoderFactory() {
        }

        @Override
        public MessageToByteEncoder<ByteBuf> createEncoder() {
            return new ZstdEncoder(HttpContentCompressor.this.zstdOptions.compressionLevel(), HttpContentCompressor.this.zstdOptions.blockSize(), HttpContentCompressor.this.zstdOptions.maxEncodeSize());
        }
    }

    private final class BrEncoderFactory
    implements CompressionEncoderFactory {
        private BrEncoderFactory() {
        }

        @Override
        public MessageToByteEncoder<ByteBuf> createEncoder() {
            return new BrotliEncoder(HttpContentCompressor.this.brotliOptions.parameters());
        }
    }

    private final class DeflateEncoderFactory
    implements CompressionEncoderFactory {
        private DeflateEncoderFactory() {
        }

        @Override
        public MessageToByteEncoder<ByteBuf> createEncoder() {
            return ZlibCodecFactory.newZlibEncoder(ZlibWrapper.ZLIB, HttpContentCompressor.this.deflateOptions.compressionLevel(), HttpContentCompressor.this.deflateOptions.windowBits(), HttpContentCompressor.this.deflateOptions.memLevel());
        }
    }

    private final class GzipEncoderFactory
    implements CompressionEncoderFactory {
        private GzipEncoderFactory() {
        }

        @Override
        public MessageToByteEncoder<ByteBuf> createEncoder() {
            return ZlibCodecFactory.newZlibEncoder(ZlibWrapper.GZIP, HttpContentCompressor.this.gzipOptions.compressionLevel(), HttpContentCompressor.this.gzipOptions.windowBits(), HttpContentCompressor.this.gzipOptions.memLevel());
        }
    }
}

