/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.ItemSnapshotList;
import androidx.paging.LoadType;
import androidx.paging.PageEvent;
import androidx.paging.PagingDataEvent;
import androidx.paging.PlaceholderPaddedList;
import androidx.paging.TransformablePage;
import androidx.paging.ViewportHint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00017B+\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u0017\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\b\u00a2\u0006\u0002\u0010 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010&\u001a\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u0002J\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000*J\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\bJ\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000(2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000(2\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u000006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010$\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013\u00a8\u00068"}, d2={"Landroidx/paging/PageStore;", "T", "", "Landroidx/paging/PlaceholderPaddedList;", "pages", "", "Landroidx/paging/TransformablePage;", "placeholdersBefore", "", "placeholdersAfter", "<init>", "(Ljava/util/List;II)V", "insertEvent", "Landroidx/paging/PageEvent$Insert;", "(Landroidx/paging/PageEvent$Insert;)V", "", "value", "dataCount", "getDataCount", "()I", "originalPageOffsetFirst", "getOriginalPageOffsetFirst", "originalPageOffsetLast", "getOriginalPageOffsetLast", "getPlaceholdersBefore", "getPlaceholdersAfter", "checkIndex", "", "index", "toString", "", "get", "(I)Ljava/lang/Object;", "snapshot", "Landroidx/paging/ItemSnapshotList;", "getItem", "size", "getSize", "fullCount", "processEvent", "Landroidx/paging/PagingDataEvent;", "pageEvent", "Landroidx/paging/PageEvent;", "initializeHint", "Landroidx/paging/ViewportHint$Initial;", "accessHintForPresenterIndex", "Landroidx/paging/ViewportHint$Access;", "insertPage", "insert", "dropPagesWithOffsets", "pageOffsetsToDrop", "Lkotlin/ranges/IntRange;", "dropPages", "drop", "Landroidx/paging/PageEvent$Drop;", "Companion", "paging-common"})
@SourceDebugExtension(value={"SMAP\nPageStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageStore.kt\nandroidx/paging/PageStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,257:1\n1#2:258\n1368#3:259\n1454#3,5:260\n1368#3:265\n1454#3,5:266\n1368#3:271\n1454#3,5:272\n12604#4,2:277\n*S KotlinDebug\n*F\n+ 1 PageStore.kt\nandroidx/paging/PageStore\n*L\n80#1:259\n80#1:260,5\n172#1:265\n172#1:266,5\n187#1:271\n187#1:272,5\n204#1:277,2\n*E\n"})
public final class PageStore<T>
implements PlaceholderPaddedList<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TransformablePage<T>> pages;
    private int dataCount;
    private int placeholdersBefore;
    private int placeholdersAfter;
    @NotNull
    private static final PageStore<Object> INITIAL = new PageStore<Object>(PageEvent.Insert.Companion.getEMPTY_REFRESH_LOCAL());

    public PageStore(@NotNull List<TransformablePage<T>> pages, int placeholdersBefore, int placeholdersAfter) {
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        this.pages = CollectionsKt.toMutableList((Collection)pages);
        this.dataCount = this.fullCount(pages);
        this.placeholdersBefore = placeholdersBefore;
        this.placeholdersAfter = placeholdersAfter;
    }

    public PageStore(@NotNull PageEvent.Insert<T> insertEvent) {
        Intrinsics.checkNotNullParameter(insertEvent, (String)"insertEvent");
        this(insertEvent.getPages(), insertEvent.getPlaceholdersBefore(), insertEvent.getPlaceholdersAfter());
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    private final int getOriginalPageOffsetFirst() {
        Integer n = ArraysKt.minOrNull((int[])((TransformablePage)CollectionsKt.first(this.pages)).getOriginalPageOffsets());
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    private final int getOriginalPageOffsetLast() {
        Integer n = ArraysKt.maxOrNull((int[])((TransformablePage)CollectionsKt.last(this.pages)).getOriginalPageOffsets());
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    @Override
    public int getPlaceholdersBefore() {
        return this.placeholdersBefore;
    }

    @Override
    public int getPlaceholdersAfter() {
        return this.placeholdersAfter;
    }

    private final void checkIndex(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        int n = this.getDataCount();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<T> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.getItem((int)it));
        }
        String items = CollectionsKt.joinToString$default((Iterable)arrayList, null, null, null, (int)0, null, null, (int)63, null);
        return "[(" + this.getPlaceholdersBefore() + " placeholders), " + items + ", (" + this.getPlaceholdersAfter() + " placeholders)]";
    }

    @Nullable
    public final T get(int index) {
        this.checkIndex(index);
        int localIndex = index - this.getPlaceholdersBefore();
        if (localIndex < 0 || localIndex >= this.getDataCount()) {
            return null;
        }
        return this.getItem(localIndex);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemSnapshotList<T> snapshot() {
        List list;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.pages;
        int n = this.getPlaceholdersAfter();
        int n2 = this.getPlaceholdersBefore();
        boolean $i$f$flatMap = false;
        void var3_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TransformablePage it = (TransformablePage)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getData();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        int n3 = n;
        int n4 = n2;
        return new ItemSnapshotList(n4, n3, list2);
    }

    @Override
    @NotNull
    public T getItem(int index) {
        int indexInPage;
        int pageSize;
        int pageIndex = 0;
        int localPageCount = this.pages.size();
        for (indexInPage = index; pageIndex < localPageCount && (pageSize = this.pages.get(pageIndex).getData().size()) <= indexInPage; indexInPage -= pageSize, ++pageIndex) {
        }
        return this.pages.get(pageIndex).getData().get(indexInPage);
    }

    @Override
    public int getSize() {
        return this.getPlaceholdersBefore() + this.getDataCount() + this.getPlaceholdersAfter();
    }

    /*
     * WARNING - void declaration
     */
    private final int fullCount(List<TransformablePage<T>> $this$fullCount) {
        Iterable iterable = $this$fullCount;
        int n = 0;
        for (Object t : iterable) {
            void it;
            TransformablePage transformablePage = (TransformablePage)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getData().size();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final PagingDataEvent<T> processEvent(@NotNull PageEvent<T> pageEvent) {
        PagingDataEvent<T> pagingDataEvent;
        Intrinsics.checkNotNullParameter(pageEvent, (String)"pageEvent");
        PageEvent<T> pageEvent2 = pageEvent;
        if (pageEvent2 instanceof PageEvent.Insert) {
            pagingDataEvent = this.insertPage((PageEvent.Insert)pageEvent);
        } else if (pageEvent2 instanceof PageEvent.Drop) {
            pagingDataEvent = this.dropPages((PageEvent.Drop)pageEvent);
        } else {
            throw new IllegalStateException("Paging received an event to process StaticList or LoadStateUpdate while\nprocessing Inserts and Drops. If you see this exception, it is most\nlikely a bug in the library. Please file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
        }
        return pagingDataEvent;
    }

    @NotNull
    public final ViewportHint.Initial initializeHint() {
        int presentedItems = this.getDataCount();
        return new ViewportHint.Initial(presentedItems / 2, presentedItems / 2, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    @NotNull
    public final ViewportHint.Access accessHintForPresenterIndex(int index) {
        int indexInPage;
        int pageIndex = 0;
        for (indexInPage = index - this.getPlaceholdersBefore(); indexInPage >= this.pages.get(pageIndex).getData().size() && pageIndex < CollectionsKt.getLastIndex(this.pages); indexInPage -= this.pages.get(pageIndex).getData().size(), ++pageIndex) {
        }
        return this.pages.get(pageIndex).viewportHintFor(indexInPage, index - this.getPlaceholdersBefore(), this.getSize() - index - this.getPlaceholdersAfter() - 1, this.getOriginalPageOffsetFirst(), this.getOriginalPageOffsetLast());
    }

    /*
     * WARNING - void declaration
     */
    private final PagingDataEvent<T> insertPage(PageEvent.Insert<T> insert) {
        PagingDataEvent pagingDataEvent;
        int insertSize = this.fullCount(insert.getPages());
        switch (WhenMappings.$EnumSwitchMapping$0[insert.getLoadType().ordinal()]) {
            case 1: {
                throw new IllegalStateException("Paging received a refresh event in the middle of an actively loading generation\nof PagingData. If you see this exception, it is most likely a bug in the library.\nPlease file a bug so we can fix it at:\nhttps://issuetracker.google.com/issues/new?component=413106");
            }
            case 2: {
                void $this$flatMapTo$iv$iv;
                int oldPlaceholdersBefore = this.getPlaceholdersBefore();
                this.pages.addAll(0, (Collection)insert.getPages());
                this.dataCount = this.getDataCount() + insertSize;
                this.placeholdersBefore = insert.getPlaceholdersBefore();
                Iterable $this$flatMap$iv = insert.getPages();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TransformablePage it = (TransformablePage)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getData();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                int n = oldPlaceholdersBefore;
                int n2 = this.getPlaceholdersBefore();
                List list = (List)destination$iv$iv;
                pagingDataEvent = new PagingDataEvent.Prepend(list, n2, n);
                break;
            }
            case 3: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                int oldPlaceholdersAfter = this.getPlaceholdersAfter();
                int oldDataCount = this.getDataCount();
                this.pages.addAll(this.pages.size(), (Collection)insert.getPages());
                this.dataCount = this.getDataCount() + insertSize;
                this.placeholdersAfter = insert.getPlaceholdersAfter();
                Iterable $i$f$flatMap = insert.getPages();
                int n = this.getPlaceholdersBefore() + oldDataCount;
                boolean $i$f$flatMap2 = false;
                void destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TransformablePage it = (TransformablePage)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getData();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                int n3 = oldPlaceholdersAfter;
                int n4 = this.getPlaceholdersAfter();
                List list2 = list;
                int n5 = n;
                pagingDataEvent = new PagingDataEvent.Append(n5, list2, n4, n3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pagingDataEvent;
    }

    private final int dropPagesWithOffsets(IntRange pageOffsetsToDrop) {
        int removeCount = 0;
        Iterator<TransformablePage<T>> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            boolean bl;
            TransformablePage<T> page;
            block2: {
                page = pageIterator.next();
                int[] $this$any$iv = page.getOriginalPageOffsets();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!pageOffsetsToDrop.contains(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            removeCount += page.getData().size();
            pageIterator.remove();
        }
        return removeCount;
    }

    private final PagingDataEvent<T> dropPages(PageEvent.Drop<T> drop) {
        PagingDataEvent pagingDataEvent;
        int itemDropCount = this.dropPagesWithOffsets(new IntRange(drop.getMinPageOffset(), drop.getMaxPageOffset()));
        this.dataCount = this.getDataCount() - itemDropCount;
        if (drop.getLoadType() == LoadType.PREPEND) {
            int oldPlaceholdersBefore = this.getPlaceholdersBefore();
            this.placeholdersBefore = drop.getPlaceholdersRemaining();
            pagingDataEvent = new PagingDataEvent.DropPrepend(itemDropCount, this.getPlaceholdersBefore(), oldPlaceholdersBefore);
        } else {
            int oldPlaceholdersAfter = this.getPlaceholdersAfter();
            this.placeholdersAfter = drop.getPlaceholdersRemaining();
            pagingDataEvent = new PagingDataEvent.DropAppend(this.getPlaceholdersBefore() + this.getDataCount(), itemDropCount, drop.getPlaceholdersRemaining(), oldPlaceholdersAfter);
        }
        return pagingDataEvent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0001\u0010\u0007*\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0007\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/paging/PageStore$Companion;", "", "<init>", "()V", "INITIAL", "Landroidx/paging/PageStore;", "initial", "T", "event", "Landroidx/paging/PageEvent$Insert;", "initial$paging_common", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> PageStore<T> initial$paging_common(@Nullable PageEvent.Insert<T> event) {
            PageStore<T> pageStore;
            if (event != null) {
                pageStore = new PageStore<T>(event);
            } else {
                PageStore pageStore2 = INITIAL;
                pageStore = pageStore2;
                Intrinsics.checkNotNull((Object)pageStore2, (String)"null cannot be cast to non-null type androidx.paging.PageStore<T of androidx.paging.PageStore.Companion.initial>");
            }
            return pageStore;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.PREPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.APPEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

