/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.io;

import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.io.InputStreamExtKt;
import com.ustadmobile.libcache.io.OutputStreamExtKt;
import com.ustadmobile.libcache.io.RangeInputStream;
import com.ustadmobile.libcache.io.TransferResult;
import com.ustadmobile.libcache.io.UnzippedEntry;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004\u001a\u0012\u0010\u000e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"transferToAndGetSha256", "Lcom/ustadmobile/libcache/io/TransferResult;", "Lkotlinx/io/Source;", "path", "Lkotlinx/io/files/Path;", "sourceCompression", "Lcom/ustadmobile/libcache/CompressionType;", "destCompressionType", "useAndReadSha256", "", "unzipTo", "", "Lcom/ustadmobile/libcache/io/UnzippedEntry;", "destPath", "uncompress", "compressionType", "range", "Lkotlinx/io/RawSource;", "fromByte", "", "toByte", "respect-lib-cache_debug"})
@SourceDebugExtension(value={"SMAP\nSourceExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceExt.kt\ncom/ustadmobile/libcache/io/SourceExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class SourceExtKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TransferResult transferToAndGetSha256(@NotNull Source $this$transferToAndGetSha256, @NotNull Path path, @NotNull CompressionType sourceCompression, @NotNull CompressionType destCompressionType) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$transferToAndGetSha256, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceCompression), (String)"sourceCompression");
        Intrinsics.checkNotNullParameter((Object)((Object)destCompressionType), (String)"destCompressionType");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = OutputStreamExtKt.compressIfRequired(SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)path, (boolean)false, (int)2, null))), destCompressionType);
        Throwable throwable = null;
        try {
            long l2;
            OutputStream outStream = (OutputStream)closeable;
            boolean bl = false;
            long it = l2 = ByteStreamsKt.copyTo$default((InputStream)InputStreamExtKt.uncompress(new DigestInputStream(SourcesJvmKt.asInputStream((Source)$this$transferToAndGetSha256), messageDigest), sourceCompression), (OutputStream)outStream, (int)0, (int)2, null);
            boolean bl2 = false;
            outStream.flush();
            l = l2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long bytesTransferred = l;
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return new TransferResult(byArray, bytesTransferred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] useAndReadSha256(@NotNull Source $this$useAndReadSha256) {
        Intrinsics.checkNotNullParameter((Object)$this$useAndReadSha256, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = SourcesJvmKt.asInputStream((Source)$this$useAndReadSha256);
        Throwable throwable = null;
        try {
            InputStream inStream = (InputStream)closeable;
            boolean bl = false;
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while (true) {
                int n;
                int it = n = inStream.read(buffer);
                boolean bl2 = false;
                bytesRead = it;
                if (n == -1) break;
                messageDigest.update(buffer, 0, bytesRead);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<UnzippedEntry> unzipTo(@NotNull Source $this$unzipTo, @NotNull Path destPath) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        List unzippedEntries = new ArrayList();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        Closeable closeable = new ZipInputStream(SourcesJvmKt.asInputStream((Source)$this$unzipTo));
        Throwable throwable = null;
        try {
            ZipInputStream zipInput = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = null;
            while (true) {
                Serializable serializable;
                ZipEntry zipEntry2;
                Closeable closeable2;
                if (zipInput.getNextEntry() != null) {
                    ZipEntry it = closeable2;
                    boolean bl2 = false;
                    zipEntry = it;
                    zipEntry2 = closeable2;
                } else {
                    zipEntry2 = null;
                }
                if (zipEntry2 == null) break;
                ZipEntry zipEntry3 = zipEntry;
                if (zipEntry3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"zipEntry");
                    zipEntry3 = null;
                }
                if (zipEntry3.isDirectory()) continue;
                File destFile = new File(destPath.toString(), zipEntry.getName());
                File it = serializable = destFile.getParentFile();
                boolean bl3 = false;
                File file = !it.exists() ? serializable : null;
                if (file != null) {
                    file.mkdirs();
                }
                closeable2 = new DigestOutputStream(new FileOutputStream(destFile), messageDigest);
                serializable = null;
                try {
                    DigestOutputStream outStream = (DigestOutputStream)closeable2;
                    boolean bl4 = false;
                    ByteStreamsKt.copyTo$default((InputStream)zipInput, (OutputStream)outStream, (int)0, (int)2, null);
                    outStream.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    serializable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)serializable);
                }
                String string = destFile.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Path path = PathsJvmKt.Path((String)string);
                String string2 = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                byte[] byArray = messageDigest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                unzippedEntries.add(new UnzippedEntry(path, string2, byArray));
                messageDigest.reset();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return unzippedEntries;
    }

    @NotNull
    public static final Source uncompress(@NotNull Source $this$uncompress, @NotNull CompressionType compressionType) {
        Intrinsics.checkNotNullParameter((Object)$this$uncompress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)compressionType), (String)"compressionType");
        return compressionType != CompressionType.NONE ? CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)InputStreamExtKt.uncompress(SourcesJvmKt.asInputStream((Source)$this$uncompress), compressionType))) : $this$uncompress;
    }

    @NotNull
    public static final RawSource range(@NotNull Source $this$range, long fromByte, long toByte) {
        Intrinsics.checkNotNullParameter((Object)$this$range, (String)"<this>");
        return JvmCoreKt.asSource((InputStream)new RangeInputStream(SourcesJvmKt.asInputStream((Source)$this$range), fromByte, toByte));
    }
}

