package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.entities.PersonBadgeEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonQrBadgeEntityDao_Impl(
  __db: RoomDatabase,
) : PersonQrBadgeEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonBadgeEntity: EntityInsertAdapter<PersonBadgeEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonBadgeEntity = object : EntityInsertAdapter<PersonBadgeEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `PersonBadgeEntity` (`pqrGuidNum`,`pqrGuid`,`pqrLastModified`,`pqrStored`,`pqrQrCodeUrl`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonBadgeEntity) {
        statement.bindLong(1, entity.pqrGuidNum)
        statement.bindText(2, entity.pqrGuid)
        val _tmp: Long? = __sharedConverters.fromInstant(entity.pqrLastModified)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindLong(3, _tmp)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.pqrStored)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindLong(4, _tmp_1)
        }
        statement.bindText(5, entity.pqrQrCodeUrl)
      }
    }
  }

  public override suspend fun upsert(personQrCodeEntity: PersonBadgeEntity): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonBadgeEntity.insert(_connection, personQrCodeEntity)
  }

  public override suspend fun upsertAsyncList(list: List<PersonBadgeEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonBadgeEntity.insert(_connection, list)
  }

  public override suspend fun getAll(): List<PersonBadgeEntity> {
    val _sql: String = "SELECT * FROM PersonBadgeEntity"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: MutableList<PersonBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _item = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAll(personGuidNum: Long): List<PersonBadgeEntity> {
    val _sql: String = """
        |
        |        SELECT PersonBadgeEntity.*
        |          FROM PersonBadgeEntity
        |         WHERE PersonBadgeEntity.pqrGuidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personGuidNum)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: MutableList<PersonBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _item = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuid(guid: String): PersonBadgeEntity? {
    val _sql: String = """
        |
        |           SELECT PersonBadgeEntity.* 
        |             FROM PersonBadgeEntity
        |            WHERE pqrGuid = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, guid)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: PersonBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _result = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByQrCodeUrl(qrCodeUrl: String): PersonBadgeEntity? {
    val _sql: String = """
        |
        |        SELECT PersonBadgeEntity.*
        |          FROM PersonBadgeEntity
        |         WHERE PersonBadgeEntity.pqrQrCodeUrl = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, qrCodeUrl)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: PersonBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _result = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedByUidNum(uidNum: Long): Long? {
    val _sql: String = """
        |
        |        SELECT PersonBadgeEntity.pqrLastModified
        |          FROM PersonBadgeEntity
        |         WHERE PersonBadgeEntity.pqrGuidNum = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uidNum)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUidList(uids: List<Long>): List<PersonBadgeEntity> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        SELECT PersonBadgeEntity.*")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("          FROM PersonBadgeEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE PersonBadgeEntity.pqrGuidNum IN (")
    val _inputSize: Int = uids.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: Long in uids) {
          _stmt.bindLong(_argIndex, _item)
          _argIndex++
        }
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: MutableList<PersonBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: PersonBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _item_1 = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAllByPersonGuid(personGuid: String): List<PersonBadgeEntity> {
    val _sql: String = """
        |
        |        SELECT PersonBadgeEntity.*
        |          FROM PersonBadgeEntity
        |         WHERE PersonBadgeEntity.pqrGuid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, personGuid)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: MutableList<PersonBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _item = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllByPersonGuidAsFlow(personGuid: Long): Flow<List<PersonBadgeEntity>> {
    val _sql: String = """
        |
        |        SELECT PersonBadgeEntity.*
        |          FROM PersonBadgeEntity
        |         WHERE PersonBadgeEntity.pqrGuidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonBadgeEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, personGuid)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: MutableList<PersonBadgeEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonBadgeEntity
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _item = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun existsByQrCodeUrlExcludingPerson(qrCodeUrl: String, excludePersonGuid: Long): Boolean {
    val _sql: String = """
        |
        |        SELECT EXISTS(
        |            SELECT 1 
        |            FROM PersonBadgeEntity 
        |            WHERE pqrQrCodeUrl = ?
        |              AND pqrGuid != ?
        |        )
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, qrCodeUrl)
        _argIndex = 2
        _stmt.bindLong(_argIndex, excludePersonGuid)
        val _result: Boolean
        if (_stmt.step()) {
          val _tmp: Int
          _tmp = _stmt.getLong(0).toInt()
          _result = _tmp != 0
        } else {
          _result = false
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidHashAsFlow(guidnum: Long): Flow<PersonBadgeEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonBadgeEntity
        |        WHERE pqrGuidNum = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonBadgeEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidnum)
        val _columnIndexOfPqrGuidNum: Int = getColumnIndexOrThrow(_stmt, "pqrGuidNum")
        val _columnIndexOfPqrGuid: Int = getColumnIndexOrThrow(_stmt, "pqrGuid")
        val _columnIndexOfPqrLastModified: Int = getColumnIndexOrThrow(_stmt, "pqrLastModified")
        val _columnIndexOfPqrStored: Int = getColumnIndexOrThrow(_stmt, "pqrStored")
        val _columnIndexOfPqrQrCodeUrl: Int = getColumnIndexOrThrow(_stmt, "pqrQrCodeUrl")
        val _result: PersonBadgeEntity?
        if (_stmt.step()) {
          val _tmpPqrGuidNum: Long
          _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum)
          val _tmpPqrGuid: String
          _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid)
          val _tmpPqrLastModified: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfPqrLastModified)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfPqrLastModified)
          }
          val _tmp_1: Instant? = __sharedConverters.toInstant(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrLastModified = _tmp_1
          }
          val _tmpPqrStored: Instant
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPqrStored)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPqrStored)
          }
          val _tmp_3: Instant? = __sharedConverters.toInstant(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpPqrStored = _tmp_3
          }
          val _tmpPqrQrCodeUrl: String
          _tmpPqrQrCodeUrl = _stmt.getText(_columnIndexOfPqrQrCodeUrl)
          _result = PersonBadgeEntity(_tmpPqrGuidNum,_tmpPqrGuid,_tmpPqrLastModified,_tmpPqrStored,_tmpPqrQrCodeUrl)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByGuid(guidNum: Long) {
    val _sql: String = """
        |
        |        DELETE FROM PersonBadgeEntity 
        |         WHERE pqrGuid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidNum)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
