/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.AndroidFlingSpline;
import androidx.compose.animation.FlingCalculatorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/animation/FlingCalculator;", "", "friction", "", "density", "Landroidx/compose/ui/unit/Density;", "<init>", "(FLandroidx/compose/ui/unit/Density;)V", "getDensity", "()Landroidx/compose/ui/unit/Density;", "magicPhysicalCoefficient", "computeDeceleration", "getSplineDeceleration", "", "velocity", "flingDuration", "", "flingDistance", "flingInfo", "Landroidx/compose/animation/FlingCalculator$FlingInfo;", "FlingInfo", "animation"})
@StabilityInferred(parameters=1)
public final class FlingCalculator {
    private final float friction;
    @NotNull
    private final Density density;
    private final float magicPhysicalCoefficient;
    public static final int $stable;

    public FlingCalculator(float friction, @NotNull Density density) {
        Intrinsics.checkNotNullParameter(density, "density");
        this.friction = friction;
        this.density = density;
        this.magicPhysicalCoefficient = this.computeDeceleration(this.density);
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    private final float computeDeceleration(Density density) {
        return FlingCalculatorKt.access$computeDeceleration(0.84f, density.getDensity());
    }

    private final double getSplineDeceleration(float velocity) {
        return AndroidFlingSpline.INSTANCE.deceleration(velocity, this.friction * this.magicPhysicalCoefficient);
    }

    public final long flingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (long)(1000.0 * Math.exp(l / decelMinusOne));
    }

    public final float flingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l));
    }

    @NotNull
    public final FlingInfo flingInfo(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return new FlingInfo(velocity, (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l)), (long)(1000.0 * Math.exp(l / decelMinusOne)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/FlingCalculator$FlingInfo;", "", "initialVelocity", "", "distance", "duration", "", "<init>", "(FFJ)V", "getInitialVelocity", "()F", "getDistance", "getDuration", "()J", "position", "time", "velocity", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "animation"})
    @StabilityInferred(parameters=1)
    public static final class FlingInfo {
        private final float initialVelocity;
        private final float distance;
        private final long duration;
        public static final int $stable;

        public FlingInfo(float initialVelocity, float distance, long duration) {
            this.initialVelocity = initialVelocity;
            this.distance = distance;
            this.duration = duration;
        }

        public final float getInitialVelocity() {
            return this.initialVelocity;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final float position(long time2) {
            float splinePos = this.duration > 0L ? (float)time2 / (float)this.duration : 1.0f;
            return this.distance * Math.signum(this.initialVelocity) * AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getDistanceCoefficient();
        }

        public final float velocity(long time2) {
            float splinePos = this.duration > 0L ? (float)time2 / (float)this.duration : 1.0f;
            return AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getVelocityCoefficient() * Math.signum(this.initialVelocity) * this.distance / (float)this.duration * 1000.0f;
        }

        public final float component1() {
            return this.initialVelocity;
        }

        public final float component2() {
            return this.distance;
        }

        public final long component3() {
            return this.duration;
        }

        @NotNull
        public final FlingInfo copy(float initialVelocity, float distance, long duration) {
            return new FlingInfo(initialVelocity, distance, duration);
        }

        public static /* synthetic */ FlingInfo copy$default(FlingInfo flingInfo, float f, float f2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                f = flingInfo.initialVelocity;
            }
            if ((n & 2) != 0) {
                f2 = flingInfo.distance;
            }
            if ((n & 4) != 0) {
                l = flingInfo.duration;
            }
            return flingInfo.copy(f, f2, l);
        }

        @NotNull
        public String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.initialVelocity);
            result2 = result2 * 31 + Float.hashCode(this.distance);
            result2 = result2 * 31 + Long.hashCode(this.duration);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            FlingInfo flingInfo = (FlingInfo)other;
            if (Float.compare(this.initialVelocity, flingInfo.initialVelocity) != 0) {
                return false;
            }
            if (Float.compare(this.distance, flingInfo.distance) != 0) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

