/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.serialization.node.JsonLocationAware;
import com.networknt.schema.serialization.node.JsonNodeFactoryFactory;
import java.io.IOException;
import java.io.InputStream;

public class JsonNodes {
    public static <T extends JsonNode> T get(JsonNode node2, JsonNodePath path) {
        int nameCount = path.getNameCount();
        JsonNode current = node2;
        for (int x2 = 0; x2 < nameCount; ++x2) {
            Object segment = path.getElement(x2);
            T result2 = JsonNodes.get(current, segment);
            if (result2 == null) {
                return null;
            }
            current = result2;
        }
        return (T)current;
    }

    public static <T extends JsonNode> T get(JsonNode node2, Object propertyOrIndex) {
        JsonNode value = null;
        value = propertyOrIndex instanceof Number && node2.isArray() ? node2.get(((Number)propertyOrIndex).intValue()) : node2.get(propertyOrIndex.toString());
        return (T)value;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, String content2, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonFactory factory = objectMapper.getFactory();
            JsonParser parser = factory.createParser(content2);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader2 = objectMapper.reader(nodeFactory);
                JsonNode result2 = (JsonNode)reader2.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result2 != null ? result2 : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, InputStream inputStream2, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonFactory factory = objectMapper.getFactory();
            JsonParser parser = factory.createParser(inputStream2);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader2 = objectMapper.reader(nodeFactory);
                JsonNode result2 = (JsonNode)reader2.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result2 != null ? result2 : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static JsonLocation tokenLocationOf(JsonNode jsonNode) {
        if (jsonNode instanceof JsonLocationAware) {
            return ((JsonLocationAware)((Object)jsonNode)).tokenLocation();
        }
        throw new IllegalArgumentException("JsonNode does not contain the location information.");
    }
}

