/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.io;

import com.ustadmobile.libcache.io.InputStreamExtKt;
import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\n\u0010\u000eJ'\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/libcache/io/RangeInputStream;", "Ljava/io/FilterInputStream;", "Ljava/io/InputStream;", "src", "", "fromByte", "toByte", "<init>", "(Ljava/io/InputStream;JJ)V", "", "read", "()I", "", "b", "([B)I", "off", "len", "([BII)I", "", "markSupported", "()Z", "Ljava/io/InputStream;", "J", "pos", "respect-lib-cache"})
public final class RangeInputStream
extends FilterInputStream {
    @NotNull
    private final InputStream src;
    private final long fromByte;
    private final long toByte;
    private volatile long pos;

    public RangeInputStream(@NotNull InputStream src, long fromByte, long toByte) {
        Intrinsics.checkNotNullParameter(src, "src");
        super(src);
        this.src = src;
        this.fromByte = fromByte;
        this.toByte = toByte;
        InputStreamExtKt.skipExactly(this, this.fromByte);
        this.pos = this.fromByte;
    }

    @Override
    public int read() {
        int n;
        if (this.pos <= this.toByte) {
            int n2;
            int it = n2 = this.src.read();
            boolean bl = false;
            long l = this.pos;
            this.pos = l + 1L;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b2) {
        Intrinsics.checkNotNullParameter(b2, "b");
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(@NotNull byte[] b2, int off, int len) {
        int n;
        Intrinsics.checkNotNullParameter(b2, "b");
        long bytesRemaining = this.toByte - this.pos + 1L;
        if (bytesRemaining <= 0L) {
            return -1;
        }
        int effectiveLen = (long)len <= bytesRemaining ? len : (int)bytesRemaining;
        int it = n = super.read(b2, off, effectiveLen);
        boolean bl = false;
        this.pos += (long)it;
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

