/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.annotation.RestrictTo;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import androidx.lifecycle.viewmodel.MutableCreationExtras;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavViewModelStoreProvider;
import androidx.navigation.internal.NavContext;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.SavedStateWriter;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\r\u0010I\u001a\u00020EH\u0000\u00a2\u0006\u0002\bJJ\u0015\u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b]J\b\u0010^\u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001b\u00100\u001a\u0002018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b2\u00103R\u0016\u00106\u001a\u0004\u0018\u00010\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0015R\u0014\u00108\u001a\u0002098@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R$\u0010A\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u0017@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0019\"\u0004\bC\u0010\u001bR\u0014\u0010K\u001a\u00020L8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020PX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0014\u0010S\u001a\u00020T8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0014\u0010W\u001a\u00020X8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u001b\u0010_\u001a\u00020P8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\ba\u00105\u001a\u0004\b`\u0010R\u00a8\u0006c"}, d2={"Landroidx/navigation/internal/NavBackStackEntryImpl;", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "<init>", "(Landroidx/navigation/NavBackStackEntry;)V", "getEntry", "()Landroidx/navigation/NavBackStackEntry;", "context", "Landroidx/navigation/internal/NavContext;", "getContext$navigation_common", "()Landroidx/navigation/internal/NavContext;", "destination", "Landroidx/navigation/NavDestination;", "getDestination$navigation_common", "()Landroidx/navigation/NavDestination;", "setDestination$navigation_common", "(Landroidx/navigation/NavDestination;)V", "immutableArgs", "Landroidx/savedstate/SavedState;", "getImmutableArgs$navigation_common", "()Landroidx/savedstate/SavedState;", "hostLifecycleState", "Landroidx/lifecycle/Lifecycle$State;", "getHostLifecycleState$navigation_common", "()Landroidx/lifecycle/Lifecycle$State;", "setHostLifecycleState$navigation_common", "(Landroidx/lifecycle/Lifecycle$State;)V", "viewModelStoreProvider", "Landroidx/navigation/NavViewModelStoreProvider;", "getViewModelStoreProvider$navigation_common", "()Landroidx/navigation/NavViewModelStoreProvider;", "id", "", "getId$navigation_common", "()Ljava/lang/String;", "savedState", "getSavedState$navigation_common", "savedStateRegistryController", "Landroidx/savedstate/SavedStateRegistryController;", "getSavedStateRegistryController$navigation_common", "()Landroidx/savedstate/SavedStateRegistryController;", "savedStateRegistryAttached", "", "getSavedStateRegistryAttached$navigation_common", "()Z", "setSavedStateRegistryAttached$navigation_common", "(Z)V", "defaultFactory", "Landroidx/lifecycle/SavedStateViewModelFactory;", "getDefaultFactory$navigation_common", "()Landroidx/lifecycle/SavedStateViewModelFactory;", "defaultFactory$delegate", "Lkotlin/Lazy;", "arguments", "getArguments$navigation_common", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "getSavedStateHandle$navigation_common", "()Landroidx/lifecycle/SavedStateHandle;", "lifecycle", "Landroidx/lifecycle/LifecycleRegistry;", "getLifecycle$navigation_common", "()Landroidx/lifecycle/LifecycleRegistry;", "maxState", "maxLifecycle", "getMaxLifecycle$navigation_common", "setMaxLifecycle$navigation_common", "handleLifecycleEvent", "", "event", "Landroidx/lifecycle/Lifecycle$Event;", "handleLifecycleEvent$navigation_common", "updateState", "updateState$navigation_common", "viewModelStore", "Landroidx/lifecycle/ViewModelStore;", "getViewModelStore$navigation_common", "()Landroidx/lifecycle/ViewModelStore;", "defaultViewModelProviderFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getDefaultViewModelProviderFactory$navigation_common", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "defaultViewModelCreationExtras", "Landroidx/lifecycle/viewmodel/MutableCreationExtras;", "getDefaultViewModelCreationExtras$navigation_common", "()Landroidx/lifecycle/viewmodel/MutableCreationExtras;", "savedStateRegistry", "Landroidx/savedstate/SavedStateRegistry;", "getSavedStateRegistry$navigation_common", "()Landroidx/savedstate/SavedStateRegistry;", "saveState", "outBundle", "saveState$navigation_common", "toString", "navResultSavedStateFactory", "getNavResultSavedStateFactory", "navResultSavedStateFactory$delegate", "SavedStateViewModel", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavBackStackEntryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavBackStackEntryImpl.kt\nandroidx/navigation/internal/NavBackStackEntryImpl\n+ 2 SavedState.nonAndroid.kt\nandroidx/savedstate/SavedStateKt__SavedState_nonAndroidKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n+ 5 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,166:1\n30#2:167\n45#2:168\n34#2,2:169\n1#3:171\n1#3:173\n106#4:172\n32#5:174\n69#5,2:175\n*S KotlinDebug\n*F\n+ 1 NavBackStackEntryImpl.kt\nandroidx/navigation/internal/NavBackStackEntryImpl\n*L\n62#1:167\n62#1:168\n62#1:169,2\n62#1:171\n62#1:172\n161#1:174\n161#1:175,2\n*E\n"})
public final class NavBackStackEntryImpl {
    @NotNull
    private final NavBackStackEntry entry;
    @Nullable
    private final NavContext context;
    @NotNull
    private NavDestination destination;
    @Nullable
    private final SavedState immutableArgs;
    @NotNull
    private Lifecycle.State hostLifecycleState;
    @Nullable
    private final NavViewModelStoreProvider viewModelStoreProvider;
    @NotNull
    private final String id;
    @Nullable
    private final SavedState savedState;
    @NotNull
    private final SavedStateRegistryController savedStateRegistryController;
    private boolean savedStateRegistryAttached;
    @NotNull
    private final Lazy defaultFactory$delegate;
    @NotNull
    private final LifecycleRegistry lifecycle;
    @NotNull
    private Lifecycle.State maxLifecycle;
    @NotNull
    private final ViewModelProvider.Factory defaultViewModelProviderFactory;
    @NotNull
    private final Lazy navResultSavedStateFactory$delegate;

    public NavBackStackEntryImpl(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entry = entry;
        this.context = this.entry.getContext$navigation_common();
        this.destination = this.entry.getDestination();
        this.immutableArgs = this.entry.getImmutableArgs$navigation_common();
        this.hostLifecycleState = this.entry.getHostLifecycleState$navigation_common();
        this.viewModelStoreProvider = this.entry.getViewModelStoreProvider$navigation_common();
        this.id = this.entry.getId();
        this.savedState = this.entry.getSavedState$navigation_common();
        this.savedStateRegistryController = SavedStateRegistryController.Companion.create((SavedStateRegistryOwner)this.entry);
        this.defaultFactory$delegate = LazyKt.lazy(NavBackStackEntryImpl::defaultFactory_delegate$lambda$0);
        this.lifecycle = new LifecycleRegistry((LifecycleOwner)this.entry);
        this.maxLifecycle = Lifecycle.State.INITIALIZED;
        this.defaultViewModelProviderFactory = (ViewModelProvider.Factory)this.getDefaultFactory$navigation_common();
        this.navResultSavedStateFactory$delegate = LazyKt.lazy(NavBackStackEntryImpl::navResultSavedStateFactory_delegate$lambda$10);
    }

    @NotNull
    public final NavBackStackEntry getEntry() {
        return this.entry;
    }

    @Nullable
    public final NavContext getContext$navigation_common() {
        return this.context;
    }

    @NotNull
    public final NavDestination getDestination$navigation_common() {
        return this.destination;
    }

    public final void setDestination$navigation_common(@NotNull NavDestination navDestination) {
        Intrinsics.checkNotNullParameter((Object)navDestination, (String)"<set-?>");
        this.destination = navDestination;
    }

    @Nullable
    public final SavedState getImmutableArgs$navigation_common() {
        return this.immutableArgs;
    }

    @NotNull
    public final Lifecycle.State getHostLifecycleState$navigation_common() {
        return this.hostLifecycleState;
    }

    public final void setHostLifecycleState$navigation_common(@NotNull Lifecycle.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"<set-?>");
        this.hostLifecycleState = state;
    }

    @Nullable
    public final NavViewModelStoreProvider getViewModelStoreProvider$navigation_common() {
        return this.viewModelStoreProvider;
    }

    @NotNull
    public final String getId$navigation_common() {
        return this.id;
    }

    @Nullable
    public final SavedState getSavedState$navigation_common() {
        return this.savedState;
    }

    @NotNull
    public final SavedStateRegistryController getSavedStateRegistryController$navigation_common() {
        return this.savedStateRegistryController;
    }

    public final boolean getSavedStateRegistryAttached$navigation_common() {
        return this.savedStateRegistryAttached;
    }

    public final void setSavedStateRegistryAttached$navigation_common(boolean bl) {
        this.savedStateRegistryAttached = bl;
    }

    @NotNull
    public final SavedStateViewModelFactory getDefaultFactory$navigation_common() {
        Lazy lazy = this.defaultFactory$delegate;
        return (SavedStateViewModelFactory)lazy.getValue();
    }

    @Nullable
    public final SavedState getArguments$navigation_common() {
        SavedState savedState;
        if (this.immutableArgs == null) {
            savedState = null;
        } else {
            SavedState savedState2;
            Map initialState$iv = MapsKt.emptyMap();
            boolean $i$f$savedState = false;
            Map copiedState$iv = MapsKt.toMutableMap((Map)initialState$iv);
            SavedState $this$savedState_u24lambda_u240$iv = savedState2 = new SavedState(copiedState$iv);
            boolean bl = false;
            SavedState $this$write$iv$iv = $this$savedState_u24lambda_u240$iv;
            boolean $i$f$write = false;
            SavedState $this$_get_arguments__u24lambda_u241 = SavedStateWriter.constructor-impl((SavedState)$this$write$iv$iv);
            boolean bl2 = false;
            SavedStateWriter.putAll-impl((SavedState)$this$_get_arguments__u24lambda_u241, (SavedState)this.immutableArgs);
            savedState = savedState2;
        }
        return savedState;
    }

    @NotNull
    public final SavedStateHandle getSavedStateHandle$navigation_common() {
        if (!this.savedStateRegistryAttached) {
            boolean $i$a$-check-NavBackStackEntryImpl$savedStateHandle$32 = false;
            String $i$a$-check-NavBackStackEntryImpl$savedStateHandle$32 = "You cannot access the NavBackStackEntry's SavedStateHandle until it is added to the NavController's back stack (i.e., the Lifecycle of the NavBackStackEntry reaches the CREATED state).";
            throw new IllegalStateException($i$a$-check-NavBackStackEntryImpl$savedStateHandle$32.toString());
        }
        if (!(this.lifecycle.getCurrentState() != Lifecycle.State.DESTROYED)) {
            boolean bl = false;
            String string = "You cannot access the NavBackStackEntry's SavedStateHandle after the NavBackStackEntry is destroyed.";
            throw new IllegalStateException(string.toString());
        }
        return ((SavedStateViewModel)ViewModelProvider.Companion.create$default((ViewModelProvider.Companion)ViewModelProvider.Companion, (ViewModelStoreOwner)this.entry, (ViewModelProvider.Factory)this.getNavResultSavedStateFactory(), null, (int)4, null).get(Reflection.getOrCreateKotlinClass(SavedStateViewModel.class))).getHandle();
    }

    @NotNull
    public final LifecycleRegistry getLifecycle$navigation_common() {
        return this.lifecycle;
    }

    @NotNull
    public final Lifecycle.State getMaxLifecycle$navigation_common() {
        return this.maxLifecycle;
    }

    public final void setMaxLifecycle$navigation_common(@NotNull Lifecycle.State maxState) {
        Intrinsics.checkNotNullParameter((Object)maxState, (String)"maxState");
        this.maxLifecycle = maxState;
        this.updateState$navigation_common();
    }

    public final void handleLifecycleEvent$navigation_common(@NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.entry.setHostLifecycleState$navigation_common(event.getTargetState());
        this.hostLifecycleState = event.getTargetState();
        this.updateState$navigation_common();
    }

    public final void updateState$navigation_common() {
        if (!this.savedStateRegistryAttached) {
            this.savedStateRegistryController.performAttach();
            this.savedStateRegistryAttached = true;
            if (this.viewModelStoreProvider != null) {
                SavedStateHandleSupport.enableSavedStateHandles((SavedStateRegistryOwner)this.entry);
            }
            this.savedStateRegistryController.performRestore(this.savedState);
        }
        if (this.hostLifecycleState.ordinal() < this.maxLifecycle.ordinal()) {
            this.lifecycle.setCurrentState(this.hostLifecycleState);
        } else {
            this.lifecycle.setCurrentState(this.maxLifecycle);
        }
    }

    @NotNull
    public final ViewModelStore getViewModelStore$navigation_common() {
        if (!this.savedStateRegistryAttached) {
            boolean $i$a$-check-NavBackStackEntryImpl$viewModelStore$32 = false;
            String $i$a$-check-NavBackStackEntryImpl$viewModelStore$32 = "You cannot access the NavBackStackEntry's ViewModels until it is added to the NavController's back stack (i.e., the Lifecycle of the NavBackStackEntry reaches the CREATED state).";
            throw new IllegalStateException($i$a$-check-NavBackStackEntryImpl$viewModelStore$32.toString());
        }
        if (!(this.lifecycle.getCurrentState() != Lifecycle.State.DESTROYED)) {
            boolean $i$a$-check-NavBackStackEntryImpl$viewModelStore$42 = false;
            String $i$a$-check-NavBackStackEntryImpl$viewModelStore$42 = "You cannot access the NavBackStackEntry's ViewModels after the NavBackStackEntry is destroyed.";
            throw new IllegalStateException($i$a$-check-NavBackStackEntryImpl$viewModelStore$42.toString());
        }
        if (this.viewModelStoreProvider == null) {
            boolean bl = false;
            String string = "You must call setViewModelStore() on your NavHostController before accessing the ViewModelStore of a navigation graph.";
            throw new IllegalStateException(string.toString());
        }
        return this.viewModelStoreProvider.getViewModelStore(this.id);
    }

    @NotNull
    public final ViewModelProvider.Factory getDefaultViewModelProviderFactory$navigation_common() {
        return this.defaultViewModelProviderFactory;
    }

    @NotNull
    public final MutableCreationExtras getDefaultViewModelCreationExtras$navigation_common() {
        MutableCreationExtras extras;
        block0: {
            extras = new MutableCreationExtras(null, 1, null);
            extras.set(SavedStateHandleSupport.SAVED_STATE_REGISTRY_OWNER_KEY, (Object)this.entry);
            extras.set(SavedStateHandleSupport.VIEW_MODEL_STORE_OWNER_KEY, (Object)this.entry);
            SavedState savedState = this.getArguments$navigation_common();
            if (savedState == null) break block0;
            SavedState args = savedState;
            boolean bl = false;
            extras.set(SavedStateHandleSupport.DEFAULT_ARGS_KEY, (Object)args);
        }
        return extras;
    }

    @NotNull
    public final SavedStateRegistry getSavedStateRegistry$navigation_common() {
        return this.savedStateRegistryController.getSavedStateRegistry();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void saveState$navigation_common(@NotNull SavedState outBundle) {
        Intrinsics.checkNotNullParameter((Object)outBundle, (String)"outBundle");
        this.savedStateRegistryController.performSave(outBundle);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Reflection.getOrCreateKotlinClass(this.entry.getClass()).getSimpleName());
        sb.append("(" + this.id + ")");
        sb.append(" destination=");
        sb.append(this.destination);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final ViewModelProvider.Factory getNavResultSavedStateFactory() {
        Lazy lazy = this.navResultSavedStateFactory$delegate;
        return (ViewModelProvider.Factory)lazy.getValue();
    }

    private static final SavedStateViewModelFactory defaultFactory_delegate$lambda$0() {
        return new SavedStateViewModelFactory();
    }

    private static final SavedStateViewModel navResultSavedStateFactory_delegate$lambda$10$lambda$9$lambda$8(CreationExtras $this$initializer) {
        Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
        return new SavedStateViewModel(SavedStateHandleSupport.createSavedStateHandle((CreationExtras)$this$initializer));
    }

    /*
     * WARNING - void declaration
     */
    private static final ViewModelProvider.Factory navResultSavedStateFactory_delegate$lambda$10() {
        void $this$initializer$iv;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
        boolean $i$f$viewModelFactory = false;
        InitializerViewModelFactoryBuilder $this$navResultSavedStateFactory_delegate_u24lambda_u2410_u24lambda_u249 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
        boolean bl = false;
        InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$navResultSavedStateFactory_delegate_u24lambda_u2410_u24lambda_u249;
        Function1 initializer$iv = NavBackStackEntryImpl::navResultSavedStateFactory_delegate$lambda$10$lambda$9$lambda$8;
        boolean $i$f$initializer = false;
        $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(SavedStateViewModel.class), initializer$iv);
        return initializerViewModelFactoryBuilder.build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/navigation/internal/NavBackStackEntryImpl$SavedStateViewModel;", "Landroidx/lifecycle/ViewModel;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "<init>", "(Landroidx/lifecycle/SavedStateHandle;)V", "getHandle", "()Landroidx/lifecycle/SavedStateHandle;", "navigation-common"})
    private static final class SavedStateViewModel
    extends ViewModel {
        @NotNull
        private final SavedStateHandle handle;

        public SavedStateViewModel(@NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            this.handle = handle;
        }

        @NotNull
        public final SavedStateHandle getHandle() {
            return this.handle;
        }
    }
}

