/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.validateqrbadge;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.http.URLUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.shared.generated.resources.Res;
import world.respect.shared.generated.resources.String2_commonMainKt;
import world.respect.shared.util.exception.ExceptionWithUiTextKt;
import world.respect.shared.util.ext.StringResourceExtKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0010"}, d2={"Lworld/respect/shared/domain/account/validateqrbadge/ValidateQrCodeUseCase;", "", "<init>", "()V", "invoke", "", "qrCodeUrl", "", "schoolUrl", "personGuid", "allowReplacement", "", "validateUrlFormat", "validateSchoolUrl", "validateQrBadgeSection", "validateFormatOnly", "respect-lib-shared_debug"})
@StabilityInferred(parameters=1)
public final class ValidateQrCodeUseCase {
    public static final int $stable;

    public final void invoke(@NotNull String qrCodeUrl, @Nullable String schoolUrl, @Nullable String personGuid, boolean allowReplacement) {
        Intrinsics.checkNotNullParameter((Object)qrCodeUrl, (String)"qrCodeUrl");
        this.validateUrlFormat(qrCodeUrl);
        this.validateSchoolUrl(qrCodeUrl, schoolUrl);
        this.validateQrBadgeSection(qrCodeUrl);
    }

    public static /* synthetic */ void invoke$default(ValidateQrCodeUseCase validateQrCodeUseCase, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        validateQrCodeUseCase.invoke(string2, string3, string4, bl);
    }

    private final void validateUrlFormat(String qrCodeUrl) {
        try {
            URLUtilsKt.Url((String)qrCodeUrl);
        }
        catch (Exception e) {
            throw ExceptionWithUiTextKt.withUiText(new IllegalArgumentException("Invalid QR code URL format"), StringResourceExtKt.asUiText(String2_commonMainKt.getQr_code_invalid_format(Res.string.INSTANCE)));
        }
    }

    private final void validateSchoolUrl(String qrCodeUrl, String schoolUrl) {
        if (schoolUrl != null && !StringsKt.startsWith$default((String)qrCodeUrl, (String)schoolUrl, (boolean)false, (int)2, null)) {
            throw ExceptionWithUiTextKt.withUiText(new IllegalArgumentException("QR code must start with school URL"), StringResourceExtKt.asUiText(String2_commonMainKt.getQr_code_must_start_with_school_url(Res.string.INSTANCE)));
        }
    }

    private final void validateQrBadgeSection(String qrCodeUrl) {
        if (!StringsKt.contains((CharSequence)qrCodeUrl, (CharSequence)"/respect_qr_badge", (boolean)true)) {
            throw ExceptionWithUiTextKt.withUiText(new IllegalArgumentException("QR code must contain /respect_qr_badge section"), StringResourceExtKt.asUiText(String2_commonMainKt.getQr_code_must_contain_respect_qr_badge(Res.string.INSTANCE)));
        }
    }

    public final boolean validateFormatOnly(@NotNull String qrCodeUrl, @Nullable String schoolUrl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)qrCodeUrl, (String)"qrCodeUrl");
        try {
            URLUtilsKt.Url((String)qrCodeUrl);
            if (schoolUrl != null && !StringsKt.startsWith$default((String)qrCodeUrl, (String)schoolUrl, (boolean)false, (int)2, null)) {
                return false;
            }
            bl = StringsKt.contains((CharSequence)qrCodeUrl, (CharSequence)"/respect_qr_badge", (boolean)true);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }
}

