/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;
import net.sourceforge.argparse4j.internal.ParseState;
import net.sourceforge.argparse4j.internal.SubparserImpl;
import net.sourceforge.argparse4j.internal.UnrecognizedCommandException;

public final class SubparsersImpl
implements Subparsers {
    private final ArgumentParserImpl mainParser_;
    private final Map<String, SubparserImpl> parsers_ = new LinkedHashMap<String, SubparserImpl>();
    private String help_ = "";
    private String title_ = "";
    private String description_ = "";
    private String dest_ = "";
    private String metavar_ = "";

    SubparsersImpl(ArgumentParserImpl mainParser) {
        this.mainParser_ = mainParser;
    }

    @Override
    public SubparserImpl addParser(String command2) {
        return this.addParser(command2, true, this.mainParser_.getPrefixChars());
    }

    @Override
    public SubparserImpl addParser(String command2, boolean addHelp) {
        return this.addParser(command2, addHelp, this.mainParser_.getPrefixChars());
    }

    @Override
    public SubparserImpl addParser(String command2, boolean addHelp, String prefixChars) {
        if (command2 == null || command2.isEmpty()) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        if (this.parsers_.containsKey(command2)) {
            throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "command '%s' has been already used", command2));
        }
        SubparserImpl parser = new SubparserImpl(this.mainParser_.getConfig().forSubparser(addHelp, prefixChars), command2, this.mainParser_);
        this.parsers_.put(command2, parser);
        return parser;
    }

    @Override
    public SubparsersImpl dest(String dest) {
        this.dest_ = TextHelper.nonNull(dest);
        return this;
    }

    @Override
    public SubparsersImpl help(String help) {
        this.help_ = TextHelper.nonNull(help);
        return this;
    }

    @Override
    public SubparsersImpl title(String title2) {
        this.title_ = TextHelper.nonNull(title2);
        return this;
    }

    public String getTitle() {
        return this.title_;
    }

    @Override
    public SubparsersImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    public String getDescription() {
        return this.description_;
    }

    @Override
    public SubparsersImpl metavar(String metavar) {
        this.metavar_ = TextHelper.nonNull(metavar);
        return this;
    }

    boolean hasSubCommand() {
        return !this.parsers_.isEmpty();
    }

    boolean hasNotSuppressedSubCommand() {
        for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
            if (entry.getValue().getHelpControl() == FeatureControl.SUPPRESS) continue;
            return true;
        }
        return false;
    }

    private SubparserImpl resolveNextSubparser(String command2) throws ArgumentParserException {
        if (command2.isEmpty()) {
            return null;
        }
        SubparserImpl ap = this.parsers_.get(command2);
        if (ap == null) {
            List<String> cand = TextHelper.findPrefix(this.parsers_.keySet(), command2);
            int size2 = cand.size();
            if (size2 == 1) {
                ap = this.parsers_.get(cand.get(0));
            } else if (size2 > 1) {
                Collections.sort(cand);
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("ambiguousCommandError"), command2, TextHelper.concat(cand, 0, ", ")), (ArgumentParser)this.mainParser_);
            }
        }
        return ap;
    }

    void parseArg(ParseState state2, Map<String, Object> opts) throws ArgumentParserException {
        if (this.parsers_.isEmpty()) {
            throw new IllegalArgumentException("too many arguments");
        }
        SubparserImpl ap = this.resolveNextSubparser(state2.getArg());
        if (ap == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
                sb.append("'").append(entry.getKey()).append("', ");
            }
            sb.delete(sb.length() - 2, sb.length());
            throw new UnrecognizedCommandException(String.format(TextHelper.LOCALE_ROOT, this.localize("invalidChoiceError"), state2.getArg(), sb.toString()), (ArgumentParser)this.mainParser_, state2.getArg());
        }
        ++state2.index;
        ap.parseArgs(state2, opts);
        if (!this.dest_.isEmpty()) {
            opts.put(this.dest_, ap.getCommand());
        }
    }

    String formatShortSyntax() {
        if (this.metavar_.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
                if (entry.getValue().getHelpControl() == FeatureControl.SUPPRESS) continue;
                sb.append(entry.getKey()).append(",");
            }
            if (sb.length() > 1) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append("}");
            return sb.toString();
        }
        return this.metavar_;
    }

    void printSubparserHelp(PrintWriter writer2, int format_width) {
        TextHelper.printHelp(writer2, this.formatShortSyntax(), this.help_, this.mainParser_.getTextWidthCounter(), format_width);
        for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
            if (entry.getValue().getHelpControl() == FeatureControl.SUPPRESS || !entry.getKey().equals(entry.getValue().getCommand())) continue;
            entry.getValue().printSubparserHelp(writer2, format_width);
        }
    }

    Collection<String> getCommands() {
        return this.parsers_.keySet();
    }

    void addAlias(SubparserImpl subparser, String ... alias) {
        for (String command2 : alias) {
            if (this.parsers_.containsKey(command2)) {
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "command '%s' has been already used", command2));
            }
            this.parsers_.put(command2, subparser);
        }
    }

    private String localize(String messageKey) {
        return MessageLocalization.localize(this.mainParser_.getConfig().getResourceBundle(), messageKey);
    }
}

