/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCacheWhatWithIdAndPayload;
import com.ustadmobile.libcache.util.ByteBufferExtKt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0086\b\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0010\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\rJ8\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001f\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u0018R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010\r\u00a8\u0006%"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCacheWhatWithIdAndPayload;", "", "id", "httpPort", "", "deviceName", "", "payload", "<init>", "(IILjava/lang/String;[B)V", "toBytes", "()[B", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "component1", "component2", "component3", "()Ljava/lang/String;", "component4", "copy", "(IILjava/lang/String;[B)Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "toString", "I", "getId", "getHttpPort", "Ljava/lang/String;", "getDeviceName", "[B", "getPayload", "Companion", "respect-lib-cache"})
public final class DistributedCachePing
extends DistributedCachePacket
implements DistributedCacheWhatWithIdAndPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int httpPort;
    @NotNull
    private final String deviceName;
    @NotNull
    private final byte[] payload;
    public static final int OVERHEAD_SIZE = 13;

    public DistributedCachePing(int id, int httpPort, @NotNull String deviceName, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(deviceName, "deviceName");
        Intrinsics.checkNotNullParameter(payload, "payload");
        super(null);
        this.id = id;
        this.httpPort = httpPort;
        this.deviceName = deviceName;
        this.payload = payload;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    @Override
    @NotNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        int n = 13 + this.getPayload().length;
        String string2 = this.deviceName;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        int size2 = n + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(size2);
        byteBuffer.put((byte)2);
        byteBuffer.putInt(this.getHttpPort());
        byteBuffer.putInt(this.getId());
        Intrinsics.checkNotNull(byteBuffer);
        ByteBufferExtKt.writeShortString(byteBuffer, this.deviceName);
        ByteBufferExtKt.writePayload(byteBuffer, this.getPayload());
        byte[] byArray2 = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray2, "array(...)");
        return byArray2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DistributedCachePing)) {
            return false;
        }
        if (this.getId() != ((DistributedCachePing)other).getId()) {
            return false;
        }
        if (this.getHttpPort() != ((DistributedCachePing)other).getHttpPort()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.deviceName, ((DistributedCachePing)other).deviceName)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), ((DistributedCachePing)other).getPayload());
    }

    public int hashCode() {
        int result2 = this.getId();
        result2 = 31 * result2 + this.getHttpPort();
        result2 = 31 * result2 + this.deviceName.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.getPayload());
        return result2;
    }

    public final int component1() {
        return this.id;
    }

    public final int component2() {
        return this.httpPort;
    }

    @NotNull
    public final String component3() {
        return this.deviceName;
    }

    @NotNull
    public final byte[] component4() {
        return this.payload;
    }

    @NotNull
    public final DistributedCachePing copy(int id, int httpPort, @NotNull String deviceName, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(deviceName, "deviceName");
        Intrinsics.checkNotNullParameter(payload, "payload");
        return new DistributedCachePing(id, httpPort, deviceName, payload);
    }

    public static /* synthetic */ DistributedCachePing copy$default(DistributedCachePing distributedCachePing, int n, int n2, String string2, byte[] byArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = distributedCachePing.id;
        }
        if ((n3 & 2) != 0) {
            n2 = distributedCachePing.httpPort;
        }
        if ((n3 & 4) != 0) {
            string2 = distributedCachePing.deviceName;
        }
        if ((n3 & 8) != 0) {
            byArray = distributedCachePing.payload;
        }
        return distributedCachePing.copy(n, n2, string2, byArray);
    }

    @NotNull
    public String toString() {
        return "DistributedCachePing(id=" + this.id + ", httpPort=" + this.httpPort + ", deviceName=" + this.deviceName + ", payload=" + Arrays.toString(this.payload) + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing$Companion;", "", "<init>", "()V", "Ljava/nio/ByteBuffer;", "", "httpPort", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "readDistributedCachePing", "(Ljava/nio/ByteBuffer;I)Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "OVERHEAD_SIZE", "I", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePing readDistributedCachePing(@NotNull ByteBuffer $this$readDistributedCachePing, int httpPort) {
            Intrinsics.checkNotNullParameter($this$readDistributedCachePing, "<this>");
            int id = $this$readDistributedCachePing.getInt();
            String deviceName = ByteBufferExtKt.readShortString($this$readDistributedCachePing);
            byte[] payload = ByteBufferExtKt.readPayload($this$readDistributedCachePing);
            return new DistributedCachePing(id, httpPort, deviceName, payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

