/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyApplicationEngineKt;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.util.pipeline.PipelineContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001FB5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010%R\u001b\u0010+\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001b\u0010.\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010(\u001a\u0004\b-\u0010*R\u001b\u00102\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010(\u001a\u0004\b0\u00101R\u001b\u00105\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010(\u001a\u0004\b4\u0010*R\u001b\u0010:\u001a\u0002068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010(\u001a\u0004\b8\u00109R\u0018\u0010<\u001a\u0004\u0018\u00010;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u001e\u0010@\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010>8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR!\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00110>8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010(\u001a\u0004\bC\u0010D\u00a8\u0006G"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/events/Events;", "monitor", "", "developmentMode", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "configuration", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lio/ktor/events/Events;ZLio/ktor/server/netty/NettyApplicationEngine$Configuration;Lkotlin/jvm/functions/Function0;)V", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "Lio/netty/bootstrap/ServerBootstrap;", "createBootstrap", "(Lio/ktor/server/engine/EngineConnectorConfig;)Lio/netty/bootstrap/ServerBootstrap;", "wait", "start", "(Z)Lio/ktor/server/netty/NettyApplicationEngine;", "", "terminate", "()V", "", "gracePeriodMillis", "timeoutMillis", "stop", "(JJ)V", "", "toString", "()Ljava/lang/String;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "getConfiguration", "()Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lkotlin/jvm/functions/Function0;", "Lio/netty/channel/EventLoopGroup;", "connectionEventGroup$delegate", "Lkotlin/Lazy;", "getConnectionEventGroup", "()Lio/netty/channel/EventLoopGroup;", "connectionEventGroup", "workerEventGroup$delegate", "getWorkerEventGroup", "workerEventGroup", "customBootstrap$delegate", "getCustomBootstrap", "()Lio/netty/bootstrap/ServerBootstrap;", "customBootstrap", "callEventGroup$delegate", "getCallEventGroup", "callEventGroup", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "workerDispatcher$delegate", "getWorkerDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "workerDispatcher", "Lkotlinx/coroutines/CompletableJob;", "cancellationJob", "Lkotlinx/coroutines/CompletableJob;", "", "Lio/netty/channel/Channel;", "channels", "Ljava/util/List;", "bootstraps$delegate", "getBootstraps$ktor_server_netty", "()Ljava/util/List;", "bootstraps", "Configuration", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyApplicationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyApplicationEngine.kt\nio/ktor/server/netty/NettyApplicationEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1563#2:319\n1634#2,3:320\n1563#2:323\n1634#2,3:324\n1563#2:327\n1634#2,3:328\n1563#2:331\n1634#2,3:332\n1869#2,2:335\n1617#2,9:337\n1869#2:346\n1870#2:348\n1626#2:349\n1869#2,2:350\n1563#2:352\n1634#2,3:353\n1#3:347\n*S KotlinDebug\n*F\n+ 1 NettyApplicationEngine.kt\nio/ktor/server/netty/NettyApplicationEngine\n*L\n253#1:319\n253#1:320,3\n254#1:323\n254#1:324,3\n256#1:327\n256#1:328,3\n272#1:331\n272#1:332,3\n272#1:335,2\n286#1:337,9\n286#1:346\n286#1:348\n286#1:349\n304#1:350,2\n202#1:352\n202#1:353,3\n286#1:347\n*E\n"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Function0<Application> applicationProvider;
    @NotNull
    private final Lazy connectionEventGroup$delegate;
    @NotNull
    private final Lazy workerEventGroup$delegate;
    @NotNull
    private final Lazy customBootstrap$delegate;
    @NotNull
    private final Lazy callEventGroup$delegate;
    @NotNull
    private final Lazy workerDispatcher$delegate;
    @Nullable
    private CompletableJob cancellationJob;
    @Nullable
    private List<? extends Channel> channels;
    @NotNull
    private final Lazy bootstraps$delegate;

    public NettyApplicationEngine(@NotNull ApplicationEnvironment environment, @NotNull Events monitor, boolean developmentMode, @NotNull Configuration configuration, @NotNull Function0<Application> applicationProvider) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(monitor, "monitor");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(applicationProvider, "applicationProvider");
        super(environment, monitor, developmentMode, null, 8, null);
        this.configuration = configuration;
        this.applicationProvider = applicationProvider;
        this.connectionEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.connectionEventGroup_delegate$lambda$0(this));
        this.workerEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.workerEventGroup_delegate$lambda$2(this));
        this.customBootstrap$delegate = LazyKt.lazy(() -> NettyApplicationEngine.customBootstrap_delegate$lambda$3(this));
        this.callEventGroup$delegate = LazyKt.lazy(() -> NettyApplicationEngine.callEventGroup_delegate$lambda$4(this));
        this.workerDispatcher$delegate = LazyKt.lazy(() -> NettyApplicationEngine.workerDispatcher_delegate$lambda$5(this));
        this.bootstraps$delegate = LazyKt.lazy(() -> NettyApplicationEngine.bootstraps_delegate$lambda$6(this));
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), NettyApplicationEngineKt.access$getAFTER_CALL_PHASE$p());
        this.getPipeline().intercept(NettyApplicationEngineKt.access$getAFTER_CALL_PHASE$p(), (Function3)new Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            @Override
            public final Object invokeSuspend(Object $result) {
                PipelineContext pipelineContext = (PipelineContext)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$intercept;
                        ResultKt.throwOnFailure($result);
                        void $this$call$iv = $this$intercept;
                        boolean $i$f$getCall = false;
                        PipelineCall pipelineCall = (PipelineCall)$this$call$iv.getContext();
                        NettyApplicationCall nettyApplicationCall = pipelineCall instanceof NettyApplicationCall ? (NettyApplicationCall)pipelineCall : null;
                        if (nettyApplicationCall == null) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$intercept);
                        this.label = 1;
                        Object object2 = nettyApplicationCall.finish$ktor_server_netty(this);
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            public final Object invoke(PipelineContext<Unit, PipelineCall> p1, Unit p2, Continuation<? super Unit> p3) {
                Function3<PipelineContext<Unit, PipelineCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    private final EventLoopGroup getConnectionEventGroup() {
        Lazy lazy = this.connectionEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final EventLoopGroup getWorkerEventGroup() {
        Lazy lazy = this.workerEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ServerBootstrap getCustomBootstrap() {
        Lazy lazy = this.customBootstrap$delegate;
        return (ServerBootstrap)lazy.getValue();
    }

    private final EventLoopGroup getCallEventGroup() {
        Lazy lazy = this.callEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ExecutorCoroutineDispatcher getWorkerDispatcher() {
        Lazy lazy = this.workerDispatcher$delegate;
        return (ExecutorCoroutineDispatcher)lazy.getValue();
    }

    @NotNull
    public final List<ServerBootstrap> getBootstraps$ktor_server_netty() {
        Lazy lazy = this.bootstraps$delegate;
        return (List)lazy.getValue();
    }

    private final ServerBootstrap createBootstrap(EngineConnectorConfig connector) {
        ServerBootstrap serverBootstrap;
        ServerBootstrap $this$createBootstrap_u24lambda_u247 = serverBootstrap = this.getCustomBootstrap().clone();
        boolean bl = false;
        if ($this$createBootstrap_u24lambda_u247.config().group() == null && $this$createBootstrap_u24lambda_u247.config().childGroup() == null) {
            $this$createBootstrap_u24lambda_u247.group(this.getConnectionEventGroup(), this.getWorkerEventGroup());
        }
        if ($this$createBootstrap_u24lambda_u247.config().channelFactory() == null) {
            $this$createBootstrap_u24lambda_u247.channel(JvmClassMappingKt.getJavaClass(NettyApplicationEngineKt.getChannelClass()));
        }
        CoroutineContext userContext = NettyApplicationCallHandler.Companion.getCallHandlerCoroutineName$ktor_server_netty().plus(new DefaultUncaughtExceptionHandler(this.getEnvironment().getLog()));
        $this$createBootstrap_u24lambda_u247.childHandler(new NettyChannelInitializer(this.applicationProvider, this.getPipeline(), this.getEnvironment(), this.getCallEventGroup(), this.getWorkerDispatcher(), userContext, connector, this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec(), this.configuration.getChannelPipelineConfig(), this.configuration.getEnableHttp2(), this.configuration.getEnableH2c()));
        if (this.configuration.getTcpKeepAlive()) {
            $this$createBootstrap_u24lambda_u247.childOption(ChannelOption.SO_KEEPALIVE, true);
        }
        ServerBootstrap serverBootstrap2 = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue(serverBootstrap2, "apply(...)");
        return serverBootstrap2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        Iterable destination$iv$iv;
        Object object;
        try {
            void $this$mapTo$iv$iv;
            ChannelFuture it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)this.getBootstraps$ktor_server_netty(), (Iterable)this.configuration.getConnectors());
            object = this;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((ServerBootstrap)((Pair)((Object)it)).getFirst()).bind(((EngineConnectorConfig)((Pair)((Object)it)).getSecond()).getHost(), ((EngineConnectorConfig)((Pair)((Object)it)).getSecond()).getPort()));
            }
            $this$map$iv = (List)destination$iv$iv2;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (ChannelFuture)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.sync().channel());
            }
            ((NettyApplicationEngine)object).channels = (List)destination$iv$iv2;
            List<? extends Channel> list2 = this.channels;
            Intrinsics.checkNotNull(list2);
            Iterable $this$map$iv2 = CollectionsKt.zip((Iterable)list2, (Iterable)this.configuration.getConnectors());
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Pair bl = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)it2.getSecond();
                SocketAddress socketAddress = ((Channel)it2.getFirst()).localAddress();
                Intrinsics.checkNotNullExpressionValue(socketAddress, "localAddress(...)");
                object.add(EngineConnectorConfigJvmKt.withPort(engineConnectorConfig, NetworkAddressJvmKt.getPort(socketAddress)));
            }
            List connectors = (List)destination$iv$iv;
            this.getResolvedConnectorsDeferred().complete(connectors);
        }
        catch (BindException cause) {
            this.terminate();
            throw cause;
        }
        EventsKt.raiseCatching(this.getMonitor(), DefaultApplicationEventsKt.getServerReady(), this.getEnvironment(), this.getEnvironment().getLog());
        this.cancellationJob = EngineContextCancellationHelperKt.stopServerOnCancellation(this, this.applicationProvider.invoke(), this.configuration.getShutdownGracePeriod(), this.configuration.getShutdownTimeout());
        if (wait) {
            List<? extends Channel> list3 = this.channels;
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Channel bl2 = (Channel)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl = false;
                    object.add(it.closeFuture());
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ChannelFuture it = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it.sync();
                }
            }
            this.stop(this.configuration.getShutdownGracePeriod(), this.configuration.getShutdownTimeout());
        }
        return this;
    }

    private final void terminate() {
        this.getConnectionEventGroup().shutdownGracefully().sync();
        this.getWorkerEventGroup().shutdownGracefully().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        List list2;
        List list3;
        CompletableJob completableJob = this.cancellationJob;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), this.getEnvironment());
        List<? extends Channel> list4 = this.channels;
        if (list4 != null) {
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list4;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ChannelFuture it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if ((it.isOpen() ? it.close() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List channelFutures = list2;
        try {
            Future<?> future;
            Future<?> shutdownConnections = this.getConnectionEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            shutdownConnections.await();
            Future<?> shutdownWorkers = this.getWorkerEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                future = shutdownWorkers.await();
            } else {
                Future<?> shutdownCall = this.getCallEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
                shutdownWorkers.await();
                future = shutdownCall.await();
            }
        }
        finally {
            Iterable $this$forEach$iv = channelFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    private static final EventLoopGroup connectionEventGroup_delegate$lambda$0(NettyApplicationEngine this$0) {
        EventLoopGroup eventLoopGroup = this$0.getCustomBootstrap().config().group();
        if (eventLoopGroup == null) {
            eventLoopGroup = EventLoopGroupProxy.Companion.create(this$0.configuration.getConnectionGroupSize());
        }
        return eventLoopGroup;
    }

    private static final EventLoopGroup workerEventGroup_delegate$lambda$2(NettyApplicationEngine this$0) {
        EventLoopGroup eventLoopGroup = this$0.getCustomBootstrap().config().childGroup();
        if (eventLoopGroup != null) {
            EventLoopGroup it = eventLoopGroup;
            boolean bl = false;
            return it;
        }
        return this$0.configuration.getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(this$0.configuration.getWorkerGroupSize() + this$0.configuration.getCallGroupSize()) : EventLoopGroupProxy.Companion.create(this$0.configuration.getWorkerGroupSize());
    }

    private static final ServerBootstrap customBootstrap_delegate$lambda$3(NettyApplicationEngine this$0) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        this$0.configuration.getConfigureBootstrap().invoke(serverBootstrap);
        return serverBootstrap;
    }

    private static final EventLoopGroup callEventGroup_delegate$lambda$4(NettyApplicationEngine this$0) {
        return this$0.configuration.getShareWorkGroup() ? this$0.getWorkerEventGroup() : (EventLoopGroup)EventLoopGroupProxy.Companion.create(this$0.configuration.getCallGroupSize());
    }

    private static final ExecutorCoroutineDispatcher workerDispatcher_delegate$lambda$5(NettyApplicationEngine this$0) {
        return ExecutorsKt.from(this$0.getWorkerEventGroup());
    }

    /*
     * WARNING - void declaration
     */
    private static final List bootstraps_delegate$lambda$6(NettyApplicationEngine this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.configuration.getConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.createBootstrap((EngineConnectorConfig)p0));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R3\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\t\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\"\u0010\"\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\t\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR\"\u0010%\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0010\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R\"\u0010(\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\t\u001a\u0004\b)\u0010\u000b\"\u0004\b*\u0010\rR\"\u0010+\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\t\u001a\u0004\b,\u0010\u000b\"\u0004\b-\u0010\rR\"\u0010.\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\t\u001a\u0004\b/\u0010\u000b\"\u0004\b0\u0010\rR\"\u00101\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010\u0010\u001a\u0004\b2\u0010\u0012\"\u0004\b3\u0010\u0014R\"\u00104\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010\u0010\u001a\u0004\b5\u0010\u0012\"\u0004\b6\u0010\u0014R(\u00108\u001a\b\u0012\u0004\u0012\u00020\u0004078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R3\u0010?\u001a\u0013\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010\u001a\u001a\u0004\b@\u0010\u001c\"\u0004\bA\u0010\u001e\u00a8\u0006B"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "<init>", "()V", "Lio/netty/handler/codec/http/HttpServerCodec;", "defaultHttpServerCodec", "()Lio/netty/handler/codec/http/HttpServerCodec;", "", "runningLimit", "I", "getRunningLimit", "()I", "setRunningLimit", "(I)V", "", "shareWorkGroup", "Z", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "configureBootstrap", "Lkotlin/jvm/functions/Function1;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "tcpKeepAlive", "getTcpKeepAlive", "setTcpKeepAlive", "maxInitialLineLength", "getMaxInitialLineLength", "setMaxInitialLineLength", "maxHeaderSize", "getMaxHeaderSize", "setMaxHeaderSize", "maxChunkSize", "getMaxChunkSize", "setMaxChunkSize", "enableHttp2", "getEnableHttp2", "setEnableHttp2", "enableH2c", "getEnableH2c", "setEnableH2c", "Lkotlin/Function0;", "httpServerCodec", "Lkotlin/jvm/functions/Function0;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "Lio/netty/channel/ChannelPipeline;", "channelPipelineConfig", "getChannelPipelineConfig", "setChannelPipelineConfig", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int runningLimit = 32;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = Configuration::configureBootstrap$lambda$0;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        private boolean tcpKeepAlive;
        private int maxInitialLineLength = 4096;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;
        private boolean enableHttp2 = true;
        private boolean enableH2c;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = new Function0<HttpServerCodec>((Object)this){

            public final HttpServerCodec invoke() {
                return Configuration.access$defaultHttpServerCodec((Configuration)this.receiver);
            }
        };
        @NotNull
        private Function1<? super ChannelPipeline, Unit> channelPipelineConfig = Configuration::channelPipelineConfig$lambda$1;

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n) {
            this.requestReadTimeoutSeconds = n;
        }

        public final boolean getTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public final void setTcpKeepAlive(boolean bl) {
            this.tcpKeepAlive = bl;
        }

        public final int getMaxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        public final void setMaxInitialLineLength(int n) {
            this.maxInitialLineLength = n;
        }

        public final int getMaxHeaderSize() {
            return this.maxHeaderSize;
        }

        public final void setMaxHeaderSize(int n) {
            this.maxHeaderSize = n;
        }

        public final int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        public final void setMaxChunkSize(int n) {
            this.maxChunkSize = n;
        }

        public final boolean getEnableHttp2() {
            return this.enableHttp2;
        }

        public final void setEnableHttp2(boolean bl) {
            this.enableHttp2 = bl;
        }

        public final boolean getEnableH2c() {
            return this.enableH2c;
        }

        public final void setEnableH2c(boolean bl) {
            this.enableH2c = bl;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkNotNullParameter(function0, "<set-?>");
            this.httpServerCodec = function0;
        }

        @NotNull
        public final Function1<ChannelPipeline, Unit> getChannelPipelineConfig() {
            return this.channelPipelineConfig;
        }

        public final void setChannelPipelineConfig(@NotNull Function1<? super ChannelPipeline, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.channelPipelineConfig = function1;
        }

        private final HttpServerCodec defaultHttpServerCodec() {
            return new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize);
        }

        private static final Unit configureBootstrap$lambda$0(ServerBootstrap serverBootstrap) {
            Intrinsics.checkNotNullParameter(serverBootstrap, "<this>");
            return Unit.INSTANCE;
        }

        private static final Unit channelPipelineConfig$lambda$1(ChannelPipeline channelPipeline) {
            Intrinsics.checkNotNullParameter(channelPipeline, "<this>");
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ HttpServerCodec access$defaultHttpServerCodec(Configuration $this) {
            return $this.defaultHttpServerCodec();
        }
    }
}

