package com.ustadmobile.libcache.db.dao

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.getTotalChangedRows
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.ustadmobile.libcache.db.DbTypeConverters
import com.ustadmobile.libcache.db.entities.DownloadJob
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class DownloadJobDao_Impl(
  __db: RoomDatabase,
) : DownloadJobDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfDownloadJob: EntityInsertAdapter<DownloadJob>

  private val __dbTypeConverters: DbTypeConverters = DbTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfDownloadJob = object : EntityInsertAdapter<DownloadJob>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `DownloadJob` (`djUid`,`djType`,`djStatus`,`djName`,`djPubManifestUrl`,`djPubManifestHash`,`djTimeCreated`,`djCreationType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: DownloadJob) {
        statement.bindLong(1, entity.djUid.toLong())
        statement.bindLong(2, entity.djType.toLong())
        statement.bindLong(3, entity.djStatus.toLong())
        val _tmpDjName: String? = entity.djName
        if (_tmpDjName == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmpDjName)
        }
        val _tmpDjPubManifestUrl: Url? = entity.djPubManifestUrl
        val _tmp: String? = __dbTypeConverters.fromUrl(_tmpDjPubManifestUrl)
        if (_tmp == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp)
        }
        statement.bindLong(6, entity.djPubManifestHash)
        statement.bindLong(7, entity.djTimeCreated)
        statement.bindLong(8, entity.djCreationType.toLong())
      }
    }
  }

  public override suspend fun insert(downloadJob: DownloadJob): Long = performSuspending(__db, false, true) { _connection ->
    val _result: Long = __insertAdapterOfDownloadJob.insertAndReturnId(_connection, downloadJob)
    _result
  }

  public override suspend fun findByUid(uid: Int): DownloadJob? {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM DownloadJob 
        |         WHERE djUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid.toLong())
        val _columnIndexOfDjUid: Int = getColumnIndexOrThrow(_stmt, "djUid")
        val _columnIndexOfDjType: Int = getColumnIndexOrThrow(_stmt, "djType")
        val _columnIndexOfDjStatus: Int = getColumnIndexOrThrow(_stmt, "djStatus")
        val _columnIndexOfDjName: Int = getColumnIndexOrThrow(_stmt, "djName")
        val _columnIndexOfDjPubManifestUrl: Int = getColumnIndexOrThrow(_stmt, "djPubManifestUrl")
        val _columnIndexOfDjPubManifestHash: Int = getColumnIndexOrThrow(_stmt, "djPubManifestHash")
        val _columnIndexOfDjTimeCreated: Int = getColumnIndexOrThrow(_stmt, "djTimeCreated")
        val _columnIndexOfDjCreationType: Int = getColumnIndexOrThrow(_stmt, "djCreationType")
        val _result: DownloadJob?
        if (_stmt.step()) {
          val _tmpDjUid: Int
          _tmpDjUid = _stmt.getLong(_columnIndexOfDjUid).toInt()
          val _tmpDjType: Int
          _tmpDjType = _stmt.getLong(_columnIndexOfDjType).toInt()
          val _tmpDjStatus: Int
          _tmpDjStatus = _stmt.getLong(_columnIndexOfDjStatus).toInt()
          val _tmpDjName: String?
          if (_stmt.isNull(_columnIndexOfDjName)) {
            _tmpDjName = null
          } else {
            _tmpDjName = _stmt.getText(_columnIndexOfDjName)
          }
          val _tmpDjPubManifestUrl: Url?
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfDjPubManifestUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfDjPubManifestUrl)
          }
          _tmpDjPubManifestUrl = __dbTypeConverters.toUrl(_tmp)
          val _tmpDjPubManifestHash: Long
          _tmpDjPubManifestHash = _stmt.getLong(_columnIndexOfDjPubManifestHash)
          val _tmpDjTimeCreated: Long
          _tmpDjTimeCreated = _stmt.getLong(_columnIndexOfDjTimeCreated)
          val _tmpDjCreationType: Int
          _tmpDjCreationType = _stmt.getLong(_columnIndexOfDjCreationType).toInt()
          _result = DownloadJob(_tmpDjUid,_tmpDjType,_tmpDjStatus,_tmpDjName,_tmpDjPubManifestUrl,_tmpDjPubManifestHash,_tmpDjTimeCreated,_tmpDjCreationType)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateStatusSetCompleteIfAllItemsComplete(jobUid: Int): Int {
    val _sql: String = """
        |
        |        UPDATE DownloadJob
        |           SET djStatus = 21
        |         WHERE djUid = ?
        |          AND NOT EXISTS(
        |              SELECT DownloadJobItem.djiUid
        |                FROM DownloadJobItem
        |               WHERE DownloadJobItem.djiDjUid = ?
        |                 AND DownloadJobItem.djiStatus != 21) 
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, jobUid.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, jobUid.toLong())
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateStatus(jobUid: Int, status: Int) {
    val _sql: String = """
        |
        |        UPDATE DownloadJob
        |           SET djStatus = ?
        |         WHERE djUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, status.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, jobUid.toLong())
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateStatusByManifestHash(manifestHash: Long, status: Int) {
    val _sql: String = """
        |
        |        UPDATE DownloadJob
        |           SET djStatus = ?
        |         WHERE DownloadJob.djPubManifestHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, status.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, manifestHash)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
